/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.operatecore.va;

import java.time.LocalDate;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.web.applybill.operatecore.extend.WtcAbstractUnityBillAutoOperator;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VaAutoOperator
extends WtcAbstractUnityBillAutoOperator {
    public VaAutoOperator(UnifyBillInfoContext infoContext) {
        super(infoContext);
    }

    @Override
    public UnifyBillEnum getUnifyBillEnum() {
        return UnifyBillEnum.VA;
    }

    public Date getUseVersionDate(DynamicObject dataEntity, ApplyBillCheckEnum checkEnum) {
        String startMethod = dataEntity.getString(checkEnum.getStartMethod());
        Date startDate = dataEntity.getDate(checkEnum.getStartDate());
        Date endDate = dataEntity.getDate(checkEnum.getEndDate());
        Date ownDate = dataEntity.getDate(checkEnum.getOwndate());
        if (startDate == null) {
            return WTCDateUtils.toDate((LocalDate)LocalDate.now());
        }
        return VaAutoOperator.getUseVersionDate(startMethod, startDate, endDate, ownDate, this.isUseStartOrEnd());
    }

    public static Date getUseVersionDate(String startMethod, Date startDate, Date endDate, Date ownDate, boolean useStartOrEnd) {
        if (StringUtils.equalsAny((CharSequence)startMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_UP.value, WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value})) {
            if (useStartOrEnd) {
                return new Date(startDate.getTime());
            }
            return new Date(endDate.getTime());
        }
        return new Date(ownDate.getTime());
    }
}

