/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.ruleengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineInitParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineRequestParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class PlanRuleEngineHelper {
    private static final Log LOG = LogFactory.getLog(PlanRuleEngineHelper.class);
    private static final HRBaseServiceHelper RULEASSOCIATION_HELPER = new HRBaseServiceHelper("wtp_ruleassociation");
    private static final HRBaseServiceHelper SCENE_HELPER = new HRBaseServiceHelper("brm_scene");
    private static final HRBaseServiceHelper PERSONTSPROP_HELPER = new HRBaseServiceHelper("hrpi_pernontsprop");
    private static final String PERSONID = "person.id";

    public static void loadRequestParams(PlanRuleEngineInitParam initParam, List<PlanRuleEngineRequestParam> requestParamList) {
        LOG.info("PlanRuleEngineHelper.loadRequestParams");
        ArrayList personIdList = Lists.newArrayList((Iterable)initParam.getAttPersonBoIds());
        LOG.info("PlanRuleEngineHelper.loadRequestParams personIdList={}", (Object)personIdList);
        Map<Long, List<DynamicObject>> attModeMap = PlanRuleEngineHelper.getAttFileSchedule(initParam.getAttFileBoIds(), initParam.getBeginDate(), initParam.getEndDate(), AttFileScheduleEnum.MODE);
        Map<Long, List<DynamicObject>> attFileHisMap = PlanRuleEngineHelper.getHisMap(PERSONID, "wtp_attfilebase", personIdList);
        Map<Long, List<DynamicObject>> empJobHisMap = PlanRuleEngineHelper.getHisMap(PERSONID, "hrpi_empjobrel", personIdList);
        Map<Long, List<DynamicObject>> employeeHisMap = PlanRuleEngineHelper.getHisMap(PERSONID, "hrpi_employee", personIdList);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_attendperson");
        HRBaseServiceHelper depEmpJobServiceHelper = new HRBaseServiceHelper("wtp_depempjob");
        for (PlanRuleEngineRequestParam requestParam : requestParamList) {
            DynamicObject employeeDy;
            DynamicObject empJobDy;
            DynamicObject attModeDy;
            DynamicObject policyDy;
            DynamicObject plan = requestParam.getPlan();
            if (plan == null || (policyDy = (DynamicObject)initParam.getPlanPolicyMap().get(plan.getLong("id"))) == null) continue;
            DynamicObjectCollection entryBuList = policyDy.getDynamicObjectCollection("entrybulist");
            if (WTCCollections.isNotEmpty((Collection)entryBuList)) {
                requestParam.setBuNumber(((DynamicObject)entryBuList.get(0)).getString("entitybu.number"));
            }
            DynamicObjectCollection entryRuleList = policyDy.getDynamicObjectCollection("entryrulelist");
            ArrayList filterConditionList = Lists.newArrayListWithExpectedSize((int)entryRuleList.size());
            for (DynamicObject object : entryRuleList) {
                filterConditionList.add(object.getString("filtercondition"));
            }
            requestParam.setFilterConditionList((List)filterConditionList);
            requestParam.setPolicyIdList((List)Lists.newArrayList((Object[])new Long[]{policyDy.getLong("id")}));
            HashMap requestParamMap = Maps.newHashMapWithExpectedSize((int)8);
            DynamicObject attFileDy = requestParam.getAttFile();
            DynamicObject attEndPersonDy = serviceHelper.generateEmptyDynamicObject();
            DynamicObject depEmpJobDy = depEmpJobServiceHelper.generateEmptyDynamicObject();
            long attFileBoId = attFileDy.getLong("boid");
            long attPersonBoId = attFileDy.getLong("attperson.id");
            DynamicObject attFileHisDy = PlanRuleEngineHelper.getDyTimeHis(attFileHisMap.get(attPersonBoId), requestParam.getDate());
            if (null != attFileHisDy) {
                DynamicObject attPersonDy;
                DynamicObject wtpdepempJobDy = attFileHisDy.getDynamicObject("empposorgrel");
                if (null != wtpdepempJobDy) {
                    depEmpJobDy.set("posstatus", wtpdepempJobDy.get("posstatus"));
                    depEmpJobDy.set("company", wtpdepempJobDy.get("company"));
                    depEmpJobDy.set("job", wtpdepempJobDy.get("job"));
                    depEmpJobDy.set("position", wtpdepempJobDy.get("position"));
                    attFileDy.set("adminorg", wtpdepempJobDy.get("adminorg"));
                    depEmpJobDy.set("postype", wtpdepempJobDy.get("postype"));
                    depEmpJobDy.set("isprimary", wtpdepempJobDy.get("isprimary"));
                }
                if (null != (attPersonDy = attFileHisDy.getDynamicObject("attperson"))) {
                    attEndPersonDy.set("nationality", attPersonDy.get("nationality"));
                    attEndPersonDy.set("gender", attPersonDy.get("gender"));
                    attEndPersonDy.set("marriagestatus", attPersonDy.get("marriagestatus"));
                }
            }
            if ((attModeDy = PlanRuleEngineHelper.getDyTimeHis(attModeMap.get(attFileBoId), requestParam.getDate())) != null) {
                attFileDy.set("mode", attModeDy.get("mode"));
            }
            if ((empJobDy = PlanRuleEngineHelper.getDyTimeHis(empJobHisMap.get(attPersonBoId), requestParam.getDate())) != null) {
                attEndPersonDy.set("joblevel", empJobDy.get("joblevel"));
                attEndPersonDy.set("jobgrade", empJobDy.get("jobgrade"));
            }
            if ((employeeDy = PlanRuleEngineHelper.getDyTimeHis(employeeHisMap.get(attPersonBoId), requestParam.getDate())) != null) {
                attEndPersonDy.set("laborreltype", employeeDy.get("laborreltype"));
                attEndPersonDy.set("laborrelstatus", employeeDy.get("laborrelstatus"));
                attEndPersonDy.set("number", employeeDy.get("empnumber"));
            }
            Map sceneInputParamMap = requestParam.getSceneInputParamMap();
            PlanRuleEngineHelper.putRequestParam(requestParamMap, sceneInputParamMap, attFileDy);
            PlanRuleEngineHelper.putRequestParam(requestParamMap, sceneInputParamMap, attEndPersonDy);
            PlanRuleEngineHelper.putRequestParam(requestParamMap, sceneInputParamMap, depEmpJobDy);
            requestParam.setRequestParamMap((Map)requestParamMap);
        }
    }

    public static Map<Long, List<DynamicObject>> getHisMap(String fieldName, String pageKey, List<Long> personIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(pageKey);
        QFilter[] qFilterArr = new QFilter[3];
        qFilterArr[0] = new QFilter(fieldName, "in", personIdList);
        qFilterArr[1] = new QFilter("iscurrentversion", "=", (Object)"0");
        ArrayList dataStatusList = Lists.newArrayListWithExpectedSize((int)3);
        dataStatusList.add("0");
        dataStatusList.add("1");
        dataStatusList.add("2");
        qFilterArr[2] = new QFilter("datastatus", "in", (Object)dataStatusList);
        DynamicObject[] result = helper.loadDynamicObjectArray(qFilterArr);
        List<DynamicObject> resultList = PlanRuleEngineHelper.filterDuplicate(result);
        return resultList.stream().collect(Collectors.groupingBy(info -> info.getLong(fieldName)));
    }

    private static List<DynamicObject> filterDuplicate(DynamicObject[] result) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)result.length);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)result.length);
        for (DynamicObject dy : result) {
            Date startDate = dy.getDate("bsed");
            String startDateStr = HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
            Date endDate = dy.getDate("bsled");
            String endDateStr = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
            String resultStr = startDateStr + endDateStr;
            if (map.containsKey(resultStr)) continue;
            map.put(resultStr, resultStr);
            resultList.add(dy);
        }
        return resultList;
    }

    @Deprecated
    private static void loadPlanPolicy(List<PlanRuleEngineRequestParam> requestParamList) {
        Set<Long> planIdSet = requestParamList.stream().map(param -> param.getPlan().getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> policyList = PlanRuleEngineHelper.getPolicyByPlanIds(planIdSet);
        Map<Long, List<DynamicObject>> planIdGroupMap = policyList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("planid")));
        ArrayList allPolicyIdList = new ArrayList(16);
        for (PlanRuleEngineRequestParam planRuleEngineParam : requestParamList) {
            List<DynamicObject> planPolicyList = planIdGroupMap.get(planRuleEngineParam.getPlan().getLong("id"));
            if (CollectionUtils.isEmpty(planPolicyList)) continue;
            List policyIdLIst = planPolicyList.stream().map(dy -> dy.getLong("policyid")).collect(Collectors.toList());
            planRuleEngineParam.setPolicyIdList(policyIdLIst);
            allPolicyIdList.addAll(policyIdLIst);
        }
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("brm_policy_edit");
        QFilter qFilter = new QFilter("id", "in", allPolicyIdList);
        DynamicObject[] dynamicObjects = baseServiceHelper.queryOriginalArray("id,entrybulist.entitybu.number", qFilter.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        Map policyMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (key1, key2) -> key2));
        for (PlanRuleEngineRequestParam planRuleEngineParam : requestParamList) {
            DynamicObject dynamicObject;
            List policyIdList = planRuleEngineParam.getPolicyIdList();
            if (CollectionUtils.isEmpty((Collection)policyIdList) || (dynamicObject = (DynamicObject)policyMap.get(policyIdList.get(0))) == null) continue;
            planRuleEngineParam.setBuNumber(dynamicObject.getString("entrybulist.entitybu.number"));
        }
    }

    private static void putRequestParam(Map<String, DynamicObject> requestParam, Map<String, String> sceneInputParamMap, DynamicObject objDy) {
        if (objDy == null) {
            return;
        }
        String entityId = objDy.getDataEntityType().getName();
        String inputKey = sceneInputParamMap.get(entityId);
        if (HRStringUtils.isEmpty((String)inputKey)) {
            return;
        }
        requestParam.put(inputKey, objDy);
    }

    public static PlanRuleEngineInitParam getRequestInitParam(@Deprecated PlanSceneEnum planSceneEnum, List<PlanRuleEngineRequestParam> requestParamList) {
        HashSet attFileBoIdSet = Sets.newHashSetWithExpectedSize((int)requestParamList.size());
        HashSet attPersonBoIdSet = Sets.newHashSetWithExpectedSize((int)requestParamList.size());
        PlanRuleEngineRequestParam param0 = requestParamList.get(0);
        Date startDate = param0.getDate();
        Date endDate = param0.getDate();
        PlanRuleEngineInitParam initParam = new PlanRuleEngineInitParam();
        PlanRuleEngineHelper.initParamScenePolicy(initParam, requestParamList);
        for (PlanRuleEngineRequestParam requestParam : requestParamList) {
            String paramType;
            DynamicObject sceneDy;
            DynamicObject plan;
            DynamicObject attFileDy = requestParam.getAttFile();
            attFileBoIdSet.add(attFileDy.getLong("boid"));
            attPersonBoIdSet.add(attFileDy.getLong("attperson.id"));
            if (startDate.compareTo(requestParam.getDate()) > 0) {
                startDate = requestParam.getDate();
            }
            if (endDate.compareTo(requestParam.getDate()) < 0) {
                endDate = requestParam.getDate();
            }
            if ((plan = requestParam.getPlan()) == null || (sceneDy = (DynamicObject)initParam.getPlanSceneMap().get(plan.getLong("id"))) == null) continue;
            DynamicObjectCollection sceneInputParams = sceneDy.getDynamicObjectCollection("sceneinputparams");
            HashMap inputParamMap = Maps.newHashMapWithExpectedSize((int)sceneInputParams.size());
            for (DynamicObject inputParam : sceneInputParams) {
                paramType = inputParam.getString("inputparamstype");
                if (!"dynamicObject".equals(paramType) && !"basedata".equals(paramType) || inputParam.getDynamicObject("inputobject") == null) continue;
                String objNumber = inputParam.getDynamicObject("inputobject").getString("number");
                inputParamMap.put(objNumber, inputParam.getString("inputnumber"));
            }
            requestParam.setSceneInputParamMap((Map)inputParamMap);
            LOG.info("PlanRuleEngineHelper.getRequestInitParam inputParamMap={}", (Object)inputParamMap);
            DynamicObjectCollection sceneOutputParams = sceneDy.getDynamicObjectCollection("sceneoutputparams");
            HashMap outputParamMap = Maps.newHashMapWithExpectedSize((int)sceneOutputParams.size());
            for (DynamicObject outputParma : sceneOutputParams) {
                paramType = outputParma.getString("outputparamstype");
                if (!"dynamicObject".equals(paramType) && !"basedata".equals(paramType) || outputParma.getDynamicObject("outputobject") == null) continue;
                String objNumber = outputParma.getDynamicObject("outputobject").getString("number");
                outputParamMap.put(outputParma.getString("outputnumber"), objNumber);
            }
            requestParam.setSceneOutputParamMap((Map)outputParamMap);
            LOG.info("PlanRuleEngineHelper.getRequestInitParam outputParamMap={}", (Object)outputParamMap);
        }
        LOG.info("PlanRuleEngineHelper.getRequestInitParam beginDate={},endDate={}", (Object)startDate, (Object)endDate);
        initParam.setAttFileBoIds((Set)attFileBoIdSet);
        initParam.setAttPersonBoIds((Set)attPersonBoIdSet);
        initParam.setBeginDate(startDate);
        initParam.setEndDate(endDate);
        return initParam;
    }

    public static Map<Long, List<DynamicObject>> getAttFileSchedule(Set<Long> attFileBoIdSet, Date beginDate, Date endDate, AttFileScheduleEnum scheduleEnum) {
        AttFileScheduleQueryParam param = new AttFileScheduleQueryParam();
        param.setFileBoIdSet(attFileBoIdSet);
        param.setLoad(Boolean.TRUE);
        param.setEndDate(endDate);
        param.setStartDate(beginDate);
        return AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(scheduleEnum, param);
    }

    public static List<DynamicObject> getPolicyByPlanIds(Collection<Long> planIds) {
        QFilter qFilter = new QFilter("planid", "in", planIds);
        DynamicObject[] dynamicObjects = RULEASSOCIATION_HELPER.query(WTCStringUtils.joinOnComma((String[])new String[]{"planid", "ruleset", "policyid"}), qFilter.toArray());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String ruleSet = dynamicObject.getString("ruleset");
            if (!HRStringUtils.equals((String)ruleSet, (String)"2")) continue;
            result.add(dynamicObject);
        }
        return result;
    }

    private static DynamicObject getScene(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        return SCENE_HELPER.loadDynamicObject(qFilter);
    }

    public static DynamicObject getDyTimeHis(List<DynamicObject> dyList, Date date) {
        if (CollectionUtils.isEmpty(dyList)) {
            return null;
        }
        Optional<DynamicObject> any = dyList.stream().filter(dy -> date.compareTo(dy.getDate("bsed")) >= 0 && date.compareTo(dy.getDate("bsled")) <= 0).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        return null;
    }

    private static Map<Long, DynamicObject> getHrpiPersonTSProp(Collection<Long> personIds) {
        QFilter qFilter = new QFilter(PERSONID, "in", personIds);
        DynamicObject[] personTsPropArr = PERSONTSPROP_HELPER.loadDynamicObjectArray(qFilter.toArray());
        if (personTsPropArr == null || personTsPropArr.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(personTsPropArr).collect(Collectors.toMap(info -> info.getLong(PERSONID), Function.identity(), (oldValue, newValue) -> newValue));
    }

    private static void initParamScenePolicy(PlanRuleEngineInitParam initParam, List<PlanRuleEngineRequestParam> requestParamList) {
        List<Long> planIds = requestParamList.stream().filter(item -> item.getPlan() != null).map(item -> item.getPlan().getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> planPolicyMap = PlanRuleEngineHelper.getPolicyPlanMapByPlanIds(planIds);
        Map<Long, DynamicObject> planSceneMap = PlanRuleEngineHelper.getPlanSceneMap(planPolicyMap);
        initParam.setPlanPolicyMap(planPolicyMap);
        initParam.setPlanSceneMap(planSceneMap);
    }

    public static Map<Long, DynamicObject> getPolicyPlanMapByPlanIds(Collection<Long> planIds) {
        if (WTCCollections.isEmpty(planIds)) {
            return Collections.emptyMap();
        }
        List<DynamicObject> policyByPlanIds = PlanRuleEngineHelper.getPolicyByPlanIds(planIds);
        Map<Long, Long> planPolicyMap = policyByPlanIds.stream().collect(Collectors.toMap(item -> item.getLong("planid"), item -> item.getLong("policyid")));
        if (planPolicyMap.size() > 0) {
            Collection<Long> policyIds = planPolicyMap.values();
            QFilter policyFilter = new QFilter("id", "in", policyIds);
            DynamicObject[] policyDys = HRBaseServiceHelper.create((String)"brm_policy_edit").query("id,number,scene.number,entrybulist.entitybu,entryrulelist.filtercondition", policyFilter.toArray());
            Map policyMap = Arrays.stream(policyDys).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
            HashMap planPolicyDyMap = Maps.newHashMapWithExpectedSize((int)planPolicyMap.size());
            for (Map.Entry<Long, Long> entry : planPolicyMap.entrySet()) {
                Long planId = entry.getKey();
                Long policyId = entry.getValue();
                DynamicObject policyDy = (DynamicObject)policyMap.get(policyId);
                if (policyDy == null) continue;
                planPolicyDyMap.put(planId, policyDy);
            }
            return planPolicyDyMap;
        }
        return Collections.emptyMap();
    }

    private static DynamicObject[] getSceneByNumbers(List<String> sceneNumbers) {
        QFilter qFilter = new QFilter("number", "in", sceneNumbers);
        return SCENE_HELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public static Map<Long, DynamicObject> getPlanSceneMap(Map<Long, DynamicObject> planPolicyMap) {
        if (WTCCollections.isEmpty(planPolicyMap)) {
            return Collections.emptyMap();
        }
        Collection<DynamicObject> policys = planPolicyMap.values();
        List<String> sceneNumbers = policys.stream().filter(Objects::nonNull).map(item -> item.getString("scene.number")).collect(Collectors.toList());
        if (WTCCollections.isEmpty(sceneNumbers)) {
            return Collections.emptyMap();
        }
        DynamicObject[] scenes = PlanRuleEngineHelper.getSceneByNumbers(sceneNumbers);
        Map sceneMap = Arrays.stream(scenes).collect(Collectors.toMap(item -> item.getString("number"), Function.identity(), (o1, o2) -> o1));
        HashMap planSceneMap = Maps.newHashMapWithExpectedSize((int)planPolicyMap.size());
        for (Map.Entry<Long, DynamicObject> entry : planPolicyMap.entrySet()) {
            String sceneNumber;
            DynamicObject sceneDy;
            Long planId = entry.getKey();
            DynamicObject policyDy = entry.getValue();
            if (policyDy == null || (sceneDy = (DynamicObject)sceneMap.get(sceneNumber = policyDy.getString("scene.number"))) == null) continue;
            planSceneMap.put(planId, sceneDy);
        }
        return planSceneMap;
    }
}

