/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.ruleengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.enums.WTCRuleEngineSceneEnum;
import kd.sdk.wtc.wtp.business.ruleengine.OnGenRuleEngineInputParamEvent;
import kd.sdk.wtc.wtp.business.ruleengine.RuleEngineInputParamExtPlugin;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.applybill.ruleengine.IPlanRuleEngineService;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.common.constants.ruleengine.RuleEngineConstants;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineInParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineInitParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineRequestParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class PlanRuleEngineService
implements IPlanRuleEngineService {
    private static final Log LOG = LogFactory.getLog(PlanRuleEngineService.class);
    private PlanRuleEngineInitParam initParam;
    private List<PlanRuleEngineRequestParam> requestParamList;

    private PlanRuleEngineService() {
    }

    public static PlanRuleEngineService getInstance() {
        return new PlanRuleEngineService();
    }

    @Override
    public List<PlanRuleEngineOutParam> batchCallRuleEngine(@Deprecated PlanSceneEnum planSceneEnum, List<PlanRuleEngineInParam> inParamList) {
        if (CollectionUtils.isEmpty(inParamList)) {
            return Collections.emptyList();
        }
        LOG.info("PlanRuleEngineService.batchCallRuleEngine.begin");
        HashMap<String, Object> baseRequestMap = new HashMap<String, Object>(16);
        baseRequestMap.put("bizApp", "wtp");
        this.requestParamList = this.convertRequestParam(inParamList);
        this.initParam = PlanRuleEngineHelper.getRequestInitParam(planSceneEnum, this.requestParamList);
        PlanRuleEngineHelper.loadRequestParams(this.initParam, this.requestParamList);
        try {
            for (PlanRuleEngineRequestParam planRuleEngineParam : this.requestParamList) {
                DynamicObject sceneDy;
                DynamicObject plan = planRuleEngineParam.getPlan();
                if (plan == null || (sceneDy = (DynamicObject)this.initParam.getPlanSceneMap().get(plan.getLong("id"))) == null) continue;
                String sceneNumber = sceneDy.getString("number");
                baseRequestMap.put("sceneNumber", sceneNumber);
                baseRequestMap.put("buNumber", planRuleEngineParam.getBuNumber());
                Map requestParamMap = planRuleEngineParam.getRequestParamMap();
                if (CollectionUtils.isEmpty((Map)requestParamMap)) {
                    LOG.info("PlanRuleEngineService.batchCallRuleEngine requestParamMap is empty");
                    continue;
                }
                List policyIdList = planRuleEngineParam.getPolicyIdList();
                if (CollectionUtils.isEmpty((Collection)policyIdList)) {
                    LOG.info("PlanRuleEngineService.batchCallRuleEngine policyIdList is empty");
                    continue;
                }
                baseRequestMap.put("executePolicyIds", policyIdList);
                HashMap<String, Object> inputParamMap = new HashMap<String, Object>(requestParamMap.size());
                inputParamMap.putAll(requestParamMap);
                this.extendInputParamMap(inputParamMap, planSceneEnum.getSceneNumber(), planRuleEngineParam);
                baseRequestMap.put("inputParams", inputParamMap);
                if (LOG.isInfoEnabled()) {
                    DynamicObject attFile = (DynamicObject)requestParamMap.get("wtp_attfilebase");
                    DynamicObject attPerson = (DynamicObject)requestParamMap.get("wtp_attendperson");
                    DynamicObject depempJob = (DynamicObject)requestParamMap.get("wtp_depempjob");
                    if (null != attFile) {
                        LOG.info("PlanRuleEngineService.batchCallRuleEngine.attFile:number[{}],mode[{}],adminorg[{}],org[{}],affiliateadminorg[{}],ismanaged[{}],dependency[{}],dependencytype[{}],empgroup[{}],atttag[{}],workplace[{}]", new Object[]{attFile.get("number"), attFile.get("mode"), attFile.get("adminorg.id"), attFile.get("org.id"), attFile.get("affiliateadminorg.id"), attFile.get("ismanaged"), attFile.get("dependency.id"), attFile.get("dependencytype.id"), attFile.get("empgroup.id"), attFile.get("atttag.id"), attFile.get("workplace.id")});
                    }
                    if (null != attPerson) {
                        LOG.info("PlanRuleEngineService.batchCallRuleEngine.attPerson:nationality[{}],marriagestatus[{}],laborreltype[{}],laborrelstatus[{}],joblevel[{}],jobgrade[{}],number[{}],gender[{}]", new Object[]{attPerson.get("nationality.id"), attPerson.get("marriagestatus.id"), attPerson.get("laborreltype.id"), attPerson.get("laborrelstatus.id"), attPerson.get("joblevel.id"), attPerson.get("jobgrade.id"), attPerson.get("number"), attPerson.get("gender.id")});
                    }
                    if (null != depempJob) {
                        LOG.info("PlanRuleEngineService.batchCallRuleEngine.depempJob:posstatus[{}],postype[{}],isprimary[{}],position[{}],company[{}],job[{}]", new Object[]{depempJob.get("posstatus.id"), depempJob.get("postype.id"), depempJob.get("isprimary"), depempJob.get("position.id"), depempJob.get("company.id"), depempJob.get("job.id")});
                    }
                }
                Map responseMap = (Map)WTCServiceHelper.invokeHRMPService("brm", "IBRMRuleService", "callRuleEngine", baseRequestMap);
                LOG.info("PlanRuleEngineService.batchCallRuleEngine.responseMap:{}", (Object)responseMap);
                planRuleEngineParam.setResponseMap(responseMap);
            }
            this.transferResponseParam();
        }
        catch (Exception ex) {
            LOG.warn("PlanRuleEngineService.batchCallRuleEngine.error:", (Throwable)ex);
            throw new WTCBizException((Throwable)ex);
        }
        return this.transferOutputParam();
    }

    private void extendInputParamMap(Map<String, Object> requestParamMap, String sceneNumber, PlanRuleEngineRequestParam planRuleEngineParam) {
        if (null == WTCRuleEngineSceneEnum.getPlanEnumByNumber((String)sceneNumber)) {
            return;
        }
        if (HRCollUtil.isEmpty((Collection)planRuleEngineParam.getFilterConditionList())) {
            return;
        }
        boolean extendFlag = false;
        HashSet<String> extendKeys = new HashSet<String>(4);
        for (String condition : planRuleEngineParam.getFilterConditionList()) {
            AccessDto accessDto;
            try {
                accessDto = (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
            }
            catch (Exception e) {
                throw new WTCBizException((Throwable)e, "parse error");
            }
            List<ConditionDto> conditionList = accessDto.getConditionList();
            for (ConditionDto conditionDto : conditionList) {
                String param = conditionDto.getParam();
                String[] split = param.split("\\.");
                String identify = split[0];
                if (!RuleEngineConstants.INPUT_PARAM_IDENTIFY_SET.contains(identify) || split.length < 3) {
                    extendFlag = true;
                    extendKeys.add(split.length < 3 ? split[0] : split[0] + "." + split[2]);
                    continue;
                }
                String fieldName = split[2];
                if (!this.isExtendField(identify, fieldName)) continue;
                extendFlag = true;
                extendKeys.add(identify + "." + fieldName);
            }
        }
        if (extendFlag) {
            PlanRuleEngineService.genInputParamExtend(requestParamMap, planRuleEngineParam, extendKeys, sceneNumber);
        }
    }

    private boolean isExtendField(String identify, String fieldName) {
        if (HRStringUtils.equalsIgnoreCase((String)"wtp_attfilebase", (String)identify) && !RuleEngineConstants.INPUT_PARAM_ATTFILE_SET.contains(fieldName)) {
            return true;
        }
        if (HRStringUtils.equalsIgnoreCase((String)"wtp_attendperson", (String)identify) && !RuleEngineConstants.INPUT_PARAM_ATTERSON_SET.contains(fieldName)) {
            return true;
        }
        return HRStringUtils.equalsIgnoreCase((String)"wtp_depempjob", (String)identify) && !RuleEngineConstants.INPUT_PARAM_EMPJOB_SET.contains(fieldName);
    }

    private static void genInputParamExtend(Map<String, Object> inputParaMap, PlanRuleEngineRequestParam planRuleEngineParam, Set<String> extendKeys, String sceneNumber) {
        WTCPluginProxy<RuleEngineInputParamExtPlugin> inputParamExtPlugin = WTCPluginProxyFactory.create(RuleEngineInputParamExtPlugin.class, "kd.sdk.wtc.wtp.business.ruleengine.RuleEngineInputParamExtPlugin");
        if (!inputParamExtPlugin.hasPlugin()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("RuleEngineInputParamExtPlugin,\u672a\u5b9e\u73b0\u6269\u5c55\u7c7b\u3002");
            }
            return;
        }
        long planVersionId = planRuleEngineParam.getPlan().getLong("id");
        HashMap<String, Object> extendMap = new HashMap<String, Object>(extendKeys.size());
        for (String extendKey : extendKeys) {
            extendMap.put(extendKey, null);
        }
        OnGenRuleEngineInputParamEvent param = new OnGenRuleEngineInputParamEvent(planRuleEngineParam.getDate(), sceneNumber, planVersionId, inputParaMap, extendKeys, extendMap);
        inputParamExtPlugin.invokeReplace(extPlugin -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RuleEngineInputParamExtPlugin,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)extPlugin.getClass().getName());
            }
            extPlugin.onGenInputParam(param);
        });
        for (Map.Entry entry : param.getExtendMap().entrySet()) {
            if (extendKeys.contains(entry.getKey())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6269\u5c55\u5165\u53c2\u5b57\u6bb5\u201c{0}\u201d\u8d85\u51fa\u89c4\u5219\u5f15\u64ce\u6269\u5c55\u5b57\u6bb5\u9650\u5236\u3002", (String)"PlanRuleEngineService_1", (String)"wtc-wtbs-business", (Object[])new Object[]{entry.getKey()}));
        }
    }

    private List<PlanRuleEngineOutParam> transferOutputParam() {
        ArrayList<PlanRuleEngineOutParam> outParamList = new ArrayList<PlanRuleEngineOutParam>(this.requestParamList.size());
        for (PlanRuleEngineRequestParam requestParam : this.requestParamList) {
            PlanRuleEngineOutParam outParam = new PlanRuleEngineOutParam();
            outParam.setPlan(requestParam.getPlan());
            outParam.setDate(requestParam.getDate());
            outParam.setRules(requestParam.getRule());
            outParam.setRule(PlanRuleEngineHelper.getDyTimeHis(requestParam.getRule(), requestParam.getDate()));
            outParam.setMatchResultList(requestParam.getMatchResultList());
            outParam.setAttFileDy(requestParam.getAttFile());
            outParamList.add(outParam);
        }
        return outParamList;
    }

    private List<PlanRuleEngineRequestParam> convertRequestParam(List<PlanRuleEngineInParam> inParamList) {
        ArrayList<PlanRuleEngineRequestParam> requestParamList = new ArrayList<PlanRuleEngineRequestParam>(inParamList.size());
        for (PlanRuleEngineInParam inParam : inParamList) {
            PlanRuleEngineRequestParam requestParam = new PlanRuleEngineRequestParam();
            requestParam.setAttFile(inParam.getAttFile());
            requestParam.setShift(inParam.getShift());
            requestParam.setPlan(inParam.getPlan());
            requestParam.setDate(inParam.getDate());
            requestParamList.add(requestParam);
        }
        return requestParamList;
    }

    private void transferResponseParam() {
        if (CollectionUtils.isEmpty(this.requestParamList)) {
            return;
        }
        for (PlanRuleEngineRequestParam planRuleEngineParam : this.requestParamList) {
            List policyResults;
            String responseCode;
            Map responseMap = planRuleEngineParam.getResponseMap();
            SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)responseMap);
            if (sceneResult == null || (responseCode = sceneResult.getResponseCode()) == null || !"200".equals(responseCode) || CollectionUtils.isEmpty((Collection)(policyResults = sceneResult.getPolicyResults()))) continue;
            planRuleEngineParam.setMatchResultList(this.getMatchResults(policyResults));
        }
        this.matchResult2Rule();
    }

    private List<Map<String, Object>> getMatchResults(List<PolicyResult> policyResults) {
        LOG.info("PlanRuleEngineService.getMatchResults.begin");
        ArrayList<Map<String, Object>> allMatchResultList = new ArrayList<Map<String, Object>>(policyResults.size());
        for (PolicyResult policyResult : policyResults) {
            Map defaultResults;
            ArrayList<Map> matchResultList = new ArrayList<Map>(8);
            List ruleResults = policyResult.getRuleResults();
            for (RuleResult ruleResult : ruleResults) {
                Map matchResults = ruleResult.getMatchResults();
                if (CollectionUtils.isEmpty((Map)matchResults)) continue;
                matchResultList.add(matchResults);
            }
            if (CollectionUtils.isEmpty(matchResultList) && !CollectionUtils.isEmpty((Map)(defaultResults = policyResult.getDefaultResults()))) {
                matchResultList.add(defaultResults);
            }
            if (CollectionUtils.isEmpty(matchResultList)) continue;
            allMatchResultList.addAll(matchResultList);
        }
        LOG.info("PlanRuleEngineService.getMatchResults.end");
        return allMatchResultList;
    }

    private void matchResult2Rule() {
        if (CollectionUtils.isEmpty(this.requestParamList)) {
            return;
        }
        LOG.info("PlanRuleEngineService.matchResult2Rule.begin");
        HashSet ruleIdSet = Sets.newHashSetWithExpectedSize((int)this.requestParamList.size());
        String entityId = "";
        for (PlanRuleEngineRequestParam requestParam : this.requestParamList) {
            HashSet ruleSetForRequestParam = Sets.newHashSetWithExpectedSize((int)this.requestParamList.size());
            List matchResultList = requestParam.getMatchResultList();
            if (CollectionUtils.isEmpty((Collection)matchResultList)) continue;
            for (Map matchResult : matchResultList) {
                entityId = this.getMatchRule(matchResult, ruleSetForRequestParam);
            }
            requestParam.setRuleBoIds((Set)ruleSetForRequestParam);
            ruleIdSet.addAll(ruleSetForRequestParam);
        }
        if (CollectionUtils.isEmpty((Collection)ruleIdSet)) {
            return;
        }
        Map<Long, List<DynamicObject>> ruleMap = this.getRuleList(ruleIdSet, this.initParam.getBeginDate(), this.initParam.getEndDate(), entityId);
        for (PlanRuleEngineRequestParam requestParam : this.requestParamList) {
            Set ruleBoIds = requestParam.getRuleBoIds();
            if (CollectionUtils.isEmpty((Collection)ruleBoIds)) continue;
            ArrayList ruleDys = Lists.newArrayListWithExpectedSize((int)ruleBoIds.size());
            for (Long ruleBoId : ruleBoIds) {
                if (ruleBoId == 0L) continue;
                ruleDys.addAll((Collection)ruleMap.get(ruleBoId));
            }
            requestParam.setRule((List)ruleDys);
        }
        LOG.info("PlanRuleEngineService.matchResult2Rule.end");
    }

    private String getMatchRule(Map<String, Object> matchResult, Set<Long> ruleIdSet) {
        String entityId = "";
        for (Map.Entry<String, Object> entry : matchResult.entrySet()) {
            String key = entry.getKey();
            if (!"rule".equals(key)) continue;
            Object value = entry.getValue();
            if (value instanceof DynamicObject) {
                DynamicObject rule = (DynamicObject)value;
                long ruleBoId = rule.getLong("id");
                ruleIdSet.add(ruleBoId);
                entityId = rule.getDynamicObjectType().getName();
            }
            if (!(value instanceof DynamicObjectCollection)) continue;
            DynamicObjectCollection valueDyCollection = (DynamicObjectCollection)value;
            for (DynamicObject valDy : valueDyCollection) {
                long ruleBoId = valDy.getLong("id");
                ruleIdSet.add(ruleBoId);
            }
            entityId = valueDyCollection.getDynamicObjectType().getName();
        }
        return entityId;
    }

    private Map<Long, List<DynamicObject>> getRuleList(Set<Long> ruleIdSet, Date startDate, Date endDate, String entityType) {
        LOG.info("PlanRuleEngineService.getRuleList.begin.entityType:{}", (Object)entityType);
        if (CollectionUtils.isEmpty(ruleIdSet) || HRStringUtils.isEmpty((String)entityType)) {
            return Collections.emptyMap();
        }
        QFilter qFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        qFilter.and("boid", "in", ruleIdSet);
        QFilter dateFilter = AttFileQueryHelper.getDateQFilter(startDate, endDate, true);
        qFilter.and(dateFilter);
        qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
        LOG.info("PlanRuleEngineService.getRuleList.qFilter:{}", (Object)qFilter);
        DynamicObject[] dynamicObjects = new HRBaseServiceHelper(entityType).loadDynamicObjectArray(qFilter.toArray());
        return Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    @Override
    @Deprecated
    public Optional<DynamicObject> getRuleFromRuleEngineParam(List<PlanRuleEngineOutParam> outParamList, DynamicObject planDy) {
        if (CollectionUtils.isEmpty(outParamList)) {
            return Optional.empty();
        }
        long planId = planDy.getLong("id");
        Optional<PlanRuleEngineOutParam> resultOptional = outParamList.stream().filter(outParam -> planId == outParam.getPlan().getLong("id")).findAny();
        if (resultOptional.isPresent()) {
            return Optional.ofNullable(resultOptional.get().getRule());
        }
        return Optional.empty();
    }

    @Override
    public Optional<DynamicObject> getRuleFromRuleEngineParam(List<PlanRuleEngineOutParam> outParamList, DynamicObject planDy, Date date, DynamicObject attFileDy) {
        if (CollectionUtils.isEmpty(outParamList)) {
            return Optional.empty();
        }
        long planId = planDy.getLong("id");
        Optional<PlanRuleEngineOutParam> resultOptional = outParamList.stream().filter(outParam -> planId == outParam.getPlan().getLong("id") && outParam.getAttFileDy() != null && outParam.getDate() != null && date != null && outParam.getDate().compareTo(date) == 0 && attFileDy != null && attFileDy.getLong("id") == outParam.getAttFileDy().getLong("id")).findAny();
        return resultOptional.map(PlanRuleEngineOutParam::getRule);
    }
}

