/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.billservice.baseset.BillBaseStateLessService;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyAdvanceAndAfterDetail;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillAdvanceAfterInfo;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoQuery;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceAdvAfterResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceBaseNewSetInfo;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class AdvanceAfterValidateUtil {
    private static final Log LOG = LogFactory.getLog(AdvanceAfterValidateUtil.class);

    protected static Tuple<Boolean, String> buildAdvanceAfterResp(Map<BillAdvanceAfterEnum, List<BillServiceAdvAfterResp>> resp, BillServiceBaseNewSetInfo baseNewSetInfo) {
        if (WTCCollections.isEmpty(resp) || baseNewSetInfo == null) {
            return new Tuple((Object)true, null);
        }
        BillServiceAdvAfterResp advance = AdvanceAfterValidateUtil.matchResp(BillAdvanceAfterEnum.ADVANCE, baseNewSetInfo, resp);
        BillServiceAdvAfterResp after = AdvanceAfterValidateUtil.matchResp(BillAdvanceAfterEnum.AFTER, baseNewSetInfo, resp);
        BillServiceAdvAfterResp maxAdvance = AdvanceAfterValidateUtil.matchResp(BillAdvanceAfterEnum.MAX_ADVANCE, baseNewSetInfo, resp);
        if (advance != null && advance.getBillPeriodInfoResp() != null && BaseSetUnitTypeEnum.PERIOD.getCode().equals(advance.getLimitUnit()) && !advance.getBillPeriodInfoResp().isAdvancePeriodCheck()) {
            String tipInfo = advance.getBillPeriodInfoResp().getTipInfo();
            return new Tuple((Object)false, (Object)tipInfo);
        }
        if (after != null && after.getBillPeriodInfoResp() != null && BaseSetUnitTypeEnum.PERIOD.getCode().equals(after.getLimitUnit()) && !after.getBillPeriodInfoResp().isAfterPeriodCheck()) {
            String tipInfo = after.getBillPeriodInfoResp().getTipInfo();
            return new Tuple((Object)false, (Object)tipInfo);
        }
        if (maxAdvance != null && maxAdvance.getBillPeriodInfoResp() != null && BaseSetUnitTypeEnum.PERIOD.getCode().equals(maxAdvance.getLimitUnit()) && !maxAdvance.getBillPeriodInfoResp().isMaxAdvancePeriodCheck()) {
            String tipInfo = maxAdvance.getBillPeriodInfoResp().getTipInfo();
            return new Tuple((Object)false, (Object)tipInfo);
        }
        if (advance != null && !advance.isPassCheck()) {
            String unit = AdvanceAfterValidateUtil.buildUnitInfoByBaseSet(advance.getLimitNum(), advance.getLimitUnit());
            String errorMsg = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u81f3\u5c11\u9700\u8981\u63d0\u524d%s\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"AdvanceAfterValidateUtil_0", (String)"wtc-wtbs-business", (Object[])new Object[]{unit});
            return new Tuple((Object)false, (Object)errorMsg);
        }
        if (after != null && !after.isPassCheck()) {
            String unit = AdvanceAfterValidateUtil.buildUnitInfoByBaseSet(after.getLimitNum(), after.getLimitUnit());
            String errorMsg = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u5141\u8bb8\u8865\u63d0%s\u5185\u7684\u7533\u8bf7\u3002", (String)"AdvanceAfterValidateUtil_1", (String)"wtc-wtbs-business", (Object[])new Object[]{unit});
            return new Tuple((Object)false, (Object)errorMsg);
        }
        if (maxAdvance != null && !maxAdvance.isPassCheck()) {
            String unit = AdvanceAfterValidateUtil.buildUnitInfoByBaseSet(maxAdvance.getLimitNum(), maxAdvance.getLimitUnit());
            String errorMsg = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u53ea\u80fd\u63d0\u4ea4%s\u5185\u7684\u7533\u8bf7\u3002", (String)"AdvanceAfterValidateUtil_3", (String)"wtc-wtbs-business", (Object[])new Object[]{unit});
            return new Tuple((Object)false, (Object)errorMsg);
        }
        return new Tuple((Object)true, null);
    }

    private static BillServiceAdvAfterResp matchResp(BillAdvanceAfterEnum advanceAfterEnum, BillServiceBaseNewSetInfo baseNewSetInfo, Map<BillAdvanceAfterEnum, List<BillServiceAdvAfterResp>> resp) {
        List<BillServiceAdvAfterResp> resps = resp.get(advanceAfterEnum);
        if (WTCCollections.isEmpty(resps)) {
            return null;
        }
        for (BillServiceAdvAfterResp billServiceAdvAfterResp : resps) {
            if (billServiceAdvAfterResp.getBaseSetInfo() == null || !billServiceAdvAfterResp.getBaseSetInfo().equals((Object)baseNewSetInfo)) continue;
            return billServiceAdvAfterResp;
        }
        return null;
    }

    protected static Tuples.Tuple2<Boolean, String> buildAdvanceAfterResp(UnifyBillAdvanceAfterInfo checkBase, Map<Date, UnifyBillAdvanceAfterInfo> advanceAndAfterInfo) {
        String errorMsg;
        String unit;
        if (WTCCollections.isEmpty(advanceAndAfterInfo)) {
            return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)"");
        }
        List<Date> dates = advanceAndAfterInfo.keySet().stream().sorted().collect(Collectors.toList());
        LinkedHashSet<LocalDate> localDates = new LinkedHashSet<LocalDate>(16);
        for (Date date : dates) {
            localDates.add(WTCDateUtils.toLocalDate((Date)date));
        }
        HashMap<LocalDate, Integer> dutyDateAndWeekDay = new HashMap<LocalDate, Integer>(16);
        for (Map.Entry<Date, UnifyBillAdvanceAfterInfo> entry : advanceAndAfterInfo.entrySet()) {
            UnifyBillAdvanceAfterInfo value = entry.getValue();
            Date dutyDate = entry.getKey();
            if (value == null || dutyDate == null) continue;
            dutyDateAndWeekDay.put(WTCDateUtils.toLocalDate((Date)dutyDate), value.getWeekDayOffSet());
        }
        UnifyAdvanceAndAfterDetail unifyAdvanceAndAfterDetail = checkBase.getAfterInfo();
        UnifyAdvanceAndAfterDetail unifyAdvanceAndAfterDetail2 = checkBase.getAdvanceInfo();
        Tuples.Tuple2<Boolean, String> period = AdvanceAfterValidateUtil.verifyAfterAndAdvancePeriod(dates, checkBase, checkBase.getPersonId());
        if (!((Boolean)period.item1).booleanValue()) {
            return new Tuples.Tuple2((Object)Boolean.FALSE, period.item2);
        }
        if (checkBase.isCheckAdvance() && unifyAdvanceAndAfterDetail2 != null && unifyAdvanceAndAfterDetail2.isNeedVerify()) {
            unit = AdvanceAfterValidateUtil.buildUnitInfoByBaseSet(unifyAdvanceAndAfterDetail2.getAdvanceAfterNum(), unifyAdvanceAndAfterDetail2.getAdvanceAfterUnit());
            errorMsg = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u81f3\u5c11\u9700\u8981\u63d0\u524d%s\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"AdvanceAfterValidateUtil_4", (String)"wtc-wtbs-business", (Object[])new Object[]{unit});
            if (BaseSetUnitTypeEnum.DAY.getCode().equals(unifyAdvanceAndAfterDetail2.getAdvanceAfterUnit()) && !BillBaseStateLessService.passDay(localDates, unifyAdvanceAndAfterDetail2.getAdvanceAfterNum(), BillAdvanceAfterEnum.ADVANCE)) {
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)errorMsg);
            }
            if (BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(unifyAdvanceAndAfterDetail2.getAdvanceAfterUnit()) && !BillBaseStateLessService.passWorkDay(dutyDateAndWeekDay, unifyAdvanceAndAfterDetail2.getAdvanceAfterNum(), BillAdvanceAfterEnum.ADVANCE)) {
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)errorMsg);
            }
        }
        if (checkBase.isCheckAfter() && unifyAdvanceAndAfterDetail != null && unifyAdvanceAndAfterDetail.isNeedVerify()) {
            unit = AdvanceAfterValidateUtil.buildUnitInfoByBaseSet(unifyAdvanceAndAfterDetail.getAdvanceAfterNum(), unifyAdvanceAndAfterDetail.getAdvanceAfterUnit());
            errorMsg = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u5141\u8bb8\u8865\u63d0%s\u5185\u7684\u7533\u8bf7\u3002", (String)"AdvanceAfterValidateUtil_5", (String)"wtc-wtbs-business", (Object[])new Object[]{unit});
            if (BaseSetUnitTypeEnum.DAY.getCode().equals(unifyAdvanceAndAfterDetail.getAdvanceAfterUnit()) && !BillBaseStateLessService.passDay(localDates, unifyAdvanceAndAfterDetail.getAdvanceAfterNum(), BillAdvanceAfterEnum.AFTER)) {
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)errorMsg);
            }
            if (BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(unifyAdvanceAndAfterDetail.getAdvanceAfterUnit()) && !BillBaseStateLessService.passWorkDay(dutyDateAndWeekDay, unifyAdvanceAndAfterDetail.getAdvanceAfterNum(), BillAdvanceAfterEnum.AFTER)) {
                return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)errorMsg);
            }
        }
        return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)"");
    }

    public static Tuples.Tuple2<Boolean, String> verifyAfterAndAdvancePeriod(List<Date> verifyDate, UnifyBillAdvanceAfterInfo advanceAfterInfo, long personId) {
        BillPeriodInfoResp billPeriodInfoResp;
        String tipInfo;
        String afterUnit;
        UnifyAdvanceAndAfterDetail advanceInfo;
        String afterUnit2;
        if (advanceAfterInfo == null || WTCCollections.isEmpty(verifyDate)) {
            return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)"");
        }
        BillAttFileService billAttFileService = new BillAttFileService();
        UnifyAdvanceAndAfterDetail afterInfo = advanceAfterInfo.getAfterInfo();
        BillPeriodInfoQuery query = new BillPeriodInfoQuery();
        query.setMaxAdvance(null);
        query.setPersonId(personId);
        query.setPeriodBillCheckResult(advanceAfterInfo.getPeriodBillCheckResult());
        query.setCheckAdvance(advanceAfterInfo.isCheckAdvance());
        query.setCheckAfter(advanceAfterInfo.isCheckAfter());
        LinkedHashSet<LocalDate> linkedHashSet = new LinkedHashSet<LocalDate>(16);
        for (Date date : verifyDate) {
            linkedHashSet.add(WTCDateUtils.toLocalDate((Date)date));
        }
        query.setVerifyDate(linkedHashSet);
        boolean needCheckPeriod = false;
        if (afterInfo != null && afterInfo.isNeedVerify() && HRStringUtils.equals((String)(afterUnit2 = afterInfo.getAdvanceAfterUnit()), (String)BaseSetUnitTypeEnum.PERIOD.getCode())) {
            query.setAfter(afterInfo.getAdvanceAfterNum());
            needCheckPeriod = true;
        }
        if ((advanceInfo = advanceAfterInfo.getAdvanceInfo()) != null && advanceInfo.isNeedVerify() && HRStringUtils.equals((String)(afterUnit = advanceInfo.getAdvanceAfterUnit()), (String)BaseSetUnitTypeEnum.PERIOD.getCode())) {
            query.setAdvance(advanceInfo.getAdvanceAfterNum());
            needCheckPeriod = true;
        }
        if (needCheckPeriod && HRStringUtils.isNotEmpty((String)(tipInfo = (billPeriodInfoResp = billAttFileService.checkBillPeriod(query)).getTipInfo()))) {
            return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)tipInfo);
        }
        return new Tuples.Tuple2((Object)Boolean.TRUE, (Object)"");
    }

    @Deprecated
    protected static Tuple<Boolean, BillResponse> buildAdvanceAfterResp(Map<Date, UnifyBillAdvanceAfterInfo> advanceAndAfterInfo, List<String> msg) {
        String errorMsg;
        boolean success = true;
        Iterator<Map.Entry<Date, UnifyBillAdvanceAfterInfo>> iterator = advanceAndAfterInfo.entrySet().iterator();
        String afterStr = "";
        String advanceStr = "";
        if (LOG.isInfoEnabled()) {
            LOG.info("AdvanceAfterValidateUtil.buildAdvanceAfterResp advanceAndAfterInfo = {}", (Object)JSON.toJSONString(advanceAndAfterInfo.values()));
        }
        Date curDate = WTCDateUtils.toDate((LocalDate)LocalDate.now());
        while (iterator.hasNext()) {
            Map.Entry<Date, UnifyBillAdvanceAfterInfo> next = iterator.next();
            UnifyBillAdvanceAfterInfo errorInfo = next.getValue();
            Date checkDate = next.getKey();
            if (!Objects.nonNull(errorInfo)) continue;
            String info = "";
            boolean isAdvance = checkDate.compareTo(curDate) >= 0;
            UnifyAdvanceAndAfterDetail advanceInfo = errorInfo.getAdvanceInfo();
            UnifyAdvanceAndAfterDetail afterInfo = errorInfo.getAfterInfo();
            if (errorInfo.isPassAfter() != null && !errorInfo.isPassAfter().booleanValue() && afterInfo != null && StringUtils.equalsAny((CharSequence)afterInfo.getAdvanceAfterUnit(), (CharSequence[])new String[]{BaseSetUnitTypeEnum.WEEKDAY.getCode(), BaseSetUnitTypeEnum.DAY.getCode()}) && !isAdvance) {
                info = AdvanceAfterValidateUtil.buildUnitInfoByBaseSet(errorInfo.getAfterInfo().getAdvanceAfterNum(), errorInfo.getAfterInfo().getAdvanceAfterUnit());
                afterStr = ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u8865\u63d0%s\u5185\u7684\u7533\u8bf7\u3002", (String)"AdvanceAfterValidateUtil_6", (String)"wtc-wtbs-business", (Object[])new Object[]{info});
                success = false;
                break;
            }
            if (errorInfo.isPassAdvance() == null || errorInfo.isPassAdvance().booleanValue() || advanceInfo == null || !StringUtils.equalsAny((CharSequence)advanceInfo.getAdvanceAfterUnit(), (CharSequence[])new String[]{BaseSetUnitTypeEnum.WEEKDAY.getCode(), BaseSetUnitTypeEnum.DAY.getCode()}) || !isAdvance || !HRStringUtils.isEmpty((String)advanceStr)) continue;
            info = AdvanceAfterValidateUtil.buildUnitInfoByBaseSet(errorInfo.getAdvanceInfo().getAdvanceAfterNum(), errorInfo.getAdvanceInfo().getAdvanceAfterUnit());
            advanceStr = ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u63d0\u524d%s\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"AdvanceAfterValidateUtil_7", (String)"wtc-wtbs-business", (Object[])new Object[]{info});
            success = false;
        }
        if (HRStringUtils.isNotEmpty((String)afterStr)) {
            errorMsg = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c%s", (String)"AdvanceAfterValidateUtil_8", (String)"wtc-wtbs-business", (Object[])new Object[]{afterStr});
            msg.add(errorMsg);
        } else if (HRStringUtils.isNotEmpty((String)advanceStr)) {
            errorMsg = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c%s", (String)"AdvanceAfterValidateUtil_9", (String)"wtc-wtbs-business", (Object[])new Object[]{advanceStr});
            msg.add(errorMsg);
        }
        return new Tuple((Object)success, null);
    }

    private static String buildUnitInfoByBaseSet(Integer failCheckAdvanceAfterNum, String failCheckAdvanceAfterUnit) {
        String info = "";
        if (BaseSetUnitTypeEnum.DAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"%s\u4e2a\u81ea\u7136\u65e5", (String)"AdvanceAfterValidateUtil_10", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.MONTH.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"%s\u4e2a\u6708", (String)"AdvanceAfterValidateUtil_11", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.PERIOD.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"%s\u4e2a\u8003\u52e4\u671f\u95f4", (String)"AdvanceAfterValidateUtil_12", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"%s\u4e2a\u5de5\u4f5c\u65e5", (String)"AdvanceAfterValidateUtil_13", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        }
        return info;
    }

    private static String linkErrorInfo(String str, String adviceOrAfter) {
        if (!str.contains(adviceOrAfter)) {
            if (!HRStringUtils.isEmpty((String)str)) {
                str = ResManager.loadKDString((String)"\u540c\u65f6%s", (String)"AdvanceAfterValidateUtil_14", (String)"wtc-wtbs-business", (Object[])new Object[]{str});
            }
            str = adviceOrAfter + str;
        }
        return str;
    }
}

