/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.service.BatchBillCheckParam;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class BatchBillCheckService {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static BatchBillCheckService batchBillCheckService = new BatchBillCheckService();

    public static BatchBillCheckService getInstance() {
        return batchBillCheckService;
    }

    public String checkEverDayHasRule(BatchBillCheckParam billCheckParam, Map<Date, DynamicObject> ruleDy, DynamicObject billEntry) {
        long attFileBoId = billCheckParam.getAttFileBoId();
        WtcAbstractUnityBillOperator operator = billCheckParam.getOperator();
        ApplyBillCheckEnum checkEnum = billCheckParam.getCheckEnum();
        UnifyBillEnum unifyBillEnum = billCheckParam.getUnifyBillEnum();
        String errorMsg = "";
        if (ruleDy.containsValue(null)) {
            List<Date> nonRuleDayList = this.getNonRuleDays(ruleDy);
            if (WTCCollections.isEmpty(nonRuleDayList)) {
                return "";
            }
            Date startNonRuleDay = nonRuleDayList.get(0);
            Date endNonRuleDay = nonRuleDayList.get(nonRuleDayList.size() - 1);
            Map<Date, UnifyBillDutyInfoResult> unifyBillDutyInfoResults = this.getUnifyBillDutyInfoResults(attFileBoId, operator);
            List<Object> noRuleDates = Lists.newArrayList();
            if (WTCCollections.isNotEmpty(unifyBillDutyInfoResults)) {
                noRuleDates = this.getNoRuleDates(unifyBillDutyInfoResults, startNonRuleDay, endNonRuleDay);
            }
            if (WTCCollections.isEmpty((Collection)noRuleDates)) {
                long targetTypeId = billEntry.getLong(checkEnum.getType() + ".id");
                String targetTypeName = billEntry.getString(checkEnum.getType() + ".name");
                List<Object> noTypeDates = Lists.newArrayList();
                if (WTCCollections.isNotEmpty(unifyBillDutyInfoResults)) {
                    noTypeDates = this.getNoTypeDates(unifyBillDutyInfoResults, nonRuleDayList, targetTypeId);
                }
                errorMsg = WTCCollections.isEmpty((Collection)noTypeDates) ? BatchBillKDString.notInLimit((String)targetTypeName) : BatchBillKDString.noHaveType((String)targetTypeName);
            } else {
                Date endDate;
                List sortedDate = noRuleDates.stream().sorted().collect(Collectors.toList());
                Date startDate = (Date)sortedDate.get(0);
                errorMsg = startDate.compareTo(endDate = (Date)sortedDate.get(sortedDate.size() - 1)) == 0 ? String.format(ResManager.loadKDString((String)"%1$s\u672a\u8bbe\u7f6e%2$s\u89c4\u5219\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_18", (String)"wtc-wtbs-business", (Object[])new Object[0]), simpleDateFormat.format(startDate), unifyBillEnum.getDescriptionStr()) : String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u672a\u8bbe\u7f6e%3$s\u89c4\u5219\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_19", (String)"wtc-wtbs-business", (Object[])new Object[0]), simpleDateFormat.format(startDate), simpleDateFormat.format(endDate), unifyBillEnum.getDescriptionStr());
            }
        }
        return errorMsg;
    }

    private List<Date> getNoTypeDates(Map<Date, UnifyBillDutyInfoResult> unifyBillDutyInfoResults, List<Date> nonRuleDayList, long targetTypeId) {
        ArrayList<Date> noTypeDates = new ArrayList<Date>(nonRuleDayList.size());
        if (unifyBillDutyInfoResults == null) {
            noTypeDates.addAll(nonRuleDayList);
        } else {
            for (Date date : nonRuleDayList) {
                UnifyBillDutyInfoResult dutyInfoResult = unifyBillDutyInfoResults.get(date);
                if (dutyInfoResult != null && dutyInfoResult.getRuleCalIds().contains(targetTypeId)) continue;
                noTypeDates.add(date);
            }
        }
        return noTypeDates;
    }

    private List<Date> getNoRuleDates(Map<Date, UnifyBillDutyInfoResult> unifyBillDutyInfoResults, Date startNonRuleDay, Date endNonRuleDay) {
        if (unifyBillDutyInfoResults == null) {
            return Collections.emptyList();
        }
        List<Date> noRuleDates = unifyBillDutyInfoResults.entrySet().stream().filter(item -> ((Date)item.getKey()).compareTo(startNonRuleDay) >= 0 && ((Date)item.getKey()).compareTo(endNonRuleDay) <= 0).filter(item -> item.getValue() == null || ((UnifyBillDutyInfoResult)item.getValue()).getMatchRuleDy() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        return noRuleDates;
    }

    private List<Date> getNonRuleDays(Map<Date, DynamicObject> ruleDyMap) {
        ArrayList<Date> list = new ArrayList<Date>(4);
        for (Map.Entry<Date, DynamicObject> next : ruleDyMap.entrySet()) {
            if (!Objects.isNull(next.getValue())) continue;
            list.add(next.getKey());
        }
        return list;
    }

    private Map<Date, UnifyBillDutyInfoResult> getUnifyBillDutyInfoResults(long attFileBoId, WtcAbstractUnityBillOperator operator) {
        UnifyBillInfoContext infoContext = operator.getInfoContext();
        if (infoContext == null) {
            return null;
        }
        List billResult = infoContext.getBillResult();
        if (WTCCollections.isEmpty((Collection)billResult)) {
            return null;
        }
        Optional<UnifyBillResult> first = billResult.stream().filter(item -> item.getAttFileBoId() == attFileBoId).findFirst();
        ArrayList<UnifyBillDutyInfoResult> dutyInfoResults = new ArrayList<UnifyBillDutyInfoResult>(16);
        if (first.isPresent()) {
            UnifyBillResult unifyBillResult = first.get();
            List entryResultList = unifyBillResult.getEntryResultList();
            if (WTCCollections.isEmpty((Collection)entryResultList)) {
                return null;
            }
            for (UnifyBillEntryResult unifyBillEntryResult : entryResultList) {
                List dutyInfos;
                if (unifyBillEntryResult == null || WTCCollections.isEmpty((Collection)(dutyInfos = unifyBillEntryResult.getDutyInfos()))) continue;
                for (UnifyBillDutyInfoResult dutyInfoResult : dutyInfos) {
                    dutyInfoResults.add(dutyInfoResult);
                }
            }
        }
        return dutyInfoResults.stream().collect(Collectors.toMap(item -> item.getDutyDate(), Function.identity(), (o1, o2) -> o1));
    }
}

