/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.daterange.IDateRangeService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.service.AdvanceAfterValidateUtil;
import kd.wtc.wtbs.business.web.applybill.service.BatchBillCheckParam;
import kd.wtc.wtbs.business.web.applybill.service.BatchBillCheckService;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.business.web.applybill.service.LactationCheckService;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.billservice.dutyDate.BillOptionalDutyDateService;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.bill.BillQueryEnum;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.ApplyBillBaseSetEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.ApplyBillDutyDateErrorEnum;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.enums.bill.unify.BillSourceTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.BillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.BillFailInfo;
import kd.wtc.wtbs.common.model.bill.VaInfoBo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyAdvanceAndAfterDetail;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillAdvanceAfterInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyServiceEntryInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillExpandInfo;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateReq;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateResp;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.BooleanUtils;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailItemPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailPreviewVo;

public abstract class BillCheckService {
    private static final Log LOG = LogFactory.getLog(BillCheckService.class);
    protected static final Set<String> STATUS_LIST = Sets.newHashSet((Object[])new String[]{"C", "B", "D"});
    private final WtcAbstractUnityBillOperator check;
    private String attFileF7AuthEntity;
    private final UnifyBillApplyAttr billApplyAttr;
    private final ApplyBillCheckEnum checkEnum;
    private final UnifyBillEnum unifyBillEnum;
    private List<DynamicObject> dyList;
    protected boolean isImport = false;
    private Map<String, Set<LocalDate>> contextCustomOver24Date;

    protected WtcAbstractUnityBillOperator getCheck() {
        return this.check;
    }

    protected ApplyBillCheckEnum getCheckEnum() {
        return this.checkEnum;
    }

    protected UnifyBillEnum getUnifyBillEnum() {
        return this.unifyBillEnum;
    }

    protected List<DynamicObject> getDyList() {
        return this.dyList;
    }

    private void setDyList(List<DynamicObject> dys) {
        this.dyList = dys;
    }

    protected UnifyBillApplyAttr getBillApplyAttr() {
        return this.billApplyAttr;
    }

    public abstract IDateRangeService getDateRangeService();

    public abstract HRBaseServiceHelper getBaseServiceHelper();

    @Deprecated
    public BillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, String attFileF7AuthEntity) {
        this.billApplyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        this.checkEnum = checkEnum;
        this.unifyBillEnum = unifyBillEnum;
        this.dyList = dyList;
        this.check = this.startInitContext(dyList, this.billApplyAttr);
        this.attFileF7AuthEntity = attFileF7AuthEntity;
    }

    @Deprecated
    public BillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, WtcAbstractUnityBillOperator operator, String attFileF7AuthEntity) {
        this.checkEnum = checkEnum;
        this.unifyBillEnum = unifyBillEnum;
        this.dyList = dyList;
        this.check = operator;
        this.attFileF7AuthEntity = attFileF7AuthEntity;
        this.billApplyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
    }

    public BillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, WtcAbstractUnityBillOperator operator, UnifyBillApplyAttr applyAttr) {
        this.checkEnum = checkEnum;
        this.unifyBillEnum = unifyBillEnum;
        this.dyList = dyList;
        if (operator == null) {
            operator = this.startInitContext(dyList, applyAttr);
        }
        this.check = operator;
        this.billApplyAttr = applyAttr;
    }

    public BillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, WtcAbstractUnityBillOperator operator, UnifyBillApplyAttr applyAttr, boolean isImport) {
        this.checkEnum = checkEnum;
        this.unifyBillEnum = unifyBillEnum;
        this.dyList = dyList;
        if (operator == null) {
            operator = this.startInitContext(dyList, applyAttr);
        }
        this.check = operator;
        if (isImport) {
            applyAttr.setSourceType(BillSourceTypeEnum.IMPORT);
        }
        this.billApplyAttr = applyAttr;
        this.isImport = isImport;
    }

    @Deprecated
    public BillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, DynamicObject dynamicObject, String attFileF7AuthEntity) {
        this(checkEnum, unifyBillEnum, Collections.singletonList(dynamicObject), attFileF7AuthEntity);
    }

    private WtcAbstractUnityBillOperator startInitContext(List<DynamicObject> dyList, UnifyBillApplyAttr applyAttr) {
        return this.initContext(dyList, applyAttr);
    }

    protected abstract WtcAbstractUnityBillOperator initContext(List<DynamicObject> var1, UnifyBillApplyAttr var2);

    public abstract BillResponse checkBillRepeat();

    protected abstract void setCustomEntry(DynamicObject var1, BillApplyTimeResult var2);

    protected abstract BillEntityCheckService getBillEntityCheckService(Long var1, UnifyBillEnum var2, ApplyBillCheckEnum var3, DynamicObject var4, String var5);

    protected abstract BillEntityCheckService getBillEntityCheckService(Long var1, DynamicObject var2, UnifyBillEnum var3, ApplyBillCheckEnum var4, String var5);

    protected BillResponse checkSubEntryInfo(DynamicObject billDyn, DynamicObject row, BillEntityCheckService entityCheckService) {
        return BillResponse.success();
    }

    public static List<UnifyBillApplyInitInfo> createUnifyBillApplyInfo(List<DynamicObject> dyList, ApplyBillCheckEnum checkEnum) {
        ArrayList<UnifyBillApplyInitInfo> list = new ArrayList<UnifyBillApplyInitInfo>(dyList.size());
        for (DynamicObject dy : dyList) {
            UnifyBillApplyInitInfo initInfo = BillCheckService.transformOne(dy, checkEnum);
            list.add(initInfo);
        }
        return list;
    }

    private static UnifyBillApplyInitInfo transformOne(DynamicObject dy, ApplyBillCheckEnum checkEnum) {
        Object pkValue = dy.getPkValue();
        long attfile = dy.getLong(checkEnum.getAttfile() + ".id");
        List<UnifyBillApplyServiceEntryInitInfo> entryInitInfoList = BillCheckService.transformEntryRow(dy.getDynamicObjectCollection("entryentity"), checkEnum);
        return new UnifyBillApplyInitInfo(pkValue, attfile, entryInitInfoList);
    }

    private static List<UnifyBillApplyServiceEntryInitInfo> transformEntryRow(DynamicObjectCollection dynamicObjectCollection, ApplyBillCheckEnum checkEnum) {
        ArrayList<UnifyBillApplyServiceEntryInitInfo> list = new ArrayList<UnifyBillApplyServiceEntryInitInfo>(dynamicObjectCollection.size());
        for (DynamicObject entry : dynamicObjectCollection) {
            Object entryId = entry.getPkValue();
            Date startDate = entry.getDate(checkEnum.getStartDate());
            Date endDate = entry.getDate(checkEnum.getEndDate());
            long typeId = entry.getLong(checkEnum.getType() + ".id");
            String startMethod = entry.getString(checkEnum.getStartMethod());
            String endMethod = entry.getString(checkEnum.getEndMethod());
            UnifyBillApplyServiceEntryInitInfo billApplyServiceEntryInitInfo = new UnifyBillApplyServiceEntryInitInfo(entryId, startDate, endDate, typeId);
            UnifyBillExpandInfo billExpandInfo = new UnifyBillExpandInfo(startMethod, endMethod);
            billApplyServiceEntryInitInfo.setExpandInfo((Object)billExpandInfo);
            list.add(billApplyServiceEntryInitInfo);
        }
        return list;
    }

    public BillResponse checkAll() {
        ArrayList messages = new ArrayList(10);
        Object data = null;
        BillResponse billResponse = this.checkAttfile();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkStartDateAndEndDate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("checkStartDateAndEndDate:{}", (Object)billResponse.isSuccess());
        }
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        List<DynamicObject> dysCopy = this.ignoreTPLoseEfficacy();
        billResponse = this.checkBaseSet();
        this.recoverDyList(dysCopy);
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        if (!CollectionUtils.isEmpty((Collection)billResponse.getMessage())) {
            messages.addAll(billResponse.getMessage());
            data = billResponse.getData();
        }
        if (!(billResponse = this.checkChangeSet()).isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkBillRepeat();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse.setMessage(messages);
        billResponse.setData(data);
        return billResponse;
    }

    public BillResponse refresh() {
        ArrayList messages = new ArrayList(10);
        Object data = null;
        BillResponse billResponse = this.checkAttfile();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkStartDateAndEndDate();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        List<DynamicObject> dysCopy = this.ignoreTPLoseEfficacy();
        billResponse = this.checkBaseSet();
        this.recoverDyList(dysCopy);
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        if (!CollectionUtils.isEmpty((Collection)billResponse.getMessage())) {
            messages.addAll(billResponse.getMessage());
            data = billResponse.getData();
        }
        billResponse.setMessage(messages);
        billResponse.setData(data);
        return billResponse;
    }

    public BillResponse havePlan() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            long attfile = WTCDynamicObjectUtils.getBaseDataId(dynamicObject, this.checkEnum.getAttfile());
            List<DynamicObject> allPlan = this.check.getAllPlan(attfile);
            if (!CollectionUtils.isEmpty(allPlan)) continue;
            String errorMsg = String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%1$s\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7%2$s\u3002", (String)"BillCommonCheckerService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.unifyBillEnum.getDescriptionStr(), this.unifyBillEnum.getDescriptionStr());
            msg.add(errorMsg);
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkStartDateAndEndDate() {
        BillResponse billResponse = this.checkAttfileBoBsed();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkAttfileHisAuth();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkRoster();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkFrozenScope();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkNotInSuspend();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkWorkExperience();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkEverDayHasPlan();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        return BillResponse.success();
    }

    public BillResponse checkBaseSet() {
        ArrayList messages = new ArrayList(10);
        Object data = null;
        BillResponse billResponse = this.checkEverDayHasRule();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkLactation();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkPersonInfo();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkEverDateRage();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        if (!CollectionUtils.isEmpty((Collection)billResponse.getMessage())) {
            messages.addAll(billResponse.getMessage());
            data = billResponse.getData();
        }
        if (!(billResponse = this.checkAdviceAndAfter()).isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkApplyTime();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkMustInput();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        return BillResponse.success((Object)data, messages);
    }

    public BillResponse checkLactation() {
        return BillResponse.success();
    }

    public BillResponse checkAttfile() {
        BillResponse billResponse = this.havePlan();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        return BillResponse.success();
    }

    public BillResponse checkHisBillRepeat(List<DynamicObject> dyList) {
        return BillResponse.success();
    }

    public BillResponse checkStagingBillRepeat() {
        Map<Long, List<DynamicObject>> dyListPersonIdMap = this.dyList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("personid.id")));
        for (Map.Entry<Long, List<DynamicObject>> personBill : dyListPersonIdMap.entrySet()) {
            Long personId = personBill.getKey();
            List<DynamicObject> dynamicObjects = personBill.getValue();
            ArrayList<DynamicObject> entityCollection = new ArrayList<DynamicObject>(10);
            dynamicObjects.forEach(dynamicObject -> entityCollection.addAll((Collection<DynamicObject>)dynamicObject.getDynamicObjectCollection("entryentity")));
            int count = entityCollection.size();
            BillResponse billResponse = this.docheckRepeat(entityCollection, personId);
            if (billResponse.isSuccess()) continue;
            Object data = billResponse.getData();
            BillFailInfo failInfo = (BillFailInfo)data;
            ArrayList<String> msgList = new ArrayList<String>(10);
            Set billNos = this.dyList.stream().filter(element -> failInfo.getErrorInfos().containsKey(element.getLong("id"))).map(dy -> dy.getString("billno")).collect(Collectors.toSet());
            String billNoStr = billNos.stream().collect(Collectors.joining("\u3001"));
            String errorMsg = ResManager.loadKDString((String)"\u5355\u636e%s\u4e4b\u95f4\u7684\u7533\u8bf7\u65f6\u6bb5\u5b58\u5728\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u540e\u63d0\u4ea4\u3002", (String)"BillCommonCheckerService_3", (String)"wtc-wtbs-business", (Object[])new Object[]{billNoStr});
            if (BillSourceTypeEnum.OPENAPI != this.getBillApplyAttr().getSourceType()) {
                errorMsg = this.getMsg(count, failInfo.getFailIndex(), errorMsg);
            }
            Set billIds = failInfo.getErrorInfos().keySet();
            for (Long billId : billIds) {
                failInfo.getErrorInfos().put(billId, errorMsg);
            }
            msgList.add(errorMsg);
            return BillResponse.error((Object)failInfo, msgList);
        }
        return BillResponse.success();
    }

    protected BillResponse docheckRepeat(List<DynamicObject> entityCollection, long personId) {
        entityCollection.sort((entity1, entity2) -> {
            Date startOwn2;
            Date startOwn1 = entity1.getDate(this.checkEnum.getOwndate());
            if (startOwn1.compareTo(startOwn2 = entity2.getDate(this.checkEnum.getOwndate())) == 0) {
                return StringUtils.compare((String)entity1.getString(this.checkEnum.getStartMethod()), (String)entity2.getString(this.checkEnum.getStartMethod()));
            }
            return entity1.getDate(this.checkEnum.getStartDate()).compareTo(entity2.getDate(this.checkEnum.getStartDate()));
        });
        HashMap<Long, Object> failInfos = new HashMap<Long, Object>(16);
        block0: for (int xindex = 0; xindex < entityCollection.size() - 1; ++xindex) {
            BillFailInfo failInfo = new BillFailInfo(failInfos, xindex);
            DynamicObject entity = entityCollection.get(xindex);
            DynamicObject bill = (DynamicObject)entity.getParent();
            String startMethod = entity.getString(this.checkEnum.getStartMethod());
            String endMethod = entity.getString(this.checkEnum.getEndMethod());
            Date startOwnDate = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)startMethod) ? entity.getDate(this.checkEnum.getOwndate()) : entity.getDate(this.checkEnum.getStartDate());
            Date endOwnDate = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)startMethod) ? entity.getDate(this.checkEnum.getOwndate()) : entity.getDate(this.checkEnum.getEndDate());
            for (int yindex = xindex + 1; yindex < entityCollection.size(); ++yindex) {
                Date middleDate;
                BillResponse middleDateResp;
                Date nextStartOwnDate;
                DynamicObject nextDyn = entityCollection.get(yindex);
                DynamicObject nextBill = (DynamicObject)nextDyn.getParent();
                if ((this.checkEnum == ApplyBillCheckEnum.VACATION || this.checkEnum == ApplyBillCheckEnum.VACATIONFORM) && (LactationCheckService.isLactation(entity) || LactationCheckService.isLactation(nextDyn))) {
                    VaInfoBo bo2;
                    LactationCheckService lactationCheckService = new LactationCheckService(this::getMiddleDate);
                    VaInfoBo bo1 = this.getVaInfoBo(entity, personId);
                    if (!lactationCheckService.isLactationOverlapping((BillEntryEntityVo)bo1, (BillEntryEntityVo)(bo2 = this.getVaInfoBo(nextDyn, personId)))) continue;
                    failInfos.put(bill.getLong("id"), null);
                    failInfos.put(nextBill.getLong("id"), null);
                    return BillResponse.error((Object)failInfo, null);
                }
                String nextStartMethod = nextDyn.getString(this.checkEnum.getStartMethod());
                Date date = nextStartOwnDate = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)nextStartMethod) ? nextDyn.getDate(this.checkEnum.getOwndate()) : nextDyn.getDate(this.checkEnum.getStartDate());
                if (endOwnDate.before(nextStartOwnDate)) continue block0;
                if (endOwnDate.after(nextStartOwnDate)) {
                    failInfos.put(bill.getLong("id"), null);
                    failInfos.put(nextBill.getLong("id"), null);
                    return BillResponse.error((Object)failInfo, null);
                }
                if (StringUtils.equalsAny((CharSequence)WtcTimeRangeBtnTypeEnum.DAY.value, (CharSequence[])new CharSequence[]{startMethod, nextStartMethod})) {
                    failInfos.put(bill.getLong("id"), null);
                    failInfos.put(nextBill.getLong("id"), null);
                    return BillResponse.error((Object)failInfo, null);
                }
                if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.HALF_UP.value, (CharSequence)endMethod)) {
                    if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, (CharSequence)nextStartMethod)) continue;
                    if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)nextStartMethod)) {
                        middleDateResp = this.getMiddleDate(personId, nextStartOwnDate);
                        if (!middleDateResp.isSuccess()) continue;
                        middleDate = (Date)middleDateResp.getData();
                        if (!nextDyn.getDate(this.checkEnum.getStartDate()).before(middleDate)) continue;
                        failInfos.put(bill.getLong("id"), null);
                        failInfos.put(nextBill.getLong("id"), null);
                        return BillResponse.error((Object)failInfo, null);
                    }
                    failInfos.put(bill.getLong("id"), null);
                    failInfos.put(nextBill.getLong("id"), null);
                    return BillResponse.error((Object)failInfo, null);
                }
                if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, (CharSequence)endMethod)) {
                    if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, (CharSequence)startMethod) && DateUtils.isSameDay((Date)startOwnDate, (Date)endOwnDate) && StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)nextStartMethod) && (middleDateResp = this.getMiddleDate(personId, nextStartOwnDate)).isSuccess()) {
                        middleDate = (Date)middleDateResp.getData();
                        if (!nextDyn.getDate(this.checkEnum.getEndDate()).after(middleDate)) continue;
                    }
                    failInfos.put(bill.getLong("id"), null);
                    failInfos.put(nextBill.getLong("id"), null);
                    return BillResponse.error((Object)failInfo, null);
                }
                if (!entity.getDate(this.checkEnum.getEndDate()).after(nextDyn.getDate(this.checkEnum.getStartDate()))) continue;
                failInfos.put(bill.getLong("id"), null);
                failInfos.put(nextBill.getLong("id"), null);
                return BillResponse.error((Object)failInfo, null);
            }
        }
        return BillResponse.success();
    }

    private BillResponse getMiddleDate(long personId, Date ownDate) {
        DutyShiftResponse dutyShiftResponse = EvaluationServiceHelper.getDutyShifts(Lists.newArrayList((Object[])new Long[]{personId}), ownDate, ownDate);
        Shift shift = dutyShiftResponse.getCurrShiftHis(Long.valueOf(personId), ownDate).orElse(null);
        if (shift == null || shift.isOff() && shift.getOffNonPlan()) {
            return BillResponse.error(null, null);
        }
        ShiftMiddleRule shiftMiddleRule = shift.getShiftMiddleRule();
        int middlepoint = shiftMiddleRule.getMiddlepoint();
        RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
        Date refMiddleDate = ownDate;
        if (RefDateType.NEXTDAY == middleRefDate) {
            refMiddleDate = DateUtils.addDays((Date)ownDate, (int)1);
        }
        Date middleDate = WTCDateUtils.getDate((Date)refMiddleDate, (Integer)middlepoint);
        return BillResponse.success((Object)middleDate);
    }

    public BillResponse checkApplyTime() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            boolean isNotLeave;
            boolean isnottrip;
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            if (this.checkEnum.getApplyBillBaseSetEnum() == ApplyBillBaseSetEnum.BUSTRIP && (isnottrip = dynamicObject.getBoolean("isnottrip")) || this.checkEnum.getApplyBillBaseSetEnum() == ApplyBillBaseSetEnum.VACATION && (isNotLeave = dynamicObject.getBoolean("isnotleave"))) continue;
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                BillResponse response;
                BillEntityCheckService entityCheckService = this.getBillEntityCheckService((Long)attfile, this.unifyBillEnum, this.checkEnum, entry, this.billApplyAttr.getAttFileF7AuthEntity());
                entityCheckService.setBillDy(dynamicObject);
                BillResponse billResponse = this.checkSubEntryInfo(dynamicObject, entry, entityCheckService);
                if (!billResponse.isSuccess()) {
                    List message = billResponse.getMessage();
                    if (!CollectionUtils.isEmpty((Collection)message)) {
                        message.add(0, this.getMsg(entryEntity.size(), index, (String)message.get(0)));
                        msg.addAll(message);
                    }
                    msg.addAll(billResponse.getMessage());
                    success = false;
                }
                if (BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init) && !(billResponse = entityCheckService.checkBeforeGenerateApplyTime()).isSuccess()) {
                    List messages = billResponse.getMessage();
                    if (!CollectionUtils.isEmpty((Collection)messages)) {
                        msg.add(this.getMsg(entryEntity.size(), index, (String)messages.get(0)));
                    }
                    msg.addAll(billResponse.getMessage());
                    success = false;
                }
                BillApplyTimeResult timeResult = entityCheckService.generateApplyTime();
                this.setCustomEntry(entry, timeResult);
                BigDecimal applyTime = timeResult.getTimeByUnit().setScale(2, RoundingMode.HALF_UP);
                if (BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init) && !(response = entityCheckService.checkApplyTime(timeResult)).isSuccess()) {
                    List errorMsgList = response.getMessage();
                    if (errorMsgList != null && !errorMsgList.isEmpty()) {
                        errorMsgList.add(0, this.getMsg(entryEntity.size(), index, (String)errorMsgList.get(0)));
                        msg.addAll(errorMsgList);
                    }
                    success = false;
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkAttfileBoBsed() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue;
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                Date firstBsed;
                Date startDate = entry.getDate(this.checkEnum.getStartDate());
                Date endDate = entry.getDate(this.checkEnum.getEndDate());
                List<DynamicObject> dynamicObjects = this.check.getAttFileAllVersion(attfile);
                if (!CollectionUtils.isEmpty(dynamicObjects) && !CollectionUtils.isEmpty(dynamicObjects) && startDate.compareTo(firstBsed = dynamicObjects.get(0).getDate("startdate")) < 0) {
                    Date firstBSedDate = HRDateTimeUtils.addDay((Date)firstBsed, (long)-1L);
                    String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u8d85\u51fa\u6240\u9009\u6863\u6848\u7248\u672c\u7684\u65f6\u95f4\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BillCommonCheckerService_9", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)(endDate.before(firstBSedDate) ? endDate : firstBSedDate)));
                    msg.add(this.getMsg(entryEntity.size(), index, errorMsg));
                    success = false;
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkFrozenScope() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                Date startDate = entry.getDate(this.checkEnum.getStartDate());
                Date endDate = entry.getDate(this.checkEnum.getEndDate());
                Date ownDate = entry.getDate(this.checkEnum.getOwndate());
                Map<Date, Tuple<Date, Date>> dateDateMap = this.check.getBillFrozenInfo(attfile, startDate, endDate);
                if (dateDateMap != null) {
                    Collection<Tuple<Date, Date>> values = dateDateMap.values();
                    for (Tuple<Date, Date> item : values) {
                        if (item == null) continue;
                        Date startOwn = startDate;
                        Date endOwn = endDate;
                        if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)entry.getString(this.checkEnum.getStartMethod()))) {
                            startOwn = ownDate;
                            endOwn = ownDate;
                        }
                        if (!BillCheckService.legalIf((Date)item.item1, (Date)item.item2, startOwn, endOwn)) continue;
                        String sFormat = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)item.item1));
                        String eFormat = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)item.item2));
                        String failMsg = String.format(ResManager.loadKDString((String)"\u6b64\u63d0\u5355\u65e5\u671f\u5df2\u51bb\u7ed3\uff0c\u5728 %1$s\u81f3%2$s \u5185\u4e0d\u53ef\u7533\u8bf7%3$s\u5355\u3002", (String)"BillCommonCheckerService_10", (String)"wtc-wtbs-business", (Object[])new Object[0]), sFormat, eFormat, this.unifyBillEnum.getDescriptionStr());
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                        success = false;
                        break;
                    }
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkRoster() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date ownDate = null;
        for (DynamicObject dynamicObject : this.dyList) {
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                String failMsg;
                Date startDate = new Date(entry.getDate(this.checkEnum.getStartDate()).getTime());
                Date endDate = new Date(entry.getDate(this.checkEnum.getEndDate()).getTime());
                Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDate = this.check.getDutyDate(attfile, startDate, endDate);
                List dateList = (List)dutyDate.item1;
                ApplyBillDutyDateErrorEnum errorEnum = (ApplyBillDutyDateErrorEnum)dutyDate.item2;
                if (ApplyBillDutyDateErrorEnum.NOSHIFT == errorEnum) {
                    failMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u95f4\u4e0d\u5728\u73ed\u6b21\u6709\u6548\u8303\u56f4\u5185\u3002", (String)"BillCommonCheckHelper_40", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                    msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                    success = false;
                } else if (ApplyBillDutyDateErrorEnum.CROSSSHIFT == errorEnum) {
                    if (BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) {
                        failMsg = ResManager.loadKDString((String)"\u6309\u65f6\u5206\u7533\u8bf7\u4e0d\u5141\u8bb8\u8de8\u73ed\u6b21\u63d0%s\u5355\u3002", (String)"BillCommonCheckerService_12", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                        success = false;
                    }
                } else if (ApplyBillDutyDateErrorEnum.OVER_24 == errorEnum) {
                    if (BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) {
                        failMsg = ResManager.loadKDString((String)"\u6309\u65f6\u5206\u7533\u8bf7\u65f6\u957f\u4e0d\u80fd\u8d85\u8fc724\u5c0f\u65f6\u3002", (String)"BillCheckService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                        success = false;
                    }
                } else {
                    ownDate = (Date)dateList.get(0);
                    entry.set(this.checkEnum.getOwndate(), (Object)ownDate);
                    Map<Date, Shift> shiftMap = this.check.getShift(attfile, startDate, endDate);
                    List collect = shiftMap.entrySet().stream().map(dateShiftEntry -> (Date)dateShiftEntry.getKey()).sorted().collect(Collectors.toList());
                    Date startOwnDate = (Date)collect.get(0);
                    Date endOwnDate = (Date)collect.get(collect.size() - 1);
                    if (Objects.isNull(shiftMap.get(startOwnDate)) || Objects.isNull(shiftMap.get(endOwnDate))) {
                        String failMsg2;
                        if (Objects.isNull(shiftMap.get(startOwnDate)) && Objects.isNull(shiftMap.get(endOwnDate))) {
                            failMsg2 = DateUtils.isSameDay((Date)startDate, (Date)endDate) ? ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u6392\u73ed\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_11", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startOwnDate)}) : String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u672a\u8bbe\u7f6e\u6392\u73ed\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_13", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startOwnDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endOwnDate));
                            msg.add(this.getMsg(entryEntity.size(), index, failMsg2));
                        } else if (Objects.isNull(shiftMap.get(startOwnDate))) {
                            failMsg2 = ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u6392\u73ed\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_11", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startOwnDate)});
                            msg.add(this.getMsg(entryEntity.size(), index, failMsg2));
                        } else {
                            failMsg2 = ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u6392\u73ed\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_11", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endOwnDate)});
                            msg.add(this.getMsg(entryEntity.size(), index, failMsg2));
                        }
                        success = false;
                    }
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    private static boolean legalIf(Date aBegin, Date aEnd, Date bBegin, Date bEnd) {
        if (aBegin == null || aEnd == null || bBegin == null || bEnd == null) {
            return false;
        }
        return !aBegin.after(bEnd) && !aEnd.before(bBegin);
    }

    public BillResponse checkNotInSuspend() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue;
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                Date endDate;
                Date startDate = entry.getDate(this.checkEnum.getStartDate());
                Map<Date, Boolean> dateBooleanMap = this.check.verifyNotInSuspend(attfile, startDate, endDate = entry.getDate(this.checkEnum.getEndDate()));
                if (dateBooleanMap.containsValue(Boolean.FALSE)) {
                    String failMsg;
                    Date endNotInSuspend;
                    List<Date> notInSuspendlist = BillCheckService.getnotInSuspend(dateBooleanMap);
                    Date startNotInSuspend = notInSuspendlist.get(0);
                    if (startNotInSuspend.compareTo(endNotInSuspend = notInSuspendlist.get(notInSuspendlist.size() - 1)) == 0) {
                        failMsg = ResManager.loadKDString((String)"%s\u5df2\u505c\u6b62\u8003\u52e4\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_14", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endNotInSuspend)});
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                    } else {
                        failMsg = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u5df2\u505c\u6b62\u8003\u52e4\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_15", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNotInSuspend), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endNotInSuspend));
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                    }
                    success = false;
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkWorkExperience() {
        ArrayList<String> msg = new ArrayList<String>(10);
        this.initCustomCrossShift();
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            long attfileBo = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            if (this.checkBillAllEfficacy(dynamicObject)) continue;
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                Date startDate = entry.getDate(this.checkEnum.getStartDate());
                Date endDate = entry.getDate(this.checkEnum.getEndDate());
                Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDate = this.getCheck().getDutyDate(attfileBo, startDate, endDate);
                if (dutyDate == null || WTCCollections.isEmpty((Collection)((Collection)dutyDate.item1))) {
                    ++index;
                    continue;
                }
                HashSet<LocalDate> allDate = new HashSet<LocalDate>(16);
                for (Date date : (List)dutyDate.item1) {
                    if (date == null) continue;
                    allDate.add(WTCDateUtils.toLocalDate((Date)date));
                }
                if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)entry.getString(this.checkEnum.getStartMethod()))) {
                    this.handleCustomCrossShift(attfileBo, WTCDynamicObjectUtils.getBaseDataId(entry, this.checkEnum.getType()), startDate, endDate, allDate);
                }
                if (WTCCollections.isEmpty(allDate)) {
                    ++index;
                    continue;
                }
                Set notNullDate = allDate.stream().filter(Objects::nonNull).collect(Collectors.toSet());
                Date[] dateList = notNullDate.stream().map(WTCDateUtils::toDate).collect(Collectors.toList()).toArray(new Date[0]);
                List<Tuples.Tuple2<LocalDate, LocalDate>> missWorkExperience = BillAttFileService.getInstance().missWorkExperience(WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinDate((Date[])dateList)), WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMaxDate((Date[])dateList)), this.getCheck().getAttFileAllVersion(attfileBo));
                if (WTCCollections.isNotEmpty(missWorkExperience)) {
                    success = false;
                    String finalTip = ResManager.loadKDString((String)"{0}\u7684\u8003\u52e4\u6863\u6848\u5bf9\u5e94\u7684\u6838\u5fc3\u4eba\u529b\u7684\u4efb\u804c\u7ecf\u5386\u5df2\u5220\u9664\uff0c\u8003\u52e4\u6863\u6848\u5173\u8054\u7684\u5c97\u4f4d\u4fe1\u606f\u4e0d\u51c6\u786e\uff0c\u8bf7\u8c03\u6574\u8003\u52e4\u6863\u6848\u7684\u5c97\u4f4d\u4fe1\u606f\u3002", (String)"BillEntityCheckService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                    msg.add(this.getMsg(entryEntity.size(), index, MessageFormat.format(finalTip, BillCommonService.getInstance().handleTimePariInfo(missWorkExperience))));
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    private void handleCustomCrossShift(long attFileBoId, long typeId, Date startDate, Date endDate, Set<LocalDate> allDate) {
        if (startDate == null || endDate == null) {
            return;
        }
        String sign = this.getSignByAttFileAndTime(attFileBoId, typeId, startDate, endDate);
        if (this.contextCustomOver24Date == null) {
            this.initCustomCrossShift();
        }
        if (this.contextCustomOver24Date == null) {
            return;
        }
        Set<LocalDate> localDates = this.contextCustomOver24Date.get(sign);
        if (WTCCollections.isEmpty(localDates)) {
            return;
        }
        allDate.addAll(localDates);
    }

    private void initCustomCrossShift() {
        ArrayList collect;
        if (this.contextCustomOver24Date != null) {
            return;
        }
        this.contextCustomOver24Date = new HashMap<String, Set<LocalDate>>(16);
        BillOptionalDutyDateService dutyDateService = new BillOptionalDutyDateService();
        String dutyDateKey = dutyDateService.getAppCustomParameter("allowCrossShiftAnd24h");
        if (LOG.isDebugEnabled()) {
            LOG.debug("BillCheckService_initCustomCrossShift,dutyDateKey = {}", (Object)dutyDateKey);
        }
        if (!HRStringUtils.equals((String)"true", (String)dutyDateKey)) {
            return;
        }
        HashMap attFileAndIndexReqs = new HashMap(16);
        for (DynamicObject dynamicObject : this.dyList) {
            long attFileBoId = WTCDynamicObjectUtils.getBaseDataId(dynamicObject, "attfile");
            DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection("entryentity");
            if (WTCCollections.isEmpty((Collection)entryColl)) continue;
            for (DynamicObject entryDy : entryColl) {
                List<Tuple<DutyShift, Shift>> dutyShiftsRange;
                Date endDate;
                if (!StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)entryDy.getString(this.checkEnum.getStartMethod())) || entryDy.getDate(this.checkEnum.getStartDate()) == null || entryDy.getDate(this.checkEnum.getEndDate()) == null) continue;
                long typeId = WTCDynamicObjectUtils.getBaseDataId(entryDy, this.checkEnum.getType());
                Date startDate = new Date(entryDy.getDate(this.checkEnum.getStartDate()).getTime());
                if (!dutyDateService.over24OrCrossShift(startDate, endDate = new Date(entryDy.getDate(this.checkEnum.getEndDate()).getTime()), dutyShiftsRange = this.getCheck().getDutyShiftsRange(attFileBoId, startDate, endDate))) continue;
                ArrayList<BillOptionDutyDateReq> tmp = new ArrayList<BillOptionDutyDateReq>(10);
                BillOptionDutyDateReq reqStart = new BillOptionDutyDateReq();
                reqStart.setAttFileBoId(Long.valueOf(attFileBoId));
                reqStart.setShiftInfo(dutyShiftsRange);
                reqStart.setStartTime(startDate);
                reqStart.setEndTime(startDate);
                tmp.add(reqStart);
                BillOptionDutyDateReq reqEnd = new BillOptionDutyDateReq();
                reqEnd.setAttFileBoId(Long.valueOf(attFileBoId));
                reqEnd.setShiftInfo(dutyShiftsRange);
                reqEnd.setStartTime(endDate);
                reqEnd.setEndTime(endDate);
                tmp.add(reqEnd);
                attFileAndIndexReqs.put(this.getSignByAttFileAndTime(attFileBoId, typeId, startDate, endDate), tmp);
            }
        }
        if (WTCCollections.isEmpty(attFileAndIndexReqs)) {
            return;
        }
        ArrayList billOptionDutyDateReqs = Lists.newArrayList();
        if (WTCCollections.isNotEmpty(attFileAndIndexReqs.values()) && WTCCollections.isNotEmpty(collect = new ArrayList(attFileAndIndexReqs.values()))) {
            for (List reqs : collect) {
                billOptionDutyDateReqs.addAll(reqs);
            }
        }
        List<BillOptionDutyDateResp> dutyDate = dutyDateService.getDutyDate(billOptionDutyDateReqs);
        HashMap mapping = Maps.newHashMapWithExpectedSize((int)billOptionDutyDateReqs.size());
        for (int index = 0; index < billOptionDutyDateReqs.size(); ++index) {
            mapping.put(billOptionDutyDateReqs.get(index), dutyDate.get(index));
        }
        HashMap<String, Set<LocalDate>> result = new HashMap<String, Set<LocalDate>>(16);
        for (Map.Entry signAndReq : attFileAndIndexReqs.entrySet()) {
            Date[] collect2;
            List dateRange;
            String sign = (String)signAndReq.getKey();
            HashSet<LocalDate> dates = new HashSet<LocalDate>(10);
            List reqList = (List)signAndReq.getValue();
            if (WTCCollections.isNotEmpty((Collection)reqList)) {
                for (BillOptionDutyDateReq req : reqList) {
                    BillOptionDutyDateResp billOptionDutyDateResp = (BillOptionDutyDateResp)mapping.get(req);
                    if (billOptionDutyDateResp != null && billOptionDutyDateResp.getDutyDate() != null) {
                        dates.add(WTCDateUtils.toLocalDate((Date)billOptionDutyDateResp.getDutyDate()));
                        continue;
                    }
                    dates.add(WTCDateUtils.toLocalDate((Date)req.getStartTime()));
                }
            }
            if (WTCCollections.isNotEmpty((Collection)(dateRange = WTCDateUtils.getDateRange((Date)WTCDateUtils.getMinDate((Date[])(collect2 = dates.stream().filter(Objects::nonNull).map(WTCDateUtils::toDate).collect(Collectors.toList()).toArray(new Date[0]))), (Date)WTCDateUtils.getMaxDate((Date[])collect2))))) {
                dates.addAll(dateRange.stream().filter(Objects::nonNull).map(WTCDateUtils::toLocalDate).collect(Collectors.toSet()));
            }
            result.put(sign, dates);
        }
        this.contextCustomOver24Date = result;
    }

    private String getSignByAttFileAndTime(long attFileBoId, long type, Date startTime, Date endTime) {
        startTime = startTime == null ? WTCDateUtils.getMinEndDate() : startTime;
        endTime = endTime == null ? WTCDateUtils.getMinEndDate() : endTime;
        return attFileBoId + startTime.getTime() + endTime.getTime() + type + "";
    }

    public BillResponse checkEverDayHasPlan() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                Date startDate = new Date(entry.getDate(this.checkEnum.getStartDate()).getTime());
                Date endDate = new Date(entry.getDate(this.checkEnum.getEndDate()).getTime());
                long type = entry.getLong(this.checkEnum.getType() + ".id");
                Map<Date, DynamicObject> planDy = this.check.getPlanDy(attfile, startDate, endDate);
                if (planDy.containsValue(null)) {
                    String failMsg;
                    Date endNonRuleDay;
                    List<Date> nonRuleDays = BillCheckService.getNonRuleDays(planDy);
                    Date startNonPlanDay = nonRuleDays.get(0);
                    if (startNonPlanDay.compareTo(endNonRuleDay = nonRuleDays.get(nonRuleDays.size() - 1)) == 0) {
                        failMsg = ResManager.loadKDString((String)"{0}\u672a\u8bbe\u7f6e{1}\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7{2}\u3002", (String)"BillCommonCheckerService_16", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNonPlanDay), this.unifyBillEnum.getDescriptionStr(), this.unifyBillEnum.getDescriptionStr()});
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                    } else {
                        failMsg = ResManager.loadKDString((String)"{0}\u81f3{1}\u672a\u8bbe\u7f6e{2}\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7{3}\u3002", (String)"BillCommonCheckerService_17", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNonPlanDay), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endNonRuleDay), this.unifyBillEnum.getDescriptionStr(), this.unifyBillEnum.getDescriptionStr()});
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                    }
                    success = false;
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkEverDayHasRule() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                Date startDate = new Date(entry.getDate(this.checkEnum.getStartDate()).getTime());
                Date endDate = new Date(entry.getDate(this.checkEnum.getEndDate()).getTime());
                long type = entry.getLong(this.checkEnum.getType() + ".id");
                Map<Date, DynamicObject> ruleDy = this.check.getRuleCalDy(attfile, startDate, endDate, type);
                if (BillSourceTypeEnum.BATCH == this.billApplyAttr.getSourceType()) {
                    BatchBillCheckParam batchBillCheckParam = new BatchBillCheckParam(attfile, this.check, this.checkEnum, this.unifyBillEnum);
                    String failMsg = BatchBillCheckService.getInstance().checkEverDayHasRule(batchBillCheckParam, ruleDy, entry);
                    if (HRStringUtils.isNotEmpty((String)failMsg)) {
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                        success = false;
                    }
                } else if (ruleDy.containsValue(null)) {
                    String failMsg;
                    Date endNonRuleDay;
                    List<Date> nonRuleDayList = BillCheckService.getNonRuleDays(ruleDy);
                    Date startNonRuleDay = nonRuleDayList.get(0);
                    if (startNonRuleDay.compareTo(endNonRuleDay = nonRuleDayList.get(nonRuleDayList.size() - 1)) == 0) {
                        failMsg = String.format(ResManager.loadKDString((String)"%1$s\u672a\u8bbe\u7f6e%2$s\u89c4\u5219\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_18", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNonRuleDay), this.unifyBillEnum.getDescriptionStr());
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                    } else {
                        failMsg = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u672a\u8bbe\u7f6e%3$s\u89c4\u5219\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_19", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNonRuleDay), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endNonRuleDay), this.unifyBillEnum.getDescriptionStr());
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                    }
                    success = false;
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkEverDateRage() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        BillSourceTypeEnum sourceType = this.getBillApplyAttr().getSourceType();
        boolean isBatch = BillSourceTypeEnum.BATCH == sourceType;
        for (DynamicObject dynamicObject : this.dyList) {
            if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue;
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                String failMsg;
                DutyShift endShift;
                DutyShift startShift;
                DynamicObject endDy;
                DynamicObject startDy;
                Map<Date, DynamicObject> baseSetMap;
                Date startDate = new Date(entry.getDate(this.checkEnum.getStartDate()).getTime());
                Date endDate = new Date(entry.getDate(this.checkEnum.getEndDate()).getTime());
                long type = entry.getLong(this.checkEnum.getType() + ".id");
                String startMetohd = entry.getString(this.checkEnum.getStartMethod());
                if (StringUtils.equalsAny((CharSequence)startMetohd, (CharSequence[])new CharSequence[]{"0", "1", "2"})) {
                    baseSetMap = this.check.getBaseSetDy(attfile, startDate, endDate, type);
                    startDy = baseSetMap.get(startDate);
                    endDy = baseSetMap.get(endDate);
                    startShift = this.check.getDutyShift(attfile, startDate, endDate).get(startDate);
                    endShift = this.check.getDutyShift(attfile, startDate, endDate).get(endDate);
                } else {
                    baseSetMap = this.check.getBaseSetDy(attfile, startDate, endDate, type);
                    endDy = startDy = baseSetMap.entrySet().iterator().next().getValue();
                    startShift = this.check.getDutyShift(attfile, startDate, endDate).entrySet().iterator().next().getValue();
                    endShift = this.check.getDutyShift(attfile, startDate, endDate).entrySet().iterator().next().getValue();
                }
                String auditbegindate = startDy.getString(this.checkEnum.getApplyBillBaseSetEnum().getAuditbegindate());
                String auditenddate = endDy.getString(this.checkEnum.getApplyBillBaseSetEnum().getAuditenddate());
                Long startShiftDateType = startShift.getDateTypeModel() == null ? null : startShift.getDateTypeModel().getId();
                Long endShiftDateType = startShift.getDateTypeModel() == null ? null : endShift.getDateTypeModel().getId();
                String fieldDateRangeCondition = this.unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum().getDateRangeCondition();
                Boolean startIsSatisfyDateRange = this.getDateRangeService().isSatisfyDateRange(startShiftDateType, startShift.getDateAttribute().getCode(), startDy.getString(fieldDateRangeCondition));
                Boolean endIsSatisfyDateRange = this.getDateRangeService().isSatisfyDateRange(endShiftDateType, endShift.getDateAttribute().getCode(), endDy.getString(fieldDateRangeCondition));
                switch (auditbegindate) {
                    case "A": {
                        if (!BooleanUtils.isNotTrue((Boolean)startIsSatisfyDateRange)) break;
                        success = false;
                        failMsg = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5728\u8be5%1$s\u7c7b\u578b\u7684\u65e5\u671f\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u7533\u8bf7%2$s\u3002", (String)"BillCommonCheckerService_20", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.unifyBillEnum.getDescriptionStr(), this.unifyBillEnum.getDescriptionStr());
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                        break;
                    }
                    case "B": {
                        if (!BooleanUtils.isNotTrue((Boolean)startIsSatisfyDateRange) || isBatch) break;
                        failMsg = ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5728\u8be5%s\u7c7b\u578b\u7684\u65e5\u671f\u8303\u56f4\u4e2d\u3002", (String)"BillCommonCheckerService_21", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                        break;
                    }
                }
                switch (auditenddate) {
                    case "A": {
                        if (!BooleanUtils.isNotTrue((Boolean)endIsSatisfyDateRange)) break;
                        success = false;
                        failMsg = String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u5728\u8be5%1$s\u7c7b\u578b\u7684\u65e5\u671f\u8303\u56f4\u4e2d\uff0c\u4e0d\u53ef\u4ee5\u7533\u8bf7%2$s\u3002", (String)"BillCommonCheckerService_22", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.unifyBillEnum.getDescriptionStr(), this.unifyBillEnum.getDescriptionStr());
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                        break;
                    }
                    case "B": {
                        if (!BooleanUtils.isNotTrue((Boolean)endIsSatisfyDateRange) || isBatch) break;
                        failMsg = ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u5728\u8be5%s\u7c7b\u578b\u7684\u65e5\u671f\u8303\u56f4\u4e2d\u3002", (String)"BillCommonCheckerService_23", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
                        msg.add(this.getMsg(entryEntity.size(), index, failMsg));
                        break;
                    }
                }
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error((Object)"", msg);
        }
        return BillResponse.success((Object)"", msg);
    }

    private static List<Date> getNonRuleDays(Map<Date, DynamicObject> ruleDyMap) {
        ArrayList<Date> list = new ArrayList<Date>(4);
        for (Map.Entry<Date, DynamicObject> next : ruleDyMap.entrySet()) {
            if (!Objects.isNull(next.getValue())) continue;
            list.add(next.getKey());
        }
        return list;
    }

    private static List<Date> getnotInSuspend(Map<Date, Boolean> dateBooleanMap) {
        ArrayList<Date> list = new ArrayList<Date>(10);
        for (Map.Entry<Date, Boolean> next : dateBooleanMap.entrySet()) {
            if (next.getValue().booleanValue()) continue;
            list.add(next.getKey());
        }
        return list;
    }

    private boolean check(DynamicObject attFileDy, Date entryStartDate, Date entryEndDate) {
        Date bsEd = attFileDy.getDate("bsed");
        Date bslEd = attFileDy.getDate("bsled");
        return entryStartDate != null && entryEndDate != null && bsEd != null && bslEd != null && bsEd.compareTo(entryEndDate) <= 0 && entryStartDate.compareTo(bslEd) <= 0;
    }

    public BillResponse checkAttfileHisAuth() {
        LOG.info("\u6821\u9a8ccheckAttfileHisAuth\u5f00\u59cb");
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        String notInAdminOrgErrMsg = BatchBillKDString.notInAdminOrg();
        String notAllowSpanAdminOrgErrMsg = BatchBillKDString.notAllowSpanAdminOrg();
        for (DynamicObject dynamicObject : this.dyList) {
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            List<DynamicObject> attFileHisAuthList = this.check.getAttFileHisAuth(attfile);
            List<DynamicObject> attFileAllVersionList = this.check.getAttFileAllVersion(attfile);
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            for (DynamicObject entry : entryEntity) {
                Date startDate = new Date(entry.getDate(this.checkEnum.getStartDate()).getTime());
                Date endDate = new Date(entry.getDate(this.checkEnum.getEndDate()).getTime());
                ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)attFileAllVersionList.size());
                for (DynamicObject dynamicObject2 : attFileAllVersionList) {
                    if (!this.check(dynamicObject2, startDate, endDate)) continue;
                    dynamicObjects.add(dynamicObject2);
                }
                ArrayList authVersions = Lists.newArrayListWithExpectedSize((int)attFileHisAuthList.size());
                for (Object attFileDy3 : attFileHisAuthList) {
                    if (!this.check((DynamicObject)attFileDy3, startDate, endDate)) continue;
                    authVersions.add(attFileDy3);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("authVersions:{}", (Object)authVersions.size());
                }
                if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                    Set set = authVersions.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                    if (set.size() != dynamicObjects.size()) {
                        Object attFileDy3;
                        attFileDy3 = dynamicObjects.iterator();
                        while (attFileDy3.hasNext()) {
                            DynamicObject dy2 = (DynamicObject)attFileDy3.next();
                            if (set.contains(dy2.getLong("id"))) continue;
                            Date bsed = dy2.getDate("bsed");
                            Date bsled = dy2.getDate("bsled");
                            Date minEndDate = startDate.compareTo(bsed) > 0 ? startDate : bsed;
                            Date maxStartDate = endDate.compareTo(bsled) > 0 ? bsled : endDate;
                            String errorMsg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s\u81f3%2$s\u4e4b\u95f4\u7684\u6863\u6848\u6743\u9650\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckerService_24", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)minEndDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)maxStartDate));
                            msg.add(this.getMsg(entryEntity.size(), index, errorMsg));
                            success = false;
                        }
                    } else if (BillSourceTypeEnum.BATCH == this.getBillApplyAttr().getSourceType()) {
                        if (!BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init)) continue;
                        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)dynamicObjects.size());
                        for (DynamicObject attFileVDy : dynamicObjects) {
                            adminOrgIds.add(attFileVDy.getLong("adminorg.id"));
                        }
                        String errorMsg = "";
                        Long adminOrgId = this.billApplyAttr.getAdminOrgId();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("BillCheckService.checkAttfileHisAuth.adminOrgIds:{},vaAdminOrg:{}", (Object)JSON.toJSONString((Object)adminOrgIds), (Object)adminOrgId);
                        }
                        if (!adminOrgIds.contains(adminOrgId)) {
                            errorMsg = notInAdminOrgErrMsg;
                        } else if (adminOrgIds.size() > 1) {
                            errorMsg = notAllowSpanAdminOrgErrMsg;
                        }
                        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                            msg.add(this.getMsg(entryEntity.size(), index, errorMsg));
                            success = false;
                        }
                    }
                }
                ++index;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("billNo:{},\u6821\u9a8c\u7ed3\u679c\uff1a{}, entryEntity:{}", new Object[]{dynamicObject.getString("billno"), success, entryEntity.size()});
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkAdviceAndAfter() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        for (DynamicObject dynamicObject : this.dyList) {
            long attfile = dynamicObject.getLong(this.checkEnum.getAttfile() + ".id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            int index = 0;
            boolean checkAdv = BatchBillUnifyService.getInstance().isNeedCheck(dynamicObject, UnifyCallChainEnum.init);
            boolean checkAfter = true;
            for (DynamicObject entry : entryEntity) {
                UnifyBillAdvanceAfterInfo checkInfo;
                Date startDate = new Date(entry.getDate(this.checkEnum.getStartDate()).getTime());
                Date endDate = new Date(entry.getDate(this.checkEnum.getEndDate()).getTime());
                long type = entry.getLong(this.checkEnum.getType() + ".id");
                Map<Date, UnifyBillAdvanceAfterInfo> advanceAndAfterInfo = this.check.getAdvanceAndAfterInfo(attfile, startDate, endDate, type);
                List dates = advanceAndAfterInfo.keySet().stream().sorted().collect(Collectors.toList());
                UnifyBillAdvanceAfterInfo unifyBillAdvanceAfterInfo = checkInfo = this.check.isUseStartOrEnd() ? advanceAndAfterInfo.get(dates.get(0)) : advanceAndAfterInfo.get(dates.get(dates.size() - 1));
                if (checkInfo != null) {
                    UnifyAdvanceAndAfterDetail advanceInfo;
                    checkInfo.setCheckAdvance(checkAdv);
                    checkInfo.setCheckAfter(checkAfter);
                    if (!checkAdv && (advanceInfo = checkInfo.getAdvanceInfo()) != null) {
                        advanceInfo.setNeedVerify(false);
                    }
                }
                Tuples.Tuple2<Boolean, String> advanceAfterResp = AdvanceAfterValidateUtil.buildAdvanceAfterResp(checkInfo, advanceAndAfterInfo);
                if (!((Boolean)advanceAfterResp.item1).booleanValue()) {
                    msg.add(0, this.getMsg(entryEntity.size(), index, (String)advanceAfterResp.item2));
                }
                success &= ((Boolean)advanceAfterResp.item1).booleanValue();
                ++index;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkPersonInfo() {
        return BillResponse.success();
    }

    protected BillResponse checkChangeSet() {
        ArrayList msg = new ArrayList(4);
        boolean success = true;
        List changeList = this.dyList.stream().filter(dynamicObject -> dynamicObject.getBoolean("ischange")).collect(Collectors.toList());
        if (changeList.isEmpty()) {
            return BillResponse.success();
        }
        HashSet entryparentids = new HashSet();
        for (DynamicObject dynamicObject2 : changeList) {
            DynamicObjectCollection entryEntity = dynamicObject2.getDynamicObjectCollection("entryentity");
            entryparentids.addAll(entryEntity.stream().map(object -> object.getLong("entryparentid")).collect(Collectors.toSet()));
        }
        DynamicObject[] dynamicObjects = this.getBaseServiceHelper().loadDynamicObjectArray(new QFilter[]{new QFilter("entryentity.id", "in", entryparentids)});
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> dynamicObjectCollection.addAll((Collection)dynamicObject.getDynamicObjectCollection("entryentity")));
        Map<Long, DynamicObject> dynamicObjectMap = dynamicObjectCollection.stream().collect(Collectors.toMap(dy -> (Long)dy.getPkValue(), dy -> dy));
        for (DynamicObject dynamicObject3 : changeList) {
            DynamicObjectCollection entryEntity = dynamicObject3.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                DynamicObject parentBill;
                long parentAttFile;
                BillEntityCheckService entryCheckService;
                BillResponse billResponse;
                long entryparentid = entry.getLong("entryparentid");
                DynamicObject entryDy = dynamicObjectMap.get(entryparentid);
                if (entryDy == null || (billResponse = (entryCheckService = this.getBillEntityCheckService((Long)(parentAttFile = (parentBill = (DynamicObject)entryDy.getParent()).getLong(this.checkEnum.getAttfile() + ".id")), entryDy, this.unifyBillEnum, this.checkEnum, this.billApplyAttr.getAttFileF7AuthEntity())).checkChangeSet(entry)).isSuccess()) continue;
                msg.addAll(billResponse.getMessage());
                success = false;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public static List<VaDetailPreviewVo> transFormDetailList(DynamicObjectCollection subRowObjs) {
        if (Objects.isNull(subRowObjs)) {
            return Collections.emptyList();
        }
        ArrayList<VaDetailPreviewVo> detailPreviewVos = new ArrayList<VaDetailPreviewVo>(subRowObjs.size());
        HashMap<Date, VaDetailPreviewVo> cacheMap = new HashMap<Date, VaDetailPreviewVo>(16);
        for (DynamicObject rowObj : subRowObjs) {
            Date date = rowObj.getDate("vaentrydate");
            VaDetailPreviewVo vo = (VaDetailPreviewVo)cacheMap.get(date);
            if (vo == null) {
                vo = new VaDetailPreviewVo();
                cacheMap.put(date, vo);
                detailPreviewVos.add(vo);
            }
            VaDetailItemPreviewVo itemPreviewVo = new VaDetailItemPreviewVo();
            itemPreviewVo.setDate(rowObj.getDate("vaentrystarttime")).setStartTime(rowObj.getDate("vaentrystarttime")).setEndTime(rowObj.getDate("vaentryendtime")).setApplyTimeDay(rowObj.getBigDecimal("vaentryapplytimeday")).setApplyTimeHour(rowObj.getBigDecimal("vaentryapplytimehour")).setUnit(rowObj.getString("vaentryunit")).setRowSeq(rowObj.getInt("vaentryseq"));
            vo.getItemVos().add(itemPreviewVo);
            vo.setDate(date);
            vo.setUnit(rowObj.getString("vaentryunit"));
            DynamicObject dateType = rowObj.getDynamicObject("vaentrydatetype");
            if (dateType != null) {
                vo.setDateType(dateType.getLong("id"));
            }
            vo.adjustApplyTime();
        }
        return detailPreviewVos;
    }

    private VaInfoBo getVaInfoBo(DynamicObject dy, long personId) {
        VaInfoBo bo = new VaInfoBo();
        bo.setAttFileBoid(personId);
        bo.setStartDate(dy.getDate(this.checkEnum.getStartDate()));
        bo.setStartMethod(dy.getString(this.checkEnum.getStartMethod()));
        bo.setEndDate(dy.getDate(this.checkEnum.getEndDate()));
        bo.setEndMethod(dy.getString(this.checkEnum.getEndMethod()));
        bo.setOwnDate(dy.getDate(this.checkEnum.getOwndate()));
        bo.setVacationType(dy.getLong("entryvacationtype.id"));
        bo.setSpecialVaType(dy.getString("specialvatype"));
        if (LactationCheckService.isLactation((BillEntryEntityVo)bo)) {
            bo.setSpecialVaMethod(dy.getDynamicObject("specialvamethod").getLong("id"));
            bo.setDetailList(BillCheckService.transFormDetailList(dy.getDynamicObjectCollection("vadetailentry")));
            LactationCheckService.setLactationInfo(bo);
        }
        return bo;
    }

    public BillResponse checkMustInput() {
        return BillResponse.success();
    }

    public String getAttFileF7AuthEntity() {
        return this.attFileF7AuthEntity;
    }

    public void setAttFileF7AuthEntity(String attFileF7AuthEntity) {
        this.attFileF7AuthEntity = attFileF7AuthEntity;
    }

    public String getMsg(int count, int curIndex, String msg) {
        if (BillSourceTypeEnum.IMPORT != this.getBillApplyAttr().getSourceType() && BillSourceTypeEnum.OPENAPI != this.getBillApplyAttr().getSourceType()) {
            return msg;
        }
        if (count <= 1) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < count; ++index) {
            String s1 = ResManager.loadKDString((String)"\u5206\u5f55{0}", (String)"BustripBillPeriodService_3", (String)"wtc-wtbs-business", (Object[])new Object[]{index + 1});
            sb.append(s1);
            sb.append(WTCSymbolMultiLanguageUtil.getColonSymbol());
            if (index == curIndex) {
                sb.append(msg);
                continue;
            }
            String s2 = ResManager.loadKDString((String)"\u56e0\u5176\u4ed6\u5206\u5f55\u5bfc\u5165\u5931\u8d25\u3002", (String)"BustripBillPeriodService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            sb.append(s2);
        }
        return sb.toString();
    }

    private List<DynamicObject> ignoreTPLoseEfficacy() {
        if (UnifyBillEnum.TP != this.getUnifyBillEnum() && UnifyBillEnum.VA != this.getUnifyBillEnum()) {
            return this.getDyList();
        }
        ArrayList<DynamicObject> dysCopy = new ArrayList<DynamicObject>(this.getDyList());
        this.setDyList(this.getDyList().stream().filter(e -> !this.checkBillAllEfficacy((DynamicObject)e)).collect(Collectors.toList()));
        return dysCopy;
    }

    private void recoverDyList(List<DynamicObject> dysCopy) {
        if (UnifyBillEnum.TP != this.getUnifyBillEnum() && UnifyBillEnum.VA != this.getUnifyBillEnum()) {
            return;
        }
        this.setDyList(dysCopy);
    }

    private boolean checkBillAllEfficacy(DynamicObject billDy) {
        BillQueryEnum billQueryEnum = BillQueryEnum.getWithUnifyBillEnum((UnifyBillEnum)this.getUnifyBillEnum());
        if (billQueryEnum == null) {
            return false;
        }
        String isChangeFieldName = billQueryEnum.getIsChange();
        String isLoseEfficacy = billQueryEnum.getIsNotTrip();
        boolean isChange = billDy.containsProperty(isChangeFieldName) && billDy.get(isChangeFieldName) instanceof Boolean && billDy.getBoolean(isChangeFieldName);
        boolean isNotTrip = billDy.containsProperty(isLoseEfficacy) && billDy.get(isLoseEfficacy) instanceof Boolean && billDy.getBoolean(isLoseEfficacy);
        return isChange && isNotTrip;
    }
}

