/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.IDateRangeService;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.business.util.ShiftParseUtil;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.extend.WtcAbstractUnityBillAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.AdvanceAfterValidateUtil;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.billservice.baseset.BillBaseStateLessService;
import kd.wtc.wtbs.business.web.billservice.dutyDate.BillOptionalDutyDateService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.bill.BillQueryEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.BillTypeConstants;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.enums.bill.ApplyBillDutyDateErrorEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterFieldEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBaseSetEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleCalEntryEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.BillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyServiceEntryInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillExpandInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateReq;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceAdvAfterResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceBaseNewSetInfo;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTTESystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.BooleanUtils;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtte.common.enums.OutWorkType;

public abstract class BillEntityCheckService {
    private static final Log LOG = LogFactory.getLog(BillEntityCheckService.class);
    protected WtcAbstractUnityBillAutoOperator billAutoOperator;
    protected Long attfileBo;
    protected DynamicObject billDy;
    protected DynamicObject dyObject;
    protected ApplyBillCheckEnum checkEnum;
    protected UnifyBillEnum unifyBillEnum;
    protected boolean init = false;
    protected boolean checkStartAndEndSuccess = false;
    protected boolean checkBaseSetSuccess = false;
    protected Boolean needCheckAttFileAuth = Boolean.FALSE;
    protected Shift firstDateShift;
    protected Shift lastDateShift;
    protected String attFileF7AuthEntity;
    private UnifyBillApplyAttr billApplyAttr;

    public void setNeedCheckAttFileAuth(Boolean needCheckAttFileAuth) {
        this.needCheckAttFileAuth = needCheckAttFileAuth;
    }

    public String getAttFileF7AuthEntity() {
        return this.attFileF7AuthEntity;
    }

    public void setAttFileF7AuthEntity(String attFileF7AuthEntity) {
        this.attFileF7AuthEntity = attFileF7AuthEntity;
    }

    public UnifyBillApplyAttr getBillApplyAttr() {
        return this.billApplyAttr;
    }

    public BillEntityCheckService setBillApplyAttr(UnifyBillApplyAttr billApplyAttr) {
        this.billApplyAttr = billApplyAttr;
        return this;
    }

    public DynamicObject getBillDy() {
        return this.billDy;
    }

    public void setBillDy(DynamicObject billDy) {
        this.billDy = billDy;
    }

    @Deprecated
    public void fillBillEntityCheckService(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, String attFileF7AuthEntity) {
        this.initBean(attfileBo, unifyBillEnum, checkEnum, dyObject, attFileF7AuthEntity);
    }

    public void fillBillEntityCheckService(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, UnifyBillApplyAttr applyAttr) {
        this.initBean(attfileBo, unifyBillEnum, checkEnum, dyObject, applyAttr);
    }

    public void fillBillEntityCheckService(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, UnifyBillApplyAttr applyAttr, WtcAbstractUnityBillOperator operator) {
        this.initBean(attfileBo, unifyBillEnum, checkEnum, dyObject, applyAttr, operator);
    }

    @Deprecated
    public void initBean(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, String attFileF7AuthEntity) {
        this.attfileBo = attfileBo;
        this.unifyBillEnum = unifyBillEnum;
        this.checkEnum = checkEnum;
        this.dyObject = dyObject;
        this.billApplyAttr = new UnifyBillApplyAttr("wtam", attFileF7AuthEntity);
        this.billAutoOperator = this.initContext(dyObject, this.billApplyAttr);
        this.attFileF7AuthEntity = attFileF7AuthEntity;
    }

    public void initBean(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, UnifyBillApplyAttr applyAttr) {
        this.attfileBo = attfileBo;
        this.unifyBillEnum = unifyBillEnum;
        this.checkEnum = checkEnum;
        this.dyObject = dyObject;
        this.billAutoOperator = this.initContext(dyObject, applyAttr);
        this.attFileF7AuthEntity = applyAttr.getAttFileF7AuthEntity();
        this.billApplyAttr = applyAttr;
    }

    public void initBean(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, UnifyBillApplyAttr applyAttr, WtcAbstractUnityBillOperator operator) {
        this.attfileBo = attfileBo;
        this.unifyBillEnum = unifyBillEnum;
        this.checkEnum = checkEnum;
        this.dyObject = dyObject;
        if (operator == null) {
            this.billAutoOperator = this.initContext(dyObject, applyAttr);
        } else {
            this.billAutoOperator = (WtcAbstractUnityBillAutoOperator)operator;
            this.init = true;
        }
        this.attFileF7AuthEntity = applyAttr.getAttFileF7AuthEntity();
        this.billApplyAttr = applyAttr;
    }

    protected abstract WtcAbstractUnityBillAutoOperator initContext(DynamicObject var1, UnifyBillApplyAttr var2);

    public BillResponse genVaSubEntity() {
        return BillResponse.success(new ArrayList(4));
    }

    public List<UnifyBillApplyInitInfo> createUnifyBillApplyInfo(DynamicObject dyObject) {
        UnifyBillApplyInitInfo initInfo;
        if (Objects.nonNull(dyObject)) {
            Date startDate = dyObject.getDate(this.checkEnum.getStartDate());
            Date endDate = dyObject.getDate(this.checkEnum.getEndDate());
            startDate = BillEntityCheckService.getDate(startDate);
            endDate = BillEntityCheckService.getDate(endDate);
            long type = dyObject.getLong(this.checkEnum.getType() + ".id");
            String startMethod = dyObject.getString(this.checkEnum.getStartMethod());
            String endMethod = dyObject.getString(this.checkEnum.getEndMethod());
            UnifyBillApplyServiceEntryInitInfo unifyBillApplyServiceEntryInitInfo = new UnifyBillApplyServiceEntryInitInfo(startDate, endDate, type);
            unifyBillApplyServiceEntryInitInfo.setExpandInfo((Object)new UnifyBillExpandInfo(startMethod, endMethod));
            initInfo = new UnifyBillApplyInitInfo(null, this.attfileBo.longValue(), Collections.singletonList(unifyBillApplyServiceEntryInitInfo));
            this.init = true;
        } else {
            initInfo = new UnifyBillApplyInitInfo(null, this.attfileBo.longValue(), Collections.emptyList());
        }
        return Collections.singletonList(initInfo);
    }

    public BillResponse checkAttfile() {
        BillResponse billResponse = this.havePlan();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        return BillResponse.success();
    }

    public BillResponse checkStartDateAndEndDate() {
        Object data = null;
        BillResponse billResponse = this.checkAttfileBoBsed();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkAttfileHisAuth();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkRoster();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        data = billResponse.getData();
        billResponse = this.checkFrozenScope();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkNotInSuspend();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkWorkExperience();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkEverDayHasPlan();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        if (type != 0L && !(billResponse = this.checkEverDayHasRule()).isSuccess()) {
            return billResponse;
        }
        this.checkStartAndEndSuccess = true;
        return BillResponse.success((Object)data);
    }

    public BillResponse checkBaseSet() {
        BillResponse billResponse = this.checkBaseSetBaseInfo();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        List messages = billResponse.getMessage();
        billResponse = this.checkBeforeGenerateApplyTime();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        BillApplyTimeResult applyTime = this.generateApplyTime();
        BillResponse checkApplyTimeRes = this.checkApplyTime(applyTime);
        if (!checkApplyTimeRes.isSuccess()) {
            checkApplyTimeRes.setData((Object)applyTime);
            return checkApplyTimeRes;
        }
        this.checkBaseSetSuccess = true;
        return BillResponse.success((Object)applyTime, (List)messages);
    }

    public BillResponse checkBaseSetBaseInfo() {
        BillResponse billResponse;
        if ((UnifyBillEnum.TP == this.getUnifyBillEnum() || UnifyBillEnum.VA == this.getUnifyBillEnum()) && this.checkBillAllEfficacy(this.getDyObject())) {
            return BillResponse.success();
        }
        ArrayList messages = new ArrayList(10);
        if (!this.checkStartAndEndSuccess && !(billResponse = this.checkStartDateAndEndDate()).isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkEverDayHasRule();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkEverDateRage();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        if (!CollectionUtils.isEmpty((Collection)billResponse.getMessage())) {
            messages.addAll(billResponse.getMessage());
        }
        this.checkBaseSetSuccess = true;
        billResponse = this.checkAdviceAndAfter();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        return BillResponse.success(null, messages);
    }

    public BillResponse checkAndGetBaseSetDy() {
        BillResponse billResponse = this.checkStartDateAndEndDate();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        DynamicObject baseSetDy = this.getBaseSetDy();
        return BillResponse.success((Object)baseSetDy);
    }

    protected BillResponse checkEverDayHasPlan() {
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        Map<Date, DynamicObject> planDy = this.billAutoOperator.getPlanDy(this.attfileBo, startDate, endDate);
        if (planDy.containsValue(null)) {
            Date endNonRuleDay;
            List<Date> nonPlanDayList = BillEntityCheckService.getNonRuleDays(planDy);
            Date startNonPlanDay = nonPlanDayList.get(0);
            String failMsg = startNonPlanDay.compareTo(endNonRuleDay = nonPlanDayList.get(nonPlanDayList.size() - 1)) == 0 ? String.format(ResManager.loadKDString((String)"%1$s\u672a\u8bbe\u7f6e%2$s\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNonPlanDay), this.unifyBillEnum.getDescriptionStr()) : String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u672a\u8bbe\u7f6e%3$s\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_2", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNonPlanDay), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endNonRuleDay), this.unifyBillEnum.getDescriptionStr());
            msg.add(failMsg);
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public List<String> getMustInput() {
        Date ownDate = this.dyObject.getDate(this.checkEnum.getOwndate());
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        ownDate = BillEntityCheckService.getDate(ownDate);
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        LOG.info("BillCommonCheckHelper.getMustInput.attfileBo{},ownDate :{}, startDate :{}, endDate :{}, type :{}", new Object[]{this.attfileBo, ownDate, startDate, endDate, type});
        Map<Date, DynamicObject> baseSetDy = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
        if (MapUtils.isEmpty(baseSetDy)) {
            LOG.info("BillCommonCheckHelper.getMustInput,\u672a\u83b7\u53d6\u5230\u57fa\u7840\u914d\u7f6eMap.");
            return Lists.newArrayListWithCapacity((int)2);
        }
        DynamicObject baseSet = this.billAutoOperator.isUseStartOrEnd() ? baseSetDy.get(startDate) : baseSetDy.get(endDate);
        if (Objects.isNull(baseSet)) {
            baseSet = baseSetDy.get(ownDate);
        }
        if (baseSet == null) {
            LOG.info("BillCommonCheckHelper.getMustInput,\u672a\u83b7\u53d6\u5230\u57fa\u7840\u914d\u7f6e.");
            return Lists.newArrayListWithCapacity((int)2);
        }
        List mustInput = this.checkEnum.getApplyBillBaseSetEnum().getMustInput();
        DynamicObject finalBaseSet = baseSet;
        List<String> collect = mustInput.stream().filter(element -> finalBaseSet.getBoolean(element)).collect(Collectors.toList());
        return collect;
    }

    @Deprecated
    public DynamicObject getMatchBaseSet() {
        if (!this.checkBaseSetSuccess) {
            return null;
        }
        Date ownDate = this.dyObject.getDate(this.checkEnum.getOwndate());
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        ownDate = BillEntityCheckService.getDate(ownDate);
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> baseSetDy = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
        DynamicObject baseSet = baseSetDy.get(ownDate);
        return baseSet;
    }

    public DynamicObject getMatchChangeSet() {
        DynamicObject changeSet;
        String startMethod = this.dyObject.getString(this.checkEnum.getStartMethod());
        Date ownDate = new Date(this.dyObject.getDate(this.checkEnum.getOwndate()).getTime());
        Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> changeSetDy = this.billAutoOperator.getChangeSetDy(this.attfileBo, startDate, endDate, type);
        if (StringUtils.equalsAny((CharSequence)startMethod, (CharSequence[])new CharSequence[]{"0", "1", "2"})) {
            changeSet = this.billAutoOperator.isUseStartOrEnd() ? changeSetDy.get(startDate) : changeSetDy.get(endDate);
        } else {
            Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDate = this.billAutoOperator.getDutyDate(this.attfileBo, startDate, endDate);
            List dateList = (List)dutyDate.item1;
            ApplyBillDutyDateErrorEnum errorEnum = (ApplyBillDutyDateErrorEnum)dutyDate.item2;
            List msg = WTCCollections.modifiableList((Object[])new String[0]);
            if (errorEnum != null) {
                this.getErrorMsg(errorEnum, msg, startDate, endDate);
                return null;
            }
            if (CollectionUtils.isEmpty((Collection)dateList)) {
                return null;
            }
            ownDate = (Date)dateList.get(0);
            changeSet = changeSetDy.get(ownDate);
        }
        return changeSet;
    }

    public DynamicObject getMatchRule() {
        DynamicObject rule;
        String startMethod = this.dyObject.getString(this.checkEnum.getStartMethod());
        Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> ruleDy = this.billAutoOperator.getRuleCalDy(this.attfileBo, startDate, endDate, type);
        if (LOG.isDebugEnabled()) {
            LOG.debug("BillEntityCheckService#getMatchRule:{}", (Object)SerializationUtils.toJsonString(ruleDy));
        }
        if (StringUtils.equalsAny((CharSequence)startMethod, (CharSequence[])new CharSequence[]{"0", "1", "2"})) {
            rule = this.billAutoOperator.isUseStartOrEnd() ? ruleDy.get(startDate) : ruleDy.get(endDate);
        } else {
            Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDate = this.billAutoOperator.getDutyDate(this.attfileBo, startDate, endDate);
            List dateList = (List)dutyDate.item1;
            ApplyBillDutyDateErrorEnum errorEnum = (ApplyBillDutyDateErrorEnum)dutyDate.item2;
            List msg = WTCCollections.modifiableList((Object[])new String[0]);
            if (errorEnum != null) {
                this.getErrorMsg(errorEnum, msg, startDate, endDate);
                return null;
            }
            if (CollectionUtils.isEmpty((Collection)dateList)) {
                return null;
            }
            Date ownDate = (Date)dateList.get(0);
            rule = ruleDy.get(ownDate);
        }
        return rule;
    }

    public BillResponse checkBeforeGenerateApplyTime() {
        return BillResponse.success();
    }

    public abstract BillApplyTimeResult generateApplyTime();

    public DynamicObject getBustripBaseSetDy() {
        Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> baseSetDy = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
        if (MapUtils.isEmpty(baseSetDy)) {
            LOG.info("\u672a\u67e5\u8be2\u5230\u51fa\u5dee\u57fa\u7840\u914d\u7f6e\u3002startDate\uff1a{}\uff0c endDate:{}, type:{}, attfileBo:{}", new Object[]{startDate, endDate, type, this.attfileBo});
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2{0}\u57fa\u7840\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillCommonCheckHelper_36", (String)"wtc-wtbs-business", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}));
        }
        List sortedKeys = baseSetDy.keySet().stream().sorted().collect(Collectors.toList());
        DynamicObject baseSetDyn = this.billAutoOperator.isUseStartOrEnd() ? baseSetDy.get(sortedKeys.get(0)) : baseSetDy.get(sortedKeys.get(sortedKeys.size() - 1));
        return baseSetDyn;
    }

    public DynamicObject getBaseSetDy() {
        Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> baseSetDy = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
        if (MapUtils.isEmpty(baseSetDy)) {
            LOG.info("\u672a\u67e5\u8be2\u5230\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u3002startDate\uff1a{}\uff0c endDate:{}, type:{}, attfileBo:{}", new Object[]{startDate, endDate, type, this.attfileBo});
            throw new KDBizException(ResManager.loadKDString((String)"\u4f11\u5047\u57fa\u7840\u914d\u7f6e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillCommonCheckHelper_34", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        List sortedKeys = baseSetDy.keySet().stream().sorted().collect(Collectors.toList());
        DynamicObject baseSetDyn = this.billAutoOperator.isUseStartOrEnd() ? baseSetDy.get(sortedKeys.get(0)) : baseSetDy.get(sortedKeys.get(sortedKeys.size() - 1));
        return baseSetDyn;
    }

    public BillApplyTimeResult generateBustripApplyTime(List<Tuple<DutyShift, Shift>> dutyShiftsRange, Date date, DynamicObject baseSetDyn) {
        BigDecimal valHour = BigDecimal.ZERO;
        BigDecimal valDay = BigDecimal.ZERO;
        Tuple<DutyShift, Shift> tupleDutyShift = null;
        String unit = baseSetDyn.getString("unit");
        for (Tuple<DutyShift, Shift> truple : dutyShiftsRange) {
            Date rosterDate = ((DutyShift)truple.item1).getRosterDate();
            if (!DateUtils.isSameDay((Date)rosterDate, (Date)date)) continue;
            tupleDutyShift = truple;
            break;
        }
        if (tupleDutyShift == null) {
            LOG.info("BillEntityCheckService.generateBustripApplyTime not tupleDutyShift\u3002 date:{}", (Object)date);
            return new BillApplyTimeResult(unit, BigDecimal.ZERO, BigDecimal.ZERO);
        }
        DateAttribute dateAttribute = ((DutyShift)tupleDutyShift.item1).getDateAttribute();
        Long dateTypeId = ((DutyShift)tupleDutyShift.item1).getDateTypeModel() != null ? ((DutyShift)tupleDutyShift.item1).getDateTypeModel().getId() : null;
        String fieldDateRangeCondition = this.unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum().getDateRangeCondition();
        boolean satisfyDateRange = new DateRangeServiceImpl().isSatisfyDateRange(dateTypeId, dateAttribute.getCode(), baseSetDyn.getString(fieldDateRangeCondition));
        if (satisfyDateRange) {
            ShiftMiddleRule shiftMiddleRule = ((Shift)tupleDutyShift.item2).getShiftMiddleRule();
            BigDecimal allDayHour = shiftMiddleRule.getAlldayhour();
            Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
            Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
            BigDecimal shiftOtTime = this.getShiftOtTime(baseSetDyn, tupleDutyShift, true, startDate, endDate);
            BigDecimal multiply = new BigDecimal(endDate.getTime()).subtract(new BigDecimal(startDate.getTime()));
            multiply = multiply.subtract(shiftOtTime);
            valHour = multiply.divide(new BigDecimal(3600000), 6, RoundingMode.HALF_UP);
            valDay = valHour.divide(allDayHour, 6, RoundingMode.HALF_UP);
        }
        return new BillApplyTimeResult(unit, valHour, valDay);
    }

    private BigDecimal getShiftOtTime(DynamicObject baseSetDyn, Tuple<DutyShift, Shift> tupleDutyShift, boolean isOptional, Date startDate, Date endDate) {
        boolean isShiftOt = baseSetDyn.getBoolean("isshiftot");
        BigDecimal shiftOtTime = BigDecimal.ZERO;
        if (!isShiftOt) {
            List shiftDetailList = ((Shift)tupleDutyShift.item2).getShiftDetailList();
            for (ShiftDetail shiftDetail : shiftDetailList) {
                if (!HRStringUtils.equals((String)OutWorkType.OT.code, (String)shiftDetail.getOutWorkType())) continue;
                Date detailStartDate = ShiftParseUtil.getRosterStartDate(shiftDetail, ((DutyShift)tupleDutyShift.item1).getRosterDate());
                Date detailEndDate = ShiftParseUtil.getRosterDetailEndDate(shiftDetail, ((DutyShift)tupleDutyShift.item1).getRosterDate());
                if (isOptional) {
                    if (detailStartDate.compareTo(startDate) <= 0) {
                        detailStartDate = startDate;
                    }
                    if (detailEndDate.compareTo(endDate) >= 0) {
                        detailEndDate = endDate;
                    }
                }
                shiftOtTime = shiftOtTime.add(new BigDecimal(detailEndDate.getTime()).subtract(new BigDecimal(detailStartDate.getTime())));
            }
        }
        return shiftOtTime;
    }

    public BillApplyTimeResult calWholeDayHours(List<Tuple<DutyShift, Shift>> dutyShifts, Date startDate, Date endDate, DynamicObject baseSetDyn) {
        return this.calWholeDayHours(dutyShifts, startDate, endDate, baseSetDyn, false);
    }

    public BillApplyTimeResult calWholeDayHours(List<Tuple<DutyShift, Shift>> dutyShifts, Date startDate, Date endDate, DynamicObject baseSetDyn, boolean containBreak) {
        LOG.info("calWholeDayHours start startDate: {}, endDate :{}, vaBeSetId: {}, dutyShiftDayMap: {}", new Object[]{startDate, endDate, baseSetDyn.getPkValue(), dutyShifts});
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal entryVaTimeHour = BigDecimal.ZERO;
        BigDecimal entryVaTimeDay = BigDecimal.ZERO;
        IDateRangeService dateRangeService = (IDateRangeService)WTCAppContextHelper.getBean(DateRangeServiceImpl.class);
        boolean before = startDate.before(endDate) || DateUtils.isSameDay((Date)startDate, (Date)endDate);
        Map<String, Tuple> tupleMap = dutyShifts.stream().collect(Collectors.toMap(tuple -> dateFormat.format(((DutyShift)tuple.item1).getRosterDate()), tuple -> tuple, (tuple1, tuple2) -> tuple1));
        while (before) {
            Tuple tuple3 = tupleMap.get(dateFormat.format(startDate));
            if (tuple3 != null) {
                DateAttribute dateAttribute = ((DutyShift)tuple3.item1).getDateAttribute();
                Long dateTypeId = ((DutyShift)tuple3.item1).getDateTypeModel() != null ? ((DutyShift)tuple3.item1).getDateTypeModel().getId() : null;
                String fieldDateRangeCondition = this.unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum().getDateRangeCondition();
                boolean satisfyDateRange = dateRangeService.isSatisfyDateRange(dateTypeId, dateAttribute.getCode(), baseSetDyn.getString(fieldDateRangeCondition));
                if (satisfyDateRange) {
                    if (((Shift)tuple3.item2).getOffNonPlan() && ((Shift)tuple3.item2).isOff()) {
                        entryVaTimeDay = entryVaTimeDay.add(((Shift)tuple3.item2).getShiftMiddleRule().getAllday());
                        entryVaTimeHour = entryVaTimeHour.add(((Shift)tuple3.item2).getShiftMiddleRule().getAlldayhour());
                    } else {
                        BigDecimal shiftOtTime = this.getShiftOtTime(baseSetDyn, (Tuple<DutyShift, Shift>)tuple3, false, startDate, endDate);
                        shiftOtTime = shiftOtTime.divide(new BigDecimal(3600000), 6, RoundingMode.HALF_UP);
                        BigDecimal standardHour = BigDecimal.valueOf(((Shift)tuple3.item2).getStandardTime().intValue()).divide(BigDecimal.valueOf(3600L), 6, RoundingMode.HALF_UP);
                        standardHour = standardHour.subtract(shiftOtTime);
                        entryVaTimeHour = entryVaTimeHour.add(standardHour);
                        BigDecimal allDayHour = ((Shift)tuple3.item2).getShiftMiddleRule().getAlldayhour();
                        BigDecimal entryDay = standardHour.divide(allDayHour, 6, RoundingMode.HALF_UP);
                        entryVaTimeDay = entryVaTimeDay.add(entryDay);
                    }
                }
            }
            before = (startDate = DateUtils.addDays((Date)startDate, (int)1)).before(endDate) || DateUtils.isSameDay((Date)startDate, (Date)endDate);
        }
        LOG.info("calWholeDayHours end entryVaTimeHour: {}, entryVaTimeDay: {}", (Object)entryVaTimeHour, (Object)entryVaTimeHour);
        return new BillApplyTimeResult(null, entryVaTimeHour, entryVaTimeDay);
    }

    public BillApplyTimeResult calHalfDayHours(List<Tuple<DutyShift, Shift>> dutyShiftsRange, Date date, DynamicObject baseSetDyn, boolean isHalfUp) {
        return this.calHalfDayHours(dutyShiftsRange, date, baseSetDyn, isHalfUp, false);
    }

    public BillApplyTimeResult calHalfDayHours(List<Tuple<DutyShift, Shift>> dutyShiftsRange, Date date, DynamicObject baseSetDyn, boolean isHalfUp, boolean containBreak) {
        Tuple<DutyShift, Shift> tupleDutyShift = null;
        for (Tuple<DutyShift, Shift> truple : dutyShiftsRange) {
            Date rosterDate = ((DutyShift)truple.item1).getRosterDate();
            if (!DateUtils.isSameDay((Date)rosterDate, (Date)date)) continue;
            tupleDutyShift = truple;
            break;
        }
        if (tupleDutyShift == null) {
            LOG.info("\u65e5\u671f\u65e0\u73ed\u6b21\uff0c\u4e0d\u8ba1\u7b97\u534a\u5929\u73ed\u65f6\u957f\uff0cdate:{}", (Object)date);
            return new BillApplyTimeResult();
        }
        DateAttribute dateAttribute = ((DutyShift)tupleDutyShift.item1).getDateAttribute();
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        Long dateTypeId = ((DutyShift)tupleDutyShift.item1).getDateTypeModel() != null ? ((DutyShift)tupleDutyShift.item1).getDateTypeModel().getId() : null;
        String fieldDateRangeCondition = this.unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum().getDateRangeCondition();
        boolean satisfyDateRange = dateRangeService.isSatisfyDateRange(dateTypeId, dateAttribute.getCode(), baseSetDyn.getString(fieldDateRangeCondition));
        BigDecimal entryVaTimeHour = BigDecimal.ZERO;
        BigDecimal entryVaTimeDay = BigDecimal.ZERO;
        if (satisfyDateRange) {
            ShiftMiddleRule shiftMiddleRule = ((Shift)tupleDutyShift.item2).getShiftMiddleRule();
            if (((Shift)tupleDutyShift.item2).getOffNonPlan() && ((Shift)tupleDutyShift.item2).isOff()) {
                entryVaTimeHour = shiftMiddleRule.getAlldayhour().divide(BigDecimal.valueOf(2L), 6, RoundingMode.HALF_UP);
                entryVaTimeDay = shiftMiddleRule.getAllday().divide(BigDecimal.valueOf(2L), 6, RoundingMode.HALF_UP);
            } else {
                double dateInsectionTimes = 0.0;
                int lastShiftStartDate = ((Shift)tupleDutyShift.item2).getLastShiftStartDate();
                Date rosterBeginDate = WTCDateUtils.getDate((Date)date, (Integer)lastShiftStartDate);
                RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
                Date refMiddleDate = date;
                if (RefDateType.NEXTDAY == middleRefDate) {
                    refMiddleDate = DateUtils.addDays((Date)date, (int)1);
                }
                Date middleDate = WTCDateUtils.getDate((Date)refMiddleDate, (Integer)shiftMiddleRule.getMiddlepoint());
                Date rosterEndDate = ShiftParseUtil.getRosterEndDate((Shift)tupleDutyShift.item2, date);
                List shiftDetails = ((Shift)tupleDutyShift.item2).getShiftDetailList();
                boolean isShiftOt = baseSetDyn.getBoolean("isshiftot");
                for (ShiftDetail detail : shiftDetails) {
                    if (StringUtils.equalsAny((CharSequence)detail.getOutWorkType(), (CharSequence[])new CharSequence[]{OutWorkType.BREAK.code}) && !containBreak || !isShiftOt && HRStringUtils.equals((String)OutWorkType.OT.code, (String)detail.getOutWorkType())) continue;
                    Date detailStartDate = ShiftParseUtil.getRosterStartDate(detail, ((DutyShift)tupleDutyShift.item1).getRosterDate());
                    Date detailEndDate = ShiftParseUtil.getRosterDetailEndDate(detail, ((DutyShift)tupleDutyShift.item1).getRosterDate());
                    if (isHalfUp) {
                        dateInsectionTimes += (double)WTCDateUtils.getDateInsectionTimes((Date)rosterBeginDate, (Date)middleDate, (Date)detailStartDate, (Date)detailEndDate);
                        continue;
                    }
                    dateInsectionTimes += (double)WTCDateUtils.getDateInsectionTimes((Date)middleDate, (Date)rosterEndDate, (Date)detailStartDate, (Date)detailEndDate);
                }
                entryVaTimeHour = BigDecimal.valueOf(dateInsectionTimes / 3600.0).setScale(6, RoundingMode.HALF_UP);
                if (BigDecimal.ZERO.compareTo(shiftMiddleRule.getAlldayhour()) != 0) {
                    entryVaTimeDay = entryVaTimeHour.divide(shiftMiddleRule.getAlldayhour(), 6, RoundingMode.HALF_UP);
                }
            }
        }
        return new BillApplyTimeResult(null, entryVaTimeHour, entryVaTimeDay);
    }

    public boolean beginDayIsHoleDay(String startMethod, String endMethod, Date startDate, Date endDate) {
        boolean result = HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.DAY.value) || HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) && !DateUtils.isSameDay((Date)startDate, (Date)endDate) || HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value);
        return result;
    }

    public BillResponse havePlan() {
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        List<DynamicObject> allPlan = this.billAutoOperator.getAllPlan(this.attfileBo);
        if (CollectionUtils.isEmpty(allPlan)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%1$s\u65b9\u6848\uff0c\u65e0\u6cd5\u7533\u8bf7%2$s\u3002", (String)"BillCommonCheckHelper_3", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.unifyBillEnum.getDescriptionStr(), this.unifyBillEnum.getDescriptionStr());
            msg.add(errorMsg);
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkAdviceAndAfter() {
        if (!this.init) {
            return BillResponse.success();
        }
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> advanceAndAfterInfo = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
        if (WTCCollections.isEmpty(advanceAndAfterInfo)) {
            return BillResponse.success();
        }
        List sortedKeys = advanceAndAfterInfo.keySet().stream().sorted().collect(Collectors.toList());
        LinkedHashSet<LocalDate> checkDates = new LinkedHashSet<LocalDate>(sortedKeys.size());
        for (Date sortedKey : sortedKeys) {
            checkDates.add(WTCDateUtils.toLocalDate((Date)sortedKey));
        }
        if (WTCCollections.isEmpty(sortedKeys)) {
            return BillResponse.success();
        }
        BillServiceBaseNewSetInfo queryNewInfo = new BillServiceBaseNewSetInfo();
        queryNewInfo.setCheckDates(checkDates);
        queryNewInfo.setPersonId(this.billAutoOperator.getPersonIdByAttFileBoId(this.attfileBo));
        queryNewInfo.setBaseSetDy(this.getBaseSetDy());
        queryNewInfo.setAttFileBoId(this.getAttfileBo().longValue());
        BillBaseStateLessService service = new BillBaseStateLessService();
        UnifyBaseSetEnum baseSetEnum = this.getBillAutoOperator().getUnifyBillEnum().getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum();
        Map<BillAdvanceAfterEnum, List<BillServiceAdvAfterResp>> billAdvanceAfterEnumListMap = service.checkAdvanceAfter(Lists.newArrayList((Object[])new BillServiceBaseNewSetInfo[]{queryNewInfo}), this.buildAdvanceAndAfterInfo(baseSetEnum));
        Tuple<Boolean, String> result = AdvanceAfterValidateUtil.buildAdvanceAfterResp(billAdvanceAfterEnumListMap, queryNewInfo);
        if (((Boolean)result.item1).booleanValue()) {
            return BillResponse.success();
        }
        return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{(String)result.item2}));
    }

    private Map<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>> buildAdvanceAndAfterInfo(UnifyBaseSetEnum baseSetEnum) {
        HashMap<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>> result = new HashMap<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>>(16);
        HashMap<BillAdvanceAfterFieldEnum, String> after = new HashMap<BillAdvanceAfterFieldEnum, String>(16);
        after.put(BillAdvanceAfterFieldEnum.CTRL, baseSetEnum.getFieldAfterNeedInBaseSet());
        after.put(BillAdvanceAfterFieldEnum.UNIT, baseSetEnum.getFieldAfterUnitInBaseSet());
        after.put(BillAdvanceAfterFieldEnum.OFFSET, baseSetEnum.getFieldAfterNumberInBaseSet());
        HashMap<BillAdvanceAfterFieldEnum, String> advance = new HashMap<BillAdvanceAfterFieldEnum, String>(16);
        advance.put(BillAdvanceAfterFieldEnum.CTRL, baseSetEnum.getFieldAdvanceNeedInBaseSet());
        advance.put(BillAdvanceAfterFieldEnum.UNIT, baseSetEnum.getFieldAdvanceUnitInBaseSet());
        advance.put(BillAdvanceAfterFieldEnum.OFFSET, baseSetEnum.getFieldAdvanceNumberInBaseSet());
        HashMap<BillAdvanceAfterFieldEnum, String> maxAdv = new HashMap<BillAdvanceAfterFieldEnum, String>(16);
        maxAdv.put(BillAdvanceAfterFieldEnum.CTRL, baseSetEnum.getFieldMaxAdvanceNeedInBaseSet());
        maxAdv.put(BillAdvanceAfterFieldEnum.UNIT, baseSetEnum.getFieldMaxAdvanceUnitInBaseSet());
        maxAdv.put(BillAdvanceAfterFieldEnum.OFFSET, baseSetEnum.getFieldMaxAdvanceNumberInBaseSet());
        result.put(BillAdvanceAfterEnum.ADVANCE, advance);
        result.put(BillAdvanceAfterEnum.AFTER, after);
        result.put(BillAdvanceAfterEnum.MAX_ADVANCE, maxAdv);
        return result;
    }

    public BillResponse checkApplyTime(BillApplyTimeResult applyTimeResult) {
        BigDecimal applyTime = applyTimeResult.getTimeByUnit();
        return this.checkApplyTime(applyTime);
    }

    public BillResponse checkApplyTime(BigDecimal applyTime) {
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> baseSetDyMap = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
        DynamicObject baseSetDy = baseSetDyMap.entrySet().iterator().next().getValue();
        BigDecimal minApplyTime = baseSetDy.getBigDecimal(this.checkEnum.getApplyBillBaseSetEnum().getMinApplyTime());
        minApplyTime = minApplyTime.setScale(2, RoundingMode.HALF_UP);
        String unit = baseSetDy.getString(this.checkEnum.getApplyBillBaseSetEnum().getUnit());
        if (applyTime.compareTo(BigDecimal.ZERO) == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u957f\u4e0d\u80fd\u4e3a0\u3002", (String)"BillCommonCheckHelper_12", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            msg.add(errorMsg);
            success = false;
        }
        if ((applyTime = applyTime.setScale(2, RoundingMode.HALF_UP)).compareTo(minApplyTime) < 0) {
            String timeWithUnit = StringUtils.equals((CharSequence)unit, (CharSequence)"A") ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5929", (String)"BillCommonCheckHelper_5", (String)"wtc-wtbs-business", (Object[])new Object[0]), minApplyTime) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5c0f\u65f6", (String)"BillCommonCheckHelper_13", (String)"wtc-wtbs-business", (Object[])new Object[0]), minApplyTime);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6700\u5c0f%1$s\u65f6\u957f\u9700\u5927\u4e8e\u7b49\u4e8e%2$s\u3002", (String)"BillCommonCheckHelper_14", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.unifyBillEnum.getDescriptionStr(), timeWithUnit);
            msg.add(errorMsg);
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        this.checkBaseSetSuccess = true;
        return BillResponse.success();
    }

    public BillResponse checkNotInSuspend() {
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        Map<Date, Boolean> dateBooleanMap = this.billAutoOperator.verifyNotInSuspend(this.attfileBo, startDate, endDate);
        if (dateBooleanMap.containsValue(Boolean.FALSE)) {
            Date endNotInSuspend;
            List<Date> notInSuspendlist = BillEntityCheckService.getnotInSuspend(dateBooleanMap);
            Date startNotInSuspend = notInSuspendlist.get(0);
            if (startNotInSuspend.compareTo(endNotInSuspend = notInSuspendlist.get(notInSuspendlist.size() - 1)) == 0) {
                String failMsg = ResManager.loadKDString((String)"%s\u5df2\u505c\u6b62\u8003\u52e4\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_15", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endNotInSuspend)});
                msg.add(failMsg);
            } else {
                String failMsg = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u5df2\u505c\u6b62\u8003\u52e4\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_16", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNotInSuspend), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endNotInSuspend));
                msg.add(failMsg);
            }
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    private static List<Date> getnotInSuspend(Map<Date, Boolean> dateBooleanMap) {
        ArrayList<Date> list = new ArrayList<Date>(4);
        for (Map.Entry<Date, Boolean> next : dateBooleanMap.entrySet()) {
            if (next.getValue().booleanValue()) continue;
            list.add(next.getKey());
        }
        return list;
    }

    private BillResponse checkWorkExperience() {
        if (!this.init) {
            return BillResponse.success();
        }
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDate = this.billAutoOperator.getDutyDate(this.attfileBo, startDate, endDate);
        if (dutyDate == null || WTCCollections.isEmpty((Collection)((Collection)dutyDate.item1))) {
            return BillResponse.success();
        }
        HashSet<LocalDate> allDate = new HashSet<LocalDate>(16);
        for (Date date : (List)dutyDate.item1) {
            if (date == null) continue;
            allDate.add(WTCDateUtils.toLocalDate((Date)date));
        }
        if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)this.dyObject.getString(this.checkEnum.getStartMethod()))) {
            this.handleCustomCrossShift(startDate, endDate, allDate);
        }
        if (WTCCollections.isEmpty(allDate)) {
            return BillResponse.success();
        }
        Set notNullDate = allDate.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Date[] dateList = notNullDate.stream().map(WTCDateUtils::toDate).collect(Collectors.toList()).toArray(new Date[0]);
        List<Tuples.Tuple2<LocalDate, LocalDate>> missWorkExperience = BillAttFileService.getInstance().missWorkExperience(WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinDate((Date[])dateList)), WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMaxDate((Date[])dateList)), this.billAutoOperator.getAttFileAllVersion(this.attfileBo));
        if (WTCCollections.isEmpty(missWorkExperience)) {
            return BillResponse.success();
        }
        String finalTip = ResManager.loadKDString((String)"{0}\u7684\u8003\u52e4\u6863\u6848\u5bf9\u5e94\u7684\u6838\u5fc3\u4eba\u529b\u7684\u4efb\u804c\u7ecf\u5386\u5df2\u5220\u9664\uff0c\u8003\u52e4\u6863\u6848\u5173\u8054\u7684\u5c97\u4f4d\u4fe1\u606f\u4e0d\u51c6\u786e\uff0c\u8bf7\u8c03\u6574\u8003\u52e4\u6863\u6848\u7684\u5c97\u4f4d\u4fe1\u606f\u3002", (String)"BillEntityCheckService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{MessageFormat.format(finalTip, BillCommonService.getInstance().handleTimePariInfo(missWorkExperience))}));
    }

    private void handleCustomCrossShift(Date startDate, Date endDate, Set<LocalDate> allDate) {
        if (startDate == null || endDate == null) {
            return;
        }
        BillOptionalDutyDateService dutyDateService = new BillOptionalDutyDateService();
        String dutyDateKey = dutyDateService.getAppCustomParameter("allowCrossShiftAnd24h");
        if (LOG.isDebugEnabled()) {
            LOG.debug("BillEntityCheckService_checkWorkExperience,dutyDateKey = {}", (Object)dutyDateKey);
        }
        List<Tuple<DutyShift, Shift>> dutyShiftsRange = this.billAutoOperator.getDutyShiftsRange(this.attfileBo, startDate, endDate);
        if (HRStringUtils.equals((String)"true", (String)dutyDateKey) && dutyDateService.over24OrCrossShift(startDate, endDate, dutyShiftsRange)) {
            LOG.info("BillOptionalDutyDateService_getDutyDate crossShiftAndOver24");
            ArrayList<BillOptionDutyDateReq> reqs = new ArrayList<BillOptionDutyDateReq>(10);
            BillOptionDutyDateReq reqStart = new BillOptionDutyDateReq();
            reqStart.setAttFileBoId(this.attfileBo);
            reqStart.setShiftInfo(dutyShiftsRange);
            reqStart.setStartTime(startDate);
            reqStart.setEndTime(startDate);
            reqStart.setShiftInfo(dutyShiftsRange);
            BillOptionDutyDateReq reqEnd = new BillOptionDutyDateReq();
            reqEnd.setAttFileBoId(this.attfileBo);
            reqEnd.setShiftInfo(dutyShiftsRange);
            reqEnd.setStartTime(endDate);
            reqEnd.setEndTime(endDate);
            reqEnd.setShiftInfo(dutyShiftsRange);
            reqs.add(reqStart);
            reqs.add(reqEnd);
            List<BillOptionDutyDateResp> over24DutyDate = dutyDateService.getDutyDate(reqs);
            if (WTCCollections.isNotEmpty(over24DutyDate)) {
                BillOptionDutyDateResp billOptionDutyDateResp;
                Optional startOptional = WTCCollectionIndexUtil.getEleFromList(over24DutyDate, (int)0);
                Optional endOptional = WTCCollectionIndexUtil.getEleFromList(over24DutyDate, (int)1);
                if (startOptional.isPresent()) {
                    billOptionDutyDateResp = (BillOptionDutyDateResp)startOptional.get();
                    if (billOptionDutyDateResp.getDutyDate() != null) {
                        allDate.add(WTCDateUtils.toLocalDate((Date)billOptionDutyDateResp.getDutyDate()));
                    } else {
                        allDate.add(WTCDateUtils.toLocalDate((Date)reqStart.getStartTime()));
                    }
                }
                if (endOptional.isPresent()) {
                    billOptionDutyDateResp = (BillOptionDutyDateResp)endOptional.get();
                    if (billOptionDutyDateResp.getDutyDate() != null) {
                        allDate.add(WTCDateUtils.toLocalDate((Date)billOptionDutyDateResp.getDutyDate()));
                    } else {
                        allDate.add(WTCDateUtils.toLocalDate((Date)reqEnd.getEndTime()));
                    }
                }
            }
            if (WTCCollections.isEmpty(allDate)) {
                return;
            }
            Date[] collect = allDate.stream().filter(Objects::nonNull).map(WTCDateUtils::toDate).collect(Collectors.toList()).toArray(new Date[0]);
            List dateRange = WTCDateUtils.getDateRange((Date)WTCDateUtils.getMinDate((Date[])collect), (Date)WTCDateUtils.getMaxDate((Date[])collect));
            if (WTCCollections.isNotEmpty((Collection)dateRange)) {
                allDate.addAll(dateRange.stream().filter(Objects::nonNull).map(WTCDateUtils::toLocalDate).collect(Collectors.toSet()));
            }
        }
    }

    public BillResponse checkEverDateRage() {
        String failMsg;
        DutyShift endShift;
        DutyShift startShift;
        DynamicObject startDy;
        Map<Date, DynamicObject> baseSetMap;
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        String startMetohd = this.dyObject.getString(this.checkEnum.getStartMethod());
        if (StringUtils.equalsAny((CharSequence)startMetohd, (CharSequence[])new CharSequence[]{"0", "1", "2"})) {
            baseSetMap = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
            startDy = baseSetMap.get(startDate);
            startShift = this.billAutoOperator.getDutyShift(this.attfileBo, startDate, endDate).get(startDate);
            endShift = this.billAutoOperator.getDutyShift(this.attfileBo, startDate, endDate).get(endDate);
        } else {
            baseSetMap = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
            startDy = baseSetMap.entrySet().iterator().next().getValue();
            startShift = this.billAutoOperator.getDutyShift(this.attfileBo, startDate, endDate).entrySet().iterator().next().getValue();
            endShift = this.billAutoOperator.getDutyShift(this.attfileBo, startDate, endDate).entrySet().iterator().next().getValue();
        }
        String auditbegindate = startDy.getString(this.checkEnum.getApplyBillBaseSetEnum().getAuditbegindate());
        String auditenddate = startDy.getString(this.checkEnum.getApplyBillBaseSetEnum().getAuditenddate());
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        Long startShiftDateType = startShift.getDateTypeModel() == null ? null : startShift.getDateTypeModel().getId();
        Long endShiftDateType = startShift.getDateTypeModel() == null ? null : endShift.getDateTypeModel().getId();
        String fieldDateRangeCondition = this.unifyBillEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getBaseSetEnum().getDateRangeCondition();
        Boolean startIsSatisfyDateRange = dateRangeService.isSatisfyDateRange(startShiftDateType, startShift.getDateAttribute().getCode(), startDy.getString(fieldDateRangeCondition));
        Boolean endIsSatisfyDateRange = dateRangeService.isSatisfyDateRange(endShiftDateType, endShift.getDateAttribute().getCode(), startDy.getString(fieldDateRangeCondition));
        switch (auditbegindate) {
            case "A": {
                if (!BooleanUtils.isNotTrue((Boolean)startIsSatisfyDateRange)) break;
                success = false;
                failMsg = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5728\u8be5%1$s\u7c7b\u578b\u7684\u65e5\u671f\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u7533\u8bf7%2$s\u3002", (String)"BillCommonCheckHelper_17", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.unifyBillEnum.getDescriptionStr(), this.unifyBillEnum.getDescriptionStr());
                msg.add(failMsg);
                break;
            }
            case "B": {
                if (!BooleanUtils.isNotTrue((Boolean)startIsSatisfyDateRange)) break;
                failMsg = ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5728\u8be5%s\u7c7b\u578b\u7684\u65e5\u671f\u8303\u56f4\u4e2d\u3002", (String)"BillCommonCheckHelper_18", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
                msg.add(failMsg);
                break;
            }
            case "C": {
                break;
            }
        }
        switch (auditenddate) {
            case "A": {
                if (!BooleanUtils.isNotTrue((Boolean)endIsSatisfyDateRange)) break;
                success = false;
                failMsg = String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u5728\u8be5%1$s\u7c7b\u578b\u7684\u65e5\u671f\u8303\u56f4\u4e2d\uff0c\u4e0d\u53ef\u4ee5\u7533\u8bf7%2$s\u3002", (String)"BillCommonCheckHelper_19", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.unifyBillEnum.getDescriptionStr(), this.unifyBillEnum.getDescriptionStr());
                msg.add(failMsg);
                break;
            }
            case "B": {
                if (!BooleanUtils.isNotTrue((Boolean)endIsSatisfyDateRange)) break;
                failMsg = ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u5728\u8be5%s\u7c7b\u578b\u7684\u65e5\u671f\u8303\u56f4\u4e2d\u3002", (String)"BillCommonCheckHelper_20", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
                msg.add(failMsg);
                break;
            }
            case "C": {
                break;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success(null, msg);
    }

    public BillResponse checkChangeSet(DynamicObject newEntryDy) {
        Date startDate = new Date(newEntryDy.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(newEntryDy.getDate(this.checkEnum.getEndDate()).getTime());
        String startMethod = newEntryDy.getString(this.checkEnum.getStartMethod());
        String endMethod = newEntryDy.getString(this.checkEnum.getEndMethod());
        long type = newEntryDy.getLong(this.checkEnum.getType() + ".id");
        String typeName = newEntryDy.getLocaleString(this.checkEnum.getType() + ".name").getLocaleValue();
        return this.checkChangeSet(type, typeName, startDate, endDate, startMethod, endMethod);
    }

    public BillResponse checkChangeSet(Long newType, String newTypeName, Date newStart, Date newEnd, String newStartMethod, String newEndMethod) {
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        if (startDate == null || endDate == null) {
            return BillResponse.success();
        }
        String startMethod = this.dyObject.getString(this.checkEnum.getStartMethod());
        String endMethod = this.dyObject.getString(this.checkEnum.getEndMethod());
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> changeSetDy = this.billAutoOperator.getChangeSetDy(this.attfileBo, startDate, endDate, type);
        if (!CollectionUtils.isEmpty(changeSetDy)) {
            DynamicObject value = changeSetDy.entrySet().iterator().next().getValue();
            if (Objects.nonNull(value)) {
                DynamicObjectCollection entryEntity;
                Set changeSet;
                String failMsg;
                LOG.info("\u627e\u5230\u4f11\u5047\u53d8\u66f4\u914d\u7f6e\uff1a{}", value.getPkValue());
                boolean ischangetime = value.getBoolean(this.checkEnum.getApplyBillChangeSetEnum().getIschangetime());
                boolean istypechange = value.getBoolean(this.checkEnum.getApplyBillChangeSetEnum().getIstypechange());
                if (ischangetime) {
                    String bgtimetype = value.getString(this.checkEnum.getApplyBillChangeSetEnum().getBgtimetype());
                    Map<Date, Shift> shiftMap = this.billAutoOperator.getShift(this.attfileBo, startDate, endDate);
                    this.firstDateShift = this.getfirstShift(shiftMap);
                    this.lastDateShift = this.getlastShift(shiftMap);
                    if (HRStringUtils.equals((String)bgtimetype, (String)"A") && (this.checkStartNotBefore(startDate, startMethod, newStart, newStartMethod) || this.checkEndNotAfter(endDate, endMethod, newEnd, newEndMethod))) {
                        success = false;
                        LOG.info("endDate:{}, endMethod:{}, newEnd:{}, newEndMethod:{}", new Object[]{endDate, endMethod, newEnd, newEndMethod});
                        failMsg = ResManager.loadKDString((String)"%s\u65f6\u95f4\u53ea\u80fd\u5728\u539f\u5355\u8303\u56f4\u5185\u53d8\u66f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillCommonCheckHelper_21", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
                        msg.add(failMsg);
                    }
                } else if (startDate.compareTo(newStart) != 0 || endDate.compareTo(newEnd) != 0 || !HRStringUtils.equals((String)newStartMethod, (String)startMethod) || !HRStringUtils.equals((String)newEndMethod, (String)endMethod)) {
                    success = false;
                    String failMsg2 = ResManager.loadKDString((String)"\u8be5%s\u7c7b\u578b\u4e0d\u5141\u8bb8\u53d8\u66f4\u65f6\u95f4\u3002", (String)"BillCommonCheckHelper_22", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
                    msg.add(failMsg2);
                }
                if (istypechange && !(changeSet = (entryEntity = value.getDynamicObjectCollection(this.checkEnum.getApplyBillChangeSetEnum().getEntryentity())).stream().map(dynamicObject -> dynamicObject.getLong(this.checkEnum.getApplyBillChangeSetEnum().getType() + ".id")).collect(Collectors.toSet())).contains(newType) && newType != type) {
                    success = false;
                    failMsg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u578b\u65e0\u6cd5\u53d8\u66f4\u4e3a%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillCommonCheckHelper_23", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.unifyBillEnum.getDescriptionStr(), newTypeName);
                    msg.add(failMsg);
                }
            } else if (startDate.compareTo(newStart) != 0 || endDate.compareTo(newEnd) != 0 || newType != type) {
                success = false;
                String failMsg = ResManager.loadKDString((String)"\u8be5%s\u5355\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"BillCommonCheckHelper_25", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
                msg.add(failMsg);
            }
        } else if (startDate.compareTo(newStart) != 0 || endDate.compareTo(newEnd) != 0 || newType != type) {
            success = false;
            String failMsg = ResManager.loadKDString((String)"\u8be5%s\u5355\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"BillCommonCheckHelper_25", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
            msg.add(failMsg);
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    protected Shift getlastShift(Map<Date, Shift> shiftMap) {
        if (!CollectionUtils.isEmpty(shiftMap)) {
            Shift shift = null;
            for (Map.Entry<Date, Shift> next : shiftMap.entrySet()) {
                shift = next.getValue();
            }
            return shift;
        }
        return null;
    }

    protected Shift getfirstShift(Map<Date, Shift> shiftMap) {
        if (!CollectionUtils.isEmpty(shiftMap)) {
            Shift firstShift = shiftMap.entrySet().iterator().next().getValue();
            return firstShift;
        }
        return null;
    }

    protected boolean checkEndNotAfter(Date endDate, String endMethod, Date newEnd, String newEndMethod) {
        Date newend;
        Date oldend = this.getRelativeTime4End(endDate, endMethod);
        return oldend.compareTo(newend = this.getRelativeTime4End(newEnd, newEndMethod)) < 0;
    }

    private Date getRelativeTime4End(Date date, String dateMethod) {
        if (HRStringUtils.equals((String)dateMethod, (String)"3")) {
            return date;
        }
        if (HRStringUtils.equals((String)dateMethod, (String)"0")) {
            return DateUtils.addSeconds((Date)date, (int)this.getMiddleSecond());
        }
        if (HRStringUtils.equals((String)dateMethod, (String)"1")) {
            return DateUtils.addSeconds((Date)date, (int)this.getLastSecond());
        }
        return DateUtils.addSeconds((Date)date, (int)this.getLastSecond());
    }

    private int getMiddleSecond() {
        if (this.firstDateShift != null) {
            int middlepoint = this.firstDateShift.getShiftMiddleRule().getMiddlepoint();
            if (RefDateType.NEXTDAY == this.firstDateShift.getShiftMiddleRule().getMiddleRefDate()) {
                middlepoint += 86400;
            }
            return middlepoint;
        }
        return 18;
    }

    private int getLastSecond() {
        if (this.lastDateShift != null) {
            int lastShiftEndDate = this.lastDateShift.getLastShiftEndDate();
            if (RefDateType.NEXTDAY == this.firstDateShift.getShiftMiddleRule().getMiddleRefDate()) {
                lastShiftEndDate += 86400;
            }
            return lastShiftEndDate;
        }
        return 12;
    }

    private int getFirstSecond() {
        if (this.firstDateShift != null) {
            int lastShiftStartDate = this.firstDateShift.getLastShiftStartDate();
            return lastShiftStartDate;
        }
        return 0;
    }

    private Date getRelativeTime4Start(Date date, String dateMethod) {
        if (HRStringUtils.equals((String)dateMethod, (String)"3")) {
            return date;
        }
        if (HRStringUtils.equals((String)dateMethod, (String)"0")) {
            return DateUtils.addSeconds((Date)date, (int)this.getFirstSecond());
        }
        if (HRStringUtils.equals((String)dateMethod, (String)"1")) {
            return DateUtils.addSeconds((Date)date, (int)this.getMiddleSecond());
        }
        return DateUtils.addSeconds((Date)date, (int)this.getFirstSecond());
    }

    protected boolean checkStartNotBefore(Date startDate, String startMethod, Date newStart, String newStartMethod) {
        Date newstart;
        Date oldstart = this.getRelativeTime4Start(startDate, startMethod);
        return oldstart.compareTo(newstart = this.getRelativeTime4Start(newStart, newStartMethod)) > 0;
    }

    public BillResponse checkFrozenScope() {
        Map storageMap;
        Map dateDateMap;
        boolean checkFrozen;
        if (!this.init) {
            return BillResponse.success();
        }
        long billTypeId = BillTypeConstants.VOCATION_ID;
        if (ApplyBillCheckEnum.BUSTRIP == this.getCheckEnum() || ApplyBillCheckEnum.BUSTRIPFORM == this.getCheckEnum()) {
            billTypeId = BillTypeConstants.TRAVEL_ID;
        }
        if (!(checkFrozen = WTTESystemParamQueryUtil.getBillTypeSystemParam((long)billTypeId))) {
            LOG.info("\u7ecf\u8fc7\u7cfb\u7edf\u53c2\u6570\u5224\u5b9a\uff0c\u4e0d\u9700\u8981\u6821\u9a8c\u51bb\u7ed3.");
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        ArrayList<Long> attfileBos = new ArrayList<Long>(4);
        attfileBos.add(this.attfileBo);
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        Date ownDate = this.dyObject.getDate(this.checkEnum.getOwndate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        Date startOwn = startDate;
        Date endOwn = endDate;
        if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)this.dyObject.getString(this.checkEnum.getStartMethod()))) {
            startOwn = ownDate;
            endOwn = ownDate;
        }
        Map map = dateDateMap = (storageMap = (Map)WTCServiceHelper.invokeWtcWtpBizService("IAttStateInfoService", "queryFrozenScopeByFileBoId", attfileBos)) != null ? (Map)storageMap.get(this.attfileBo) : null;
        if (dateDateMap != null) {
            Set entries = dateDateMap.entrySet();
            for (Map.Entry item : entries) {
                Date end;
                Date start = (Date)item.getKey();
                if (!BillEntityCheckService.legalIf(start, end = (Date)item.getValue(), startOwn, endOwn)) continue;
                String sFormat = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)start);
                String eFormat = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)end);
                String failMsg = String.format(ResManager.loadKDString((String)"\u6b64\u63d0\u5355\u65e5\u671f\u5df2\u51bb\u7ed3\uff0c\u5728 %1$s\u81f3%2$s \u5185\u4e0d\u53ef\u7533\u8bf7%3$s\u5355\u3002", (String)"BillCommonCheckHelper_26", (String)"wtc-wtbs-business", (Object[])new Object[0]), sFormat, eFormat, this.unifyBillEnum.getDescriptionStr());
                msg.add(failMsg);
                success = false;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    private static boolean legalIf(Date aBegin, Date aEnd, Date bBegin, Date bEnd) {
        if (aBegin == null || aEnd == null || bBegin == null || bEnd == null) {
            return false;
        }
        return !aEnd.before(bBegin) && !aBegin.after(bEnd);
    }

    public BillResponse checkAttfileBoBsed() {
        Date firstBsed;
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        if (!this.init || startDate == null) {
            return BillResponse.success();
        }
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties(AttFileQueryParam.baseProperties);
        attFileQueryParam.setBoId(this.attfileBo.longValue());
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        List<DynamicObject> dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFiles((AttFileQueryParam)attFileQueryParam);
        if (!CollectionUtils.isEmpty(dynamicObjects) && startDate.compareTo(firstBsed = dynamicObjects.get(0).getDate("firstbsed")) < 0) {
            Date firstBSedDate = HRDateTimeUtils.addDay((Date)firstBsed, (long)-1L);
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u8d85\u51fa\u6240\u9009\u6863\u6848\u7248\u672c\u7684\u65f6\u95f4\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BillCommonCheckHelper_27", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)(endDate != null && endDate.before(firstBSedDate) ? endDate : firstBSedDate)));
            msg.add(errorMsg);
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public BillResponse checkEverDayHasRule() {
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> ruleDy = this.billAutoOperator.getRuleCalDy(this.attfileBo, startDate, endDate, type);
        if (ruleDy.containsValue(null)) {
            Date endNonRuleDay;
            List<Date> nonRuleDayList = BillEntityCheckService.getNonRuleDays(ruleDy);
            Date startNonRuleDay = nonRuleDayList.get(0);
            if (startNonRuleDay.compareTo(endNonRuleDay = nonRuleDayList.get(nonRuleDayList.size() - 1)) == 0) {
                String failMsg = String.format(ResManager.loadKDString((String)"%1$s\u672a\u8bbe\u7f6e%2$s\u89c4\u5219\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_28", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNonRuleDay), this.unifyBillEnum.getDescriptionStr());
                msg.add(failMsg);
            } else {
                String failMsg = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u672a\u8bbe\u7f6e%3$s\u89c4\u5219\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_29", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startNonRuleDay), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endNonRuleDay), this.unifyBillEnum.getDescriptionStr());
                msg.add(failMsg);
            }
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    private static List<Date> getNonRuleDays(Map<Date, DynamicObject> ruleDy) {
        ArrayList<Date> list = new ArrayList<Date>();
        for (Map.Entry<Date, DynamicObject> next : ruleDy.entrySet()) {
            if (!Objects.isNull(next.getValue())) continue;
            list.add(next.getKey());
        }
        return list;
    }

    public BillResponse checkRoster() {
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date ownDate = null;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        ownDate = BillEntityCheckService.getDate(ownDate);
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDate = this.billAutoOperator.getDutyDate(this.attfileBo, startDate, endDate);
        List dateList = (List)dutyDate.item1;
        ApplyBillDutyDateErrorEnum errorEnum = (ApplyBillDutyDateErrorEnum)dutyDate.item2;
        if (errorEnum != null) {
            this.getErrorMsg(errorEnum, msg, startDate, endDate);
            success = false;
        } else {
            if (CollectionUtils.isEmpty((Collection)dateList)) {
                String failMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u95f4\u4e0d\u5728\u73ed\u6b21\u6709\u6548\u8303\u56f4\u5185\u3002", (String)"BillEntityCheckService_4", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate)});
                msg.add(failMsg);
                return BillResponse.error(null, msg);
            }
            ownDate = (Date)dateList.get(0);
            Map<Date, Shift> shiftMap = this.billAutoOperator.getShift(this.attfileBo, startDate, endDate);
            List collect = shiftMap.entrySet().stream().map(dateShiftEntry -> (Date)dateShiftEntry.getKey()).sorted().collect(Collectors.toList());
            Date startOwnDate = (Date)collect.get(0);
            Date endOwnDate = (Date)collect.get(collect.size() - 1);
            if (Objects.isNull(shiftMap.get(startOwnDate)) || Objects.isNull(shiftMap.get(endOwnDate))) {
                if (Objects.isNull(shiftMap.get(startOwnDate)) && Objects.isNull(shiftMap.get(endOwnDate))) {
                    String failMsg = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s\u672a\u8bbe\u7f6e\u6392\u73ed\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_32", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startOwnDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endOwnDate));
                    msg.add(failMsg);
                } else if (Objects.isNull(shiftMap.get(startOwnDate))) {
                    String failMsg = ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u6392\u73ed\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_30", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startOwnDate)});
                    msg.add(failMsg);
                } else {
                    String failMsg = ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u6392\u73ed\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_30", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endOwnDate)});
                    msg.add(failMsg);
                }
                success = false;
            }
        }
        LOG.info("checkRoster end, success:{}, msg:{}, errorEnum", new Object[]{success, msg, errorEnum});
        if (!success) {
            return BillResponse.error(null, msg);
        }
        this.dyObject.set(this.checkEnum.getOwndate(), (Object)ownDate);
        return BillResponse.success((Object)ownDate);
    }

    private void getErrorMsg(ApplyBillDutyDateErrorEnum errorEnum, List<String> msg, Date startDate, Date endDate) {
        String failMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u6392\u73ed\u5f52\u5c5e\u65e5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillCommonCheckHelper_38", (String)"wtc-wtbs-business", (Object[])new Object[]{WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)startDate)});
        if (ApplyBillDutyDateErrorEnum.NOSHIFT == errorEnum) {
            failMsg = ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u95f4\u4e0d\u5728\u73ed\u6b21\u6709\u6548\u8303\u56f4\u5185\u3002", (String)"BillCommonCheckHelper_40", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        } else if (ApplyBillDutyDateErrorEnum.CROSSSHIFT == errorEnum) {
            failMsg = ResManager.loadKDString((String)"\u6309\u65f6\u5206\u7533\u8bf7\u4e0d\u5141\u8bb8\u8de8\u73ed\u6b21\u63d0%s\u5355\u3002", (String)"BillEntityCheckService_2", (String)"wtc-wtbs-business", (Object[])new Object[]{this.unifyBillEnum.getDescriptionStr()});
        } else if (ApplyBillDutyDateErrorEnum.OVER_24 == errorEnum) {
            failMsg = ResManager.loadKDString((String)"\u6309\u65f6\u5206\u7533\u8bf7\u65f6\u957f\u4e0d\u80fd\u8d85\u8fc724\u5c0f\u65f6\u3002", (String)"BillEntityCheckService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        }
        msg.add(failMsg);
    }

    public BillResponse checkAttfileHisAuth() {
        Set hisSet;
        if (!this.init) {
            return BillResponse.success();
        }
        if (this.needCheckAttFileAuth.booleanValue()) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BillEntityCheckService.getDate(startDate);
        endDate = BillEntityCheckService.getDate(endDate);
        if (startDate == null || endDate == null) {
            return BillResponse.success();
        }
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setProperties(AttFileQueryParam.baseProperties + "," + "empgroup.id" + "," + "org.id" + "," + "affiliateadminorg.id");
        attFileQueryParam.setBoId(this.attfileBo.longValue());
        attFileQueryParam.setStartDate(startDate);
        attFileQueryParam.setEndDate(endDate);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        List<DynamicObject> dynamicObjects = AttFileQueryServiceImpl.getInstance().queryAttFiles((AttFileQueryParam)attFileQueryParam);
        if (BillCommonService.billAuthCheckIsStrict()) {
            attFileQueryParam.setOrgAuthCheck(true);
            attFileQueryParam.setAppId(this.billApplyAttr.getAttFileF7AuthAppId());
            attFileQueryParam.setFormId(this.billApplyAttr.getAttFileF7AuthEntity());
            attFileQueryParam.setPermField("attfilebasef7");
        } else {
            attFileQueryParam.setOrgAuthCheck(false);
        }
        AttFileQueryServiceImpl attfileQUeryService = AttFileQueryServiceImpl.getInstance();
        List<DynamicObject> authVersions = attfileQUeryService.queryAttFilesByCustomAuth(attFileQueryParam);
        if (!CollectionUtils.isEmpty(dynamicObjects) && (hisSet = authVersions.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet())).size() != dynamicObjects.size()) {
            for (DynamicObject dy2 : dynamicObjects) {
                if (hisSet.contains(dy2.getLong("id"))) continue;
                Date bsed = dy2.getDate("bsed");
                Date bsled = dy2.getDate("bsled");
                Date maxStartDate = startDate.compareTo(bsed) > 0 ? startDate : bsed;
                Date minEndDate = endDate.compareTo(bsled) > 0 ? bsled : endDate;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s\u81f3%2$s\u4e4b\u95f4\u7684\u6863\u6848\u6743\u9650\uff0c\u65e0\u6cd5\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_33", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)maxStartDate), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)minEndDate));
                msg.add(errorMsg);
                success = false;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    public Set<Long> getEnumTypeIdSet(Long attfileBo, final UnifyBillEnum applyBillInfoEnum, String appId) {
        UnifyBillApplyInitInfo info = new UnifyBillApplyInitInfo((Object)0L, attfileBo.longValue(), Collections.emptyList());
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        attr.setAttFileF7AuthAppId(appId);
        attr.setAttFileF7AuthEntity(this.attFileF7AuthEntity);
        attr.setAttFileAuthField("attfilebasef7");
        UnifyBillInfoContext billInfoContext = new UnifyBillInfoContext((List)Lists.newArrayList((Object[])new UnifyBillApplyInitInfo[]{info}), attr);
        List<DynamicObject> allType = new WtcAbstractUnityBillAutoOperator(billInfoContext){

            @Override
            public UnifyBillEnum getUnifyBillEnum() {
                return applyBillInfoEnum;
            }
        }.getAllType(attfileBo);
        return allType.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }

    public Set<Long> getEnumTypeIdSet(Long attfileBo, UnifyBillEnum applyBillInfoEnum) {
        return this.getEnumTypeIdSet(attfileBo, applyBillInfoEnum, "wtam");
    }

    public static Map<Long, Long> getTypeRegulation(Long attfileBo, UnifyBillEnum applyBillInfoEnum) {
        Map<Long, List<DynamicObject>> longListMap = WTCAttFileService.queryAttFilePlan(applyBillInfoEnum.getAttFileScheduleEnum(), new Date(), new Date(), Collections.singletonList(attfileBo));
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        if (!longListMap.containsKey(attfileBo)) {
            return resultMap;
        }
        List<Object> dynamicObjects = longListMap.get(attfileBo);
        if (!CollectionUtils.isEmpty(dynamicObjects = dynamicObjects.stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            DynamicObject ruleDy = dynamicObject.getDynamicObject(applyBillInfoEnum.getUnifyPlanEnum().getFieldRuleInPlan());
            DynamicObjectCollection entryEntity = ruleDy.getDynamicObjectCollection(applyBillInfoEnum.getUnifyPlanEnum().getRuleEnum().getCalEntry());
            UnifyRuleCalEntryEnum unifyRuleCalEntryEnum = applyBillInfoEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum();
            for (DynamicObject entryRow : entryEntity) {
                DynamicObject type = entryRow.getDynamicObject(unifyRuleCalEntryEnum.getType());
                DynamicObject regulation = entryRow.getDynamicObject(unifyRuleCalEntryEnum.getAttPolicy());
                if (!Objects.nonNull(regulation)) continue;
                resultMap.put((Long)type.getPkValue(), (Long)regulation.getPkValue());
            }
        }
        return resultMap;
    }

    @Deprecated
    public <T extends BillEntryEntityVo> BillResponse checkStagingBillRepeat(List<T> entryEntityVos, T entryEntityVo) {
        return BillResponse.success();
    }

    private BillResponse getMiddleDate(long fileBoId, Date ownDate) {
        List<Long> appFileBoIds = Collections.singletonList(fileBoId);
        DutyShiftResponse shiftResponse = ApplyUtil.getShift(appFileBoIds, ownDate, ownDate);
        Shift shift = shiftResponse.getCurrShiftHis(Long.valueOf(fileBoId), ownDate).orElse(null);
        boolean offNonPlan = shift.getOffNonPlan();
        boolean isOff = shift.isOff();
        if (isOff && offNonPlan) {
            return BillResponse.error(null, null);
        }
        ShiftMiddleRule shiftMiddleRule = shift.getShiftMiddleRule();
        int middlepoint = shiftMiddleRule.getMiddlepoint();
        Date middleDate = WTCDateUtils.getDate((Date)ownDate, (Integer)middlepoint);
        RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
        if (RefDateType.NEXTDAY == middleRefDate) {
            middleDate = WTCDateUtils.addDays((Date)middleDate, (int)1);
        }
        return BillResponse.success((Object)middleDate);
    }

    public ApplyBillCheckEnum getCheckEnum() {
        return this.checkEnum;
    }

    public WtcAbstractUnityBillAutoOperator getBillAutoOperator() {
        return this.billAutoOperator;
    }

    public Long getAttfileBo() {
        return this.attfileBo;
    }

    public DynamicObject getDyObject() {
        return this.dyObject;
    }

    public UnifyBillEnum getUnifyBillEnum() {
        return this.unifyBillEnum;
    }

    public boolean isInit() {
        return this.init;
    }

    public boolean getUseStartOrEnd() {
        return this.billAutoOperator.isUseStartOrEnd();
    }

    protected void setBillAutoOperator(WtcAbstractUnityBillAutoOperator billAutoOperator) {
        this.billAutoOperator = billAutoOperator;
    }

    protected void setAttfileBo(Long attfileBo) {
        this.attfileBo = attfileBo;
    }

    protected void setDyObject(DynamicObject dyObject) {
        this.dyObject = dyObject;
    }

    protected void setCheckEnum(ApplyBillCheckEnum checkEnum) {
        this.checkEnum = checkEnum;
    }

    protected void setUnifyBillEnum(UnifyBillEnum unifyBillEnum) {
        this.unifyBillEnum = unifyBillEnum;
    }

    public List<Tuple<DutyShift, Shift>> getDutyShiftsRange() {
        Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
        return this.billAutoOperator.getDutyShiftsRange(this.attfileBo, startDate, endDate);
    }

    @Deprecated
    public Date getUseVersionDate() {
        String startMethod = this.dyObject.getString(this.checkEnum.getStartMethod());
        if (StringUtils.equalsAny((CharSequence)startMethod, (CharSequence[])new CharSequence[]{"0", "1", "2"})) {
            if (this.billAutoOperator.isUseStartOrEnd()) {
                return this.dyObject.getDate(this.checkEnum.getStartDate());
            }
            return this.dyObject.getDate(this.checkEnum.getEndDate());
        }
        return this.dyObject.getDate(this.checkEnum.getOwndate());
    }

    public static boolean getCheckStartOrEnd() {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        String billcheckrule = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"billcheckrule");
        return StringUtils.equals((CharSequence)"0", (CharSequence)billcheckrule);
    }

    protected static Date getDate(Date date) {
        Date resultDate = null;
        if (date != null) {
            resultDate = new Date(date.getTime());
        }
        return resultDate;
    }

    private boolean checkBillAllEfficacy(DynamicObject billDy) {
        BillQueryEnum billQueryEnum = BillQueryEnum.getWithUnifyBillEnum((UnifyBillEnum)this.getUnifyBillEnum());
        if (billQueryEnum == null) {
            return false;
        }
        String isChangeFieldName = billQueryEnum.getIsChange();
        String isLoseEfficacy = billQueryEnum.getIsNotTrip();
        boolean isChange = billDy.containsProperty(isChangeFieldName) && billDy.get(isChangeFieldName) instanceof Boolean && billDy.getBoolean(isChangeFieldName);
        boolean isNotTrip = billDy.containsProperty(isLoseEfficacy) && billDy.get(isLoseEfficacy) instanceof Boolean && billDy.getBoolean(isLoseEfficacy);
        return isChange && isNotTrip;
    }
}

