/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.common.bill.BillPermQueryParam;
import kd.wtc.wtbs.common.bill.BillQueryEnum;
import kd.wtc.wtbs.common.bill.BillQueryParam;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public abstract class BillUnifyQueryService {
    private static final Log LOG = LogFactory.getLog(BillUnifyQueryService.class);
    private static final Set<String> DATASTATUS_EFF_SET = Sets.newHashSetWithExpectedSize((int)3);
    private BillQueryEnum billQueryEnum;
    protected QFilter qFilter;
    protected DynamicObject[] result;

    public BillUnifyQueryService(BillQueryEnum billQueryEnum, BillQueryParam billQueryParam) {
        this.billQueryEnum = billQueryEnum;
        this.assembleQFilter(billQueryParam);
    }

    protected void defaultQuery(BillQueryParam param, HRBaseServiceHelper service) {
        String properties = param.getProperties();
        String orderBy = param.getOrderBy();
        this.result = HRStringUtils.isNotEmpty((String)properties) ? (param.isQueryOriginal() ? service.queryOriginalArray(properties, new QFilter[]{this.qFilter}, orderBy) : service.query(properties, new QFilter[]{this.qFilter}, orderBy)) : service.loadDynamicObjectArray(new QFilter[]{this.qFilter});
    }

    private void assembleQFilter(BillQueryParam billQueryParam) {
        QFilter qFilter = new QFilter("id", "!=", (Object)0L);
        this.assembleQFilterOfLong(qFilter, billQueryParam.getOrgIdSet(), "org");
        this.assembleQFilterOfLong(qFilter, billQueryParam.getAttFileBoIdSet(), "attfile");
        this.assembleQFilterOfLong(qFilter, billQueryParam.getPersonIdSet(), "personid");
        this.assembleQFilterOfLong(qFilter, billQueryParam.getAttFileVId(), "attfilebasef7");
        this.assembleQFilterOfPerm(qFilter, billQueryParam.getBillPermQueryParam());
        this.assembleQFilterOfString(qFilter, billQueryParam.getBillNoSet(), "billno");
        this.assembleQFilterOfBusiness(qFilter, billQueryParam);
        Set billStatusSet = billQueryParam.getBillStatusSet();
        if (billStatusSet == null || billStatusSet.isEmpty()) {
            qFilter.and(new QFilter("billstatus", "in", DATASTATUS_EFF_SET));
        } else {
            qFilter.and(new QFilter("billstatus", "in", (Object)billStatusSet));
        }
        this.assembleQFilterOfDate(qFilter, billQueryParam);
        QFilter qFilter1 = billQueryParam.getqFilter();
        if (qFilter1 != null) {
            qFilter.and(qFilter1);
        }
        this.qFilter = qFilter;
    }

    private void assembleQFilterOfDate(QFilter qFilter, BillQueryParam billQueryParam) {
        Date startDate = billQueryParam.getStartDate();
        Date endDate = billQueryParam.getEndDate();
        if (BillQueryEnum.AD == this.billQueryEnum) {
            String signDate = this.billQueryEnum.getsDate();
            if (startDate != null) {
                qFilter.and(new QFilter(signDate, ">=", (Object)startDate));
            } else if (endDate != null) {
                qFilter.and(new QFilter(signDate, "<=", (Object)endDate));
            }
            return;
        }
        String startDateKey = this.billQueryEnum.getsDate();
        String endDateKey = this.billQueryEnum.geteDate();
        if (HRStringUtils.isEmpty((String)startDateKey) || HRStringUtils.isEmpty((String)endDateKey)) {
            return;
        }
        if (startDate != null && endDate != null) {
            qFilter.and(new QFilter(startDateKey, "<=", (Object)endDate)).and(new QFilter(endDateKey, ">=", (Object)startDate));
            if (BillQueryEnum.TP == this.billQueryEnum) {
                QFilter entryFilter = new QFilter("entryentity.startdate", "<=", (Object)endDate).and("entryentity.enddate", ">=", (Object)startDate);
                qFilter.and(entryFilter);
            } else if (BillQueryEnum.OT == this.billQueryEnum) {
                QFilter entryFilter = new QFilter("scentry.otdstarttime", "<=", (Object)endDate).and("scentry.otdendtime", ">=", (Object)startDate);
                QFilter entryFilter2 = new QFilter("sdentry.otstartdate", "<=", (Object)endDate).and("sdentry.otenddate", ">=", (Object)startDate);
                qFilter.and(entryFilter.or(entryFilter2));
            } else if (BillQueryEnum.VA == this.billQueryEnum) {
                QFilter entryFilter = new QFilter("entryentity.entrystartdate", "<=", (Object)endDate).and("entryentity.entryenddate", ">=", (Object)startDate);
                qFilter.and(entryFilter);
            }
        }
    }

    private void assembleQFilterOfBusiness(QFilter qFilter, BillQueryParam billQueryParam) {
        Boolean applyType;
        ArrayList<String> applyTypeVal = billQueryParam.getApplyTypeVal();
        if (applyTypeVal == null) {
            applyTypeVal = new ArrayList<String>(10);
        }
        if ((applyType = billQueryParam.getApplyType()) != null) {
            if (!applyType.booleanValue()) {
                applyTypeVal.add(BillApplyTypeEnum.SELF.getCode());
            } else {
                applyTypeVal.add(BillApplyTypeEnum.OTHER.getCode());
            }
        }
        if (WTCCollections.isNotEmpty(applyTypeVal)) {
            qFilter.and("applytyperadio", "in", applyTypeVal);
        }
        Boolean change = billQueryParam.getChange();
        String isChangeKey = this.billQueryEnum.getIsChange();
        if (change != null && HRStringUtils.isNotEmpty((String)isChangeKey)) {
            qFilter.and(isChangeKey, "=", (Object)change);
        }
        Boolean newBill = billQueryParam.getNewBill();
        String newBillKey = this.billQueryEnum.getIsNewBill();
        if (newBill != null && HRStringUtils.isNotEmpty((String)newBillKey)) {
            if (BillQueryEnum.VA == this.billQueryEnum) {
                qFilter.and(newBillKey, "=", (Object)(newBill == false ? 1 : 0));
            } else {
                qFilter.and(newBillKey, "=", (Object)newBill);
            }
        }
        Boolean invalid = billQueryParam.getInvalid();
        String invalidKey = this.billQueryEnum.getIsNotTrip();
        if (invalid != null && HRStringUtils.isNotEmpty((String)invalidKey)) {
            qFilter.and(invalidKey, "=", (Object)invalid);
        }
    }

    private void assembleQFilterOfString(QFilter qFilter, Set<String> set, String key) {
        if (set != null && !set.isEmpty()) {
            qFilter.and(new QFilter(key, "in", set));
        }
    }

    private void assembleQFilterOfLong(QFilter qFilter, Set<Long> set, String key) {
        if (set != null && !set.isEmpty()) {
            qFilter.and(new QFilter(key, "in", set));
        }
    }

    private void assembleQFilterOfPerm(QFilter qFilter, BillPermQueryParam billPermQueryParam) {
        if (billPermQueryParam != null) {
            String entityNum = billPermQueryParam.getEntityNumber();
            if (HRStringUtils.equals((String)billPermQueryParam.getEntityNumber(), (String)"wtpm_supsignpcqueryconf")) {
                entityNum = "wtpm_supsignpc";
            }
            String appNumber = billPermQueryParam.getAppNumber();
            BillCommonService commonService = new BillCommonService();
            QFilter billPermQFilter = commonService.getBillPermQFilter(billPermQueryParam.getUserId(), appNumber, entityNum, billPermQueryParam.getOrgKey(), billPermQueryParam.getPerm(), billPermQueryParam.getCustomParam());
            if (billPermQFilter != null) {
                qFilter.and(billPermQFilter);
            }
        }
    }

    static {
        DATASTATUS_EFF_SET.add("B");
        DATASTATUS_EFF_SET.add("C");
        DATASTATUS_EFF_SET.add("D");
    }
}

