/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.IDateRangeService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.extend.WtcAbstractUnityBillAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillCheckService;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.business.web.applybill.service.BustripEntityCheckService;
import kd.wtc.wtbs.business.web.billservice.baseset.BillBaseStateLessService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterFieldEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceAdvAfterResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceBaseNewSetInfo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtam.common.busitrip.BusiTripKDString;

public class BustripBillCheckService
extends BillCheckService {
    private IDateRangeService dateRangeService = new DateRangeServiceImpl();
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtam_busitripbill");
    private static final Log LOG = LogFactory.getLog(BustripBillCheckService.class);

    @Deprecated
    public BustripBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, String attFileF7AuthEntity) {
        super(checkEnum, unifyBillEnum, dyList, attFileF7AuthEntity);
    }

    @Deprecated
    public BustripBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, DynamicObject dynamicObject, String attFileF7AuthEntity) {
        super(checkEnum, unifyBillEnum, dynamicObject, attFileF7AuthEntity);
    }

    public BustripBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, DynamicObject dynamicObject, String attFileF7AuthEntity, String appId) {
        super(checkEnum, unifyBillEnum, Collections.singletonList(dynamicObject), null, new UnifyBillApplyAttr(appId, attFileF7AuthEntity));
    }

    public BustripBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, List<DynamicObject> dyList, UnifyBillApplyAttr applyAttr) {
        super(checkEnum, unifyBillEnum, dyList, null, applyAttr);
    }

    public BustripBillCheckService(ApplyBillCheckEnum checkEnum, UnifyBillEnum unifyBillEnum, DynamicObject dynamicObject, WtcAbstractUnityBillOperator operator, UnifyBillApplyAttr applyAttr) {
        super(checkEnum, unifyBillEnum, Collections.singletonList(dynamicObject), operator, applyAttr);
    }

    @Override
    public IDateRangeService getDateRangeService() {
        return this.dateRangeService;
    }

    @Override
    public HRBaseServiceHelper getBaseServiceHelper() {
        return this.serviceHelper;
    }

    @Override
    protected WtcAbstractUnityBillAutoOperator initContext(List<DynamicObject> dyList, UnifyBillApplyAttr applyAttr) {
        List<UnifyBillApplyInitInfo> unifyBillApplyInfo = BustripBillCheckService.createUnifyBillApplyInfo(dyList, this.getCheckEnum());
        UnifyBillInfoContext unifyBillInfoContext = new UnifyBillInfoContext(unifyBillApplyInfo, applyAttr);
        return new WtcAbstractUnityBillAutoOperator(unifyBillInfoContext){

            @Override
            public UnifyBillEnum getUnifyBillEnum() {
                return UnifyBillEnum.TP;
            }
        };
    }

    public WtcAbstractUnityBillOperator getTpOperator() {
        return this.getCheck();
    }

    @Override
    public BillResponse checkMustInput() {
        for (DynamicObject dynamicObject : this.getDyList()) {
            long attFile = dynamicObject.getLong("attfile.id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < entryEntity.size(); ++index) {
                DynamicObject toolDy;
                String errorMsg;
                String desc;
                DynamicObject entry = (DynamicObject)entryEntity.get(index);
                BillEntityCheckService entityCheckService = this.getBillEntityCheckService((Long)attFile, UnifyBillEnum.TP, this.getCheckEnum(), entry, this.getAttFileF7AuthEntity());
                List<String> mustInputList = entityCheckService.getMustInput();
                DynamicObject typeDy = entry.getDynamicObject("busitriptype");
                String typeName = typeDy.getString("name");
                if (mustInputList.contains("isreasonrequired") && HRStringUtils.isEmpty((String)(desc = entry.getString("tripresontex")))) {
                    errorMsg = BusiTripKDString.reason((String)typeName);
                    return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{this.getMsg(entryEntity.size(), index, errorMsg)}));
                }
                if (mustInputList.contains("isvehicle") && HRObjectUtils.isEmpty((Object)(toolDy = entry.getDynamicObject("traveltool")))) {
                    errorMsg = BusiTripKDString.tool((String)typeName);
                    return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{this.getMsg(entryEntity.size(), index, errorMsg)}));
                }
                if (!mustInputList.contains("isplace")) continue;
                DynamicObject from = entry.getDynamicObject("from");
                if (HRObjectUtils.isEmpty((Object)from)) {
                    errorMsg = BusiTripKDString.from((String)typeName);
                    return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{this.getMsg(entryEntity.size(), index, errorMsg)}));
                }
                DynamicObject to = entry.getDynamicObject("to");
                if (!HRObjectUtils.isEmpty((Object)to)) continue;
                String errorMsg2 = BusiTripKDString.to((String)typeName);
                return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{this.getMsg(entryEntity.size(), index, errorMsg2)}));
            }
        }
        return BillResponse.success();
    }

    @Override
    public BillResponse checkBillRepeat() {
        List billNoList = this.getDyList().stream().map(dy -> dy.getString("billno")).collect(Collectors.toList());
        long startTime = System.currentTimeMillis();
        LOG.info(ResManager.loadKDString((String)"\u5355\u636e\u91cd\u53e0\u6821\u9a8c\u5f00\u59cb\uff0c dysList:{}, startTime:{}", (String)"BillCommonCheckerService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), billNoList, (Object)startTime);
        LOG.info(ResManager.loadKDString((String)"\u5355\u636e\u91cd\u53e0\u6821\u9a8c\u7ed3\u675f\uff0cendTime:{}, usingTime:{}", (String)"BillCommonCheckerService_2", (String)"wtc-wtbs-business", (Object[])new Object[0]), (Object)System.currentTimeMillis(), (Object)(System.currentTimeMillis() - startTime));
        return BillResponse.success();
    }

    @Override
    protected void setCustomEntry(DynamicObject entry, BillApplyTimeResult timeResult) {
        entry.set("triptime", (Object)timeResult.getTimeByUnit());
        entry.set("efftctime", (Object)timeResult.getOtherTime());
        entry.set("unit", (Object)timeResult.getUnit());
        entry.set("strapplytime", (Object)timeResult.getDesc());
    }

    @Override
    protected BillEntityCheckService getBillEntityCheckService(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject entryPageDyn, String attFileF7AuthEntity) {
        WtcAbstractUnityBillOperator check = this.getCheck();
        if (check instanceof WtcAbstractUnityBillAutoOperator) {
            return new BustripEntityCheckService(attfileBo, unifyBillEnum, checkEnum, entryPageDyn, attFileF7AuthEntity, this.getBillApplyAttr().getAttFileF7AuthAppId(), check);
        }
        return new BustripEntityCheckService(attfileBo, unifyBillEnum, checkEnum, entryPageDyn, attFileF7AuthEntity, this.getBillApplyAttr().getAttFileF7AuthAppId());
    }

    @Override
    protected BillEntityCheckService getBillEntityCheckService(Long attfileBo, DynamicObject entryPageDyn, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, String attFileF7AuthEntity) {
        return new BustripEntityCheckService(attfileBo, unifyBillEnum, checkEnum, entryPageDyn, attFileF7AuthEntity, this.getBillApplyAttr().getAttFileF7AuthAppId());
    }

    private List<DynamicObject> queryHisBillForBustrip(DynamicObject billDyn, Date startDate, Date endDate, Date ownDate) {
        ArrayList<Long> excludeIds = new ArrayList<Long>(4);
        excludeIds.add(billDyn.getLong("id"));
        excludeIds.add(billDyn.getLong("parent"));
        long personId = billDyn.getLong("personid.id");
        QFilter qFilter = new QFilter("personid.id", "=", (Object)personId).and("billstatus", "in", (Object)STATUS_LIST).and("isnewbill", "=", (Object)Boolean.TRUE).and("isnottrip", "=", (Object)Boolean.FALSE).and("id", "not in", excludeIds);
        QFilter timeFilter = new QFilter("entryentity.startdate", "<=", (Object)endDate).and("entryentity.enddate", ">=", (Object)startDate);
        if (ownDate != null) {
            timeFilter.or("entryentity.owndate", "=", (Object)ownDate);
        }
        qFilter.and(timeFilter);
        QFilter[] qFilters = new QFilter[]{qFilter};
        HRBaseServiceHelper billServiceHelper = new HRBaseServiceHelper("wtam_busitripbill");
        DynamicObject[] bustripApplyBills = billServiceHelper.loadDynamicObjectArray(qFilters);
        return Arrays.asList(bustripApplyBills);
    }

    @Override
    public BillResponse checkHisBillRepeat(List<DynamicObject> dyList) {
        ApplyBillCheckEnum checkEnum = this.getCheckEnum();
        UnifyBillEnum unifyBillEnum = this.getUnifyBillEnum();
        for (DynamicObject billDyn : dyList) {
            long personId = billDyn.getLong("personid.id");
            DynamicObjectCollection dynamicObjectCollection = billDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : dynamicObjectCollection) {
                String emtityStartMethod = entity.getString(checkEnum.getStartMethod());
                Date ownDate = entity.getDate(checkEnum.getOwndate());
                Date startDate = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)emtityStartMethod) ? ownDate : entity.getDate(checkEnum.getStartDate());
                Date endDate = StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)emtityStartMethod) ? ownDate : entity.getDate(checkEnum.getEndDate());
                List<DynamicObject> hisBills = this.queryHisBillForBustrip(billDyn, startDate, endDate, ownDate);
                for (DynamicObject hisBill : hisBills) {
                    String billNo = hisBill.getString("billno");
                    DynamicObjectCollection hisBillentities = hisBill.getDynamicObjectCollection("entryentity");
                    hisBillentities.add(entity);
                    BillResponse billResponse = this.docheckRepeat((List<DynamicObject>)hisBillentities, personId);
                    if (billResponse.isSuccess()) continue;
                    String errMsg = String.format(ResManager.loadKDString((String)"\u4e0e\u73b0\u6709\u5355\u636e%1$s\u65f6\u6bb5\u91cd\u53e0\uff0c\u65e0\u6cd5\u7533\u8bf7\u8be5\u65f6\u6bb5%2$s\u3002", (String)"BillCommonCheckerService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]), billNo, unifyBillEnum.getDescriptionStr());
                    ArrayList<String> msgList = new ArrayList<String>(2);
                    msgList.add(errMsg);
                    return BillResponse.error(null, msgList);
                }
            }
        }
        return BillResponse.success();
    }

    @Override
    public BillResponse checkAll() {
        BillResponse billResponse = this.checkChangeBill();
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        return super.checkAll();
    }

    @Override
    public BillResponse checkAdviceAndAfter() {
        BillResponse response = super.checkAdviceAndAfter();
        if (response.isSuccess()) {
            response = this.maxAdvancePeroidCheck();
        }
        return response;
    }

    private BillResponse maxAdvancePeroidCheck() {
        ArrayList<BillServiceBaseNewSetInfo> baseSet = new ArrayList<BillServiceBaseNewSetInfo>(10);
        for (DynamicObject dynamicObject : this.getDyList()) {
            long attFileBoId = dynamicObject.getLong(this.getCheckEnum().getAttfile() + ".id");
            long personId = dynamicObject.getLong("personid.id");
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                BillEntityCheckService entityCheckService;
                DynamicObject baseSetDy;
                Date endDutyDate = new Date(entry.getDate(this.getCheckEnum().getEndDate()).getTime());
                Date startDutyDate = new Date(entry.getDate(this.getCheckEnum().getStartDate()).getTime());
                if (StringUtils.equals((CharSequence)WtcTimeRangeBtnTypeEnum.CUSTOM.value, (CharSequence)entry.getString(this.getCheckEnum().getStartMethod()))) {
                    endDutyDate = new Date(entry.getDate(this.getCheckEnum().getOwndate()).getTime());
                    startDutyDate = new Date(entry.getDate(this.getCheckEnum().getOwndate()).getTime());
                }
                if (endDutyDate.compareTo(WTCDateUtils.getDayBegin()) < 0 || (baseSetDy = (entityCheckService = this.getBillEntityCheckService((Long)attFileBoId, this.getUnifyBillEnum(), this.getCheckEnum(), entry, this.getBillApplyAttr().getAttFileF7AuthEntity())).getBaseSetDy()) == null) continue;
                BillServiceBaseNewSetInfo baseSetInfo = new BillServiceBaseNewSetInfo();
                baseSetInfo.setBaseSetDy(baseSetDy);
                baseSetInfo.setAttFileBoId(attFileBoId);
                baseSetInfo.setPersonId(personId);
                baseSetInfo.setCheckDates(WTCDateUtils.getLocalDateRange((Date)startDutyDate, (Date)endDutyDate));
                baseSet.add(baseSetInfo);
            }
        }
        if (baseSet.isEmpty()) {
            return BillResponse.success();
        }
        HashMap<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>> advanceAndAfterInfo = new HashMap<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>>(16);
        HashMap<BillAdvanceAfterFieldEnum, String> maxField = new HashMap<BillAdvanceAfterFieldEnum, String>(16);
        maxField.put(BillAdvanceAfterFieldEnum.UNIT, "lateadvanceunit");
        maxField.put(BillAdvanceAfterFieldEnum.OFFSET, "lateadvancenumber");
        maxField.put(BillAdvanceAfterFieldEnum.CTRL, "islateadvanceapple");
        advanceAndAfterInfo.put(BillAdvanceAfterEnum.MAX_ADVANCE, maxField);
        BillBaseStateLessService service = new BillBaseStateLessService();
        Map<BillAdvanceAfterEnum, List<BillServiceAdvAfterResp>> billServiceMaxAdvLimitResps = service.checkAdvanceAfter(baseSet, advanceAndAfterInfo);
        if (billServiceMaxAdvLimitResps == null) {
            return BillResponse.success();
        }
        List<BillServiceAdvAfterResp> resps = billServiceMaxAdvLimitResps.get(BillAdvanceAfterEnum.MAX_ADVANCE);
        if (resps == null) {
            return BillResponse.success();
        }
        for (int index = 0; index < billServiceMaxAdvLimitResps.size(); ++index) {
            BillServiceAdvAfterResp limitResp = resps.get(index);
            if (limitResp == null || limitResp.isPassCheck()) continue;
            String maxLimitUnit = limitResp.getLimitUnit();
            BillPeriodInfoResp billPeriodInfoResp = limitResp.getBillPeriodInfoResp();
            if (HRStringUtils.equals((String)maxLimitUnit, (String)BaseSetUnitTypeEnum.PERIOD.getCode()) && billPeriodInfoResp != null) {
                String adviceOrAfter = billPeriodInfoResp.getTipInfo();
                return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{this.getMsg(index, billServiceMaxAdvLimitResps.size(), adviceOrAfter)}));
            }
            Integer maxLimitNum = limitResp.getLimitNum();
            String info = BustripBillCheckService.buildUnitInfoByBaseSet(maxLimitNum, maxLimitUnit);
            String adviceOrAfter = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u53ea\u80fd\u63d0\u4ea4{0}\u5185\u7684\u7533\u8bf7\u3002", (String)"BustripEntityCheckService_2", (String)"wtc-wtbs-business", (Object[])new Object[]{info});
            return BillResponse.error(null, (List)Lists.newArrayList((Object[])new String[]{this.getMsg(index, billServiceMaxAdvLimitResps.size(), adviceOrAfter)}));
        }
        return BillResponse.success();
    }

    private static String buildUnitInfoByBaseSet(Integer failCheckAdvanceAfterNum, String failCheckAdvanceAfterUnit) {
        String info = "";
        if (BaseSetUnitTypeEnum.DAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u81ea\u7136\u65e5", (String)"BustripEntityCheckService_3", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.MONTH.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u6708", (String)"BustripEntityCheckService_4", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.PERIOD.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u8003\u52e4\u671f\u95f4", (String)"BustripEntityCheckService_5", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u5de5\u4f5c\u65e5", (String)"BustripEntityCheckService_6", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        }
        return info;
    }

    private BillResponse checkChangeBill() {
        List changeList = this.getDyList().stream().filter(dynamicObject -> dynamicObject.getBoolean("ischange")).collect(Collectors.toList());
        boolean success = true;
        List parentIds = changeList.stream().map(dy -> dy.getLong("parent")).collect(Collectors.toList());
        if (parentIds.isEmpty()) {
            return BillResponse.success();
        }
        DynamicObject[] parentDys = this.serviceHelper.queryOriginalArray("id,isnewbill,isnottrip", new QFilter[]{new QFilter("id", "in", parentIds)});
        Map parentDyMap = Arrays.stream(parentDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        ArrayList errMsgList = Lists.newArrayList();
        for (DynamicObject changeBillDy : changeList) {
            String errMsg;
            DynamicObject parentDy = (DynamicObject)parentDyMap.get(changeBillDy.getLong("parent"));
            if (parentDy == null || changeBillDy.getDataEntityState().getFromDatabase()) continue;
            if (!parentDy.getBoolean("isnewbill")) {
                errMsg = BusiTripKDString.validateIsNewBillTip();
                errMsgList.add(errMsg);
                success = false;
            }
            if (!parentDy.getBoolean("isnottrip")) continue;
            errMsg = BusiTripKDString.validateIsNoTripTip();
            errMsgList.add(errMsg);
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, (List)errMsgList);
        }
        return BillResponse.success();
    }
}

