/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.business.util.ShiftParseUtil;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.bill.batchbill.BatchBillKDString;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillSubEntryVo;
import kd.wtc.wtbs.common.model.bill.va.VaBillVo;
import kd.wtc.wtbs.common.model.bill.va.rpc.AttPersonVaBillReq;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.model.evaluation.ShiftMiddleRule;
import kd.wtc.wtbs.common.model.shift.RefDateType;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtte.common.enums.OutWorkType;

public class BustripBillPeriodService {
    protected static final Log LOG = LogFactory.getLog(BustripBillPeriodService.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected static final Set<String> STATUS_LIST = Sets.newHashSet((Object[])new String[]{"C", "B", "D"});
    private boolean isImport = false;
    private boolean isBatch = false;

    public BustripBillPeriodService() {
    }

    public BustripBillPeriodService(boolean isImport) {
        this.isImport = isImport;
    }

    private List<DynamicObject> getHisTpBill(List<AttPersonVaBillReq> attFileReq) {
        List partition = Lists.partition(attFileReq, (int)50000);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)attFileReq.size());
        for (List list : partition) {
            List<DynamicObject> subList = this.queryHisBill(list);
            if (subList == null || subList.isEmpty()) continue;
            resultList.addAll(subList);
        }
        return resultList;
    }

    private List<DynamicObject> queryHisBill(List<AttPersonVaBillReq> attFileReq) {
        HashSet<Long> excludeIdSet = new HashSet<Long>(attFileReq.size());
        HashSet<Long> personIdSet = new HashSet<Long>(attFileReq.size());
        Date minDate = null;
        Date maxDate = null;
        for (AttPersonVaBillReq vaBillsByAttFileBidReq : attFileReq) {
            Date startDate = vaBillsByAttFileBidReq.getStartDate();
            if (minDate == null || startDate != null && startDate.compareTo(minDate) < 0) {
                minDate = startDate;
            }
            Date endDate = vaBillsByAttFileBidReq.getEndDate();
            if (maxDate == null || endDate != null && endDate.compareTo(maxDate) > 0) {
                maxDate = endDate;
            }
            personIdSet.add(vaBillsByAttFileBidReq.getAttPersonId());
            if (vaBillsByAttFileBidReq.getId() == 0L) continue;
            excludeIdSet.add(vaBillsByAttFileBidReq.getId());
        }
        QFilter qFilter = new QFilter("personid", "in", personIdSet).and("edate", ">=", minDate).and("sdate", "<=", maxDate);
        QFilter status = new QFilter("billstatus", "in", STATUS_LIST);
        status.and("ischange", "=", (Object)Boolean.FALSE);
        if (!excludeIdSet.isEmpty()) {
            status.and("id", "not in", excludeIdSet);
        }
        HashSet statusSet = Sets.newHashSet((Object[])new String[]{"C", "D"});
        QFilter status2 = new QFilter("billstatus", "in", (Object)statusSet);
        status2.and("ischange", "=", (Object)Boolean.TRUE).and("isnottrip", "=", (Object)Boolean.FALSE);
        if (!excludeIdSet.isEmpty()) {
            status2.and("id", "not in", excludeIdSet);
        }
        status.or(status2);
        HRBaseServiceHelper billServiceHelper = new HRBaseServiceHelper("wtam_busitripbill");
        DynamicObject[] result = billServiceHelper.query("id,billno,isnottrip,attfile,personid,entryentity.startdate,entryentity.enddate,entryentity.startmethod,entryentity.endmethod,entryentity.owndate", new QFilter[]{status, qFilter}, " createtime asc ");
        if (result == null || result.length == 0) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return Arrays.asList(result);
    }

    private List<String> dealWithVa(List<VaBillVo> vaBillList, Map<String, Tuple<DutyShift, Shift>> tupleMap, List<BillEntryEntityVo> tpShiftList, List<BillEntryEntityVo> tpOffList) {
        ArrayList message = Lists.newArrayListWithExpectedSize((int)1);
        for (VaBillVo vo : vaBillList) {
            ArrayList vaShiftList = Lists.newArrayListWithExpectedSize((int)vaBillList.size());
            ArrayList vaOffList = Lists.newArrayListWithExpectedSize((int)vaBillList.size());
            this.buildPeriodTimeOfVa(Collections.singletonList(vo), vaShiftList, vaOffList, tupleMap);
            if (this.judgeOverlapOfOff(message, tpOffList, vaOffList)) {
                this.judgeOverlapOfShift(message, tpShiftList, vaShiftList);
            }
            if (message.isEmpty()) continue;
            return message;
        }
        return message;
    }

    private List<String> dealWithTpBillHis(List<DynamicObject> tpHisBillList, Map<String, Tuple<DutyShift, Shift>> tupleMap, List<BillEntryEntityVo> tpShiftList, List<BillEntryEntityVo> tpOffList) {
        ArrayList message = Lists.newArrayListWithExpectedSize((int)1);
        for (DynamicObject dy : tpHisBillList) {
            ArrayList tpShiftHisList = Lists.newArrayListWithExpectedSize((int)tpHisBillList.size());
            ArrayList tpOffHisList = Lists.newArrayListWithExpectedSize((int)tpHisBillList.size());
            DynamicObjectCollection entityCollHis = dy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryHis : entityCollHis) {
                BillEntryEntityVo billEntryEntityVo = new BillEntryEntityVo();
                billEntryEntityVo.setEndDate(entryHis.getDate("enddate"));
                billEntryEntityVo.setBillNo(dy.getString("billno"));
                billEntryEntityVo.setUnifyBillEnum(UnifyBillEnum.TP);
                billEntryEntityVo.setStartMethod(entryHis.getString("startmethod"));
                billEntryEntityVo.setStartDate(entryHis.getDate("startdate"));
                billEntryEntityVo.setEndMethod(entryHis.getString("endmethod"));
                billEntryEntityVo.setOwnDate(entryHis.getDate("owndate"));
                this.buildPeriodTimeEach(billEntryEntityVo, tpShiftHisList, tpOffHisList, tupleMap);
            }
            if (this.judgeOverlapOfOff(message, tpOffList, tpOffHisList)) {
                this.judgeOverlapOfShift(message, tpShiftList, tpShiftHisList);
            }
            if (message.isEmpty()) continue;
            return message;
        }
        return message;
    }

    private void buildPeriodTimeOfVa(List<VaBillVo> vaBillList, List<BillEntryEntityVo> vaShiftList, List<BillEntryEntityVo> vaOffList, Map<String, Tuple<DutyShift, Shift>> tupleMap) {
        for (VaBillVo vaBillVo : vaBillList) {
            List entryEntities = vaBillVo.getEntryEntities();
            if (entryEntities == null) continue;
            String billNo = vaBillVo.getBillNo();
            for (VaBillEntryEntityVo vaBillEntryEntityVo : entryEntities) {
                BillEntryEntityVo billEntryEntityVo = new BillEntryEntityVo();
                billEntryEntityVo.setEndDate(vaBillEntryEntityVo.getEndDate());
                billEntryEntityVo.setStartDate(vaBillEntryEntityVo.getStartDate());
                billEntryEntityVo.setStartMethod(vaBillEntryEntityVo.getStartMethod());
                billEntryEntityVo.setEndMethod(vaBillEntryEntityVo.getEndMethod());
                billEntryEntityVo.setOwnDate(vaBillEntryEntityVo.getOwnDate());
                billEntryEntityVo.setBillNo(billNo);
                billEntryEntityVo.setUnifyBillEnum(UnifyBillEnum.VA);
                billEntryEntityVo.setBatchBillDy(vaBillEntryEntityVo.getBatchBillDy());
                if (SpecialVaTypeEnum.LACTATION_TYPE.vaType.equals(vaBillEntryEntityVo.getSpecialVaType())) {
                    this.buildPeriodTimeOfSubVa(vaShiftList, vaBillEntryEntityVo, billNo);
                    continue;
                }
                this.buildPeriodTimeEach(billEntryEntityVo, vaShiftList, vaOffList, tupleMap);
            }
        }
    }

    private void buildPeriodTimeOfSubVa(List<BillEntryEntityVo> vaShiftList, VaBillEntryEntityVo vaBillEntryEntityVo, String billNo) {
        List vaSubEntryVoList = vaBillEntryEntityVo.getVaSubEntryVoList();
        if (vaSubEntryVoList != null) {
            for (VaBillSubEntryVo vo : vaSubEntryVoList) {
                BillEntryEntityVo vaSubVo = new BillEntryEntityVo();
                vaSubVo.setStartDate(vo.getStartDateTime());
                vaSubVo.setEndDate(vo.getEndDateTime());
                vaSubVo.setBillNo(billNo);
                vaSubVo.setUnifyBillEnum(UnifyBillEnum.VA);
                vaShiftList.add(vaSubVo);
            }
        }
    }

    public Map<Long, List<Tuple<DutyShift, Shift>>> checkTpBillRepeat(ExtendedDataEntity[] dataEntities, Map<Long, List<VaBillVo>> vaMap, Map<Long, List<DynamicObject>> tpMap) {
        Map<Long, List<DynamicObject>> tpMapInfo;
        HashSet set = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        Date minDate = null;
        Date maxDate = null;
        ArrayList attFileReq = Lists.newArrayListWithCapacity((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billDy = dataEntity.getDataEntity();
            AttPersonVaBillReq va = new AttPersonVaBillReq();
            DynamicObjectCollection entityColl = billDy.getDynamicObjectCollection("entryentity");
            Date startDate = null;
            Date endDate = null;
            for (DynamicObject entity : entityColl) {
                Date entityStartDate = entity.getDate("startdate");
                Date entityEndDate = entity.getDate("enddate");
                if (minDate == null || entityStartDate.compareTo(minDate) < 0) {
                    minDate = entityStartDate;
                }
                if (startDate == null || entityStartDate.compareTo(startDate) < 0) {
                    startDate = entityStartDate;
                }
                if (maxDate == null || entityEndDate.compareTo(maxDate) > 0) {
                    maxDate = entityEndDate;
                }
                if (endDate != null && entityEndDate.compareTo(endDate) <= 0) continue;
                endDate = entityEndDate;
            }
            long attFileBoId = billDy.getLong("attfile.id");
            set.add(attFileBoId);
            va.setAttPersonId(WTCDynamicObjectUtils.getBaseDataId(billDy, "personid"));
            va.setStartDate(WTCDateUtils.getDayBegin((Date)WTCDateUtils.addDays(startDate, (int)-1)));
            va.setEndDate(WTCDateUtils.getDayLastDate((Date)WTCDateUtils.addDays(endDate, (int)1)));
            va.setId(billDy.getLong("id"));
            va.setParentId(billDy.getLong("parent"));
            attFileReq.add(va);
        }
        ArrayList attFileBoIdList = Lists.newArrayListWithExpectedSize((int)set.size());
        attFileBoIdList.addAll(set);
        Map<Long, List<Tuple<DutyShift, Shift>>> shiftInfo = this.getShiftInfo(attFileBoIdList, minDate, maxDate);
        Map<Long, List<VaBillVo>> vaMapInfo = this.getVaMapInfo(attFileReq);
        if (vaMapInfo != null && !vaMapInfo.isEmpty()) {
            vaMap.putAll(vaMapInfo);
        }
        if ((tpMapInfo = this.getTpMapInfo(attFileReq)) != null && !tpMapInfo.isEmpty()) {
            tpMap.putAll(tpMapInfo);
        }
        return shiftInfo;
    }

    public List<String> checkAllOfRepeat(DynamicObject billDy, List<Tuple<DutyShift, Shift>> tuples, long attFileBoId, Map<Long, List<VaBillVo>> vaMap, Map<Long, List<DynamicObject>> tpMapInfo, Map<Long, List<DynamicObject>> attFileToBustripMap) {
        this.isBatch = false;
        DynamicObjectCollection entityColl = billDy.getDynamicObjectCollection("entryentity");
        List<String> errorList = this.checkRepeatOfBill(entityColl, tuples, attFileBoId);
        if (errorList != null && !errorList.isEmpty()) {
            return errorList;
        }
        errorList = this.checkRepeatWithVa(billDy, tuples, vaMap);
        if (errorList != null && !errorList.isEmpty()) {
            return errorList;
        }
        errorList = this.checkRepeatWithTp(billDy, tuples, tpMapInfo, attFileBoId);
        if (errorList != null && !errorList.isEmpty()) {
            return errorList;
        }
        this.isBatch = true;
        return this.checkRepeatWithBatch(billDy, tuples, attFileToBustripMap, attFileBoId);
    }

    private List<String> checkRepeatOfBill(DynamicObjectCollection entityColl, List<Tuple<DutyShift, Shift>> tuples, long attFileBoId) {
        if (entityColl.isEmpty() || entityColl.size() == 1) {
            return null;
        }
        int rowIndex = 1;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)entityColl.size());
        for (DynamicObject entity : entityColl) {
            BillResponse billResponse;
            BillEntryEntityVo curVo = new BillEntryEntityVo();
            curVo.setRowIndex(rowIndex);
            curVo.setRowCount(entityColl.size());
            curVo.setAttFileBoid(attFileBoId);
            curVo.setStartDate(entity.getDate("startdate"));
            curVo.setEndDate(entity.getDate("enddate"));
            curVo.setStartMethod(entity.getString("startmethod"));
            curVo.setEndMethod(entity.getString("endmethod"));
            if (!list.isEmpty() && !(billResponse = this.doCheck(list, tuples, curVo)).isSuccess()) {
                return billResponse.getMessage();
            }
            list.add(curVo);
            ++rowIndex;
        }
        return null;
    }

    private List<String> checkRepeatWithVa(DynamicObject billDy, List<Tuple<DutyShift, Shift>> tuples, Map<Long, List<VaBillVo>> vaMap) {
        if (vaMap == null) {
            return null;
        }
        List<VaBillVo> vaBillList = vaMap.get(WTCDynamicObjectUtils.getBaseDataId(billDy, "personid"));
        if (vaBillList == null || vaBillList.isEmpty() || billDy.getBoolean("isnottrip")) {
            return null;
        }
        Map<String, Tuple<DutyShift, Shift>> tupleMap = tuples.stream().collect(Collectors.toMap(tuple -> this.dateFormat.format(((DutyShift)tuple.item1).getRosterDate()), tuple -> tuple, (tuple1, tuple2) -> tuple1));
        DynamicObjectCollection entityColl = billDy.getDynamicObjectCollection("entryentity");
        ArrayList tpShiftList = Lists.newArrayListWithExpectedSize((int)entityColl.size());
        ArrayList tpOffList = Lists.newArrayListWithExpectedSize((int)entityColl.size());
        int rowIndex = 1;
        for (DynamicObject entry : entityColl) {
            BillEntryEntityVo billEntryEntityVo = new BillEntryEntityVo();
            billEntryEntityVo.setEndDate(entry.getDate("enddate"));
            billEntryEntityVo.setStartDate(entry.getDate("startdate"));
            billEntryEntityVo.setStartMethod(entry.getString("startmethod"));
            billEntryEntityVo.setEndMethod(entry.getString("endmethod"));
            billEntryEntityVo.setOwnDate(entry.getDate("owndate"));
            billEntryEntityVo.setRowCount(entityColl.size());
            billEntryEntityVo.setRowIndex(rowIndex);
            this.buildPeriodTimeEach(billEntryEntityVo, tpShiftList, tpOffList, tupleMap);
            ++rowIndex;
        }
        List<String> list = this.dealWithVa(vaBillList, tupleMap, tpShiftList, tpOffList);
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    private List<String> checkRepeatWithTp(DynamicObject billDy, List<Tuple<DutyShift, Shift>> tuples, Map<Long, List<DynamicObject>> tpMapInfo, long attFileBoId) {
        List<DynamicObject> tpHisBill = tpMapInfo.get(WTCDynamicObjectUtils.getBaseDataId(billDy, "personid"));
        if (tpHisBill == null || tpHisBill.isEmpty()) {
            return null;
        }
        List<DynamicObject> tpHisBillList = tpHisBill.stream().filter(hisDy -> Long.compare(billDy.getLong("parent"), hisDy.getLong("id")) != 0).collect(Collectors.toList());
        if (tpHisBillList == null || tpHisBillList.isEmpty()) {
            return null;
        }
        DynamicObjectCollection entityColl = billDy.getDynamicObjectCollection("entryentity");
        Map<String, Tuple<DutyShift, Shift>> tupleMap = tuples.stream().collect(Collectors.toMap(tuple -> this.dateFormat.format(((DutyShift)tuple.item1).getRosterDate()), tuple -> tuple, (tuple1, tuple2) -> tuple1));
        ArrayList tpShiftList = Lists.newArrayListWithExpectedSize((int)entityColl.size());
        ArrayList tpOffList = Lists.newArrayListWithExpectedSize((int)entityColl.size());
        int rowIndex = 1;
        for (DynamicObject entry : entityColl) {
            BillEntryEntityVo billEntryEntityVo = new BillEntryEntityVo();
            billEntryEntityVo.setEndDate(entry.getDate("enddate"));
            billEntryEntityVo.setStartDate(entry.getDate("startdate"));
            billEntryEntityVo.setStartMethod(entry.getString("startmethod"));
            billEntryEntityVo.setEndMethod(entry.getString("endmethod"));
            billEntryEntityVo.setRowCount(entityColl.size());
            billEntryEntityVo.setRowIndex(rowIndex);
            billEntryEntityVo.setOwnDate(entry.getDate("owndate"));
            this.buildPeriodTimeEach(billEntryEntityVo, tpShiftList, tpOffList, tupleMap);
            ++rowIndex;
        }
        return this.dealWithTpBillHis(tpHisBillList, tupleMap, tpShiftList, tpOffList);
    }

    private List<String> checkRepeatWithBatch(DynamicObject curBill, List<Tuple<DutyShift, Shift>> tuples, Map<Long, List<DynamicObject>> attFileToBustripMap, long attFileBoId) {
        List<DynamicObject> batchTpList = attFileToBustripMap.get(attFileBoId);
        Map<String, Tuple<DutyShift, Shift>> tupleMap = tuples.stream().collect(Collectors.toMap(tuple -> this.dateFormat.format(((DutyShift)tuple.item1).getRosterDate()), tuple -> tuple, (tuple1, tuple2) -> tuple1));
        DynamicObjectCollection curEntityColl = curBill.getDynamicObjectCollection("entryentity");
        ArrayList curShiftList = Lists.newArrayListWithExpectedSize((int)20);
        ArrayList curOffList = Lists.newArrayListWithExpectedSize((int)20);
        int rowIndex = 1;
        for (DynamicObject entry : curEntityColl) {
            BillEntryEntityVo curVo = new BillEntryEntityVo();
            curVo.setStartDate(entry.getDate("startdate"));
            curVo.setEndDate(entry.getDate("enddate"));
            curVo.setStartMethod(entry.getString("startmethod"));
            curVo.setEndMethod(entry.getString("endmethod"));
            curVo.setOwnDate(entry.getDate("owndate"));
            curVo.setRowIndex(rowIndex);
            curVo.setRowCount(curEntityColl.size());
            this.buildPeriodTimeEach(curVo, curShiftList, curOffList, tupleMap);
            ++rowIndex;
        }
        ArrayList shiftList = Lists.newArrayListWithExpectedSize((int)20);
        ArrayList offList = Lists.newArrayListWithExpectedSize((int)20);
        for (DynamicObject billDy : batchTpList) {
            long billAttFileBoId = billDy.getLong("attfile.id");
            if (billDy.getLong("id") == 0L || billAttFileBoId != attFileBoId || HRStringUtils.equals((String)curBill.getString("billno"), (String)billDy.getString("billno")) || billDy.getBoolean("isnottrip")) continue;
            DynamicObjectCollection entityColl = billDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entityColl) {
                BillEntryEntityVo billEntryEntityVo = new BillEntryEntityVo();
                billEntryEntityVo.setBillNo(billDy.getString("billno"));
                billEntryEntityVo.setStartMethod(entry.getString("startmethod"));
                billEntryEntityVo.setStartDate(entry.getDate("startdate"));
                billEntryEntityVo.setEndDate(entry.getDate("enddate"));
                billEntryEntityVo.setOwnDate(entry.getDate("owndate"));
                billEntryEntityVo.setEndMethod(entry.getString("endmethod"));
                this.buildPeriodTimeEach(billEntryEntityVo, shiftList, offList, tupleMap);
            }
        }
        ArrayList message = Lists.newArrayListWithExpectedSize((int)1);
        this.judgeOverlapOfOff(message, curOffList, offList);
        if (!message.isEmpty()) {
            return message;
        }
        this.judgeOverlapOfShift(message, curShiftList, shiftList);
        return message;
    }

    private Map<Long, List<VaBillVo>> getVaMapInfo(List<AttPersonVaBillReq> attFileReq) {
        LOG.info("BustripBillPeriodService.vaMapInfo IVaApplyBillService");
        Map vaMap = (Map)WTCServiceHelper.invokeBizService("wtc", "wtabm", "IVaApplyBillService", "getVaBillsByAttPersons", attFileReq);
        if (vaMap == null) {
            LOG.info("BustripBillPeriodService.vaMapInfo IVaApplyBillService is null");
        }
        return vaMap;
    }

    private Map<Long, List<DynamicObject>> getTpMapInfo(List<AttPersonVaBillReq> attFileReq) {
        List<DynamicObject> tpHisBillList = this.getHisTpBill(attFileReq);
        HashMap tpMap = Maps.newHashMapWithExpectedSize((int)attFileReq.size());
        if (tpHisBillList.isEmpty()) {
            return tpMap;
        }
        for (DynamicObject tpDy : tpHisBillList) {
            long personId = WTCDynamicObjectUtils.getBaseDataId(tpDy, "personid");
            List list = (List)tpMap.get(personId);
            if (list == null) {
                list = Lists.newArrayListWithExpectedSize((int)tpHisBillList.size());
            }
            list.add(tpDy);
            tpMap.put(personId, list);
        }
        return tpMap;
    }

    public <T extends BillEntryEntityVo> BillResponse checkStagingBillRepeat(List<T> entryEntityVos, T entryEntityVo) {
        if (entryEntityVos.isEmpty()) {
            return BillResponse.success();
        }
        Date ownStartDate = entryEntityVo.getOwnDate();
        Date ownEndDate = entryEntityVo.getOwnDate();
        for (BillEntryEntityVo vo : entryEntityVos) {
            Date ownDate = vo.getOwnDate();
            if (ownDate != null && ownDate.compareTo(ownStartDate) < 0) {
                ownStartDate = ownDate;
            }
            if (ownDate == null || ownDate.compareTo(ownEndDate) <= 0) continue;
            ownEndDate = ownDate;
        }
        ArrayList attFileBoIdList = Lists.newArrayListWithExpectedSize((int)1);
        attFileBoIdList.add(entryEntityVo.getAttFileBoid());
        Map<Long, List<Tuple<DutyShift, Shift>>> shiftInfo = this.getShiftInfo(attFileBoIdList, ownStartDate, ownEndDate);
        List<Tuple<DutyShift, Shift>> tuples = shiftInfo.get(attFileBoIdList.get(0));
        return this.doCheck(entryEntityVos, tuples, entryEntityVo);
    }

    private <T extends BillEntryEntityVo> BillResponse doCheck(List<T> entryEntityVos, List<Tuple<DutyShift, Shift>> tuples, T entryEntityVo) {
        if (entryEntityVos.isEmpty()) {
            return BillResponse.success();
        }
        Map<String, Tuple<DutyShift, Shift>> tupleMap = tuples.stream().collect(Collectors.toMap(tuple -> this.dateFormat.format(((DutyShift)tuple.item1).getRosterDate()), tuple -> tuple, (tuple1, tuple2) -> tuple1));
        int rowIndex = entryEntityVo.getRowIndex();
        ArrayList shiftList = Lists.newArrayListWithExpectedSize((int)entryEntityVos.size());
        ArrayList offList = Lists.newArrayListWithExpectedSize((int)entryEntityVos.size());
        this.buildPeriodTime(entryEntityVos, shiftList, offList, tupleMap, rowIndex);
        ArrayList curShiftList = Lists.newArrayListWithExpectedSize((int)entryEntityVos.size());
        ArrayList curOffList = Lists.newArrayListWithExpectedSize((int)entryEntityVos.size());
        this.buildPeriodTimeEach(entryEntityVo, curShiftList, curOffList, tupleMap);
        ArrayList message = Lists.newArrayListWithExpectedSize((int)1);
        this.judgeOverlapOfOff(message, curOffList, offList);
        if (!message.isEmpty()) {
            return BillResponse.error(null, (List)message);
        }
        this.judgeOverlapOfShift(message, curShiftList, shiftList);
        if (!message.isEmpty()) {
            return BillResponse.error(null, (List)message);
        }
        return BillResponse.success();
    }

    private boolean judgeOverlapOfShift(List<String> message, List<BillEntryEntityVo> curShiftList, List<BillEntryEntityVo> shiftList) {
        for (BillEntryEntityVo curVo : curShiftList) {
            Date curStartDate = curVo.getStartDate();
            Date curEndDate = curVo.getEndDate();
            int rowCount = curVo.getRowCount();
            int rowIndex = curVo.getRowIndex();
            for (BillEntryEntityVo vo : shiftList) {
                Date startDate = vo.getStartDate();
                Date endDate = vo.getEndDate();
                if (curStartDate == null || curEndDate == null || startDate == null || endDate == null || curStartDate.compareTo(endDate) >= 0 || startDate.compareTo(curEndDate) >= 0) continue;
                message.add(this.getMsg(vo, rowCount, rowIndex));
                return false;
            }
        }
        return true;
    }

    private boolean judgeOverlapOfOff(List<String> message, List<BillEntryEntityVo> curOffList, List<BillEntryEntityVo> offList) {
        for (BillEntryEntityVo curVo : curOffList) {
            Date curStartDate = curVo.getStartDate();
            int rowCount = curVo.getRowCount();
            int rowIndex = curVo.getRowIndex();
            for (BillEntryEntityVo vo : offList) {
                boolean downUp;
                Date startDate = vo.getStartDate();
                if (!DateUtils.isSameDay((Date)curStartDate, (Date)startDate)) continue;
                boolean upDown = HRStringUtils.equals((String)WtcTimeRangeBtnTypeEnum.HALF_UP.value, (String)curVo.getStartMethod()) && HRStringUtils.equals((String)WtcTimeRangeBtnTypeEnum.HALF_UP.value, (String)curVo.getEndMethod()) && HRStringUtils.equals((String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, (String)vo.getStartMethod()) && HRStringUtils.equals((String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, (String)vo.getEndMethod());
                boolean bl = downUp = HRStringUtils.equals((String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, (String)curVo.getStartMethod()) && HRStringUtils.equals((String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, (String)curVo.getEndMethod()) && HRStringUtils.equals((String)WtcTimeRangeBtnTypeEnum.HALF_UP.value, (String)vo.getStartMethod()) && HRStringUtils.equals((String)WtcTimeRangeBtnTypeEnum.HALF_UP.value, (String)vo.getEndMethod());
                if (upDown || downUp) continue;
                message.add(this.getMsg(vo, rowCount, rowIndex));
                return false;
            }
        }
        return true;
    }

    private String getBillNo(BillEntryEntityVo vo, UnifyBillEnum unifyBillEnum) {
        if (UnifyBillEnum.VA == unifyBillEnum) {
            DynamicObject batchBillDy = vo.getBatchBillDy();
            if (batchBillDy == null) {
                return vo.getBillNo();
            }
            return batchBillDy.getString("billno");
        }
        return vo.getBillNo();
    }

    private <T extends BillEntryEntityVo> void buildPeriodTime(List<T> entryEntityVos, List<BillEntryEntityVo> shiftList, List<BillEntryEntityVo> offList, Map<String, Tuple<DutyShift, Shift>> tupleMap, int rowIndex) {
        for (BillEntryEntityVo vo : entryEntityVos) {
            int rowIndex1 = vo.getRowIndex();
            if (rowIndex != 0 && rowIndex == rowIndex1) continue;
            this.buildPeriodTimeEach(vo, shiftList, offList, tupleMap);
        }
    }

    private void buildPeriodTimeEach(BillEntryEntityVo vo, List<BillEntryEntityVo> shiftList, List<BillEntryEntityVo> offList, Map<String, Tuple<DutyShift, Shift>> tupleMap) {
        boolean next;
        UnifyBillEnum unifyBillEnum = vo.getUnifyBillEnum();
        String billNo = vo.getBillNo();
        String startMethod = vo.getStartMethod();
        String endMethod = vo.getEndMethod();
        Date startDate = vo.getStartDate();
        Date endDate = vo.getEndDate();
        int rowIndex = vo.getRowIndex();
        int rowCount = vo.getRowCount();
        if (startDate == null || endDate == null) {
            return;
        }
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
            this.dealWithVo(startDate, endDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
            return;
        }
        Date subStart = startDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean bl = next = subStart.before(endDate) || DateUtils.isSameDay((Date)subStart, (Date)endDate);
        while (next) {
            Tuple<DutyShift, Shift> tuple = tupleMap.get(dateFormat.format(subStart));
            if (tuple != null) {
                if (((Shift)tuple.item2).getOffNonPlan() && ((Shift)tuple.item2).isOff()) {
                    this.dealWithOffVo(subStart, startDate, endDate, startMethod, endMethod, billNo, unifyBillEnum, offList);
                } else {
                    ShiftMiddleRule shiftMiddleRule = ((Shift)tuple.item2).getShiftMiddleRule();
                    RefDateType middleRefDate = shiftMiddleRule.getMiddleRefDate();
                    Date refMiddleDate = subStart;
                    if (RefDateType.NEXTDAY == middleRefDate) {
                        refMiddleDate = DateUtils.addDays((Date)subStart, (int)1);
                    }
                    Date middleDate = WTCDateUtils.getDate((Date)refMiddleDate, (Integer)shiftMiddleRule.getMiddlepoint());
                    List shiftDetails = ((Shift)tuple.item2).getShiftDetailList();
                    for (ShiftDetail detail : shiftDetails) {
                        if (StringUtils.equalsAny((CharSequence)detail.getOutWorkType(), (CharSequence[])new CharSequence[]{OutWorkType.BREAK.code})) continue;
                        Date detailStartDate = ShiftParseUtil.getRosterStartDate(detail, ((DutyShift)tuple.item1).getRosterDate());
                        Date detailEndDate = ShiftParseUtil.getRosterDetailEndDate(detail, ((DutyShift)tuple.item1).getRosterDate());
                        if (DateUtils.isSameDay((Date)startDate, (Date)endDate)) {
                            if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
                                if (detailStartDate.compareTo(middleDate) <= 0 && middleDate.compareTo(detailEndDate) <= 0) {
                                    this.dealWithVo(detailStartDate, middleDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                                    continue;
                                }
                                if (detailEndDate.compareTo(middleDate) > 0) continue;
                                this.dealWithVo(detailStartDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                                continue;
                            }
                            if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value) && HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                                if (detailStartDate.compareTo(middleDate) <= 0 && middleDate.compareTo(detailEndDate) < 0) {
                                    this.dealWithVo(middleDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                                    continue;
                                }
                                if (detailStartDate.compareTo(middleDate) < 0) continue;
                                this.dealWithVo(detailStartDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                                continue;
                            }
                            this.dealWithVo(detailStartDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                            continue;
                        }
                        if (DateUtils.isSameDay((Date)subStart, (Date)endDate)) {
                            if (HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
                                if (detailStartDate.compareTo(middleDate) <= 0 && middleDate.compareTo(detailEndDate) <= 0) {
                                    this.dealWithVo(detailStartDate, middleDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                                    continue;
                                }
                                if (detailEndDate.compareTo(middleDate) > 0) continue;
                                this.dealWithVo(detailStartDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                                continue;
                            }
                            this.dealWithVo(detailStartDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                            continue;
                        }
                        if (DateUtils.isSameDay((Date)subStart, (Date)startDate)) {
                            if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                                if (detailStartDate.compareTo(middleDate) <= 0 && middleDate.compareTo(detailEndDate) < 0) {
                                    this.dealWithVo(middleDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                                    continue;
                                }
                                if (detailStartDate.compareTo(middleDate) < 0) continue;
                                this.dealWithVo(detailStartDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                                continue;
                            }
                            this.dealWithVo(detailStartDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                            continue;
                        }
                        this.dealWithVo(detailStartDate, detailEndDate, vo, unifyBillEnum, shiftList, rowIndex, rowCount);
                    }
                }
            }
            next = (subStart = DateUtils.addDays((Date)subStart, (int)1)).before(endDate) || DateUtils.isSameDay((Date)subStart, (Date)endDate);
        }
    }

    private void dealWithVo(Date startDate, Date endDate, BillEntryEntityVo sourceVo, UnifyBillEnum unifyBillEnum, List<BillEntryEntityVo> list, int rowIndex, int rowCount) {
        BillEntryEntityVo vo = new BillEntryEntityVo();
        vo.setStartDate(startDate);
        vo.setEndDate(endDate);
        vo.setBillNo(sourceVo.getBillNo());
        vo.setUnifyBillEnum(unifyBillEnum);
        vo.setRowIndex(rowIndex);
        vo.setRowCount(rowCount);
        vo.setBatchBillDy(sourceVo.getBatchBillDy());
        list.add(vo);
    }

    private void dealWithOffVo(Date subStart, Date startDate, Date endDate, String startMethod, String endMethod, String billNo, UnifyBillEnum unifyBillEnum, List<BillEntryEntityVo> offList) {
        BillEntryEntityVo vo = new BillEntryEntityVo();
        vo.setStartDate(subStart);
        vo.setUnifyBillEnum(unifyBillEnum);
        vo.setBillNo(billNo);
        if (DateUtils.isSameDay((Date)startDate, (Date)endDate)) {
            vo.setEndDate(endDate);
            vo.setStartMethod(startMethod);
            vo.setEndMethod(endMethod);
        } else if (DateUtils.isSameDay((Date)subStart, (Date)startDate)) {
            vo.setEndDate(subStart);
            vo.setStartMethod(startMethod);
            vo.setEndMethod(WtcTimeRangeBtnTypeEnum.HALF_DOWN.value);
        } else if (DateUtils.isSameDay((Date)subStart, (Date)endDate)) {
            vo.setEndDate(endDate);
            if (HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
                vo.setStartMethod(WtcTimeRangeBtnTypeEnum.HALF_UP.value);
                vo.setEndMethod(WtcTimeRangeBtnTypeEnum.HALF_UP.value);
            } else {
                vo.setStartMethod(WtcTimeRangeBtnTypeEnum.DAY.value);
                vo.setEndMethod(WtcTimeRangeBtnTypeEnum.DAY.value);
            }
        } else {
            vo.setStartMethod(WtcTimeRangeBtnTypeEnum.DAY.value);
            vo.setEndMethod(WtcTimeRangeBtnTypeEnum.DAY.value);
        }
        offList.add(vo);
    }

    private Map<Long, List<Tuple<DutyShift, Shift>>> getShiftInfo(List<Long> attFileBoIdList, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)attFileBoIdList.size());
        DutyShiftResponse shiftResponse = ApplyUtil.getShift(attFileBoIdList, HRDateTimeUtils.addDay((Date)dutyDateQueryStartTime, (long)-1L), HRDateTimeUtils.addDay((Date)dutyDateQueryEndTime, (long)1L));
        if (shiftResponse == null) {
            return map;
        }
        Map dutyShiftMap = shiftResponse.getDutyShiftOfFileMap();
        if (CollectionUtils.isEmpty((Map)dutyShiftMap)) {
            return map;
        }
        List<Date> dateRange = this.getDateRange(dutyDateQueryStartTime, dutyDateQueryEndTime);
        for (Long attFileBoId : attFileBoIdList) {
            ArrayList matchShiftInfo = Lists.newArrayListWithExpectedSize((int)dateRange.size());
            for (Date date : dateRange) {
                DutyShift dutyShift;
                Optional shiftOptional;
                Optional dutyShiftOptional = shiftResponse.getDutyShift(attFileBoId, date);
                if (!dutyShiftOptional.isPresent() || !(shiftOptional = shiftResponse.getShiftHisData((dutyShift = (DutyShift)dutyShiftOptional.get()).getShiftVid())).isPresent()) continue;
                Shift shift = (Shift)shiftOptional.get();
                matchShiftInfo.add(new Tuple((Object)dutyShift, (Object)shift));
            }
            map.put(attFileBoId, matchShiftInfo);
        }
        return map;
    }

    private List<Date> getDateRange(Date startTime, Date endTime) {
        Date startDate = HRDateTimeUtils.addDay((Date)WTCDateUtils.getDayStartTime((Date)startTime), (long)-1L);
        Date endDate = HRDateTimeUtils.addDay((Date)WTCDateUtils.getDayStartTime((Date)endTime), (long)1L);
        ArrayList dateRange = Lists.newArrayListWithExpectedSize((int)10);
        Date lastDate = startDate;
        while (lastDate.getTime() <= endDate.getTime()) {
            dateRange.add(lastDate);
            lastDate = HRDateTimeUtils.addDay((Date)lastDate, (long)1L);
        }
        return dateRange;
    }

    private String getMsg(BillEntryEntityVo vo, int rowCount, int rowIndex) {
        String errorMsg;
        DynamicObject batchBillDy;
        UnifyBillEnum unifyBillEnum = vo.getUnifyBillEnum();
        String billNo = vo.getBillNo();
        boolean isBatchVa = false;
        if (UnifyBillEnum.VA == unifyBillEnum && (batchBillDy = vo.getBatchBillDy()) != null) {
            billNo = batchBillDy.getString("billno");
            isBatchVa = true;
        }
        if (HRStringUtils.isEmpty((String)billNo)) {
            errorMsg = ResManager.loadKDString((String)"\u4e0e\u5df2\u6dfb\u52a0\u65f6\u6bb5\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BustripBillPeriodService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        } else if (UnifyBillEnum.VA == unifyBillEnum) {
            if (isBatchVa) {
                errorMsg = BatchBillKDString.repeatHisBatch();
                errorMsg = MessageFormat.format(errorMsg, BillTypeEnum.VACATIONBILL.getBillName(), billNo);
            } else {
                errorMsg = ResManager.loadKDString((String)"\u4e0e\u73b0\u6709\u4f11\u5047\u5355{0}\u65f6\u6bb5\u91cd\u53e0\uff0c\u65e0\u6cd5\u7533\u8bf7\u8be5\u65f6\u6bb5{1}\u3002", (String)"BustripBillPeriodService_1", (String)"wtc-wtbs-business", (Object[])new Object[]{billNo, BillTypeEnum.EVECTIONBILL.getBillName()});
            }
        } else {
            errorMsg = this.isImport && this.isBatch ? ResManager.loadKDString((String)"\u4e0e\u672c\u6b21\u6279\u91cf\u521b\u5efa\u7684\u5176\u4ed6\u5355\u636e\u65f6\u6bb5\u91cd\u53e0\uff0c\u65e0\u6cd5\u7533\u8bf7\u8be5\u65f6\u6bb5{0}\u3002", (String)"BustripBillPeriodService_5", (String)"wtc-wtbs-business", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName()}) : ResManager.loadKDString((String)"\u4e0e\u73b0\u6709{0}\u5355{1}\u65f6\u6bb5\u91cd\u53e0\uff0c\u65e0\u6cd5\u7533\u8bf7\u8be5\u65f6\u6bb5{2}\u3002", (String)"BustripBillPeriodService_2", (String)"wtc-wtbs-business", (Object[])new Object[]{BillTypeEnum.EVECTIONBILL.getBillName(), billNo, BillTypeEnum.EVECTIONBILL.getBillName()});
        }
        if (!this.isImport) {
            return errorMsg;
        }
        if (rowCount <= 1) {
            return errorMsg;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 1; index <= rowCount; ++index) {
            String s1 = ResManager.loadKDString((String)"\u5206\u5f55{0}", (String)"BustripBillPeriodService_3", (String)"wtc-wtbs-business", (Object[])new Object[]{index});
            sb.append(s1);
            sb.append(WTCSymbolMultiLanguageUtil.getColonSymbol());
            if (index == rowIndex) {
                sb.append(errorMsg);
                continue;
            }
            String s2 = ResManager.loadKDString((String)"\u56e0\u5176\u4ed6\u5206\u5f55\u5bfc\u5165\u5931\u8d25\u3002", (String)"BustripBillPeriodService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            sb.append(s2);
        }
        return sb.toString();
    }
}

