/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtam.business.applytime.TpApplyTimeCalculateEvent;
import kd.sdk.wtc.wtam.business.applytime.TpApplyTimeCalculateExtPlugin;
import kd.sdk.wtc.wtam.business.applytime.bean.TpApplyTimeCalculateResult;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDto;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.shift.ShiftConvertUtils;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.extend.WtcAbstractUnityBillAutoOperator;
import kd.wtc.wtbs.business.web.applybill.operatecore.tp.TpAutoOperator;
import kd.wtc.wtbs.business.web.applybill.service.BillEntityCheckService;
import kd.wtc.wtbs.common.enums.ApplicationTypeEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleCalEntryEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillApplyTimeResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtam.common.busitrip.TimeTypeEnum;

public class BustripEntityCheckService
extends BillEntityCheckService {
    public boolean isFlagByBusTrip = false;
    private static final Log LOG = LogFactory.getLog(BillEntityCheckService.class);

    public BustripEntityCheckService() {
    }

    public BustripEntityCheckService(String attFileF7AuthEntity) {
        this.attFileF7AuthEntity = attFileF7AuthEntity;
    }

    @Deprecated
    public BustripEntityCheckService(Long attfileBo, DynamicObject dyObject, String attFileF7AuthEntity) {
        this.fillBillEntityCheckService(attfileBo, UnifyBillEnum.TP, ApplyBillCheckEnum.BUSTRIPFORM, dyObject, attFileF7AuthEntity);
    }

    public BustripEntityCheckService(Long attfileBo, DynamicObject dyObject, String attFileF7AuthEntity, String appId) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(appId, attFileF7AuthEntity);
        this.fillBillEntityCheckService(attfileBo, UnifyBillEnum.TP, ApplyBillCheckEnum.BUSTRIPFORM, dyObject, applyAttr);
    }

    @Deprecated
    public BustripEntityCheckService(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, String attFileF7AuthEntity) {
        this.fillBillEntityCheckService(attfileBo, unifyBillEnum, checkEnum, dyObject, attFileF7AuthEntity);
    }

    public BustripEntityCheckService(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, String attFileF7AuthEntity, String appId) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(appId, attFileF7AuthEntity);
        this.fillBillEntityCheckService(attfileBo, unifyBillEnum, checkEnum, dyObject, applyAttr);
    }

    public BustripEntityCheckService(Long attfileBo, UnifyBillEnum unifyBillEnum, ApplyBillCheckEnum checkEnum, DynamicObject dyObject, String attFileF7AuthEntity, String appId, WtcAbstractUnityBillOperator operator) {
        UnifyBillApplyAttr applyAttr = new UnifyBillApplyAttr(appId, attFileF7AuthEntity);
        this.fillBillEntityCheckService(attfileBo, unifyBillEnum, checkEnum, dyObject, applyAttr, operator);
    }

    @Override
    protected WtcAbstractUnityBillAutoOperator initContext(DynamicObject dyObject, UnifyBillApplyAttr attr) {
        List<UnifyBillApplyInitInfo> lst = this.createUnifyBillApplyInfo(dyObject);
        UnifyBillInfoContext unifyBillInfoContext = new UnifyBillInfoContext(lst, attr);
        return new WtcAbstractUnityBillAutoOperator(unifyBillInfoContext){

            @Override
            public UnifyBillEnum getUnifyBillEnum() {
                return UnifyBillEnum.TP;
            }
        };
    }

    @Deprecated
    public Set<Long> getChangeEnumTypeIds(long attfileBo, long changecheck, ApplyBillCheckEnum checkEnum) {
        return this.getChangeEnumTypeIds(attfileBo, changecheck, checkEnum, null);
    }

    public Set<Long> getChangeEnumTypeIds(long attfileBo, long changecheck, ApplyBillCheckEnum checkEnum, String appId) {
        HRBaseServiceHelper billServiceHelper = new HRBaseServiceHelper("wtam_busitripbill");
        Set<Object> enumTypeIdSet = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObject billDy = billServiceHelper.loadDynamicObject(new QFilter("entryentity.id", "=", (Object)changecheck));
        DynamicObjectCollection dynamicObjectCollection = billDy.getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> first = dynamicObjectCollection.stream().filter(e -> e.getPkValue().equals(changecheck)).findFirst();
        if (first.isPresent()) {
            DynamicObject entryRow = dynamicObjectCollection.stream().filter(e -> e.getPkValue().equals(changecheck)).findFirst().get();
            BustripEntityCheckService billCommonCheckHelper = new BustripEntityCheckService(attfileBo, UnifyBillEnum.TP, ApplyBillCheckEnum.BUSTRIP, entryRow, this.attFileF7AuthEntity, appId);
            DynamicObject matchChangeSet = billCommonCheckHelper.getMatchChangeSet();
            if (Objects.nonNull(matchChangeSet)) {
                boolean isTypeChange = matchChangeSet.getBoolean("istypechange");
                if (isTypeChange) {
                    DynamicObjectCollection traveltypes = matchChangeSet.getDynamicObjectCollection(checkEnum.getApplyBillChangeSetEnum().getEntryentity());
                    enumTypeIdSet = traveltypes.stream().map(e -> e.getLong(checkEnum.getApplyBillChangeSetEnum().getType() + ".id")).collect(Collectors.toSet());
                } else {
                    HRBaseServiceHelper typeHelper = new HRBaseServiceHelper("wtbd_traveltype");
                    QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                    qFilter.and("status", "=", (Object)"C");
                    DynamicObject[] query = typeHelper.query(new QFilter[]{qFilter});
                    Set collect = Arrays.stream(query).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                    enumTypeIdSet.addAll(collect);
                }
            }
            Set<Long> enumTypeIdSet2 = billCommonCheckHelper.getEnumTypeIdSet(attfileBo, UnifyBillEnum.TP, appId);
            enumTypeIdSet.retainAll(enumTypeIdSet2);
        }
        return enumTypeIdSet;
    }

    @Override
    public BillResponse checkChangeSet(DynamicObject newEntryDy) {
        if (!this.isInit()) {
            return BillResponse.success();
        }
        Date startDate = this.getDyObject().getDate(this.getCheckEnum().getStartDate());
        String startMethod = this.getDyObject().getString(this.getCheckEnum().getStartMethod());
        Date endDate = this.getDyObject().getDate(this.getCheckEnum().getEndDate());
        String endMethod = this.getDyObject().getString(this.getCheckEnum().getEndMethod());
        long typeId = this.getDyObject().getLong(this.getCheckEnum().getType() + ".id");
        long tripToolId = WTCDynamicObjectUtils.getBaseDataId(this.getDyObject(), "traveltool");
        long fromId = WTCDynamicObjectUtils.getBaseDataId(this.getDyObject(), "from");
        long toId = WTCDynamicObjectUtils.getBaseDataId(this.getDyObject(), "to");
        String reason = this.getDyObject().getString("tripresontex");
        Date newStartDate = new Date(newEntryDy.getDate(this.getCheckEnum().getStartDate()).getTime());
        Date newEndDate = new Date(newEntryDy.getDate(this.getCheckEnum().getEndDate()).getTime());
        String newStartMethod = newEntryDy.getString(this.getCheckEnum().getStartMethod());
        String newEndMethod = newEntryDy.getString(this.getCheckEnum().getEndMethod());
        long newTypeId = newEntryDy.getLong(this.getCheckEnum().getType() + ".id");
        String newTypeName = newEntryDy.getLocaleString(this.getCheckEnum().getType() + ".name").getLocaleValue();
        long newTripToolId = WTCDynamicObjectUtils.getBaseDataId(newEntryDy, "traveltool");
        long newFromId = WTCDynamicObjectUtils.getBaseDataId(newEntryDy, "from");
        long newToId = WTCDynamicObjectUtils.getBaseDataId(newEntryDy, "to");
        String newReason = newEntryDy.getString("tripresontex");
        boolean notChangeOfDateTime = startMethod.equals(newStartMethod) && endMethod.equals(newEndMethod) && startDate.getTime() == newStartDate.getTime() && endDate.getTime() == newEndDate.getTime();
        boolean notChange = typeId == newTypeId && tripToolId == newTripToolId && fromId == newFromId && toId == newToId && HRStringUtils.equals((String)reason, (String)newReason);
        boolean isChanged = !notChangeOfDateTime || !notChange;
        ArrayList<String> msgList = new ArrayList<String>(4);
        boolean success = true;
        if (isChanged) {
            Set<Map.Entry<Date, DynamicObject>> entries;
            Iterator<Map.Entry<Date, DynamicObject>> iterator;
            Map<Date, DynamicObject> changeSetDySet = this.getBillAutoOperator().getChangeSetDy(this.getAttfileBo(), startDate, endDate, typeId);
            DynamicObject changeSetDy = null;
            if (changeSetDySet != null && (iterator = (entries = changeSetDySet.entrySet()).iterator()).hasNext()) {
                Map.Entry<Date, DynamicObject> next = iterator.next();
                changeSetDy = next.getValue();
            }
            if (changeSetDy != null) {
                Map<Date, Shift> shiftMap = this.billAutoOperator.getShift(this.attfileBo, startDate, endDate);
                this.firstDateShift = this.getfirstShift(shiftMap);
                this.lastDateShift = this.getlastShift(shiftMap);
                success = this.validateChangeTime(startDate, startMethod, endDate, endMethod, newStartDate, newEndDate, newStartMethod, newEndMethod, msgList, changeSetDy);
                success = success && this.validateChangeType(typeId, newTypeId, newTypeName, msgList, changeSetDy);
                success &= this.validateCouldChangeFields(changeSetDy, newEntryDy, this.getDyObject(), tripToolId, newTripToolId, fromId, newFromId, toId, newToId, msgList);
            } else {
                success = false;
                String failMsg = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8be5%s\u5355\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"BillCommonCheckHelper_25", (String)"wtc-wtbs-business", (Object[])new Object[0]), (String)"BillCommonCheckHelper_23", (String)"wtc-wtbs-business", (Object[])new Object[]{this.getUnifyBillEnum().getDescriptionStr()});
                msgList.add(failMsg);
            }
        }
        if (!success) {
            return BillResponse.error(null, msgList);
        }
        return BillResponse.success();
    }

    private boolean validateCouldChangeFields(DynamicObject changeSetDy, DynamicObject newEntryDy, DynamicObject dyObject, long tripToolId, long newTripToolId, long fromId, long newFromId, long toId, long newToId, List<String> msgList) {
        String failMsg;
        boolean success = true;
        if (tripToolId != newTripToolId && !changeSetDy.getBoolean("isvehicle")) {
            failMsg = String.format(ResManager.loadKDString((String)"\u8be5%s\u5355\u4e0d\u5141\u8bb8\u53d8\u66f4\u4ea4\u901a\u5de5\u5177\u3002", (String)"BustripEntityCheckService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.getUnifyBillEnum().getDescriptionStr());
            msgList.add(failMsg);
            success = false;
        }
        if (!(fromId == newFromId && toId == newToId || changeSetDy.getBoolean("isdestination"))) {
            failMsg = String.format(ResManager.loadKDString((String)"\u8be5%s\u5355\u4e0d\u5141\u8bb8\u53d8\u66f4\u51fa\u53d1\u5730\u4e0e\u76ee\u7684\u5730\u3002", (String)"BustripEntityCheckService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.getUnifyBillEnum().getDescriptionStr());
            msgList.add(failMsg);
            success = false;
        }
        return success;
    }

    private boolean validateChangeType(long typeId, long newTypeId, String newTypeName, List<String> msgList, DynamicObject changeSetDy) {
        DynamicObjectCollection entryEntity;
        Set changeTypeIdSet;
        boolean success = true;
        boolean istypechange = changeSetDy.getBoolean(this.getCheckEnum().getApplyBillChangeSetEnum().getIstypechange());
        if (istypechange && !(changeTypeIdSet = (entryEntity = changeSetDy.getDynamicObjectCollection(this.getCheckEnum().getApplyBillChangeSetEnum().getEntryentity())).stream().map(el -> el.getLong(this.getCheckEnum().getApplyBillChangeSetEnum().getType() + ".id")).collect(Collectors.toSet())).contains(newTypeId) && newTypeId != typeId) {
            success = false;
            String failMsg = String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u578b\u65e0\u6cd5\u53d8\u66f4\u4e3a%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillCommonCheckHelper_23", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.getUnifyBillEnum().getDescriptionStr(), newTypeName);
            msgList.add(failMsg);
        }
        return success;
    }

    private boolean validateChangeTime(Date startDate, String startMethod, Date endDate, String endMethod, Date newStartDate, Date newEndDate, String newStartMethod, String newEndMethod, List<String> msgList, DynamicObject changeSetDy) {
        String bgtimetype = changeSetDy.getString(this.getCheckEnum().getApplyBillChangeSetEnum().getBgtimetype());
        if (HRStringUtils.equals((String)bgtimetype, (String)"A") && (this.checkStartNotBefore(startDate, startMethod, newStartDate, newStartMethod) || this.checkEndNotAfter(endDate, endMethod, newEndDate, newEndMethod))) {
            String failMsg = "";
            if (this.checkStartNotBefore(startDate, startMethod, newStartDate, newStartMethod)) {
                LOG.info("startDate:{}, startMethod:{}, newStart:{}, newStartMethod:{}", new Object[]{startDate, startMethod, newStartDate, newStartMethod});
                failMsg = failMsg + ResManager.loadResFormat((String)ResManager.loadKDString((String)"%s\u65f6\u95f4\u53ea\u80fd\u5728\u539f\u5355\u8303\u56f4\u5185\u53d8\u66f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillCommonCheckHelper_21", (String)"wtc-wtbs-business", (Object[])new Object[0]), (String)"BillCommonCheckHelper_17", (String)"wtc-wtbs-business", (Object[])new Object[]{this.getUnifyBillEnum().getDescriptionStr()});
            } else if (this.checkEndNotAfter(endDate, endMethod, newEndDate, newEndMethod)) {
                LOG.info("endDate:{}, endMethod:{}, newEnd:{}, newEndMethod:{}", new Object[]{endDate, endMethod, newEndDate, newEndMethod});
                failMsg = failMsg + ResManager.loadResFormat((String)ResManager.loadKDString((String)"%s\u65f6\u95f4\u53ea\u80fd\u5728\u539f\u5355\u8303\u56f4\u5185\u53d8\u66f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillCommonCheckHelper_21", (String)"wtc-wtbs-business", (Object[])new Object[0]), (String)"BillCommonCheckHelper_17", (String)"wtc-wtbs-business", (Object[])new Object[]{this.getUnifyBillEnum().getDescriptionStr()});
            }
            msgList.add(failMsg);
            return false;
        }
        return true;
    }

    @Override
    public BillResponse checkApplyTime(BigDecimal applyTime) {
        BillResponse billResponse = super.checkApplyTime(applyTime);
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkMaxApplyTime(applyTime);
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        billResponse = this.checkApplyTimeTypeAndUnitTime(applyTime);
        if (!billResponse.isSuccess()) {
            return billResponse;
        }
        return BillResponse.success((Object)billResponse.getData());
    }

    private BillResponse checkApplyTimeTypeAndUnitTime(BigDecimal applyTime) {
        if (!this.isFlagByBusTrip) {
            boolean success = true;
            ArrayList<String> msg = new ArrayList<String>(4);
            int startMethod = this.dyObject.getInt("startmethod");
            int endMethod = this.dyObject.getInt("endmethod");
            String travelMode = "";
            if (!(startMethod != WtcTimeRangeBtnTypeEnum.HALF_UP.code && startMethod != WtcTimeRangeBtnTypeEnum.HALF_DOWN.code || endMethod != WtcTimeRangeBtnTypeEnum.HALF_UP.code && endMethod != WtcTimeRangeBtnTypeEnum.HALF_DOWN.code)) {
                travelMode = ApplicationTypeEnum.HALF_FOR_DAY.getCode();
            } else if (startMethod == WtcTimeRangeBtnTypeEnum.DAY.code && endMethod == WtcTimeRangeBtnTypeEnum.DAY.code) {
                travelMode = ApplicationTypeEnum.ALL_DAY.getCode();
            } else if (startMethod == WtcTimeRangeBtnTypeEnum.CUSTOM.code && endMethod == WtcTimeRangeBtnTypeEnum.CUSTOM.code) {
                travelMode = ApplicationTypeEnum.TIME_HOUR.getCode();
            }
            DynamicObject busiTripType = this.dyObject.getDynamicObject("busitriptype");
            String applyTimeType = busiTripType.getString("applytimetype");
            String[] applyTimeTypeList = applyTimeType.split(",");
            List applyTimeTypes = Arrays.stream(applyTimeTypeList).filter(str -> !str.trim().isEmpty()).collect(Collectors.toList());
            StringBuilder typeStr = new StringBuilder();
            if (!applyTimeTypes.contains(travelMode) && CollectionUtils.isNotEmpty(applyTimeTypes)) {
                for (String timeType : applyTimeTypes) {
                    String description = ApplicationTypeEnum.getEnumByKey((String)timeType).getDescription();
                    typeStr.append(description).append("\u3001");
                }
                String errorMsg = ResManager.loadKDString((String)"\u51fa\u5dee\u65f6\u95f4\u8bf7\u6309%1$s\u7684\u65b9\u5f0f\u7533\u8bf7\u3002", (String)"BillCommonCheckHelper_41", (String)"wtc-wtbs-business", (Object[])new Object[]{typeStr.substring(0, typeStr.length() - 1)});
                msg.add(errorMsg);
                success = false;
            }
            if (!success) {
                return BillResponse.error(null, msg);
            }
            BillResponse billResponse = this.checkUnitTime(applyTime);
            if (!billResponse.isSuccess()) {
                return BillResponse.error(null, (List)billResponse.getMessage());
            }
        }
        return BillResponse.success();
    }

    private BillResponse checkUnitTime(BigDecimal applyTime) {
        boolean success = true;
        ArrayList<String> msg = new ArrayList<String>(4);
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BustripEntityCheckService.getDate(startDate);
        endDate = BustripEntityCheckService.getDate(endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> baseSetDyMap = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
        if (baseSetDyMap == null || baseSetDyMap.isEmpty()) {
            return BillResponse.success();
        }
        DynamicObject baseSetDy = baseSetDyMap.entrySet().iterator().next().getValue();
        String unit = baseSetDy.getString("unit");
        boolean isApplySpan = baseSetDy.getBoolean("isapplyspan");
        if (isApplySpan) {
            BigDecimal applySpan = baseSetDy.getBigDecimal("applyspan");
            String timeWithUnit = StringUtils.equals((CharSequence)unit, (CharSequence)TimeTypeEnum.DAY.getCode()) ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5929", (String)"BillCommonCheckHelper_5", (String)"wtc-wtbs-business", (Object[])new Object[0]), applySpan) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5c0f\u65f6", (String)"BillCommonCheckHelper_13", (String)"wtc-wtbs-business", (Object[])new Object[0]), applySpan);
            if (applySpan != null && applySpan.compareTo(BigDecimal.ZERO) != 0 && applyTime.remainder(applySpan).compareTo(BigDecimal.ZERO) != 0) {
                String errorMsg = ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u65f6\u957f\u4e0d\u7b26\u5408\u5355\u4f4d\u65f6\u957f%1$s\u7684\u6574\u6570\u500d\u3002", (String)"BillCommonCheckHelper_42", (String)"wtc-wtbs-business", (Object[])new Object[]{timeWithUnit});
                msg.add(errorMsg);
                success = false;
            }
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        return BillResponse.success();
    }

    private BillResponse checkMaxApplyTime(BigDecimal applyTime) {
        if (!this.init) {
            return BillResponse.success();
        }
        ArrayList<String> msg = new ArrayList<String>(4);
        boolean success = true;
        Date startDate = this.dyObject.getDate(this.checkEnum.getStartDate());
        Date endDate = this.dyObject.getDate(this.checkEnum.getEndDate());
        startDate = BustripEntityCheckService.getDate(startDate);
        endDate = BustripEntityCheckService.getDate(endDate);
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        Map<Date, DynamicObject> baseSetDyMap = this.billAutoOperator.getBaseSetDy(this.attfileBo, startDate, endDate, type);
        if (baseSetDyMap == null || baseSetDyMap.isEmpty()) {
            return BillResponse.success();
        }
        DynamicObject baseSetDy = baseSetDyMap.entrySet().iterator().next().getValue();
        BigDecimal maxApplyTime = baseSetDy.getBigDecimal("travelmaxnumber");
        if (BigDecimal.ZERO.compareTo(maxApplyTime = maxApplyTime.setScale(2, RoundingMode.HALF_UP)) >= 0) {
            LOG.info("tp\uff1atravelmaxnumber={}", (Object)maxApplyTime);
            return BillResponse.success();
        }
        String unit = baseSetDy.getString(this.checkEnum.getApplyBillBaseSetEnum().getUnit());
        if ((applyTime = applyTime.setScale(2, RoundingMode.HALF_UP)).compareTo(maxApplyTime) > 0) {
            String maxApplyTimeStr = maxApplyTime.stripTrailingZeros().toPlainString();
            String timeWithUnit = StringUtils.equals((CharSequence)unit, (CharSequence)"A") ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5929", (String)"BillCommonCheckHelper_5", (String)"wtc-wtbs-business", (Object[])new Object[0]), maxApplyTimeStr) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5c0f\u65f6", (String)"BillCommonCheckHelper_13", (String)"wtc-wtbs-business", (Object[])new Object[0]), maxApplyTimeStr);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65f6\u957f\u4e0d\u53ef\u8d85\u8fc7%1$s\u3002", (String)"BillCommonCheckHelper_39", (String)"wtc-wtbs-business", (Object[])new Object[0]), timeWithUnit);
            msg.add(errorMsg);
            success = false;
        }
        if (!success) {
            return BillResponse.error(null, msg);
        }
        this.checkBaseSetSuccess = true;
        return BillResponse.success();
    }

    @Override
    public BillApplyTimeResult generateApplyTime() {
        Date ownDate;
        BillApplyTimeResult res = new BillApplyTimeResult();
        String startMethod = this.dyObject.getString(this.checkEnum.getStartMethod());
        String endMethod = this.dyObject.getString(this.checkEnum.getEndMethod());
        Date startDate = new Date(this.dyObject.getDate(this.checkEnum.getStartDate()).getTime());
        Date endDate = new Date(this.dyObject.getDate(this.checkEnum.getEndDate()).getTime());
        long type = this.dyObject.getLong(this.checkEnum.getType() + ".id");
        String unit = null;
        BigDecimal sumHour = BigDecimal.ZERO;
        BigDecimal sumDay = BigDecimal.ZERO;
        List<Tuple<DutyShift, Shift>> dutyShiftsRange = this.billAutoOperator.getDutyShiftsRange(this.attfileBo, startDate, endDate);
        DynamicObject baseSetDyn = this.getBustripBaseSetDy();
        if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.CUSTOM.value)) {
            ownDate = this.dyObject.getDate(this.checkEnum.getOwndate());
            res = ownDate != null ? this.generateBustripApplyTime(dutyShiftsRange, ownDate, baseSetDyn) : this.generateBustripApplyTime(dutyShiftsRange, startDate, baseSetDyn);
        } else {
            BillApplyTimeResult startDateCalResult = new BillApplyTimeResult();
            BillApplyTimeResult endDateCalResult = new BillApplyTimeResult();
            ownDate = this.billAutoOperator.isUseStartOrEnd() ? startDate : endDate;
            if (HRStringUtils.equals((String)startMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_DOWN.value)) {
                startDateCalResult = this.calHalfDayHours(dutyShiftsRange, startDate, baseSetDyn, false, false);
            }
            if (HRStringUtils.equals((String)endMethod, (String)WtcTimeRangeBtnTypeEnum.HALF_UP.value)) {
                endDateCalResult = this.calHalfDayHours(dutyShiftsRange, endDate, baseSetDyn, true, false);
            }
            Date wholeDayStart = this.beginDayIsHoleDay(startMethod, endMethod, startDate, endDate) ? startDate : DateUtils.addDays((Date)startDate, (int)1);
            Date wholeDayEnd = StringUtils.equalsAny((CharSequence)endMethod, (CharSequence[])new CharSequence[]{WtcTimeRangeBtnTypeEnum.HALF_DOWN.value, WtcTimeRangeBtnTypeEnum.DAY.value}) ? endDate : DateUtils.addDays((Date)endDate, (int)-1);
            BillApplyTimeResult middleCalResult = this.calWholeDayHours(dutyShiftsRange, wholeDayStart, wholeDayEnd, baseSetDyn, false);
            sumDay = startDateCalResult.getValDay().add(middleCalResult.getValDay()).add(endDateCalResult.getValDay());
            sumHour = startDateCalResult.getValHour().add(middleCalResult.getValHour()).add(endDateCalResult.getValHour());
            res = new BillApplyTimeResult(unit, sumHour, sumDay);
        }
        unit = baseSetDyn.getString(this.checkEnum.getApplyBillBaseSetEnum().getUnit());
        res.setUnit(unit);
        WTCPluginProxy<TpApplyTimeCalculateExtPlugin> plugin = WTCPluginProxyFactory.create(TpApplyTimeCalculateExtPlugin.class, "kd.sdk.wtc.wtam.business.applytime.TpApplyTimeCalculateExtPlugin");
        if (plugin.hasPlugin()) {
            HashMap shiftDtoMap = Maps.newHashMapWithExpectedSize((int)dutyShiftsRange.size());
            for (Tuple<DutyShift, Shift> truple : dutyShiftsRange) {
                LocalDate dutyDate = WTCDateUtils.toLocalDate((Date)((DutyShift)truple.item1).getRosterDate());
                ShiftDto shiftDto = ShiftConvertUtils.convertShift((Shift)truple.item2);
                shiftDtoMap.put(dutyDate, shiftDto);
            }
            Long attfileBo = this.getAttfileBo();
            TpApplyTimeCalculateResult calResult = new TpApplyTimeCalculateResult(res.getValHour(), res.getValDay());
            TpApplyTimeCalculateEvent event = new TpApplyTimeCalculateEvent(attfileBo, this.dyObject, (Map)shiftDtoMap, calResult);
            plugin.invokeReplace(service -> service.onCalculateApplyTime(event));
            TpApplyTimeCalculateResult result = event.getResult();
            res = new BillApplyTimeResult(res.getUnit(), result.getValHour(), result.getValDay());
        }
        return res;
    }

    public Map<Long, Long> getTypeRegulation(Long attFileBoId, String appId) {
        UnifyBillApplyInitInfo info = new UnifyBillApplyInitInfo((Object)0L, attFileBoId.longValue(), Collections.emptyList());
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        attr.setAttFileF7AuthAppId(appId);
        attr.setAttFileF7AuthEntity(this.attFileF7AuthEntity);
        attr.setAttFileAuthField("attfilebasef7");
        UnifyBillInfoContext billInfoContext = new UnifyBillInfoContext((List)Lists.newArrayList((Object[])new UnifyBillApplyInitInfo[]{info}), attr);
        TpAutoOperator tpAutoOperator = new TpAutoOperator(billInfoContext);
        List<Object> allRule = tpAutoOperator.getAllRule(attFileBoId);
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        if (allRule.isEmpty()) {
            return resultMap;
        }
        allRule = allRule.stream().filter(rule -> "1".equals(rule.getString("datastatus"))).collect(Collectors.toList());
        UnifyBillEnum applyBillInfoEnum = UnifyBillEnum.TP;
        UnifyRuleCalEntryEnum unifyRuleCalEntryEnum = applyBillInfoEnum.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum();
        for (DynamicObject dynamicObject : allRule) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(applyBillInfoEnum.getUnifyPlanEnum().getRuleEnum().getCalEntry());
            for (DynamicObject entryRow : entryEntity) {
                DynamicObject type = entryRow.getDynamicObject(unifyRuleCalEntryEnum.getType());
                DynamicObject regulation = entryRow.getDynamicObject(unifyRuleCalEntryEnum.getAttPolicy());
                if (!Objects.nonNull(regulation)) continue;
                resultMap.put((Long)type.getPkValue(), (Long)regulation.getPkValue());
            }
        }
        return resultMap;
    }

    @Override
    public BillResponse checkAdviceAndAfter() {
        BillResponse billResponse = super.checkAdviceAndAfter();
        return billResponse;
    }

    private static String buildUnitInfoByBaseSet(Integer failCheckAdvanceAfterNum, String failCheckAdvanceAfterUnit) {
        String info = "";
        if (BaseSetUnitTypeEnum.DAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u81ea\u7136\u65e5", (String)"BustripEntityCheckService_3", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.MONTH.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u6708", (String)"BustripEntityCheckService_4", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.PERIOD.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u8003\u52e4\u671f\u95f4", (String)"BustripEntityCheckService_5", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        } else if (BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(failCheckAdvanceAfterUnit)) {
            info = ResManager.loadKDString((String)"{0}\u4e2a\u5de5\u4f5c\u65e5", (String)"BustripEntityCheckService_6", (String)"wtc-wtbs-business", (Object[])new Object[]{failCheckAdvanceAfterNum});
        }
        return info;
    }

    public void setFlagByBusTrip(boolean flagByBusTrip) {
        this.isFlagByBusTrip = flagByBusTrip;
    }
}

