/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.applybill.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.BiFunction;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.bill.BillEntryEntityVo;
import kd.wtc.wtbs.common.model.bill.VaInfoBo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.DateUtils;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailItemPreviewVo;
import kd.wtc.wtbs.wtabm.common.entity.VaDetailPreviewVo;

public class LactationCheckService {
    private static final Log LOG = LogFactory.getLog(LactationCheckService.class);
    private BiFunction<Long, Date, BillResponse> getMiddleDate;

    public LactationCheckService(BiFunction<Long, Date, BillResponse> getMiddleDate) {
        this.getMiddleDate = getMiddleDate;
    }

    public boolean isLactationOverlapping(BillEntryEntityVo vo1, BillEntryEntityVo vo2) {
        VaInfoBo otherBo;
        VaInfoBo lacBo;
        if (LactationCheckService.isLactation(vo1)) {
            lacBo = (VaInfoBo)vo1;
            otherBo = (VaInfoBo)vo2;
        } else if (LactationCheckService.isLactation(vo2)) {
            lacBo = (VaInfoBo)vo2;
            otherBo = (VaInfoBo)vo1;
        } else {
            return false;
        }
        if (DateUtils.truncatedCompareTo((Date)lacBo.getStartDate(), (Date)otherBo.getEndDate(), (int)5) > 0 || DateUtils.truncatedCompareTo((Date)lacBo.getEndDate(), (Date)otherBo.getStartDate(), (int)5) < 0) {
            return false;
        }
        if (LactationCheckService.isLactation((BillEntryEntityVo)otherBo)) {
            if (lacBo.getVacationType() == otherBo.getVacationType()) {
                LOG.info("\u540c\u79cd\u4f11\u5047\u7c7b\u578b\u7684\u54fa\u4e73\u5047\uff0c\u5982\u679c\u65e5\u671f\u91cd\u53e0\uff0c\u5219\u8ba4\u4e3a\u91cd\u53e0");
                return true;
            }
            for (VaDetailPreviewVo detailVo1 : lacBo.getDetailList()) {
                VaDetailPreviewVo detailVo2 = this.getLacDayDetail(otherBo, detailVo1.getDate());
                if (detailVo2 == null || !this.isOverlapping(this.getPeriods(detailVo1), this.getPeriods(detailVo2))) continue;
                return true;
            }
        } else {
            if (WtcTimeRangeBtnTypeEnum.DAY.value.equals(otherBo.getStartMethod())) {
                return true;
            }
            if (!DateUtils.isSameDay((Date)otherBo.getStartDate(), (Date)otherBo.getEndDate()) && !WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(otherBo.getStartMethod()) && WTCDateUtils.isOverlappingNotEquals((Date)lacBo.getStartDate(), (Date)lacBo.getEndDate(), (Date)otherBo.getStartDate(), (Date)otherBo.getEndDate())) {
                return true;
            }
            Date startDateMiddlePoint = WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(otherBo.getStartMethod()) ? null : this.getMiddlePoint(lacBo.getAttFileBoid(), otherBo.getStartDate());
            VaDetailPreviewVo startDateVo = this.getLacDayDetail(lacBo, otherBo.getStartDate());
            if (startDateVo != null && this.isOverlapping(otherBo.getStartMethod(), this.getPeriods(startDateVo), startDateMiddlePoint, otherBo)) {
                return true;
            }
            Date endDateMiddlePoint = WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(otherBo.getEndMethod()) ? null : this.getMiddlePoint(lacBo.getAttFileBoid(), otherBo.getEndDate());
            VaDetailPreviewVo endDateVo = this.getLacDayDetail(lacBo, otherBo.getEndDate());
            if (endDateVo != null && this.isOverlapping(otherBo.getEndMethod(), this.getPeriods(endDateVo), endDateMiddlePoint, otherBo)) {
                return true;
            }
        }
        return false;
    }

    private List<Tuple<Date, Date>> getPeriods(VaDetailPreviewVo vo) {
        ArrayList periods = Lists.newArrayListWithCapacity((int)10);
        for (VaDetailItemPreviewVo itemPreviewVo : vo.getItemVos()) {
            periods.add(new Tuple((Object)itemPreviewVo.getStartTime(), (Object)itemPreviewVo.getEndTime()));
        }
        return periods;
    }

    private VaDetailPreviewVo getLacDayDetail(VaInfoBo bo, Date date) {
        for (VaDetailPreviewVo vo : bo.getDetailList()) {
            if (!DateUtils.truncatedEquals((Date)vo.getDate(), (Date)date, (int)5)) continue;
            return vo;
        }
        return null;
    }

    private boolean isOverlapping(List<Tuple<Date, Date>> list1, List<Tuple<Date, Date>> list2) {
        for (Tuple<Date, Date> tuple1 : list1) {
            if (tuple1.item1 == null || tuple1.item2 == null) continue;
            for (Tuple<Date, Date> tuple2 : list2) {
                if (tuple2.item1 == null || tuple2.item2 == null || !WTCDateUtils.isOverlapping((Date)((Date)tuple1.item1), (Date)((Date)tuple1.item2), (Date)((Date)tuple2.item1), (Date)((Date)tuple2.item2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOverlapping(String method, List<Tuple<Date, Date>> periods, Date middlePoint, VaInfoBo otherBo) {
        if (middlePoint == null && (WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(method) || WtcTimeRangeBtnTypeEnum.HALF_DOWN.value.equals(method))) {
            return true;
        }
        if (WtcTimeRangeBtnTypeEnum.HALF_UP.value.equals(method) && periods.stream().filter(period -> period.item1 != null && period.item2 != null).anyMatch(period -> ((Date)period.item1).before(middlePoint))) {
            return true;
        }
        if (WtcTimeRangeBtnTypeEnum.HALF_DOWN.value.equals(method) && periods.stream().filter(period -> period.item1 != null && period.item2 != null).anyMatch(period -> ((Date)period.item2).after(middlePoint))) {
            return true;
        }
        return WtcTimeRangeBtnTypeEnum.CUSTOM.value.equals(method) && periods.stream().filter(period -> period.item1 != null && period.item2 != null).anyMatch(period -> WTCDateUtils.isOverlapping((Date)((Date)period.item1), (Date)((Date)period.item2), (Date)otherBo.getStartDate(), (Date)otherBo.getEndDate()));
    }

    private Date getMiddlePoint(long fileBoId, Date date) {
        BillResponse respStart = this.getMiddleDate.apply(fileBoId, DateUtils.truncate((Date)date, (int)5));
        if (respStart.isSuccess()) {
            return (Date)respStart.getData();
        }
        return null;
    }

    public static boolean isLactation(BillEntryEntityVo billEntryEntityVo) {
        return billEntryEntityVo instanceof VaInfoBo && "A".equals(((VaInfoBo)billEntryEntityVo).getSpecialVaType());
    }

    public static boolean isLactation(DynamicObject object) {
        return "A".equals(object.getString("specialvatype"));
    }

    public static void setLactationInfo(VaInfoBo bo) {
        bo.setStartMethod(WtcTimeRangeBtnTypeEnum.CUSTOM.value);
        bo.setEndMethod(WtcTimeRangeBtnTypeEnum.CUSTOM.value);
    }
}

