/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.attendperson;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.Entity;
import kd.wtc.wtbs.business.model.attendperson.AttendPerson;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.ContrWorkLoc;
import kd.wtc.wtbs.business.model.attendperson.EmpEntRel;
import kd.wtc.wtbs.business.model.attendperson.EmpJobRel;
import kd.wtc.wtbs.business.model.attendperson.EmpPosOrgRel;
import kd.wtc.wtbs.business.model.attendperson.Employee;
import kd.wtc.wtbs.business.model.attendperson.FertilityInfo;
import kd.wtc.wtbs.business.model.attendperson.PerNonTsProp;
import kd.wtc.wtbs.business.model.attendperson.PerTsProp;
import kd.wtc.wtbs.business.model.attendperson.Person;
import kd.wtc.wtbs.business.model.attendperson.TimeSeqHistory;
import kd.wtc.wtbs.business.model.attendperson.TrialPeriod;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.business.web.attendperson.IAttendPersonInitQueryService;
import kd.wtc.wtbs.common.model.attfileauth.AgreedLocation;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public abstract class AttendPersonInitQueryAbstractService
implements IAttendPersonInitQueryService {
    private static final Log logger = LogFactory.getLog(AttendPersonInitQueryAbstractService.class);

    protected void setEmpPosOrgRelData(Map<Long, List<DynamicObject>> empPosOrgRelGroupBy, AttendPerson attendPerson, List<CmpEmp> cmpEmpList, Map<Long, DynamicObject> depempGroupBy) {
        Set cmpEmpIdList = cmpEmpList.stream().map(TimeSeqVersion::getBid).collect(Collectors.toSet());
        HashMap empPosOrgRelMap = Maps.newHashMapWithExpectedSize((int)cmpEmpIdList.size());
        for (Long cmpEmpId : cmpEmpIdList) {
            List<DynamicObject> empPosOrgRelDyList = empPosOrgRelGroupBy.get(cmpEmpId);
            if (kd.bos.orm.util.CollectionUtils.isEmpty(empPosOrgRelDyList) || kd.bos.orm.util.CollectionUtils.isEmpty(empPosOrgRelDyList)) continue;
            HashMap empPosOrgRelTimeSeqMap = Maps.newHashMapWithExpectedSize((int)16);
            Map<Long, List<DynamicObject>> empPosOrgRelBoMap = empPosOrgRelDyList.stream().collect(Collectors.groupingBy(d -> d.getLong("boid")));
            for (Map.Entry<Long, List<DynamicObject>> entries : empPosOrgRelBoMap.entrySet()) {
                List<DynamicObject> value = entries.getValue();
                TimeSeqBo<EmpPosOrgRel> empPosOrgRelTimeSeqBo = this.getOneEmpPosOrgRelTimeSeqBo(value, depempGroupBy);
                empPosOrgRelTimeSeqMap.put(entries.getKey(), empPosOrgRelTimeSeqBo);
            }
            empPosOrgRelMap.put(cmpEmpId, empPosOrgRelTimeSeqMap);
        }
        attendPerson.setEmpPosOrgRelMap(empPosOrgRelMap);
    }

    protected TimeSeqBo<EmpPosOrgRel> getOneEmpPosOrgRelTimeSeqBo(List<DynamicObject> value, Map<Long, DynamicObject> depempGroupBy) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)value.size());
        for (DynamicObject empPosOrgRelObj : value) {
            EmpPosOrgRel empposorgrel = this.genEmpPosOrgRel(empPosOrgRelObj, depempGroupBy);
            list.add(empposorgrel);
        }
        return TimeSeqBo.ofMultiTimeSeq(list);
    }

    protected Person genPerson(DynamicObject personDy) {
        Person person = new Person();
        if (personDy != null) {
            person.setId(personDy.getLong("id"));
            person.setBid(personDy.getLong("boid"));
            person.setPersonIndexId(personDy.getLong("personindexid"));
            person.setHeadSculpture(personDy.getString("headsculpture"));
            person.setName(personDy.getString("name"));
            person.setNumber(personDy.getString("number"));
            person.setHrCreate(personDy.getBoolean("ishrcreate"));
        }
        return person;
    }

    protected PerNonTsProp genPerNonTsProp(Map<String, Object> perNonTsPropMap) {
        PerNonTsProp perNonTsProp = new PerNonTsProp();
        if (perNonTsPropMap != null) {
            perNonTsProp.setBeginServiceDate((Date)perNonTsPropMap.get("beginservicedate"));
            perNonTsProp.setFolk((Long)perNonTsPropMap.get("folk_id"));
            perNonTsProp.setGender((Long)perNonTsPropMap.get("gender_id"));
            perNonTsProp.setId((Long)perNonTsPropMap.get("id"));
            perNonTsProp.setNationality((Long)perNonTsPropMap.get("nationality_id"));
            perNonTsProp.setName((String)perNonTsPropMap.get("name"));
            perNonTsProp.setAge((Integer)perNonTsPropMap.get("age"));
            perNonTsProp.setBirthDay((Date)perNonTsPropMap.get("birthday"));
            perNonTsProp.setMarryDate((Date)perNonTsPropMap.get("marriageregistdate"));
        }
        return perNonTsProp;
    }

    protected TrialPeriod genTrialPeriod(DynamicObject dy) {
        TrialPeriod trialPeriod = new TrialPeriod();
        if (dy != null) {
            trialPeriod.setEntryDate(dy.getDate("entrydate"));
            trialPeriod.setRegularDate(dy.getDate("realregulardate"));
            trialPeriod.setPreregularDate(dy.getDate("preregulardate"));
        }
        return trialPeriod;
    }

    protected FertilityInfo genFertilityInfo(Map<String, Object> fertilityInfoMap) {
        FertilityInfo fertilityInfo = new FertilityInfo();
        if (fertilityInfoMap != null) {
            fertilityInfo.setBirthday((Date)fertilityInfoMap.get("birthday"));
            fertilityInfo.setChildrenNumber((Integer)fertilityInfoMap.get("childrennumber"));
            fertilityInfo.setId((Long)fertilityInfoMap.get("id"));
            fertilityInfo.setProcreatMode((Long)fertilityInfoMap.get("procreatmode_id"));
        }
        return fertilityInfo;
    }

    protected <T extends AbstractTimeSeqVersion> Map<Long, T> getCurrentEntityMap(Map<Long, List<Map<String, Object>>> entityListMap, BiFunction<TimeSeqInfoImpl, String, T> function) {
        HashMap entityCurrentMap = Maps.newHashMapWithExpectedSize((int)entityListMap.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entityEntries : entityListMap.entrySet()) {
            List<Map<String, Object>> entityList = entityEntries.getValue();
            Long boId = entityEntries.getKey();
            if (kd.bos.orm.util.CollectionUtils.isEmpty(entityList)) continue;
            Map<String, Object> objectMap = entityList.get(0);
            TimeSeqInfoImpl timeSeqInfo = this.getTimeSeqInfo(boId, objectMap);
            entityCurrentMap.put(boId, function.apply(timeSeqInfo, (String)objectMap.get("name")));
        }
        return entityCurrentMap;
    }

    protected TimeSeqInfoImpl getTimeSeqInfo(Long boId, Map<String, Object> entityMap) {
        return (TimeSeqInfoImpl)((Entity.Builder)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)((Entity.Builder)TimeSeqInfoImpl.with().bid(boId)).id((Long)entityMap.get("id"))).number(String.valueOf(boId))).bsed(WTCDateUtils.toLocalDate((Date)((Date)entityMap.get("bsed"))))).blsed(WTCDateUtils.toLocalDate((Date)((Date)entityMap.get("bsled"))))).build();
    }

    protected <T extends AbstractTimeSeqVersion> TimeSeqBo<T> getEntityTimeSeqBo(Map<Long, List<DynamicObject>> entityHisMap, Long personId, BiFunction<TimeSeqInfoImpl, DynamicObject, T> function) {
        List<DynamicObject> entityDyList = entityHisMap.get(personId);
        if (CollectionUtils.isNotEmpty(entityDyList)) {
            long boId = entityDyList.get(0).getLong("boid");
            entityDyList.removeIf(dy -> boId != dy.getLong("boid"));
        }
        ArrayList entityList = Lists.newArrayListWithExpectedSize((int)16);
        if (!kd.bos.orm.util.CollectionUtils.isEmpty(entityDyList)) {
            for (DynamicObject dy2 : entityDyList) {
                T apply = this.getEntityOneTimeSeqBo(dy2, function);
                entityList.add(apply);
            }
        }
        return TimeSeqBo.ofMultiTimeSeq(entityList);
    }

    protected <T extends AbstractTimeSeqVersion> Map<Long, TimeSeqBo<T>> getEntityTimeSeqBoMap(Map<Long, List<DynamicObject>> entityHisMap, Long personId, BiFunction<TimeSeqInfoImpl, DynamicObject, T> function) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        if (entityHisMap == null || entityHisMap.isEmpty()) {
            return resultMap;
        }
        List<DynamicObject> entityDyList = entityHisMap.get(personId);
        if (kd.bos.orm.util.CollectionUtils.isEmpty(entityDyList)) {
            return resultMap;
        }
        Map<Long, List<DynamicObject>> boDyMap = entityDyList.stream().collect(Collectors.groupingBy(d -> d.getLong("boid")));
        for (Map.Entry<Long, List<DynamicObject>> entries : boDyMap.entrySet()) {
            List<DynamicObject> value = entries.getValue();
            ArrayList entityList = Lists.newArrayListWithExpectedSize((int)value.size());
            for (DynamicObject dy : value) {
                T apply = this.getEntityOneTimeSeqBo(dy, function);
                entityList.add(apply);
            }
            if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)entityList)) continue;
            TimeSeqBo tTimeSeqBo = TimeSeqBo.ofMultiTimeSeq(entityList);
            resultMap.put(entries.getKey(), tTimeSeqBo);
        }
        return resultMap;
    }

    protected List<CmpEmp> getCmpEmpList(List<DynamicObject> manageScopesDyList) {
        ArrayList cmpEmpList = Lists.newArrayListWithExpectedSize((int)manageScopesDyList.size());
        for (DynamicObject dy : manageScopesDyList) {
            CmpEmp cmpemp = this.getEntityOneTimeSeqBo(dy, this::genCmpEmp);
            cmpEmpList.add(cmpemp);
        }
        return cmpEmpList;
    }

    protected CmpEmp genCmpEmp(TimeSeqInfoImpl timeSeqInfo, DynamicObject dy) {
        return CmpEmp.withTimeSeq(timeSeqInfo).person(dy.getLong("person.id")).employee(dy.getLong("employee.id")).managingScope(dy.getLong("managingscope.id")).primaryScope(dy.getString("isprimaryscope")).startDate(dy.getDate("startdate")).endDate(dy.getDate("enddate")).sysEndDate(dy.getDate("sysenddate")).lastWorkDate(dy.getDate("lastworkdate")).build();
    }

    protected <T extends AbstractTimeSeqVersion> T getEntityOneTimeSeqBo(DynamicObject dy, BiFunction<TimeSeqInfoImpl, DynamicObject, T> function) {
        Date startDate = dy.getDate("bsed");
        Date endDate = dy.getDate("bsled");
        TimeSeqHistory timeSeqHistory = this.getTimeSeqHistory(startDate, endDate, dy);
        timeSeqHistory.setNumber(String.valueOf(dy.getLong("boid")));
        TimeSeqInfoImpl timeSeqEntity = this.getTimeSeqEntity(timeSeqHistory);
        return (T)((AbstractTimeSeqVersion)function.apply(timeSeqEntity, dy));
    }

    private TimeSeqInfoImpl getTimeSeqEntity(TimeSeqHistory timeSeqHistory) {
        LocalDate bsled = WTCDateUtils.toLocalDate((Date)timeSeqHistory.getBsled());
        LocalDate bsed = WTCDateUtils.toLocalDate((Date)timeSeqHistory.getBsed());
        return (TimeSeqInfoImpl)((Entity.Builder)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)((Entity.Builder)((TimeSeqInfoImpl.Builder)TimeSeqInfoImpl.with().blsed(bsled)).bsed(bsed)).id(timeSeqHistory.getVid())).number(timeSeqHistory.getNumber())).bid(timeSeqHistory.getBoid())).build();
    }

    protected EmpPosOrgRel genEmpPosOrgRel(DynamicObject empPosOrgRelObj, Map<Long, DynamicObject> depempGroupBy) {
        Date startDateDy = empPosOrgRelObj.getDate("bsed");
        Date endDateDy = empPosOrgRelObj.getDate("bsled");
        String number = empPosOrgRelObj.getString("boid");
        TimeSeqHistory timeSeqHistory = new TimeSeqHistory();
        timeSeqHistory.setBoid(empPosOrgRelObj.getLong("boid"));
        timeSeqHistory.setVid(empPosOrgRelObj.getLong("id"));
        timeSeqHistory.setNumber(number);
        timeSeqHistory.setBsed(startDateDy);
        timeSeqHistory.setBsled(endDateDy);
        TimeSeqInfoImpl timeSeqEntity = this.getTimeSeqEntity(timeSeqHistory);
        DynamicObject depempDy = depempGroupBy.get(empPosOrgRelObj.getLong("depemp.id"));
        return EmpPosOrgRel.withTimeSeq(timeSeqEntity).person(empPosOrgRelObj.getLong("person.id")).employee(empPosOrgRelObj.getLong("employee.id")).cmpEmp(empPosOrgRelObj.getLong("cmpemp.id")).company(empPosOrgRelObj.getLong("company.id")).adminOrg(empPosOrgRelObj.getLong("adminorg.id")).position(empPosOrgRelObj.getLong("position.id")).job(empPosOrgRelObj.getLong("job.id")).primary(empPosOrgRelObj.getString("isprimary")).startDate(empPosOrgRelObj.getDate("startdate")).endDate(empPosOrgRelObj.getDate("enddate")).sysEndDate(empPosOrgRelObj.getDate("sysenddate")).posStatus(empPosOrgRelObj.getLong("posstatus.id")).posType(empPosOrgRelObj.getLong("postype.id")).workplace(empPosOrgRelObj.getLong("workplace.id")).depEmp(empPosOrgRelObj.getLong("depemp.id")).assignNo(depempDy == null ? "" : depempDy.getString("assignno")).serialNo(depempDy == null ? "" : depempDy.getString("serialno")).busiNumber(empPosOrgRelObj.getString("number")).build();
    }

    protected ContrWorkLoc genContrWorkLoc(TimeSeqInfoImpl timeSeqInfo, DynamicObject dy) {
        DynamicObject agreedLocation = dy.getDynamicObject("agreedlocation");
        AgreedLocation location = new AgreedLocation();
        if (agreedLocation != null) {
            location.setId(Long.valueOf(agreedLocation.getLong("id")));
            location.setNumber(agreedLocation.getString("number"));
            location.setName(agreedLocation.getString("name"));
        }
        return ContrWorkLoc.withTimeSeq(timeSeqInfo).agreedLocation(location).build();
    }

    protected Employee genEmployee(TimeSeqInfoImpl timeSeqInfo, DynamicObject dy) {
        return Employee.withTimeSeq(timeSeqInfo).startDate(dy.getDate("startdate")).endDate(dy.getDate("enddate")).sysEndDate(dy.getDate("sysenddate")).laborRelType(dy.getLong("laborreltype.id")).laborRelStatus(dy.getLong("laborrelstatus.id")).enterPrise(dy.getLong("enterprise.id")).lastWorkDate(dy.getDate("lastworkdate")).empNumber(dy.getString("empnumber")).firstEmployeeBid(dy.getLong("mid")).build();
    }

    protected EmpEntRel genEmpEntRel(TimeSeqInfoImpl timeSeqInfo, DynamicObject dy) {
        return EmpEntRel.withTimeSeq(timeSeqInfo).firstStartDate(dy.getDate("firststartdate")).startDate(dy.getDate("bsed")).laborRelStatus(dy.getLong("laborRelStatus.id")).oldEmpNumber(dy.getString("oldempnumber")).build();
    }

    protected TrialPeriod genTrialPeriod(TimeSeqInfoImpl timeSeqInfo, DynamicObject dy) {
        return TrialPeriod.withTimeSeq(timeSeqInfo).entryDate(dy.getDate("entrydate")).regularDate(dy.getDate("realregulardate")).preregularDate(dy.getDate("preregulardate")).build();
    }

    protected EmpJobRel genEmpJobRel(TimeSeqInfoImpl timeSeqInfo, DynamicObject dy) {
        return EmpJobRel.withTimeSeq(timeSeqInfo).company(dy.getLong("company.id")).adminOrg(dy.getLong("adminorg.id")).position(dy.getLong("position.id")).jobHr(dy.getLong("job.id")).job(dy.getLong("job.id")).jobLength(dy.getLong("jobLength")).hrBu(dy.getLong("hrbu.id")).jobClass(dy.getLong("jobClass.id")).jobFamily(dy.getLong("jobFamily.id")).jobSeq(dy.getLong("jobSeq.id")).startDate(dy.getDate("startdate")).endDate(dy.getDate("enddate")).jobLevel(dy.getLong("joblevel.id")).jobGrade(dy.getLong("jobgrade.id")).jobGrade(dy.getLong("jobgrade.id")).build();
    }

    protected PerTsProp genPerTsProp(TimeSeqInfoImpl timeSeqInfo, DynamicObject dy) {
        return PerTsProp.withTimeSeq(timeSeqInfo).marriageStatus(dy.getLong("marriagestatus.id")).build();
    }

    protected Map<Long, TimeSeqBo<CmpEmp>> getLongTimeSeqBoMap(List<CmpEmp> cmpEmpList) {
        Map<Long, List<CmpEmp>> cmpEmpMap = cmpEmpList.stream().collect(Collectors.groupingBy(TimeSeqVersion::getBid));
        HashMap cmpEmpMaps = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Long, List<CmpEmp>> entry : cmpEmpMap.entrySet()) {
            List<CmpEmp> cmpEmps = entry.getValue();
            TimeSeqBo<CmpEmp> list = TimeSeqBo.ofMultiTimeSeq(cmpEmps);
            cmpEmpMaps.put(entry.getKey(), list);
        }
        return cmpEmpMaps;
    }

    protected TimeSeqHistory getTimeSeqHistory(Date startDate, Date endDate, DynamicObject dynamicObject) {
        Long boId = dynamicObject.getLong("boid");
        Long vid = dynamicObject.getLong("id");
        TimeSeqHistory timeSeqHistory = new TimeSeqHistory();
        timeSeqHistory.setBoid(boId);
        timeSeqHistory.setVid(vid);
        timeSeqHistory.setBsed(startDate);
        timeSeqHistory.setBsled(endDate);
        return timeSeqHistory;
    }
}

