/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.attendperson;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AdminOrg;
import kd.wtc.wtbs.business.model.attendperson.AttendPerson;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrModel;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonHisResult;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonOtherInfo;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.Company;
import kd.wtc.wtbs.business.model.attendperson.ContrWorkLoc;
import kd.wtc.wtbs.business.model.attendperson.EmpEntRel;
import kd.wtc.wtbs.business.model.attendperson.EmpJobRel;
import kd.wtc.wtbs.business.model.attendperson.Employee;
import kd.wtc.wtbs.business.model.attendperson.FertilityInfo;
import kd.wtc.wtbs.business.model.attendperson.HRPIEntityPropertyConst;
import kd.wtc.wtbs.business.model.attendperson.Job;
import kd.wtc.wtbs.business.model.attendperson.PerTsProp;
import kd.wtc.wtbs.business.model.attendperson.Position;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonInitQueryAbstractService;
import kd.wtc.wtbs.business.web.attendperson.IAttendPersonService;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HBJMMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HBPMMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class AttendPersonServiceImpl
extends AttendPersonInitQueryAbstractService
implements IAttendPersonService {
    private static final String KEY_BIRTHDAY = "birthday";
    private static final Log logger = LogFactory.getLog(AttendPersonServiceImpl.class);
    private static final HRBaseServiceHelper attPersonHelper = new HRBaseServiceHelper("wtp_attendperson");
    private static final HRBaseServiceHelper depEmpJobPersonHelper = new HRBaseServiceHelper("wtp_depempjob");
    private static final HRBaseServiceHelper manageScopeHelper = new HRBaseServiceHelper("wtp_managescope");

    public static AttendPersonServiceImpl getInstance() {
        return (AttendPersonServiceImpl)WTCAppContextHelper.getBean(AttendPersonServiceImpl.class);
    }

    @Override
    public DynamicObject queryAttendPersonByPersonId(Long personId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("person", "=", (Object)personId)};
        return attPersonHelper.loadDynamicObject(qFilters);
    }

    @Override
    public DynamicObject[] batchQueryAttendPersonByPersonIds(Set<Long> personIds, QFilter qFilter) {
        QFilter[] qFilters = new QFilter[]{qFilter, new QFilter("person", "in", personIds)};
        return attPersonHelper.loadDynamicObjectArray(qFilters);
    }

    @Override
    public List<DynamicObject> queryCmpEmpByPersonId(Long personId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("attperson", "=", (Object)personId)};
        return Arrays.asList(manageScopeHelper.loadDynamicObjectArray(qFilters));
    }

    @Override
    public List<DynamicObject> queryEmpPosOrgRelByPersonId(Long personId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("attperson", "=", (Object)personId)};
        return Arrays.asList(depEmpJobPersonHelper.loadDynamicObjectArray(qFilters));
    }

    @Override
    public Map<Long, Map<String, Object>> queryFertilityInfoByPersonId(List<Long> personIdList, QFilter qFilter) {
        HRPIMServiceImpl hrPimService = HRPIMServiceImpl.getInstance();
        List<Map<String, Object>> fertilityInfo = hrPimService.listBatchPersonAttachs(personIdList, qFilter, "hrpi_fertilityinfo");
        return fertilityInfo.stream().filter(info -> info.get("person_id") != null).collect(Collectors.toMap(info -> (Long)info.get("person_id"), Function.identity(), (a, b) -> {
            if (a.get(KEY_BIRTHDAY) == null) {
                return b;
            }
            if (b.get(KEY_BIRTHDAY) == null) {
                return a;
            }
            return ((Date)a.get(KEY_BIRTHDAY)).after((Date)b.get(KEY_BIRTHDAY)) ? a : b;
        }));
    }

    @Override
    public AttendPersonHisResult getHisAttPersonInfo(List<Long> personIdList, Date startDate, Date endDate) {
        AttendPersonHisResult attendPersonHisResult = new AttendPersonHisResult();
        if (CollectionUtils.isEmpty(personIdList) || startDate == null || endDate == null) {
            return attendPersonHisResult;
        }
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        List<DynamicObject> personBaseInfo = hrpimService.listFieldsFilterInfoBatch("id", personIdList, StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.PERSON_SELECT_FIELDS), (String)","), null, "hrpi_person");
        Map personBaseInfoToMap = personBaseInfo.stream().filter(info -> info.get("id") != null).collect(Collectors.toMap(info -> (Long)info.get("id"), Function.identity(), (a, b) -> a));
        List<Map<String, Object>> fertilityInfo = hrpimService.listBatchPersonAttachs(personIdList, null, "hrpi_fertilityinfo");
        Map<Long, List<Map>> allFertilityInfoToMap = fertilityInfo.stream().filter(info -> info.get("person_id") != null).collect(Collectors.groupingBy(info -> (Long)info.get("person_id")));
        BinaryOperator mergerFun = (map1, map2) -> {
            long time1 = 0L;
            long time2 = 0L;
            if (map1.get(KEY_BIRTHDAY) != null) {
                time1 = ((Date)map1.get(KEY_BIRTHDAY)).getTime();
            }
            if (map2.get(KEY_BIRTHDAY) != null) {
                time2 = ((Date)map2.get(KEY_BIRTHDAY)).getTime();
            }
            return time1 >= time2 ? map1 : map2;
        };
        Map fertilityInfoToMap = fertilityInfo.stream().filter(info -> info.get("person_id") != null).collect(Collectors.toMap(info -> (Long)info.get("person_id"), Function.identity(), mergerFun));
        List<Map<String, Object>> perNotProp = hrpimService.listBatchPersonAttachs(personIdList, null, "hrpi_pernontsprop");
        Map perNotPropToMap = perNotProp.stream().filter(info -> info.get("person_id") != null).collect(Collectors.toMap(info -> (Long)info.get("person_id"), Function.identity(), (a, b) -> a));
        List<DynamicObject> perPropArr = hrpimService.listIntersectDataInfo("hrpi_pertsprop", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.PERTSPROP_FIELDS), (String)","), startDate, endDate, personIdList, null, null);
        Map<Long, List<DynamicObject>> perPropGroupBy = perPropArr.stream().collect(Collectors.groupingBy(d -> d.getLong("person.id")));
        List<DynamicObject> contrWorkLocArr = hrpimService.listIntersectDataInfo("hrpi_contrworkloc", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.CONTRWORKLOC_FIELDS), (String)","), startDate, endDate, personIdList, null, null);
        Map<Long, List<DynamicObject>> contrWorkLocArrGroupBy = contrWorkLocArr.stream().collect(Collectors.groupingBy(d -> d.getLong("person.id")));
        List<DynamicObject> employeeArr = hrpimService.listIntersectDataInfo("hrpi_employee", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPLOYEE_FIELDS), (String)","), startDate, endDate, personIdList, null, null);
        Map<Long, List<DynamicObject>> employeeGroupBy = employeeArr.stream().collect(Collectors.groupingBy(d -> d.getLong("person.id")));
        List<DynamicObject> depempArr = hrpimService.listIntersectBusinessInfo("hrpi_depemp", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.DEPEMP_FIELDS), (String)","), startDate, endDate, personIdList, null, null);
        Map<Long, DynamicObject> depempGroupBy = depempArr.stream().collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        List<DynamicObject> empentrelArr = hrpimService.listIntersectDataInfo("hrpi_empentrel", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPENTREL_FIELDS), (String)","), startDate, endDate, personIdList, null, null);
        Map<Long, List<DynamicObject>> empentrelGroupBy = empentrelArr.stream().collect(Collectors.groupingBy(d -> d.getLong("person.id")));
        QFilter personQFilter = new QFilter("person", "in", personIdList);
        DynamicObject[] trialPeriodArr = hrpimService.listFieldsFilterInfo(StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.TRIALPERIOD_FIELDS), (String)","), personQFilter, "hrpi_trialperiod");
        Map trialPeriodGroupBy = Arrays.stream(trialPeriodArr).collect(Collectors.toMap(d -> d.getLong("employee.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        List<DynamicObject> empJobRelArr = hrpimService.listIntersectDataInfo("hrpi_empjobrel", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPJOBREL_FIELDS), (String)","), startDate, endDate, personIdList, null, null);
        Map<Long, List<DynamicObject>> empJobRelGroupBy = empJobRelArr.stream().collect(Collectors.groupingBy(d -> d.getLong("person.id")));
        List<DynamicObject> cpmepmArr = hrpimService.listIntersectDataInfo("hrpi_cmpemp", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.CPMEPM_FIELDS), (String)","), startDate, endDate, personIdList, null, null);
        Map<Long, List<DynamicObject>> cpmepmGroupBy = cpmepmArr.stream().collect(Collectors.groupingBy(d -> d.getLong("person.id")));
        List<DynamicObject> empPosOrgRelArr = hrpimService.listIntersectDataInfo("hrpi_empposorgrel", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPPOSORGREL_FIELDS), (String)","), startDate, endDate, personIdList, null, null);
        Map<Long, List<DynamicObject>> empPosOrgRelGroupBy = empPosOrgRelArr.stream().collect(Collectors.groupingBy(d -> d.getLong("cmpemp.id")));
        ArrayList attendPeopleList = Lists.newArrayListWithExpectedSize((int)16);
        HashSet<Long> personIdSet = new HashSet<Long>(personIdList);
        DynamicObject[] attendPersonDys = this.batchQueryAttendPersonByPersonIds(personIdSet, null);
        Map<Long, DynamicObject> attendPersonMap = Arrays.stream(attendPersonDys).collect(Collectors.toMap(dy -> WTCDynamicObjectUtils.getBaseDataId(dy, "person"), dy -> dy));
        for (Long personId : personIdSet) {
            AttendPerson attendPerson = new AttendPerson(Boolean.TRUE);
            try {
                attendPerson.setPerson(this.genPerson((DynamicObject)personBaseInfoToMap.get(personId)));
                Map<Long, TimeSeqBo<Employee>> employeeMap = this.getEntityTimeSeqBoMap(employeeGroupBy, personId, this::genEmployee);
                attendPerson.setEmployeeMap(employeeMap);
                TimeSeqBo<Employee> employeeTimeSeqBoList = this.getEntityTimeSeqBo(employeeGroupBy, personId, this::genEmployee);
                attendPerson.setEmployeeList(employeeTimeSeqBoList);
                for (TimeSeqBo<Employee> value : employeeMap.values()) {
                    List<DynamicObject> empJobRelDyList;
                    List<DynamicObject> contrWorkLocDyList;
                    DynamicObject trialPeriodDynamicObject;
                    List<DynamicObject> empentrelDyList;
                    List<Employee> versions = value.getVersions();
                    if (WTCCollections.isEmpty(versions)) continue;
                    long employeeId = versions.get(0).getBid();
                    if (empentrelGroupBy != null && kd.bos.util.CollectionUtils.isNotEmpty(empentrelDyList = empentrelGroupBy.get(personId))) {
                        Map<Long, List<DynamicObject>> entRelMap = empentrelGroupBy.get(personId).stream().filter(entityDy -> employeeId == WTCDynamicObjectUtils.getBaseDataId(entityDy, "employee")).collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId(dy, "person")));
                        Map<Long, TimeSeqBo<EmpEntRel>> entRelTimeSeqBoMap = this.getEntityTimeSeqBoMap(entRelMap, personId, this::genEmpEntRel);
                        versions.forEach(versionData -> versionData.setEmpEntRelMap(entRelTimeSeqBoMap));
                    }
                    if (trialPeriodGroupBy != null && (trialPeriodDynamicObject = (DynamicObject)trialPeriodGroupBy.get(employeeId)) != null) {
                        versions.forEach(versionData -> versionData.setTrialPeriod(this.genTrialPeriod(trialPeriodDynamicObject)));
                    }
                    if (contrWorkLocArrGroupBy != null && kd.bos.util.CollectionUtils.isNotEmpty(contrWorkLocDyList = contrWorkLocArrGroupBy.get(personId))) {
                        Map<Long, List<DynamicObject>> contrWorkLocMap = contrWorkLocArrGroupBy.get(personId).stream().filter(entityDy -> employeeId == WTCDynamicObjectUtils.getBaseDataId(entityDy, "employee")).collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId(dy, "person")));
                        Map<Long, TimeSeqBo<ContrWorkLoc>> contrWorkLocTimeSeqBoMap = this.getEntityTimeSeqBoMap(contrWorkLocMap, personId, this::genContrWorkLoc);
                        versions.forEach(versionData -> versionData.setContrWorkLocMap(contrWorkLocTimeSeqBoMap));
                    }
                    if (empJobRelGroupBy == null || !kd.bos.util.CollectionUtils.isNotEmpty(empJobRelDyList = empJobRelGroupBy.get(personId))) continue;
                    Map<Long, List<DynamicObject>> empJobRelGroupMap = empJobRelGroupBy.get(personId).stream().filter(entityDy -> employeeId == WTCDynamicObjectUtils.getBaseDataId(entityDy, "employee")).collect(Collectors.groupingBy(dy -> WTCDynamicObjectUtils.getBaseDataId(dy, "person")));
                    Map<Long, TimeSeqBo<EmpJobRel>> tempEmpJobRelGroupMap = this.getEntityTimeSeqBoMap(empJobRelGroupMap, personId, this::genEmpJobRel);
                    versions.forEach(versionData -> versionData.setEmpJobRelMap(tempEmpJobRelGroupMap));
                }
                Map fertilityInfoMap = (Map)fertilityInfoToMap.get(personId);
                attendPerson.setFertilityInfo(this.genFertilityInfo(fertilityInfoMap));
                List<Map> fertilityInfoList = allFertilityInfoToMap.get(personId);
                if (kd.bos.util.CollectionUtils.isNotEmpty(fertilityInfoList)) {
                    List<FertilityInfo> curFertilityInfoList = fertilityInfoList.stream().map(this::genFertilityInfo).collect(Collectors.toList());
                    attendPerson.setFertilityInfoList(curFertilityInfoList);
                }
                Map perNotPropMap = (Map)perNotPropToMap.get(personId);
                attendPerson.setPerNonTsProp(this.genPerNonTsProp(perNotPropMap));
                TimeSeqBo<PerTsProp> perTsPropTimeSeqBoList = this.getEntityTimeSeqBo(perPropGroupBy, personId, this::genPerTsProp);
                attendPerson.setPerTsPropList(perTsPropTimeSeqBoList);
                TimeSeqBo<ContrWorkLoc> contrWorkLocTimeSeqBoList = this.getEntityTimeSeqBo(contrWorkLocArrGroupBy, personId, this::genContrWorkLoc);
                attendPerson.setContrWorkLocList(contrWorkLocTimeSeqBoList);
                TimeSeqBo<EmpEntRel> empEntRelTimeSeqBoList = this.getEntityTimeSeqBo(empentrelGroupBy, personId, this::genEmpEntRel);
                attendPerson.setEmpEntRelList(empEntRelTimeSeqBoList);
                Map<Long, TimeSeqBo<EmpJobRel>> empJobRelTimeSeqBoMap = this.getEntityTimeSeqBoMap(empJobRelGroupBy, personId, this::genEmpJobRel);
                attendPerson.setEmpJobRelMap(empJobRelTimeSeqBoMap);
                List<DynamicObject> manageScopesDyList = cpmepmGroupBy.get(personId);
                if (manageScopesDyList != null) {
                    List<CmpEmp> cmpEmpList = this.getCmpEmpList(manageScopesDyList);
                    Map<Long, TimeSeqBo<CmpEmp>> cmpEmpMaps = this.getLongTimeSeqBoMap(cmpEmpList);
                    attendPerson.setCmpEmpMap(cmpEmpMaps);
                    this.setEmpPosOrgRelData(empPosOrgRelGroupBy, attendPerson, cmpEmpList, depempGroupBy);
                }
                if (attendPersonMap.get(personId) != null) {
                    DynamicObject personInfo = attendPersonMap.get(personId);
                    attendPerson.setEarliestAttendDate(personInfo.getDate("earliestattenddate"));
                    attendPerson.setLatestAttendDate(personInfo.getDate("latestattenddate"));
                }
            }
            catch (Exception exception) {
                logger.error("AttendPerson init error personId = {}", (Object)personId);
                logger.error((Throwable)exception);
                attendPerson.setInitSuccess(Boolean.FALSE);
            }
            attendPeopleList.add(attendPerson);
        }
        Set companySet = empPosOrgRelArr.stream().map(dynamicObject -> dynamicObject.getLong("company.id")).collect(Collectors.toSet());
        Set adminOrgSet = empPosOrgRelArr.stream().map(dynamicObject -> dynamicObject.getLong("adminorg.id")).collect(Collectors.toSet());
        Set positionSet = empPosOrgRelArr.stream().map(dynamicObject -> dynamicObject.getLong("position.id")).collect(Collectors.toSet());
        Set jobSet = empPosOrgRelArr.stream().map(dynamicObject -> dynamicObject.getLong("job.id")).collect(Collectors.toSet());
        HAOSMServiceImpl instanceHaos = HAOSMServiceImpl.getInstance();
        attendPersonHisResult.setCompanyMap(this.getTimeSeqBoMap(instanceHaos.batchGetOrgInfo(startDate, endDate, new ArrayList<Long>(companySet)), this::genCompany));
        attendPersonHisResult.setAdminOrgMap(this.getTimeSeqBoMap(instanceHaos.batchGetOrgInfo(startDate, endDate, new ArrayList<Long>(adminOrgSet)), this::genAdminOrg));
        attendPersonHisResult.setPositionMap(this.getTimeSeqBoMap(HBPMMServiceImpl.getInstance().queryPositionHisVersion(startDate, endDate, new ArrayList<Long>(positionSet)), this::genPosition));
        attendPersonHisResult.setJobMap(this.getTimeSeqBoMap(HBJMMServiceImpl.getInstance().getJobVersionChangeInfoByEventId(startDate, endDate, new ArrayList<Long>(jobSet)), this::genJob));
        attendPersonHisResult.setAttendPeople(attendPeopleList);
        if (logger.isInfoEnabled()) {
            logger.info("getHisAttPersonInfo AttendPersonHisResult{}", (Object)JSON.toJSONString((Object)attendPersonHisResult));
        }
        return attendPersonHisResult;
    }

    @Override
    public AttendPersonCurrResult getCurrentAttPerson(List<Long> personIdList) {
        return this.getCurrentAttPersonByEmpRel(personIdList, null);
    }

    @Override
    public AttendPersonCurrResult getCurrentAttPersonByEmpRel(List<Long> personIdList, List<Long> empPosOrgRelId) {
        return this.getCurrentAttPersonByEmpRelCustom(personIdList, empPosOrgRelId, null);
    }

    @Override
    public AttendPersonCurrResult getCurrentAttPersonByEmpRelCustom(List<Long> personIdList, List<Long> empPosOrgRelId, Map<String, Object> inputParam) {
        List<Object> cpmepmArr;
        List<Object> empPosOrgRelArr;
        AttendPersonCurrResult attendPersonCurrResult = new AttendPersonCurrResult();
        if (CollectionUtils.isEmpty(personIdList)) {
            return attendPersonCurrResult;
        }
        HashSet<Long> collect = new HashSet<Long>(personIdList);
        personIdList = new ArrayList<Long>(collect);
        List employeeList = null;
        if (inputParam != null && inputParam.get("employee") != null && WTCCollections.isNotEmpty((Collection)((List)inputParam.get("employee")))) {
            employeeList = (List)inputParam.get("employee");
        }
        Date currentDate = new Date();
        ArrayList attendPersonCurrModels = Lists.newArrayListWithExpectedSize((int)personIdList.size());
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        List<DynamicObject> personBaseInfo = hrpimService.listFieldsFilterInfoBatch("id", personIdList, StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.PERSON_SELECT_FIELDS), (String)","), null, "hrpi_person");
        Map personBaseInfoToMap = personBaseInfo.stream().filter(info -> info.get("id") != null).collect(Collectors.toMap(info -> (Long)info.get("id"), Function.identity(), (a, b) -> a));
        List<Map<String, Object>> fertilityInfo = hrpimService.listBatchPersonAttachs(personIdList, null, "hrpi_fertilityinfo");
        Map fertilityInfoToMap = fertilityInfo.stream().filter(info -> info.get("person_id") != null).collect(Collectors.toMap(info -> (Long)info.get("person_id"), Function.identity(), (a, b) -> String.valueOf(a.get(KEY_BIRTHDAY)).compareTo(String.valueOf(b.get(KEY_BIRTHDAY))) > 0 ? a : b));
        Map<Long, List<Map>> fertilityInfoGroupBy = fertilityInfo.stream().filter(info -> info.get("person_id") != null).collect(Collectors.groupingBy(info -> (Long)info.get("person_id")));
        List<Map<String, Object>> perNotProp = hrpimService.listBatchPersonAttachs(personIdList, null, "hrpi_pernontsprop");
        Map perNotPropToMap = perNotProp.stream().filter(info -> info.get("person_id") != null).collect(Collectors.toMap(info -> (Long)info.get("person_id"), Function.identity(), (a, b) -> a));
        List<DynamicObject> perPropArr = hrpimService.listIntersectDataInfo("hrpi_pertsprop", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.PERTSPROP_FIELDS), (String)","), currentDate, currentDate, personIdList, null, null);
        Map perPropGroupBy = perPropArr.stream().collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        List<DynamicObject> contrWorkLocArr = hrpimService.listIntersectDataInfo("hrpi_contrworkloc", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.CONTRWORKLOC_FIELDS), (String)","), currentDate, currentDate, personIdList, employeeList, null);
        Map contrWorkLocArrGroupBy = contrWorkLocArr.stream().collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        List<DynamicObject> employeeArr = hrpimService.listIntersectDataInfo("hrpi_employee", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPLOYEE_FIELDS), (String)","), currentDate, currentDate, personIdList, null, null);
        List finalEmployeeList = employeeList;
        if (WTCCollections.isNotEmpty((Collection)employeeList)) {
            HashSet employeeSetFilter = new HashSet(employeeList);
            employeeArr.removeIf(d -> !employeeSetFilter.contains(d.getLong("boid")));
        }
        Map employeeGroupBy = employeeArr.stream().filter(dy -> kd.bos.util.CollectionUtils.isEmpty((Collection)finalEmployeeList) || finalEmployeeList.contains(dy.getLong("boid"))).collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("startdate").compareTo(item2.getDate("startdate")) >= 0 ? item1 : item2));
        List<DynamicObject> empentrelArr = hrpimService.listIntersectDataInfo("hrpi_empentrel", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPENTREL_FIELDS), (String)","), currentDate, currentDate, personIdList, employeeList, null);
        Map empentrelGroupBy = empentrelArr.stream().collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        QFilter personQFilter = new QFilter("person", "in", personIdList);
        DynamicObject[] trialPeriodArr = hrpimService.listFieldsFilterInfo(StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.TRIALPERIOD_FIELDS), (String)","), personQFilter, "hrpi_trialperiod");
        Map trialPeriodGroupBy = Arrays.stream(trialPeriodArr).collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        List<DynamicObject> empJobRelArr = hrpimService.listIntersectBusinessInfo("hrpi_empjobrel", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPJOBREL_FIELDS), (String)","), currentDate, currentDate, personIdList, employeeList, null);
        Map empJobRelGroupBy = empJobRelArr.stream().filter(d -> "1".equals(d.getString("businessstatus"))).collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (a, b) -> a));
        if (CollectionUtils.isEmpty(empPosOrgRelId)) {
            empPosOrgRelArr = hrpimService.listIntersectBusinessInfo("hrpi_empposorgrel", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPPOSORGREL_FIELDS), (String)","), currentDate, currentDate, personIdList, employeeList, null);
        } else {
            HashSet<Long> empPosOrgRelSet = new HashSet<Long>(empPosOrgRelId);
            empPosOrgRelArr = hrpimService.listIntersectBusinessInfo("hrpi_empposorgrel", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPPOSORGREL_FIELDS), (String)","), WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), personIdList, employeeList, null).stream().filter(d -> "1".equals(d.getString("datastatus")) && empPosOrgRelSet.contains(d.getLong("boid"))).collect(Collectors.toList());
        }
        List<DynamicObject> depempArr = hrpimService.listIntersectBusinessInfo("hrpi_depemp", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.DEPEMP_FIELDS), (String)","), WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), personIdList, employeeList, null);
        Map depempGroupBy = depempArr.stream().collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        Map<Object, List<DynamicObject>> empPosOrgRelGroupBy = empPosOrgRelArr.stream().collect(Collectors.groupingBy(d -> d.getLong("person.id")));
        if (CollectionUtils.isEmpty(empPosOrgRelId)) {
            cpmepmArr = hrpimService.listIntersectBusinessInfo("hrpi_cmpemp", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.CPMEPM_FIELDS), (String)","), currentDate, currentDate, personIdList, employeeList, null);
        } else {
            Set cpmepmSetId = empPosOrgRelArr.stream().map(d -> d.getLong("cmpemp.id")).collect(Collectors.toSet());
            cpmepmArr = hrpimService.listIntersectBusinessInfo("hrpi_cmpemp", StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.CPMEPM_FIELDS), (String)","), WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), personIdList, employeeList, null).stream().filter(d -> "1".equals(d.getString("datastatus")) && cpmepmSetId.contains(d.getLong("boid"))).collect(Collectors.toList());
        }
        Map<Object, List<DynamicObject>> cpmepmGroupBy = cpmepmArr.stream().collect(Collectors.groupingBy(d -> d.getLong("person.id")));
        for (Long personId : personIdList) {
            AttendPersonCurrModel attendPersonCurrModel = new AttendPersonCurrModel();
            if (personBaseInfoToMap.get(personId) != null) {
                attendPersonCurrModel.setPerson(this.genPerson((DynamicObject)personBaseInfoToMap.get(personId)));
            }
            if (fertilityInfoToMap.get(personId) != null) {
                attendPersonCurrModel.setFertilityInfo(this.genFertilityInfo((Map)fertilityInfoToMap.get(personId)));
                if (fertilityInfoGroupBy.get(personId) != null) {
                    attendPersonCurrModel.setFertilityInfoList(fertilityInfoGroupBy.get(personId).stream().map(this::genFertilityInfo).collect(Collectors.toList()));
                }
            }
            if (perNotPropToMap.get(personId) != null) {
                attendPersonCurrModel.setPerNonTsProp(this.genPerNonTsProp((Map)perNotPropToMap.get(personId)));
            }
            if (perPropGroupBy.get(personId) != null) {
                attendPersonCurrModel.setPerTsProp(this.getEntityOneTimeSeqBo((DynamicObject)perPropGroupBy.get(personId), this::genPerTsProp));
            }
            if (contrWorkLocArrGroupBy.get(personId) != null) {
                attendPersonCurrModel.setContrWorkLoc(this.getEntityOneTimeSeqBo((DynamicObject)contrWorkLocArrGroupBy.get(personId), this::genContrWorkLoc));
            }
            if (employeeGroupBy.get(personId) != null) {
                attendPersonCurrModel.setEmployee(this.getEntityOneTimeSeqBo((DynamicObject)employeeGroupBy.get(personId), this::genEmployee));
            }
            if (empentrelGroupBy.get(personId) != null) {
                attendPersonCurrModel.setEmpEntRel(this.getEntityOneTimeSeqBo((DynamicObject)empentrelGroupBy.get(personId), this::genEmpEntRel));
            }
            if (trialPeriodGroupBy.get(personId) != null) {
                attendPersonCurrModel.setTrialPeriod(this.getEntityOneTimeSeqBo((DynamicObject)trialPeriodGroupBy.get(personId), this::genTrialPeriod));
            }
            if (empJobRelGroupBy.get(personId) != null) {
                attendPersonCurrModel.setEmpJobRel(this.getEntityOneTimeSeqBo((DynamicObject)empJobRelGroupBy.get(personId), this::genEmpJobRel));
            }
            if (cpmepmGroupBy.get(personId) != null) {
                attendPersonCurrModel.setCmpEmpList(cpmepmGroupBy.get(personId).stream().map(cmpemp -> this.getEntityOneTimeSeqBo((DynamicObject)cmpemp, this::genCmpEmp)).collect(Collectors.toList()));
            }
            if (empPosOrgRelGroupBy.get(personId) != null) {
                attendPersonCurrModel.setEmpPosOrgRelList(empPosOrgRelGroupBy.get(personId).stream().map(empPosOrgRel -> this.genEmpPosOrgRel((DynamicObject)empPosOrgRel, depempGroupBy)).collect(Collectors.toList()));
            }
            attendPersonCurrModels.add(attendPersonCurrModel);
        }
        attendPersonCurrResult.setAttendPersonCurrModels(attendPersonCurrModels);
        Set companySet = empPosOrgRelArr.stream().map(dynamicObject -> dynamicObject.getLong("company.id")).collect(Collectors.toSet());
        Set adminOrgSet = empPosOrgRelArr.stream().map(dynamicObject -> dynamicObject.getLong("adminorg.id")).collect(Collectors.toSet());
        Set positionSet = empPosOrgRelArr.stream().map(dynamicObject -> dynamicObject.getLong("position.id")).collect(Collectors.toSet());
        Set jobSet = empPosOrgRelArr.stream().map(dynamicObject -> dynamicObject.getLong("job.id")).collect(Collectors.toSet());
        HAOSMServiceImpl instanceHaos = HAOSMServiceImpl.getInstance();
        attendPersonCurrResult.setAdminOrgMap(this.getCurrentEntityMap(instanceHaos.batchGetOrgInfo(currentDate, currentDate, new ArrayList<Long>(adminOrgSet)), this::genAdminOrg));
        attendPersonCurrResult.setCompanyMap(this.getCurrentEntityMap(instanceHaos.batchGetOrgInfo(currentDate, currentDate, new ArrayList<Long>(companySet)), this::genCompany));
        HBJMMServiceImpl instanceHBJM = HBJMMServiceImpl.getInstance();
        attendPersonCurrResult.setPositionMap(this.getCurrentEntityMap(HBPMMServiceImpl.getInstance().queryPositionHisVersion(currentDate, currentDate, new ArrayList<Long>(positionSet)), this::genPosition));
        attendPersonCurrResult.setJobMap(this.getCurrentEntityMap(instanceHBJM.getJobVersionChangeInfoByEventId(currentDate, currentDate, new ArrayList<Long>(jobSet)), this::genJob));
        if (logger.isInfoEnabled()) {
            logger.info("getCurrentAttPersonByEmpRel AttendPersonCurrResult {}", (Object)JSON.toJSONString((Object)attendPersonCurrResult));
        }
        return attendPersonCurrResult;
    }

    @Override
    public DynamicObject[] queryAttendPersonByPersonIds(List<Long> personIdList, String properties) {
        logger.info("AttendPersonServiceImpl.queryAttendPersonByPersonId, personId->{}, properties->{}, qFilter->{}", personIdList, (Object)properties);
        QFilter[] qFilters = new QFilter[]{new QFilter("person", "in", personIdList)};
        return HRStringUtils.isEmpty((String)properties) ? attPersonHelper.loadDynamicObjectArray(qFilters) : attPersonHelper.queryOriginalArray(properties, qFilters);
    }

    @Override
    public Map<Long, AttendPersonOtherInfo> batchQueryAttPersonOtherInfoByPersonIds(List<Long> personIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attperotherinfo");
        QFilter qFilter = new QFilter("person", "in", personIds);
        DynamicObject[] dys = helper.queryOriginalArray("person.id, qtfirsteffectdate", new QFilter[]{qFilter});
        if (dys != null && dys.length > 0) {
            return Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> AttendPersonOtherInfo.create().qtFirstEffectDate(dy.getDate("qtfirsteffectdate")).build(), (a, b) -> a));
        }
        return Maps.newHashMapWithExpectedSize((int)1);
    }

    public <T extends AbstractTimeSeqVersion> Map<Long, TimeSeqBo<T>> getTimeSeqBoMap(Map<Long, List<Map<String, Object>>> entityListMap, BiFunction<TimeSeqInfoImpl, String, T> function) {
        HashMap entityTimeSeqBoMap = Maps.newHashMapWithExpectedSize((int)entityListMap.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entityEntries : entityListMap.entrySet()) {
            List<Map<String, Object>> entityMapList = entityEntries.getValue();
            Long boId = entityEntries.getKey();
            ArrayList companyList = Lists.newArrayListWithExpectedSize((int)entityMapList.size());
            for (Map<String, Object> entityMap : entityMapList) {
                TimeSeqInfoImpl timeSeqInfo = this.getTimeSeqInfo(boId, entityMap);
                companyList.add(function.apply(timeSeqInfo, (String)entityMap.get("name")));
            }
            try {
                entityTimeSeqBoMap.put(boId, TimeSeqBo.ofMultiTimeSeq(companyList));
            }
            catch (Exception exception) {
                logger.error((Throwable)exception);
                logger.error("getTimeSeqBoMap error boId = {}", (Object)boId);
            }
        }
        return entityTimeSeqBoMap;
    }

    public Company genCompany(TimeSeqInfoImpl timeSeqInfo, String name) {
        return Company.withTimeSeq(timeSeqInfo).name(name).build();
    }

    public AdminOrg genAdminOrg(TimeSeqInfoImpl timeSeqInfo, String name) {
        return AdminOrg.withTimeSeq(timeSeqInfo).name(name).build();
    }

    public Position genPosition(TimeSeqInfoImpl timeSeqInfo, String name) {
        return Position.withTimeSeq(timeSeqInfo).name(name).build();
    }

    public Job genJob(TimeSeqInfoImpl timeSeqInfo, String name) {
        return Job.withTimeSeq(timeSeqInfo).name(name).build();
    }
}

