/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.attendperson;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrModel;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.ContrWorkLoc;
import kd.wtc.wtbs.business.model.attendperson.EmpEntRel;
import kd.wtc.wtbs.business.model.attendperson.EmpJobRel;
import kd.wtc.wtbs.business.model.attendperson.EmpPosOrgRel;
import kd.wtc.wtbs.business.model.attendperson.Employee;
import kd.wtc.wtbs.business.model.attendperson.FertilityInfo;
import kd.wtc.wtbs.business.model.attendperson.PerNonTsProp;
import kd.wtc.wtbs.business.model.attendperson.PerTsProp;
import kd.wtc.wtbs.business.model.attendperson.Person;
import kd.wtc.wtbs.business.model.attendperson.TrialPeriod;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class AttendPersonSynService {
    private static final Log logger = LogFactory.getLog(AttendPersonSynService.class);
    private static final HRBaseServiceHelper attPersonHelper = new HRBaseServiceHelper("wtp_attendperson");
    private static final HRBaseServiceHelper dePeMpJobPersonHelper = new HRBaseServiceHelper("wtp_depempjob");
    private static final HRBaseServiceHelper manageScopeHelper = new HRBaseServiceHelper("wtp_managescope");
    private static final HRBaseServiceHelper wtpTrialPeriodHelper = new HRBaseServiceHelper("wtp_fertilityinfo");

    public static AttendPersonSynService getInstance() {
        return (AttendPersonSynService)WTCAppContextHelper.getBean(AttendPersonSynService.class);
    }

    public AttendPersonCurrResult checkAndGetPersonData(List<Long> personIds, List<Long> empPosOrgRelIdList, Map<Long, String> warnInfoMap) {
        return this.checkAndGetPersonDataCustom(personIds, empPosOrgRelIdList, warnInfoMap, null);
    }

    public AttendPersonCurrResult checkAndGetPersonDataCustom(List<Long> personIds, List<Long> empPosOrgRelIdList, Map<Long, String> warnInfoMap, Map<String, Object> inputParamMap) {
        List<AttendPersonCurrModel> attendPersonModelList;
        AttendPersonCurrResult attendPersonCurrResult = AttendPersonServiceImpl.getInstance().getCurrentAttPersonByEmpRelCustom(personIds, empPosOrgRelIdList, inputParamMap);
        if (warnInfoMap == null) {
            warnInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        if (CollectionUtils.isEmpty(attendPersonModelList = attendPersonCurrResult.getAttendPersonCurrModels())) {
            warnInfoMap.put(0L, "attPersonData not find");
            return attendPersonCurrResult;
        }
        Iterator<AttendPersonCurrModel> iterator = attendPersonModelList.iterator();
        while (iterator.hasNext()) {
            AttendPersonCurrModel attendPersonModel = iterator.next();
            Long personId = this.getPersonId(attendPersonModel);
            if (personId == null || personId == 0L) {
                warnInfoMap.put(0L, "personId not find");
                iterator.remove();
                continue;
            }
            attendPersonModel.setBoid(personId);
            Person person = attendPersonModel.getPerson();
            if (person == null || WTCStringUtils.isEmpty((String)person.getNumber())) {
                warnInfoMap.put(personId, "person number not find");
                iterator.remove();
                continue;
            }
            List<EmpPosOrgRel> empPosOrgRelList = attendPersonModel.getEmpPosOrgRelList();
            if (inputParamMap != null && Boolean.TRUE == inputParamMap.get("ignorecheckrel")) continue;
            List<CmpEmp> cmpempList = attendPersonModel.getCmpEmpList();
            if (cmpempList == null) {
                warnInfoMap.put(personId, "cmpemp not find");
                iterator.remove();
                continue;
            }
            long cmpEmpErrorNum = cmpempList.stream().filter(empPosOrgRel -> empPosOrgRel.getBid() == 0L || empPosOrgRel.getEmployee() == 0L).count();
            if (cmpEmpErrorNum > 0L) {
                warnInfoMap.put(personId, "cmpempId not find or employeeId not find");
                iterator.remove();
                continue;
            }
            if (empPosOrgRelList == null) {
                warnInfoMap.put(personId, "empposorgrel not find");
                iterator.remove();
                continue;
            }
            long empPosOrgRelErrorNum = empPosOrgRelList.stream().filter(empPosOrgRel -> empPosOrgRel.getBid() == 0L || empPosOrgRel.getEmployee() == 0L).count();
            if (empPosOrgRelErrorNum <= 0L) continue;
            warnInfoMap.put(personId, "empposorgrelId or employeeId not find");
            iterator.remove();
        }
        logger.info("warnInfoMap:{}", (Object)JSON.toJSONString((Object)warnInfoMap));
        return attendPersonCurrResult;
    }

    public void updateAttPerson(AttendPersonCurrResult attendPersonCurrResult) {
        List<AttendPersonCurrModel> successAttendPersonList = attendPersonCurrResult.getAttendPersonCurrModels();
        this.dealAttendPerson(successAttendPersonList, true);
        this.dealCmPeMp(successAttendPersonList, true);
        this.dealEmpPosOrgRel(successAttendPersonList, true);
        this.dealtFertilityInfoList(successAttendPersonList, true);
    }

    public List<DynamicObject> dealAttendPerson(List<AttendPersonCurrModel> attendPersonCurrModels, boolean doOrmData) {
        if (CollectionUtils.isEmpty(attendPersonCurrModels)) {
            return Collections.emptyList();
        }
        ArrayList resultDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList insertDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList updateDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        List<Long> pendingIdList = attendPersonCurrModels.stream().map(personData -> personData.getPerson().getBid()).collect(Collectors.toList());
        DynamicObject[] existDys = AttendPersonServiceImpl.getInstance().queryAttendPersonByPersonIds(pendingIdList, null);
        Map existDyMap = Arrays.stream(existDys).collect(Collectors.toMap(existDy -> existDy.getLong("id"), Function.identity(), (a, b) -> a));
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_attendperson");
        for (AttendPersonCurrModel attendPersonCurrModel : attendPersonCurrModels) {
            Long boId = attendPersonCurrModel.getBoid();
            DynamicObject dynamicObject = (DynamicObject)existDyMap.get(boId);
            if (dynamicObject != null) {
                this.setAttPersonDetailProps(dynamicObject, attendPersonCurrModel);
                updateDyData.add(dynamicObject);
                continue;
            }
            DynamicObject attPersonObject = new DynamicObject((DynamicObjectType)dataEntityType);
            this.setAttPersonDetailProps(attPersonObject, attendPersonCurrModel);
            attPersonObject.set("id", (Object)attendPersonCurrModel.getPerson().getBid());
            insertDyData.add(attPersonObject);
        }
        if (doOrmData) {
            if (!CollectionUtils.isEmpty((Collection)insertDyData)) {
                attPersonHelper.save(insertDyData.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)updateDyData)) {
                attPersonHelper.update(updateDyData.toArray(new DynamicObject[0]));
            }
        }
        resultDyData.addAll(insertDyData);
        resultDyData.addAll(updateDyData);
        return resultDyData;
    }

    private void setFertilityInfo(FertilityInfo fertilityInfo, DynamicObject attPersonObject) {
        if (fertilityInfo != null) {
            WtbsBusinessUtils.propertyCopyToDynamicObject(fertilityInfo, attPersonObject);
        }
    }

    private void setAttPersonDetailProps(DynamicObject attPersonObject, AttendPersonCurrModel updateCurModel) {
        this.setPntProp(updateCurModel.getPerNonTsProp(), attPersonObject);
        attPersonObject.set("birthday", null);
        this.setPtProp(updateCurModel.getPerTsProp(), attPersonObject);
        this.setTrialPeriodProp(updateCurModel.getTrialPeriod(), attPersonObject);
        this.setEmployeeInfo(updateCurModel.getEmployee(), attPersonObject);
        this.setEmpentrelInfo(updateCurModel.getEmpEntRel(), attPersonObject);
        this.setEmpjobrelInfo(updateCurModel.getEmpJobRel(), attPersonObject);
        this.setFertilityInfo(updateCurModel.getFertilityInfo(), attPersonObject);
        Person person = updateCurModel.getPerson();
        WtbsBusinessUtils.propertyCopyToDynamicObject(person, attPersonObject);
        attPersonObject.set("number", (Object)person.getNumber());
        attPersonObject.set("name", (Object)person.getName());
        attPersonObject.set("personindexid", (Object)person.getPersonIndexId());
        ContrWorkLoc contrWorkLoc = updateCurModel.getContrWorkLoc();
        if (contrWorkLoc != null && contrWorkLoc.getAgreedLocation() != null) {
            attPersonObject.set("agreedlocation", (Object)contrWorkLoc.getAgreedLocation().getId());
        }
        attPersonObject.set("person", (Object)person.getBid());
        attPersonObject.set("earliestattenddate", (Object)updateCurModel.getEarliestAttendDate());
        attPersonObject.set("latestattenddate", (Object)updateCurModel.getLatestAttendDate());
    }

    private void setPntProp(PerNonTsProp pernontsProp, DynamicObject targetDO) {
        if (pernontsProp != null) {
            WtbsBusinessUtils.propertyCopyToDynamicObject(pernontsProp, targetDO);
        }
    }

    private void setPtProp(PerTsProp pertsProp, DynamicObject targetDO) {
        if (pertsProp != null) {
            WtbsBusinessUtils.propertyCopyToDynamicObject(pertsProp, targetDO);
        }
    }

    private void setTrialPeriodProp(TrialPeriod trialPeriod, DynamicObject targetDO) {
        if (trialPeriod != null) {
            WtbsBusinessUtils.propertyCopyToDynamicObject(trialPeriod, targetDO);
        } else {
            targetDO.set("entrydate", null);
            targetDO.set("regulardate", null);
            targetDO.set("preregulardate", null);
        }
    }

    private void setEmployeeInfo(Employee employee, DynamicObject attPersonObject) {
        if (employee != null) {
            WtbsBusinessUtils.propertyCopyToDynamicObject(employee, attPersonObject);
            attPersonObject.set("hirestartdate", (Object)employee.getStartDate());
            attPersonObject.set("hireenddate", (Object)employee.getEndDate());
            attPersonObject.set("resgndate", (Object)employee.getSysEndDate());
        }
    }

    private void setEmpentrelInfo(EmpEntRel empentrel, DynamicObject attPersonObject) {
        if (empentrel != null) {
            WtbsBusinessUtils.propertyCopyToDynamicObject(empentrel, attPersonObject);
        }
    }

    private void setEmpjobrelInfo(EmpJobRel empjobrel, DynamicObject attPersonObject) {
        if (empjobrel != null) {
            WtbsBusinessUtils.propertyCopyToDynamicObject(empjobrel, attPersonObject);
            attPersonObject.set("jobstartdate", (Object)empjobrel.getStartDate());
            attPersonObject.set("jobenddate", (Object)empjobrel.getEndDate());
            logger.info("\u5165\u5e93\u524d\u804c\u7ea7\u4fe1\u606f:{},{},{}", new Object[]{attPersonObject.get("jobhr"), attPersonObject.get("joblevel"), attPersonObject.get("jobgrade")});
        }
    }

    public List<DynamicObject> dealCmPeMp(List<AttendPersonCurrModel> attendPersonCurrModels, boolean doOrmData) {
        if (CollectionUtils.isEmpty(attendPersonCurrModels)) {
            return Collections.emptyList();
        }
        ArrayList resultDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList insertDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList updateDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList<Long> pendingIdList = new ArrayList<Long>();
        attendPersonCurrModels.forEach(dm -> pendingIdList.addAll(dm.getCmpEmpList().stream().map(TimeSeqVersion::getBid).collect(Collectors.toList())));
        DynamicObject[] existDys = this.queryCmPeMpList(pendingIdList);
        Map existDyMap = Arrays.stream(existDys).collect(Collectors.toMap(existDy -> existDy.getLong("id"), Function.identity(), (a, b) -> a));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_attendperson");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_managescope");
        for (AttendPersonCurrModel attendPersonCurrModel : attendPersonCurrModels) {
            List<CmpEmp> cmpEmpList = attendPersonCurrModel.getCmpEmpList();
            if (WTCCollections.isEmpty(cmpEmpList)) continue;
            for (CmpEmp cmpEmp : cmpEmpList) {
                Long boId = cmpEmp.getBid();
                DynamicObject dynamicObject = (DynamicObject)existDyMap.get(boId);
                if (dynamicObject != null) {
                    WtbsBusinessUtils.propertyCopyToDynamicObject(cmpEmp, dynamicObject);
                    updateDyData.add(dynamicObject);
                    continue;
                }
                DynamicObject manageScopeDO = new DynamicObject((DynamicObjectType)dataEntityType);
                WtbsBusinessUtils.propertyCopyToDynamicObject(cmpEmp, manageScopeDO);
                manageScopeDO.set("id", (Object)cmpEmp.getBid());
                manageScopeDO.set("person", (Object)attendPersonCurrModel.getBoid());
                DynamicObject attPersonDy = serviceHelper.generateEmptyDynamicObject();
                attPersonDy.set("id", (Object)attendPersonCurrModel.getBoid());
                manageScopeDO.set("attperson", (Object)attPersonDy);
                manageScopeDO.set("cmpemp", (Object)cmpEmp.getBid());
                Employee employee = attendPersonCurrModel.getEmployee();
                if (employee != null) {
                    manageScopeDO.set("employee", (Object)employee.getBid());
                }
                insertDyData.add(manageScopeDO);
            }
        }
        if (doOrmData) {
            if (!CollectionUtils.isEmpty((Collection)insertDyData)) {
                manageScopeHelper.save(insertDyData.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)updateDyData)) {
                manageScopeHelper.update(updateDyData.toArray(new DynamicObject[0]));
            }
        }
        resultDyData.addAll(insertDyData);
        resultDyData.addAll(updateDyData);
        return resultDyData;
    }

    public List<DynamicObject> dealtFertilityInfoList(List<AttendPersonCurrModel> attendPersonCurrModels, boolean doOrmData) {
        if (CollectionUtils.isEmpty(attendPersonCurrModels)) {
            return Collections.emptyList();
        }
        ArrayList resultDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList insertDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList updateDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList<Long> pendingIdList = new ArrayList<Long>();
        for (AttendPersonCurrModel tp : attendPersonCurrModels) {
            List<FertilityInfo> fertilityInfoList = tp.getFertilityInfoList();
            if (!WTCCollections.isNotEmpty(fertilityInfoList)) continue;
            pendingIdList.addAll(fertilityInfoList.stream().map(FertilityInfo::getId).collect(Collectors.toList()));
        }
        DynamicObject[] existDys = this.queryFyList(pendingIdList);
        Map existDyMap = Arrays.stream(existDys).collect(Collectors.toMap(existDy -> existDy.getLong("id"), Function.identity(), (a, b) -> a));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_attendperson");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_fertilityinfo");
        for (AttendPersonCurrModel attendPersonCurrModel : attendPersonCurrModels) {
            List<FertilityInfo> fertilityInfoList = attendPersonCurrModel.getFertilityInfoList();
            if (WTCCollections.isEmpty(fertilityInfoList)) continue;
            for (FertilityInfo fertilityInfo : fertilityInfoList) {
                Long fyId = fertilityInfo.getId();
                DynamicObject dynamicObject = (DynamicObject)existDyMap.get(fyId);
                if (dynamicObject != null) {
                    WtbsBusinessUtils.propertyCopyToDynamicObject(fertilityInfo, dynamicObject);
                    updateDyData.add(dynamicObject);
                    continue;
                }
                DynamicObject trialPeriodDO = new DynamicObject((DynamicObjectType)dataEntityType);
                WtbsBusinessUtils.propertyCopyToDynamicObject(fertilityInfo, trialPeriodDO);
                trialPeriodDO.set("id", (Object)fertilityInfo.getId());
                trialPeriodDO.set("person", (Object)attendPersonCurrModel.getBoid());
                DynamicObject attPersonDy = serviceHelper.generateEmptyDynamicObject();
                attPersonDy.set("id", (Object)attendPersonCurrModel.getBoid());
                trialPeriodDO.set("attperson", (Object)attPersonDy);
                trialPeriodDO.set("fyid", (Object)fertilityInfo.getId());
                insertDyData.add(trialPeriodDO);
            }
        }
        if (doOrmData) {
            if (!CollectionUtils.isEmpty((Collection)insertDyData)) {
                wtpTrialPeriodHelper.save(insertDyData.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)updateDyData)) {
                wtpTrialPeriodHelper.update(updateDyData.toArray(new DynamicObject[0]));
            }
        }
        resultDyData.addAll(insertDyData);
        resultDyData.addAll(updateDyData);
        return resultDyData;
    }

    private DynamicObject[] queryCmPeMpList(List<Long> idList) {
        QFilter[] depempIdFilters = new QFilter[]{new QFilter("id", "in", idList)};
        return manageScopeHelper.loadDynamicObjectArray(depempIdFilters);
    }

    private DynamicObject[] queryFyList(List<Long> idList) {
        QFilter[] fyIdFilters = new QFilter[]{new QFilter("id", "in", idList)};
        return wtpTrialPeriodHelper.loadDynamicObjectArray(fyIdFilters);
    }

    private DynamicObject getDy(String entity, Long id) {
        HRBaseServiceHelper affiliateAdminOrgHelper = new HRBaseServiceHelper(entity);
        DynamicObject dy = affiliateAdminOrgHelper.generateEmptyDynamicObject();
        dy.set("id", (Object)id);
        return dy;
    }

    public List<DynamicObject> dealEmpPosOrgRel(List<AttendPersonCurrModel> attendPersonCurrModels, boolean doOrmData) {
        if (CollectionUtils.isEmpty(attendPersonCurrModels)) {
            return Collections.emptyList();
        }
        ArrayList resultDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList insertDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList updateDyData = Lists.newArrayListWithExpectedSize((int)attendPersonCurrModels.size());
        ArrayList<Long> pendingIdList = new ArrayList<Long>();
        attendPersonCurrModels.forEach(dm -> pendingIdList.addAll(dm.getEmpPosOrgRelList().stream().map(TimeSeqVersion::getBid).collect(Collectors.toList())));
        DynamicObject[] existDys = this.queryEmpPosOrgRelList(pendingIdList);
        Map existDyMap = Arrays.stream(existDys).collect(Collectors.toMap(existDy -> existDy.getLong("id"), Function.identity(), (a, b) -> a));
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_depempjob");
        for (AttendPersonCurrModel attendPersonCurrModel : attendPersonCurrModels) {
            List<EmpPosOrgRel> empPosOrgRelList = attendPersonCurrModel.getEmpPosOrgRelList();
            for (EmpPosOrgRel empPosOrgRel : empPosOrgRelList) {
                Long boId = empPosOrgRel.getBid();
                DynamicObject dynamicObject = (DynamicObject)existDyMap.get(boId);
                if (dynamicObject != null) {
                    WtbsBusinessUtils.propertyCopyToDynamicObject(empPosOrgRel, dynamicObject);
                    updateDyData.add(dynamicObject);
                    continue;
                }
                DynamicObject dePeMpJobDO = new DynamicObject((DynamicObjectType)dataEntityType);
                WtbsBusinessUtils.propertyCopyToDynamicObject(empPosOrgRel, dePeMpJobDO);
                dePeMpJobDO.set("person", (Object)attendPersonCurrModel.getBoid());
                dePeMpJobDO.set("attperson", (Object)this.getDy("wtp_attendperson", attendPersonCurrModel.getBoid()));
                dePeMpJobDO.set("cmpemp", (Object)this.getDy("wtp_managescope", empPosOrgRel.getCmpEmp()));
                Employee employee = attendPersonCurrModel.getEmployee();
                if (employee != null) {
                    dePeMpJobDO.set("employee", (Object)employee.getBid());
                }
                dePeMpJobDO.set("id", (Object)empPosOrgRel.getBid());
                dePeMpJobDO.set("empposorgrel", (Object)empPosOrgRel.getBid());
                dePeMpJobDO.set("number", (Object)empPosOrgRel.getBusiNumber());
                insertDyData.add(dePeMpJobDO);
            }
        }
        if (doOrmData) {
            if (!CollectionUtils.isEmpty((Collection)insertDyData)) {
                dePeMpJobPersonHelper.save(insertDyData.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)updateDyData)) {
                dePeMpJobPersonHelper.update(updateDyData.toArray(new DynamicObject[0]));
            }
        }
        resultDyData.addAll(insertDyData);
        resultDyData.addAll(updateDyData);
        return resultDyData;
    }

    private DynamicObject[] queryEmpPosOrgRelList(List<Long> idList) {
        QFilter[] depempIdFilters = new QFilter[]{new QFilter("id", "in", idList)};
        return dePeMpJobPersonHelper.loadDynamicObjectArray(depempIdFilters);
    }

    private Long getPersonId(AttendPersonCurrModel attendPersonModel) {
        Long personId = attendPersonModel.getBoid();
        if (personId != null) {
            return personId;
        }
        Person person = attendPersonModel.getPerson();
        if (person == null) {
            return personId;
        }
        return person.getBid();
    }

    public void setEarliestAndLatestDate(DynamicObject[] dataEntities, AttendPersonCurrResult attendPersonCurrResult) {
        List personIds = Arrays.stream(dataEntities).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setAttPersonSetIds((Set)Sets.newHashSet(personIds));
        attFileQueryParam.setProperties("startdate, enddate, person, org");
        attFileQueryParam.setBeCurrent(Boolean.valueOf(true));
        List<DynamicObject> attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Map<Long, List<DynamicObject>> attFileMap = attFileDys.stream().collect(Collectors.groupingBy(attFileDy -> attFileDy.getLong("person")));
        for (DynamicObject dataEntity : dataEntities) {
            Long attPersonId = dataEntity.getLong("attperson.id");
            if (attPersonId == 0L) continue;
            List<Object> attFileDyList = attFileMap.get(attPersonId);
            if (attFileDyList == null) {
                attFileDyList = new ArrayList<DynamicObject>(10);
            } else {
                long orgId = dataEntity.getLong("org.id");
                long personId = dataEntity.getLong("person.id");
                attFileDyList = attFileDyList.stream().filter(attFileDy -> orgId != attFileDy.getLong("org") && personId == attFileDy.getLong("person")).collect(Collectors.toList());
            }
            attFileDyList.add(dataEntity);
            attFileDyList.sort(Comparator.comparing(attFileDy -> attFileDy.getDate("startdate")));
            Date earliestAttendDate = attFileDyList.get(0).getDate("startdate");
            Date latestAttendDate = ((DynamicObject)attFileDyList.get(attFileDyList.size() - 1)).getDate("enddate");
            for (AttendPersonCurrModel currModel : attendPersonCurrResult.getAttendPersonCurrModels()) {
                if (!attPersonId.equals(currModel.getPerson().getId())) continue;
                currModel.setEarliestAttendDate(earliestAttendDate);
                currModel.setLatestAttendDate(latestAttendDate);
            }
        }
    }
}

