/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.attendperson;

import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPOperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.IAttendPersonUpdateService;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class AttendPersonUpdateServiceImpl
implements IAttendPersonUpdateService {
    private static final HRBaseServiceHelper attPersonHelper = new HRBaseServiceHelper("wtp_attendperson");
    private static final HRBaseServiceHelper depEmpJobPersonHelper = new HRBaseServiceHelper("wtp_depempjob");
    private static final HRBaseServiceHelper manageScopeHelper = new HRBaseServiceHelper("wtp_managescope");

    public static AttendPersonUpdateServiceImpl getInstance() {
        return (AttendPersonUpdateServiceImpl)WTCAppContextHelper.getBean(AttendPersonUpdateServiceImpl.class);
    }

    @Override
    public void updateAttendPerson(DynamicObject person) {
        attPersonHelper.updateDataOne(person);
    }

    @Override
    public void updateCmpEmp(DynamicObject[] cmpEmp) {
        manageScopeHelper.update(cmpEmp);
    }

    @Override
    public void updateEmpPosOrgRel(DynamicObject[] empPosOrgRel) {
        depEmpJobPersonHelper.update(empPosOrgRel);
    }

    @Override
    public OperationResult updateOtherInfo(Map<Long, Map<String, Object>> allPersonMap, Map<String, String> paramMap) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attperotherinfo");
        QFilter qFilter = new QFilter("person", "in", allPersonMap.keySet());
        DynamicObject[] dys = helper.loadDynamicObjectArray(new QFilter[]{qFilter});
        DataEntityPropertyCollection properties = helper.generateEmptyDynamicObject().getDataEntityType().getProperties();
        if (dys == null || dys.length == 0) {
            DynamicObject[] list = Lists.newArrayListWithExpectedSize((int)10);
            for (Map.Entry<Long, Map<String, Object>> otherInfoMapEntry : allPersonMap.entrySet()) {
                DynamicObject saveDy = helper.generateEmptyDynamicObject();
                saveDy.set("person", (Object)otherInfoMapEntry.getKey());
                this.setFieldValue(properties, saveDy, otherInfoMapEntry.getValue());
                list.add(saveDy);
            }
            dys = list.toArray(new DynamicObject[0]);
        } else {
            for (DynamicObject dy : dys) {
                long personId = WTCDynamicObjectUtils.getBaseDataId(dy, "person");
                this.setFieldValue(properties, dy, allPersonMap.get(personId));
            }
        }
        HRMPOperationServiceImpl im = new HRMPOperationServiceImpl("wtp_attperotherinfo");
        OperateOption operateOption = OperateOption.create();
        if (paramMap != null) {
            operateOption.getVariables().putAll(paramMap);
        }
        return im.localInvokeOperation("save", dys, operateOption);
    }

    private void setFieldValue(DataEntityPropertyCollection properties, DynamicObject saveDy, Map<String, Object> currentMap) {
        for (Map.Entry<String, Object> mapEntry : currentMap.entrySet()) {
            String key = mapEntry.getKey();
            if (!properties.containsKey((Object)key)) continue;
            saveDy.set(key, mapEntry.getValue());
        }
    }
}

