/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.attperiod;

import java.time.LocalDate;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.model.period.PeriodBillCheckResult;
import kd.wtc.wtbs.common.model.period.PeriodEntryBaseModel;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttPeriodCommonService {
    private static final String END_DATE = "enddate";
    private static final String KEY_BEGIN_DATE = "begindate";

    public static AttPeriodCommonService getInstance() {
        return (AttPeriodCommonService)WTCAppContextHelper.getBean(AttPeriodCommonService.class);
    }

    public PeriodBillCheckResult getPeriodBillCheckResult(Map<Long, List<LocalDate>> dateListMap) {
        DynamicObject[] periodEntryDyArr;
        HashMap personToDateToPeriodEntryMap = Maps.newHashMapWithExpectedSize((int)dateListMap.size());
        HashMap periodEntryBaseModelMap = Maps.newHashMapWithExpectedSize((int)dateListMap.size());
        PeriodBillCheckResult periodBillCheckResult = new PeriodBillCheckResult((Map)personToDateToPeriodEntryMap, (Map)periodEntryBaseModelMap);
        if (WTCCollections.isEmpty(dateListMap)) {
            return periodBillCheckResult;
        }
        Set<Long> personSet = dateListMap.keySet();
        if (WTCCollections.isNotEmpty(personSet) && personSet.size() > 500) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u5904\u7406500\u4eba\u6570\u636e\u3002", (String)"AttPeriodCommonService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        LocalDate now = LocalDate.now();
        LocalDate minLocalDate = now.minusYears(50L);
        LocalDate maxLocalDate = now.plusYears(50L);
        PerAttPeriodQueryParam perAttPeriodQueryParam = new PerAttPeriodQueryParam();
        perAttPeriodQueryParam.setAttPersonIdSet(personSet);
        perAttPeriodQueryParam.setStartDate(WTCDateUtils.toDate((LocalDate)minLocalDate));
        perAttPeriodQueryParam.setEndDate(WTCDateUtils.toDate((LocalDate)maxLocalDate));
        perAttPeriodQueryParam.setProperties("startdate, enddate, periodentry, period, attperson, attperson.id");
        List<DynamicObject> perAttPeriodDyArr = PerAttPeriodQueryServiceImpl.getInstance().queryPerAttPeriodDy(perAttPeriodQueryParam);
        Map<Long, List<DynamicObject>> perAttPeriodMap = perAttPeriodDyArr.stream().collect(Collectors.groupingBy(d -> WTCDynamicObjectUtils.getBaseDataId(d, "attperson")));
        Set periodIdSet = perAttPeriodDyArr.stream().map(dy -> dy.getLong("period")).collect(Collectors.toSet());
        HRBaseServiceHelper periodEntryServiceHelper = new HRBaseServiceHelper("wtp_attperiodentry");
        QFilter qFilter = new QFilter("masterid", "in", periodIdSet);
        qFilter.and(new QFilter(END_DATE, ">=", (Object)minLocalDate));
        qFilter.and(new QFilter(KEY_BEGIN_DATE, "<=", (Object)maxLocalDate));
        for (DynamicObject dynamicObject : periodEntryDyArr = periodEntryServiceHelper.query("begindate,enddate,masterid,id", new QFilter[]{qFilter}, "begindate asc")) {
            long periodId = WTCDynamicObjectUtils.getBaseDataId(dynamicObject, "masterid");
            List periodEntryBaseModels = periodEntryBaseModelMap.computeIfAbsent(periodId, key -> Lists.newArrayListWithExpectedSize((int)10));
            PeriodEntryBaseModel periodEntryBaseModel = new PeriodEntryBaseModel();
            periodEntryBaseModel.setEndDate(WTCDateUtils.toLocalDate((Date)dynamicObject.getDate(END_DATE)));
            periodEntryBaseModel.setStartDate(WTCDateUtils.toLocalDate((Date)dynamicObject.getDate(KEY_BEGIN_DATE)));
            periodEntryBaseModel.setId(dynamicObject.getLong("id"));
            periodEntryBaseModel.setPeriodId(WTCDynamicObjectUtils.getBaseDataId(dynamicObject, "masterid"));
            periodEntryBaseModels.add(periodEntryBaseModel);
        }
        dateListMap.forEach((k, v) -> this.initPeriodBillCheckResult(personToDateToPeriodEntryMap, periodEntryBaseModelMap, now, perAttPeriodMap, (Long)k, (List<LocalDate>)v));
        return periodBillCheckResult;
    }

    private void initPeriodBillCheckResult(Map<Long, Map<LocalDate, Tuple<Long, Long>>> personToDateToPeriodEntryMap, Map<Long, List<PeriodEntryBaseModel>> periodEntryBaseModelMap, LocalDate now, Map<Long, List<DynamicObject>> perAttPeriodMap, Long k, List<LocalDate> v) {
        List<DynamicObject> perAttPeriodList = perAttPeriodMap.get(k);
        Map localDateTupleMap = personToDateToPeriodEntryMap.computeIfAbsent(k, key -> Maps.newHashMapWithExpectedSize((int)v.size()));
        if (WTCCollections.isNotEmpty(perAttPeriodList)) {
            perAttPeriodList.sort(Comparator.comparing(d -> d.getDate("startdate")));
            Optional<DynamicObject> any = perAttPeriodList.stream().filter(d -> !WTCDateUtils.toLocalDate((Date)d.getDate("startdate")).isAfter(now) && !WTCDateUtils.toLocalDate((Date)d.getDate(END_DATE)).isBefore(now)).findAny();
            if (any.isPresent()) {
                DynamicObject dynamicObject = any.get();
                Tuple<Long, Long> longLongTuple = this.getTuple(dynamicObject);
                for (LocalDate localDate : v) {
                    localDateTupleMap.put(localDate, longLongTuple);
                }
            } else {
                for (LocalDate localDate : v) {
                    int i = localDate.compareTo(now);
                    if (i >= 0) {
                        Optional<DynamicObject> next = perAttPeriodList.stream().filter(d -> WTCDateUtils.toLocalDate((Date)d.getDate("startdate")).isAfter(now)).findFirst();
                        if (next.isPresent()) {
                            DynamicObject dynamicObject = next.get();
                            Tuple<Long, Long> longLongTuple = this.getTupleByPeriodEntry(dynamicObject, periodEntryBaseModelMap);
                            localDateTupleMap.put(localDate, longLongTuple);
                            continue;
                        }
                        localDateTupleMap.put(localDate, null);
                        continue;
                    }
                    DynamicObject lastPerAttPeriod = this.getLastPerAttPeriod(now, perAttPeriodList);
                    if (lastPerAttPeriod != null) {
                        Tuple<Long, Long> longLongTuple = this.getTupleByPeriodEntry(lastPerAttPeriod, periodEntryBaseModelMap);
                        localDateTupleMap.put(localDate, longLongTuple);
                        continue;
                    }
                    localDateTupleMap.put(localDate, null);
                }
            }
        } else {
            for (LocalDate localDate : v) {
                localDateTupleMap.put(localDate, null);
            }
        }
    }

    private DynamicObject getLastPerAttPeriod(LocalDate now, List<DynamicObject> perAttPeriodList) {
        for (int i1 = perAttPeriodList.size() - 1; i1 >= 0; --i1) {
            DynamicObject dynamicObject = perAttPeriodList.get(i1);
            if (!WTCDateUtils.toLocalDate((Date)dynamicObject.getDate(END_DATE)).isBefore(now)) continue;
            return dynamicObject;
        }
        return null;
    }

    private Tuple<Long, Long> getTuple(DynamicObject dynamicObject) {
        return new Tuple((Object)WTCDynamicObjectUtils.getBaseDataId(dynamicObject, "periodentry"), (Object)WTCDynamicObjectUtils.getBaseDataId(dynamicObject, "period"));
    }

    private Tuple<Long, Long> getTupleByPeriodEntry(DynamicObject dynamicObject, Map<Long, List<PeriodEntryBaseModel>> periodEntryBaseModelMap) {
        Optional any;
        long periodId = WTCDynamicObjectUtils.getBaseDataId(dynamicObject, "period");
        List<PeriodEntryBaseModel> periodEntryBaseModels = periodEntryBaseModelMap.get(periodId);
        if (WTCCollections.isNotEmpty(periodEntryBaseModels) && (any = periodEntryBaseModels.stream().findAny()).isPresent()) {
            PeriodEntryBaseModel periodEntryBaseModel = (PeriodEntryBaseModel)any.get();
            return Tuple.of((Object)periodEntryBaseModel.getId(), (Object)periodEntryBaseModel.getPeriodId());
        }
        return null;
    }
}

