/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.attperiod;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.wtc.wtbs.business.web.attperiod.AttPeriod;
import kd.wtc.wtbs.business.web.attperiod.AttPeriodDetail;
import kd.wtc.wtbs.common.enums.DataStatus;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class AttPeriodDetailService {
    private static final AttPeriodDetailService singleton = new AttPeriodDetailService();

    public static final AttPeriodDetailService getInstance() {
        return singleton;
    }

    public List<AttPeriod> getAttPeriodByOrgId(Long orgId) {
        if (orgId == null || orgId == 0L) {
            return Lists.newArrayList();
        }
        String selects = "name,id";
        QFilter[] qFilters = new QFilter[2];
        qFilters[0] = new QFilter("status", "=", (Object)DataStatus.AUDIT.getCode());
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtp_attperiod", (Long)orgId);
        qFilters[0] = qFilters[0].and(baseDataFilter);
        String orderBy = "createtime asc";
        Map map = BusinessDataServiceHelper.loadFromCache((String)"wtp_attperiod", (String)selects, (QFilter[])qFilters, (String)orderBy);
        List<AttPeriod> attPeriods = map.values().stream().map(dy -> this.buildAttPeriod((DynamicObject)dy)).collect(Collectors.toList());
        return attPeriods;
    }

    public List<Long> getAttPeriodIdsByOrgId(Long orgId) {
        if (orgId == null || orgId == 0L) {
            return Lists.newArrayList();
        }
        String selects = "id";
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "=", (Object)DataStatus.AUDIT.getCode())};
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtp_attperiod", (Long)orgId);
        qFilters[0] = qFilters[0].and(baseDataFilter);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"wtp_attperiod", (String)selects, (QFilter[])qFilters);
        return map.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public List<AttPeriodDetail> getOneYearPeriodDetail(Long periodId, Date endDate) {
        if (periodId == null || periodId == 0L) {
            return Lists.newArrayList();
        }
        QFilter[] entryFiltes = new QFilter[2];
        entryFiltes[0] = new QFilter("masterid", "=", (Object)periodId);
        Map detailMap = BusinessDataServiceHelper.loadFromCache((String)"wtp_attperiodentry", (QFilter[])entryFiltes);
        Calendar calendar = Calendar.getInstance();
        if (endDate == null) {
            endDate = new Date();
        }
        Date finalEndDate = endDate;
        calendar.setTime(finalEndDate);
        calendar.add(1, -1);
        return detailMap.values().stream().filter(dy -> !dy.getDate("begindate").after(finalEndDate) && !dy.getDate("enddate").before(calendar.getTime())).map(dy -> this.buildAttPeriodDetail((DynamicObject)dy)).collect(Collectors.toList());
    }

    public List<AttPeriodDetail> getPeriodDetail(Long periodId, Date endDate) {
        if (periodId == null || periodId == 0L) {
            return Lists.newArrayList();
        }
        QFilter[] entryFiltes = new QFilter[2];
        entryFiltes[0] = new QFilter("masterid", "=", (Object)periodId);
        Map detailMap = BusinessDataServiceHelper.loadFromCache((String)"wtp_attperiodentry", (QFilter[])entryFiltes);
        Calendar calendar = Calendar.getInstance();
        if (endDate == null) {
            endDate = new Date();
        }
        Date finalEndDate = endDate;
        return detailMap.values().stream().filter(dy -> !dy.getDate("begindate").after(finalEndDate)).map(dy -> this.buildAttPeriodDetail((DynamicObject)dy)).collect(Collectors.toList());
    }

    private AttPeriodDetail buildAttPeriodDetail(DynamicObject dynamicObject) {
        AttPeriodDetail attPeriodDetail = new AttPeriodDetail();
        String ascriptionYearMonth = dynamicObject.getString("ascriptionyear") + "-" + dynamicObject.getString("ascriptionmonth");
        attPeriodDetail.setAscriptionYearMonth(ascriptionYearMonth);
        attPeriodDetail.setAttPeriodId((Long)dynamicObject.getPkValue());
        attPeriodDetail.setPerAttBeginDate(dynamicObject.getDate("begindate"));
        attPeriodDetail.setPerAttEndDate(dynamicObject.getDate("enddate"));
        attPeriodDetail.setPerAttPeriodName(dynamicObject.getString("name"));
        return attPeriodDetail;
    }

    private AttPeriod buildAttPeriod(DynamicObject dynamicObject) {
        AttPeriod attPeriod = new AttPeriod();
        attPeriod.setId((Long)dynamicObject.getPkValue());
        attPeriod.setName(dynamicObject.getString("name"));
        return attPeriod;
    }
}

