/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.attperiod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.attperiod.IPerAttPeriodGenService;
import kd.wtc.wtbs.business.web.attperiod.IPerAttPeriodQueryService;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodGenServiceImpl;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodReportGenServiceImpl;
import kd.wtc.wtbs.common.enums.ApplyBillTypeEnum;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.model.period.PerAttPeriodAndStateInfo;
import kd.wtc.wtbs.common.model.period.PerAttPeriodGenParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriodQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReport;
import kd.wtc.wtbs.common.model.result.BillPeriodCheck;
import kd.wtc.wtbs.common.model.wtteinfo.AttStateInfo;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.DateUtils;

public class PerAttPeriodQueryServiceImpl
implements IPerAttPeriodQueryService {
    private static final Log logger = LogFactory.getLog(PerAttPeriodQueryServiceImpl.class);
    private static final String ALLOW_RE_ACCOUNT_TIME = "allowreaccounttime";
    private static final String LOCK_TO = "lockto";
    private static final String STORAGE_TO = "storageto";

    private PerAttPeriodQueryServiceImpl() {
    }

    public static PerAttPeriodQueryServiceImpl getInstance() {
        return PerAttPeriodQueryInstance.singleton;
    }

    @Override
    public BillPeriodCheck billPerAttPeriodCheck(Date billDate, Long fileBoId, boolean authCheck) {
        Date nowDate = new Date();
        nowDate = WTCDateUtils.getZeroDate((Date)nowDate);
        billDate = WTCDateUtils.getZeroDate((Date)billDate);
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        queryParam.setAttFileBoIdSet(Collections.singleton(fileBoId));
        List<PerAttPeriod> perAttPeriodReport = this.queryPerAttPeriodEntity(queryParam);
        if (perAttPeriodReport.isEmpty()) {
            String tip = String.format(ResManager.loadKDString((String)"%s\u65e0\u53ef\u7528\u7684\u8003\u52e4\u671f\u95f4\u3002", (String)"PerAttPeriodQueryServiceImpl_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)billDate));
            return new BillPeriodCheck(tip);
        }
        int billStartPerIndex = -1;
        int nowDatePerIndex = -1;
        for (int i = 0; i < perAttPeriodReport.size(); ++i) {
            PerAttPeriod report = perAttPeriodReport.get(i);
            if (nowDate.compareTo(report.getPerAttEndDate()) <= 0 && nowDate.compareTo(report.getPerAttBeginDate()) >= 0) {
                nowDatePerIndex = i;
            }
            if (billDate.compareTo(report.getPerAttEndDate()) > 0 || billDate.compareTo(report.getPerAttBeginDate()) < 0) continue;
            billStartPerIndex = i;
        }
        if (nowDatePerIndex < 0) {
            String tip = String.format(ResManager.loadKDString((String)"%s\u65e0\u53ef\u7528\u7684\u8003\u52e4\u671f\u95f4\u3002", (String)"PerAttPeriodQueryServiceImpl_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)nowDate));
            return new BillPeriodCheck(tip);
        }
        if (billStartPerIndex < 0) {
            String tip = String.format(ResManager.loadKDString((String)"%s\u65e0\u53ef\u7528\u7684\u8003\u52e4\u671f\u95f4\u3002", (String)"PerAttPeriodQueryServiceImpl_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)billDate));
            return new BillPeriodCheck(tip);
        }
        if (nowDatePerIndex < billStartPerIndex) {
            return new BillPeriodCheck(ApplyBillTypeEnum.ADVANCE_APPLY, billStartPerIndex - nowDatePerIndex);
        }
        if (nowDatePerIndex > billStartPerIndex) {
            return new BillPeriodCheck(ApplyBillTypeEnum.SUPPLEMENT, nowDatePerIndex - billStartPerIndex);
        }
        return new BillPeriodCheck(ApplyBillTypeEnum.CURRENT_APPLY, 0);
    }

    public List<PerAttPeriodReport> getPerAttPeriodReport(Function<AttFileQueryParam, List<DynamicObject>> function, AttFileQueryParam fileQueryParam, Date startDate, Date endDate, Date attPeriodCreatTime) {
        PerAttPeriodGenServiceImpl iPerAttPeriodGenService = new PerAttPeriodGenServiceImpl();
        fileQueryParam.setAttStatus(AttStatusEnum.ATT_NORMAL);
        fileQueryParam.setAuthCheck(Boolean.FALSE);
        return this.getPerAttPeriodReports(startDate, endDate, attPeriodCreatTime, function.apply(fileQueryParam), iPerAttPeriodGenService);
    }

    @Override
    public List<? extends PerAttPeriod> getPerAttPeriod(List<DynamicObject> attFileList, IPerAttPeriodGenService perAttPeriodGenService, Date attPeriodCreatTime) {
        PerAttPeriodQueryParam queryParam = new PerAttPeriodQueryParam();
        Set fileBoIds = attFileList.stream().map(object -> object.getLong("boid")).collect(Collectors.toSet());
        queryParam.setAttFileBoIdSet(fileBoIds);
        List<DynamicObject> perPeriodDyList = this.queryPerAttPeriodDy(queryParam);
        PerAttPeriodReportGenServiceImpl reportGenService = new PerAttPeriodReportGenServiceImpl();
        ArrayList periodReportList = Lists.newArrayListWithCapacity((int)perPeriodDyList.size());
        for (DynamicObject perPeriodDy : perPeriodDyList) {
            PerAttPeriodGenParam perAttPeriodGenParam = new PerAttPeriodGenParam(null);
            perAttPeriodGenParam.setFileDy(perPeriodDy.getDynamicObject("attfilevid"));
            perAttPeriodGenParam.setPeriodDy(perPeriodDy.getDynamicObject("period"));
            perAttPeriodGenParam.setPeriodEntry(perPeriodDy.getDynamicObject("periodentry"));
            perAttPeriodGenParam.setPerAttPeriodStartDate(perPeriodDy.getDate("startdate"));
            perAttPeriodGenParam.setPerAttPeriodEndDate(perPeriodDy.getDate("enddate"));
            String firstNotStorage = perPeriodDy.getBoolean("firstnotstorage") ? "1" : "2";
            perAttPeriodGenParam.setEarliestNoStoragePeriod(firstNotStorage);
            String lastStorage = perPeriodDy.getBoolean("laststorage") ? "1" : "2";
            perAttPeriodGenParam.setLastStoragePeriod(lastStorage);
            periodReportList.add(reportGenService.genPerAttPeriod(perAttPeriodGenParam, perPeriodDy.getLong("id")));
        }
        return periodReportList;
    }

    private List<PerAttPeriodReport> getPerAttPeriodReports(Date startDate, Date endDate, Date attPeriodCreatTime, List<DynamicObject> attFileList, IPerAttPeriodGenService iPerAttPeriodGenService) {
        PerAttPeriodReportGenServiceImpl perAttPeriodGenService = new PerAttPeriodReportGenServiceImpl();
        PerAttPeriodQueryServiceImpl instance = PerAttPeriodQueryServiceImpl.getInstance();
        List<? extends PerAttPeriod> perAttPeriod = instance.getPerAttPeriod(attFileList, perAttPeriodGenService, attPeriodCreatTime);
        List fileBoIds = attFileList.stream().map(object -> object.getLong("boid")).distinct().collect(Collectors.toList());
        ArrayList perAttPeriodResult = Lists.newArrayListWithExpectedSize((int)perAttPeriod.size());
        if (!perAttPeriod.isEmpty()) {
            Map wtteInfoMap = (Map)WTCServiceHelper.invokeBizService("wtc", "wtp", "IAttStateInfoService", "queryAttStateInfoByFileBoId", fileBoIds);
            Map<Long, List<PerAttPeriodReport>> perAttPeriodMap = perAttPeriod.stream().map(PerAttPeriodReport.class::cast).collect(Collectors.groupingBy(PerAttPeriod::getFileBoId));
            for (Map.Entry<Long, List<PerAttPeriodReport>> entries : perAttPeriodMap.entrySet()) {
                Long fileBoId = entries.getKey();
                List<PerAttPeriodReport> value = entries.getValue();
                Map info = (Map)wtteInfoMap.get(fileBoId);
                if (info == null) {
                    logger.error("wtteInfo is null!!! AttFileBoId : {} ", (Object)fileBoId);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848%s\u6838\u7b97\u4fe1\u606f\u4e0d\u5b8c\u6574\u3002", (String)"PerAttPeriodQueryServiceImpl_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCCollectionIndexUtil.getEleFromList(value, (int)0).map(PerAttPeriodReport::getPersonName).orElse("")));
                }
                Date storageDate = (Date)info.get(STORAGE_TO);
                Date lockDate = (Date)info.get(LOCK_TO);
                value.sort(Comparator.comparing(PerAttPeriod::getPerAttBeginDate));
                for (int i = 0; i < value.size(); ++i) {
                    PerAttPeriodReport report = value.get(i);
                    Date perAttBeginDate = report.getPerAttBeginDate();
                    Date perAttEndDate = report.getPerAttEndDate();
                    if (null != startDate && perAttEndDate.before(startDate) || null != endDate && perAttBeginDate.after(endDate)) continue;
                    this.setStorageStatus(storageDate, report, perAttBeginDate, perAttEndDate);
                    this.fullPeriodStatus(info, lockDate, report, perAttBeginDate, perAttEndDate);
                    perAttPeriodResult.add(report);
                }
            }
        }
        return perAttPeriodResult;
    }

    private void fullPeriodStatus(Map<String, Object> info, Date lockDate, PerAttPeriodReport report, Date perAttBeginDate, Date perAttEndDate) {
        if (lockDate == null) {
            report.setLockStatus("2");
        } else if (this.partLock(lockDate, perAttBeginDate, perAttEndDate)) {
            report.setLockStatus("3");
        } else if (DateUtils.isSameDay((Date)lockDate, (Date)perAttEndDate) || lockDate.compareTo(perAttEndDate) >= 0) {
            report.setLockStatus("1");
        } else {
            report.setLockStatus("2");
        }
        Date frozenStartDate = info.get("frozenstartdate") == null ? null : (Date)info.get("frozenstartdate");
        Date frozenEndDate = info.get("frozenenddate") == null ? null : (Date)info.get("frozenenddate");
        report.setFrozenStatus("2");
        if (frozenStartDate != null && frozenEndDate != null) {
            if (frozenStartDate.compareTo(perAttBeginDate) <= 0 && frozenEndDate.compareTo(perAttEndDate) >= 0) {
                report.setFrozenStatus("1");
            } else if (this.partFrozen(perAttBeginDate, perAttEndDate, frozenStartDate, frozenEndDate)) {
                report.setFrozenStatus("3");
            }
        }
        String lockAction = info.get("lockaction") == null ? "" : (String)info.get("lockaction");
        Date lockTo = info.get(LOCK_TO) == null ? null : (Date)info.get(LOCK_TO);
        Date lockTime = info.get("locktime") == null ? null : (Date)info.get("locktime");
        Date date = lockTo = HRStringUtils.equals((String)lockAction, (String)"unlockto") && lockTo != null ? DateUtils.addDays((Date)lockTo, (int)1) : lockTo;
        if (this.hasLock(perAttBeginDate, lockTo)) {
            report.setLockTime(lockTime);
            if (info.get("lockerid") != null) {
                report.setLockerId((Long)info.get("lockerid"));
            }
        }
        if (info.get("storagetime") != null) {
            report.setStorageTime((Date)info.get("storagetime"));
        }
        if (info.get("storageerid") != null) {
            report.setStorageerId((Long)info.get("storageerid"));
        }
    }

    private boolean hasLock(Date perAttBeginDate, Date lockTo) {
        return lockTo != null && perAttBeginDate != null && (DateUtils.isSameDay((Date)lockTo, (Date)perAttBeginDate) || lockTo.compareTo(perAttBeginDate) >= 0);
    }

    private boolean partFrozen(Date perAttBeginDate, Date perAttEndDate, Date frozenStartDate, Date frozenEndDate) {
        return frozenStartDate.compareTo(perAttBeginDate) <= 0 && frozenEndDate.compareTo(perAttBeginDate) >= 0 || frozenStartDate.compareTo(perAttEndDate) <= 0 && frozenEndDate.compareTo(perAttEndDate) >= 0;
    }

    private boolean partLock(Date lockDate, Date perAttBeginDate, Date perAttEndDate) {
        return lockDate.compareTo(perAttEndDate) < 0 && (lockDate.compareTo(perAttBeginDate) >= 0 || DateUtils.isSameDay((Date)lockDate, (Date)perAttBeginDate));
    }

    private void originalStoragePeriodSet(List<PerAttPeriodReport> value, int index, PerAttPeriodReport report) {
        report.setEarliestNoStoragePeriod("1");
        if (index >= 1) {
            PerAttPeriodReport perReport = value.get(index - 1);
            perReport.setLastStoragePeriod("1");
        }
    }

    private void setStorageStatus(Date storageDate, PerAttPeriodReport report, Date perAttBeginDate, Date perAttEndDate) {
        if (storageDate == null) {
            report.setStorageStatus("2");
        } else if (perAttEndDate.compareTo(storageDate) <= 0) {
            report.setStorageStatus("1");
        } else if (perAttBeginDate.compareTo(storageDate) > 0) {
            report.setStorageStatus("2");
        } else {
            report.setStorageStatus("3");
        }
    }

    @Override
    public List<PerAttPeriod> queryPerAttPeriodEntity(PerAttPeriodQueryParam param) {
        if (WTCStringUtils.isEmpty((String)param.getProperties())) {
            param.setProperties(PerAttPeriodQueryParam.COMMON_QUERYFIELDS);
        }
        return this.queryPerAttPeriodDy(param).stream().map(period -> this.getPerAttPeriodByDy((DynamicObject)period, param)).sorted(Comparator.comparing(PerAttPeriod::getPerAttBeginDate)).collect(Collectors.toList());
    }

    private PerAttPeriod getPerAttPeriodByDy(DynamicObject dy, PerAttPeriodQueryParam param) {
        PerAttPeriod perAttPeriod = new PerAttPeriod();
        perAttPeriod.setPrimaryId(Long.valueOf(dy.getLong("id")));
        perAttPeriod.setNumber(dy.getString("number"));
        perAttPeriod.setFileId(Long.valueOf(dy.getLong("attfilevid")));
        perAttPeriod.setFileBoId(Long.valueOf(dy.getLong("attfileid")));
        perAttPeriod.setPersonId(Long.valueOf(dy.getLong("attperson")));
        perAttPeriod.setPerAttBeginDate(dy.getDate("startdate"));
        perAttPeriod.setPerAttEndDate(dy.getDate("enddate"));
        perAttPeriod.setMhsa(Long.valueOf(dy.getLong("periodentry.mhsa")));
        perAttPeriod.setAttPeriodId(Long.valueOf(dy.getLong("periodentry")));
        perAttPeriod.setPeriodId(Long.valueOf(dy.getLong("period")));
        perAttPeriod.setAttPeriodStartDate(dy.getDate("periodentry.begindate"));
        perAttPeriod.setAttPeriodEndDate(dy.getDate("periodentry.enddate"));
        perAttPeriod.setLastStorage(dy.getBoolean("laststorage"));
        perAttPeriod.setFirstNotStorage(dy.getBoolean("firstnotstorage"));
        perAttPeriod.setAscriptionYearMonth(dy.getString("periodentry.ascriptionyear") + "-" + dy.getString("periodentry.ascriptionmonth"));
        perAttPeriod.setPerAttPeriodName(dy.getString("periodentry.name"));
        perAttPeriod.setMhsa(Long.valueOf(dy.getLong("periodentry.mhsa")));
        perAttPeriod.setPeriodName(dy.getString("period.name"));
        perAttPeriod.setId(dy.getLong("attperson.id") + "_" + dy.getLong("periodentry") + "_" + HRDateTimeUtils.format((Date)dy.getDate("startdate"), (String)"yyyy-MM-dd") + "_" + HRDateTimeUtils.format((Date)dy.getDate("enddate"), (String)"yyyy-MM-dd"));
        this.setExtAttribute(perAttPeriod, dy, param);
        return perAttPeriod;
    }

    private void setExtAttribute(PerAttPeriod perAttPeriod, DynamicObject dy, PerAttPeriodQueryParam param) {
        if (WTCCollections.isNotEmpty((Collection)param.getExtKeys())) {
            HashMap extAttribute = Maps.newHashMapWithExpectedSize((int)param.getExtKeys().size());
            for (String extKey : param.getExtKeys()) {
                extAttribute.put(extKey, dy.get(extKey));
            }
            perAttPeriod.setExtAttribute((Map)extAttribute);
        }
    }

    @Override
    public List<DynamicObject> queryPerAttPeriodDy(PerAttPeriodQueryParam param) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_perattperiod");
        QFilter perAttPeriodQFilter = this.getPerAttPeriodQFilter(param);
        String properties = param.getProperties();
        DynamicObject[] objects = HRStringUtils.isEmpty((String)properties) ? helper.loadDynamicObjectArray(perAttPeriodQFilter.toArray()) : helper.queryOriginalArray(properties, perAttPeriodQFilter.toArray());
        return Arrays.stream(objects).collect(Collectors.toList());
    }

    private QFilter getPerAttPeriodQFilter(PerAttPeriodQueryParam param) {
        String busiStatus;
        Date endDate;
        Date startDate;
        Set periodIdSet;
        Set attPersonIdSet;
        QFilter baseQFilter = new QFilter("id", "is not null", null);
        baseQFilter.and(param.getExtendQFilter());
        Set attFileBoIdSet = param.getAttFileBoIdSet();
        if (!CollectionUtils.isEmpty((Collection)attFileBoIdSet)) {
            baseQFilter.and(this.getInOrEqualsQFilter("attfileid", attFileBoIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(attPersonIdSet = param.getAttPersonIdSet()))) {
            baseQFilter.and(this.getInOrEqualsQFilter("attperson", attPersonIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(periodIdSet = param.getPeriodIdSet()))) {
            baseQFilter.and(this.getInOrEqualsQFilter("periodentry", periodIdSet));
        }
        if ((startDate = param.getStartDate()) != null) {
            baseQFilter.and(new QFilter("enddate", ">=", (Object)startDate));
        }
        if ((endDate = param.getEndDate()) != null) {
            baseQFilter.and(new QFilter("startdate", "<=", (Object)endDate));
        }
        if (HRStringUtils.isNotEmpty((String)(busiStatus = param.getBusiStatus()))) {
            baseQFilter.and(new QFilter("busistatus", "=", (Object)busiStatus));
        }
        return baseQFilter;
    }

    private QFilter getInOrEqualsQFilter(String queryField, Set<Long> idSet) {
        if (idSet.size() == 1) {
            return new QFilter(queryField, "=", idSet.toArray()[0]);
        }
        return new QFilter(queryField, "in", idSet);
    }

    @Override
    public List<PerAttPeriodAndStateInfo> queryPerAttPeriodAndStateInfo(PerAttPeriodQueryParam param) {
        List<PerAttPeriod> perAttPeriodList = this.queryPerAttPeriodEntity(param);
        Map<Long, List<PerAttPeriod>> perAttPeriodListMap = perAttPeriodList.stream().collect(Collectors.groupingBy(PerAttPeriod::getFileBoId));
        HRBaseServiceHelper attStateInfoHelper = new HRBaseServiceHelper("wtp_attstateinfo");
        QFilter qFilter = new QFilter("fileboid", "in", (Object)param.getAttFileBoIdSet());
        DynamicObject[] attStateInfoDys = attStateInfoHelper.queryOriginalArray("accountto, lockto, storageto, fileboid", new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> attStateInfoMap = Arrays.stream(attStateInfoDys).collect(Collectors.groupingBy(dy -> dy.getLong("fileboid")));
        HRBaseServiceHelper settleInfoHelper = new HRBaseServiceHelper("wtte_settleinfo");
        Set perAttPeriodSet = perAttPeriodList.stream().map(perAttPeriod -> perAttPeriod.getPrimaryId()).collect(Collectors.toSet());
        QFilter settleInfoQFilter = new QFilter("attperattperiodpk", "in", perAttPeriodSet);
        settleInfoQFilter.and(new QFilter("busstatus", "=", (Object)"1"));
        DynamicObject[] settleInfoDys = settleInfoHelper.queryOriginalArray("lockdate, storagedate, attperattperiodpk, id", new QFilter[]{settleInfoQFilter});
        Map settleInfoMap = null;
        if (null != settleInfoDys && settleInfoDys.length > 0) {
            settleInfoMap = Arrays.stream(settleInfoDys).collect(Collectors.toMap(dyn -> dyn.getLong("attperattperiodpk"), Function.identity(), (v1, v2) -> v2));
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)perAttPeriodSet.size());
        for (Map.Entry<Long, List<PerAttPeriod>> mapEntry : perAttPeriodListMap.entrySet()) {
            PerAttPeriodAndStateInfo perAttPeriodAndStateInfo = new PerAttPeriodAndStateInfo();
            perAttPeriodAndStateInfo.setPerAttPeriod(mapEntry.getValue());
            Long key = mapEntry.getKey();
            perAttPeriodAndStateInfo.setAttFileBoID(key);
            List<DynamicObject> dynamicObjects = attStateInfoMap.get(key);
            if (dynamicObjects.size() > 0) {
                DynamicObject dy2 = dynamicObjects.get(0);
                perAttPeriodAndStateInfo.setAccountTo(dy2.getDate("accountto"));
                perAttPeriodAndStateInfo.setLockTo(dy2.getDate(LOCK_TO));
                perAttPeriodAndStateInfo.setStorageTo(dy2.getDate(STORAGE_TO));
            }
            List<PerAttPeriod> mapEntryValue = mapEntry.getValue();
            ArrayList<AttStateInfo> attStateInfoList = new ArrayList<AttStateInfo>(mapEntryValue.size());
            for (PerAttPeriod perAttPeriod2 : mapEntryValue) {
                DynamicObject settleInfoDy;
                if (perAttPeriod2 == null) continue;
                AttStateInfo attStateInfo = new AttStateInfo();
                attStateInfo.setPerAttPeriod(perAttPeriod2);
                if (settleInfoMap != null && !settleInfoMap.isEmpty() && null != (settleInfoDy = (DynamicObject)settleInfoMap.get(perAttPeriod2.getPrimaryId()))) {
                    attStateInfo.setLockTime(settleInfoDy.getDate("lockdate"));
                    attStateInfo.setStorageTime(settleInfoDy.getDate("storagedate"));
                    attStateInfo.setId(Long.valueOf(settleInfoDy.getLong("id")));
                }
                attStateInfoList.add(attStateInfo);
            }
            perAttPeriodAndStateInfo.setAttStateInfoList(attStateInfoList);
            list.add(perAttPeriodAndStateInfo);
        }
        return list;
    }

    private static class PerAttPeriodQueryInstance {
        private static final PerAttPeriodQueryServiceImpl singleton = new PerAttPeriodQueryServiceImpl();

        private PerAttPeriodQueryInstance() {
        }
    }
}

