/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.billservice.attfile;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.web.attperiod.AttPeriodCommonService;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.billservice.BillAttFileVersionPlanInfo;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoQuery;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoResp;
import kd.wtc.wtbs.common.model.period.PeriodBillCheckResult;
import kd.wtc.wtbs.common.model.period.PeriodEntryBaseModel;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class BillAttFileService {
    private static final Log LOG = LogFactory.getLog(BillPlanService.class);
    private static final BillAttFileService INS = (BillAttFileService)WTCAppContextHelper.getBean(BillAttFileService.class);

    public static BillAttFileService getInstance() {
        return INS;
    }

    public Map<Long, List<DynamicObject>> getAllAttFileVersion(Set<Long> attFileBoIds) {
        if (CollectionUtils.isEmpty(attFileBoIds)) {
            return Collections.emptyMap();
        }
        List<DynamicObject> attFileVersionList = AttFileQueryServiceImpl.getInstance().queryAttFiles(this.getAttFileQuery(attFileBoIds));
        if (CollectionUtils.isEmpty(attFileVersionList)) {
            return Collections.emptyMap();
        }
        return attFileVersionList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
    }

    public DynamicObject getAttFileVersionByDate(List<DynamicObject> attFileVersionDyList, Date queryDate) {
        Date dayEndTime;
        Date dayStartTime;
        if (CollectionUtils.isEmpty(attFileVersionDyList) || queryDate == null) {
            return null;
        }
        AttFileQueryServiceImpl queryService = AttFileQueryServiceImpl.getInstance();
        List<DynamicObject> attFileDyList = queryService.filterAttFileByHisDateRange(attFileVersionDyList, dayStartTime = WTCDateUtils.getDayStart((Date)queryDate), dayEndTime = WTCDateUtils.getDayStart((Date)queryDate));
        if (CollectionUtils.isEmpty(attFileDyList)) {
            LOG.warn("BillPlanService_getAttFile \u6863\u6848\u7248\u672c\u5207\u5206\u4e3a\u7a7a", (Object)attFileDyList.size());
            return null;
        }
        if (attFileDyList.size() > 1) {
            LOG.warn("BillPlanService_getAttFile \u6863\u6848\u7248\u672c\u5207\u5206\u9519\u8bef ,attFileDy.sie={}", (Object)attFileDyList.size());
            throw new KDBizException(new MultiLangEnumBridge("\u6863\u6848\u7248\u672c\u5207\u5206\u9519\u8bef", "BillAttFileService_0", "wtc-wtbs-business").loadKDString());
        }
        return attFileDyList.get(0);
    }

    private AttFileQueryParam getAttFileQuery(Set<Long> attFileBoIdSet) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(null);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setSetBoIds(attFileBoIdSet);
        return attFileQueryParam;
    }

    public List<BillAttFileVersionPlanInfo> getRelationByAttFileVersionAndPlan(List<DynamicObject> attFileVersionList, List<DynamicObject> attFilePlanDyList, AttFileScheduleEnum scheduleEnum) {
        if (CollectionUtils.isEmpty(attFileVersionList)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(attFilePlanDyList)) {
            return attFileVersionList.stream().map(att -> {
                BillAttFileVersionPlanInfo versionPlanInfo = new BillAttFileVersionPlanInfo();
                versionPlanInfo.setAttFileVid(att.getLong("id"));
                versionPlanInfo.setPlanDyInAttFileVid(Collections.emptyList());
                return versionPlanInfo;
            }).collect(Collectors.toList());
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)attFileVersionList.size());
        Map<Long, List<DynamicObject>> invokeResult = AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleGroupByFileVersion(scheduleEnum, attFileVersionList, attFilePlanDyList);
        for (DynamicObject attFileVersion : attFileVersionList) {
            BillAttFileVersionPlanInfo versionPlanInfo = new BillAttFileVersionPlanInfo();
            long attFileVid = attFileVersion.getLong("id");
            versionPlanInfo.setAttFileVid(attFileVid);
            List<Object> plan = invokeResult.get(attFileVid);
            plan = plan == null ? Collections.emptyList() : plan;
            versionPlanInfo.setPlanDyInAttFileVid(plan);
            result.add(versionPlanInfo);
        }
        return result;
    }

    public List<Tuples.Tuple2<LocalDate, LocalDate>> missWorkExperience(LocalDate startLocalDate, LocalDate endLocalDate, List<DynamicObject> attFileVersionInOneBo) {
        if (startLocalDate == null || endLocalDate == null || WTCCollections.isEmpty(attFileVersionInOneBo)) {
            return Collections.emptyList();
        }
        LOG.info("BillAttFileService_missWorkExperience startLocalDate = {},endLocalDate ={},attFileVersionInOneBo.size = {}", new Object[]{startLocalDate, endLocalDate, attFileVersionInOneBo.size()});
        Optional eleFromList = WTCCollectionIndexUtil.getEleFromList(attFileVersionInOneBo, (int)0);
        if (!eleFromList.isPresent()) {
            return Collections.emptyList();
        }
        DynamicObject firstAttFileVersion = (DynamicObject)eleFromList.get();
        Date endDate = firstAttFileVersion.getDate("enddate");
        if (endDate == null) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> inEffectTimeDy = new ArrayList<DynamicObject>(10);
        for (DynamicObject dynamicObject : attFileVersionInOneBo) {
            Date hisStartDate = dynamicObject.getDate("bsed");
            if (hisStartDate.after(endDate)) continue;
            inEffectTimeDy.add(dynamicObject);
        }
        LOG.info("BillAttFileService_missWorkExperience after inEffectTimeDy = {}", (Object)inEffectTimeDy.size());
        Iterator iterator = inEffectTimeDy.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            String empStatus = next.getString("empposorgrel.datastatus");
            if ("-1".equals(empStatus)) continue;
            iterator.remove();
        }
        LOG.info("BillAttFileService_missWorkExperience after datastatus.size = {}", (Object)inEffectTimeDy.size());
        if (WTCCollections.isEmpty(inEffectTimeDy)) {
            return Collections.emptyList();
        }
        ArrayList<Tuples.Tuple2<LocalDate, LocalDate>> timeCross = new ArrayList<Tuples.Tuple2<LocalDate, LocalDate>>(10);
        for (DynamicObject dynamicObject : inEffectTimeDy) {
            List timeCrossTmp;
            Date hisStartDate = dynamicObject.getDate("bsed");
            Date hisEndDate = dynamicObject.getDate("bsled");
            if (hisStartDate == null || hisEndDate == null || !WTCCollections.isNotEmpty((Collection)(timeCrossTmp = WTCDateUtils.getTimeCross((Tuples.Tuple2)new Tuples.Tuple2((Object)startLocalDate, (Object)endLocalDate), (Tuples.Tuple2)new Tuples.Tuple2((Object)WTCDateUtils.toLocalDate((Date)hisStartDate), (Object)WTCDateUtils.toLocalDate((Date)hisEndDate)))))) continue;
            timeCross.addAll(timeCrossTmp);
        }
        if (WTCCollections.isEmpty(timeCross)) {
            return timeCross;
        }
        return this.optimizationTimeLine(timeCross, true);
    }

    public Optional<PeriodBillCheckResult> getPerAttPeriods(Map<Long, List<LocalDate>> needQueryPeriodPersonMap) {
        if (needQueryPeriodPersonMap == null) {
            return Optional.empty();
        }
        if (needQueryPeriodPersonMap.size() > 1000) {
            LOG.info("BillAttFileService_getPerAttPeriods max support 1000 person period query");
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u652f\u63011000\u4e2a\u8003\u52e4\u4eba\u7684\u8003\u52e4\u671f\u95f4\u67e5\u8be2\u3002", (String)"BillAttFileService_9", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        ArrayList<HashMap> group = new ArrayList<HashMap>(16);
        int num = 0;
        HashMap<Long, List<LocalDate>> newMap = new HashMap<Long, List<LocalDate>>(16);
        for (Map.Entry<Long, List<LocalDate>> personIdAndQueryDate : needQueryPeriodPersonMap.entrySet()) {
            newMap.put(personIdAndQueryDate.getKey(), personIdAndQueryDate.getValue());
            if (++num < 500) continue;
            group.add(Maps.newHashMap(newMap));
            newMap.clear();
            num = 0;
        }
        group.add(Maps.newHashMap(newMap));
        AttPeriodCommonService commonService = new AttPeriodCommonService();
        ArrayList<PeriodBillCheckResult> periodBillCheckResultList = new ArrayList<PeriodBillCheckResult>(10);
        LOG.info("BillAttFileService_getPerAttPeriods needQueryPeriodPersonMap.size = {}, group.size = {}", (Object)needQueryPeriodPersonMap.size(), (Object)group.size());
        for (Map map : group) {
            PeriodBillCheckResult periodBillCheckResult = commonService.getPeriodBillCheckResult(map);
            BillAttFileService.getBillPeriodKeyInfoLog(periodBillCheckResult, LOG);
            if (periodBillCheckResult == null) continue;
            periodBillCheckResultList.add(periodBillCheckResult);
        }
        Optional firstOption = WTCCollectionIndexUtil.getEleFromList(periodBillCheckResultList, (int)0);
        if (!firstOption.isPresent()) {
            return Optional.empty();
        }
        PeriodBillCheckResult periodBillCheckResult = (PeriodBillCheckResult)firstOption.get();
        Map personToDateToPeriodEntryTupleMap = periodBillCheckResult.getPersonToDateToPeriodEntryTupleMap();
        Map periodEntryBaseModelList = periodBillCheckResult.getPeriodEntryBaseModelList();
        for (int index = 1; index < periodBillCheckResultList.size(); ++index) {
            PeriodBillCheckResult checkResult = (PeriodBillCheckResult)periodBillCheckResultList.get(index);
            if (checkResult == null) continue;
            Map newPersonPeriod = checkResult.getPersonToDateToPeriodEntryTupleMap();
            Map newPeriodEntry = checkResult.getPeriodEntryBaseModelList();
            if (newPersonPeriod != null) {
                personToDateToPeriodEntryTupleMap.putAll(newPersonPeriod);
            }
            if (newPeriodEntry == null) continue;
            periodEntryBaseModelList.putAll(newPeriodEntry);
        }
        return Optional.of(periodBillCheckResult);
    }

    public Optional<Tuples.Tuple2<LocalDate, LocalDate>> getPeriodStartAndEnd(PeriodBillCheckResult periodBillCheckResult, long personId, LocalDate periodListDate, LocalDate targetDate) {
        if (periodBillCheckResult == null || periodListDate == null || targetDate == null) {
            LOG.info("BillAttFileService_checkBillPeriod getPeriodStartAndEnd == null  || queryDate == null || targetDate == null");
            return Optional.empty();
        }
        Map dateAndPeriodInfo = (Map)periodBillCheckResult.getPersonToDateToPeriodEntryTupleMap().get(personId);
        if (WTCCollections.isEmpty((Map)dateAndPeriodInfo)) {
            LOG.info("BillAttFileService_checkBillPeriod dateAndPeriodInfo == null,personid={}", (Object)personId);
            return Optional.empty();
        }
        BillAttFileService.getBillPeriodKeyInfoLog(periodBillCheckResult, LOG);
        Tuple periodInfo = (Tuple)dateAndPeriodInfo.get(periodListDate);
        if (periodInfo == null) {
            return Optional.empty();
        }
        Long value = (Long)periodInfo.getValue();
        Map periodEntryBaseModelList = periodBillCheckResult.getPeriodEntryBaseModelList();
        if (WTCCollections.isEmpty((Map)periodEntryBaseModelList)) {
            LOG.info("BillAttFileService_checkBillPeriod periodEntryBaseModelList is empty");
            return Optional.empty();
        }
        List periodEntryBaseModels = (List)periodEntryBaseModelList.get(value);
        if (WTCCollections.isEmpty((Collection)periodEntryBaseModels)) {
            return Optional.empty();
        }
        for (PeriodEntryBaseModel periodEntryBaseModel : periodEntryBaseModels) {
            LocalDate startDate = periodEntryBaseModel.getStartDate();
            LocalDate endDate = periodEntryBaseModel.getEndDate();
            if (startDate == null || endDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4\u7684startDate\u3001endDate \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillAttFileService_12", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("BillAttFileService_checkBillPeriod  targetDate={},startDate = {} , endDate = {}", new Object[]{targetDate, startDate, endDate});
            }
            if (!WTCDateUtils.betweenTimeEquals((Date)WTCDateUtils.toDate((LocalDate)targetDate), (Date)WTCDateUtils.toDate((LocalDate)startDate), (Date)WTCDateUtils.toDate((LocalDate)endDate))) continue;
            LOG.info("BillAttFileService_checkBillPeriod  targetDate={},startDate = {} , endDate = {}", new Object[]{targetDate, startDate, endDate});
            return Optional.of(new Tuples.Tuple2((Object)startDate, (Object)endDate));
        }
        LOG.info("BillAttFileService_checkBillPeriod  not match");
        return Optional.empty();
    }

    public BillPeriodInfoResp checkBillPeriod(BillPeriodInfoQuery billPeriodInfoQuery) {
        if (billPeriodInfoQuery == null) {
            LOG.info("BillAttFileService_checkBillPeriod billPeriodInfoQuery == null");
            return BillPeriodInfoResp.failAll((long)0L, (String)ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8003\u52e4\u671f\u95f4\u3002", (String)"BillAttFileService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        long personId = billPeriodInfoQuery.getPersonId();
        Set verifyDate = billPeriodInfoQuery.getVerifyDate();
        if (WTCCollections.isEmpty((Collection)verifyDate)) {
            LOG.info("BillAttFileService_checkBillPeriod verifydate is empty");
            return BillPeriodInfoResp.success((long)billPeriodInfoQuery.getPersonId());
        }
        if (billPeriodInfoQuery.getPeriodBillCheckResult() == null || billPeriodInfoQuery.getPeriodBillCheckResult().getPeriodEntryBaseModelList() == null) {
            LOG.info("BillAttFileService_checkBillPeriod billPeriodInfoQuery.getPeriodBillCheckResult() == null || billPeriodInfoQuery.getPeriodBillCheckResult().getPeriodEntryBaseModelList() == null");
            return BillPeriodInfoResp.failAll((long)0L, (String)ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8003\u52e4\u671f\u95f4\u3002", (String)"BillAttFileService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        LOG.info("BillAttFileService_checkBillPeriod personId = {},verifyDate = {},maxAdvance = {},advance = {},after = {},PeriodBillCheckResult = {}", new Object[]{personId, verifyDate, billPeriodInfoQuery.getMaxAdvance(), billPeriodInfoQuery.getAdvance(), billPeriodInfoQuery.getAfter()});
        PeriodBillCheckResult periodBillCheckResult = billPeriodInfoQuery.getPeriodBillCheckResult();
        Map dateAndPeriodInfo = (Map)periodBillCheckResult.getPersonToDateToPeriodEntryTupleMap().get(personId);
        if (WTCCollections.isEmpty((Map)dateAndPeriodInfo)) {
            LOG.info("BillAttFileService_checkBillPeriod dateAndPeriodInfo == null,personid={}", (Object)personId);
            return BillPeriodInfoResp.failAll((long)personId, (String)ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8003\u52e4\u671f\u95f4\u3002", (String)"BillAttFileService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        BillAttFileService.getBillPeriodKeyInfoLog(periodBillCheckResult, LOG);
        List<LocalDate> needVerifyDateAfterSort = this.sortAsc(verifyDate);
        Integer after = billPeriodInfoQuery.getAfter();
        Integer maxAdvance = billPeriodInfoQuery.getMaxAdvance();
        Integer advance = billPeriodInfoQuery.getAdvance();
        boolean isCheckAdvance = billPeriodInfoQuery.isCheckAdvance();
        boolean isCheckAfter = billPeriodInfoQuery.isCheckAfter();
        Map periodEntryBaseModelList = periodBillCheckResult.getPeriodEntryBaseModelList();
        periodEntryBaseModelList = periodEntryBaseModelList == null ? Collections.emptyMap() : periodEntryBaseModelList;
        Tuples.Tuple3<List<PeriodEntryBaseModel>, List<PeriodEntryBaseModel>, List<Tuples.Tuple2<LocalDate, LocalDate>>> afterAndAdvMissPeriod = this.getAfterAndAdvMissPeriod(needVerifyDateAfterSort, dateAndPeriodInfo, periodEntryBaseModelList);
        List periodEntryBaseModelsAfter = (List)afterAndAdvMissPeriod.item1;
        List periodEntryBaseModelsAdv = (List)afterAndAdvMissPeriod.item2;
        List missPeriod = (List)afterAndAdvMissPeriod.item3;
        if (WTCCollections.isNotEmpty((Collection)missPeriod)) {
            List<Tuples.Tuple2<LocalDate, LocalDate>> optimziaMissPeriods = this.optimizationTimeLine(missPeriod, false);
            BillPeriodInfoResp billPeriodInfoResp = BillPeriodInfoResp.failAll((long)personId, optimziaMissPeriods);
            billPeriodInfoResp.setCheckAdvance(isCheckAdvance);
            billPeriodInfoResp.setCheckAfter(isCheckAfter);
            this.fillPutRespInfo(billPeriodInfoResp, after, maxAdvance, advance);
            return billPeriodInfoResp;
        }
        BillPeriodInfoResp resp = BillPeriodInfoResp.success((long)personId);
        resp.setCheckAdvance(isCheckAdvance);
        resp.setCheckAfter(isCheckAfter);
        if (isCheckAfter && after != null) {
            this.setAfter(resp, after, verifyDate, periodEntryBaseModelsAfter);
        }
        if (isCheckAdvance && maxAdvance != null) {
            this.setMaxAdvance(resp, maxAdvance, verifyDate, periodEntryBaseModelsAdv);
        }
        if (isCheckAdvance && advance != null) {
            this.setAdvance(resp, advance, verifyDate, periodEntryBaseModelsAdv);
        }
        this.fillPutRespInfo(resp, after, maxAdvance, advance);
        return resp;
    }

    private void fillPutRespInfo(BillPeriodInfoResp resp, Integer after, Integer maxAdvance, Integer advance) {
        boolean passMaxAdvance;
        if (!resp.isPassPeriodExistCheck()) {
            List<Tuples.Tuple2<LocalDate, LocalDate>> missPeriods = this.optimizationTimeLine(resp.getMissPeriods(), false);
            resp.setTipInfo(this.getMissErrorInfo(missPeriods));
            return;
        }
        boolean afterPeriodCheck = resp.isAfterPeriodCheck();
        boolean advancePeriodCheck = resp.isAdvancePeriodCheck();
        boolean maxAdvancePeriodCheck = resp.isMaxAdvancePeriodCheck();
        boolean passAfter = !resp.isCheckAfter() || afterPeriodCheck;
        boolean passAdvance = !resp.isCheckAdvance() || advancePeriodCheck;
        boolean bl = passMaxAdvance = !resp.isCheckAdvance() || maxAdvancePeriodCheck;
        if (!(passAfter && passAdvance && passMaxAdvance)) {
            String tip = this.outputTip(passAfter, passAdvance, passMaxAdvance, after, advance, maxAdvance);
            resp.setTipInfo(tip);
        }
    }

    private String outputTip(boolean passAfter, boolean passAdvance, boolean passMaxAdvance, Integer afterNum, Integer advanceNum, Integer maxAdvanceNum) {
        afterNum = afterNum == null ? Integer.valueOf(-1) : afterNum;
        advanceNum = advanceNum == null ? Integer.valueOf(-1) : advanceNum;
        Integer n = maxAdvanceNum = maxAdvanceNum == null ? Integer.valueOf(-1) : maxAdvanceNum;
        if (!(passAfter || passAdvance || passMaxAdvance)) {
            String tip = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u5141\u8bb8\u8865\u63d0{0}\u4e2a\u8003\u52e4\u671f\u95f4\u5185\u7684\u7533\u8bf7\uff0c\u81f3\u5c11\u9700\u8981\u63d0\u524d{1}\u4e2a\u8003\u52e4\u671f\u95f4\u63d0\u4ea4\u7533\u8bf7\uff0c\u540c\u65f6\u6700\u591a\u53ea\u80fd\u63d0\u4ea4{2}\u4e2a\u8003\u52e4\u671f\u95f4\u7684\u7533\u8bf7\u3002", (String)"BillAttFileService_13", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            return MessageFormat.format(tip, afterNum, advanceNum, maxAdvanceNum);
        }
        if (!passAfter && !passAdvance && passMaxAdvance) {
            String tip = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u5141\u8bb8\u8865\u63d0{0}\u4e2a\u8003\u52e4\u671f\u95f4\u5185\u7684\u7533\u8bf7\uff0c\u540c\u65f6\u81f3\u5c11\u9700\u8981\u63d0\u524d{1}\u4e2a\u8003\u52e4\u671f\u95f4\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"BillAttFileService_14", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            return MessageFormat.format(tip, afterNum, advanceNum);
        }
        if (!passAfter && passAdvance && !passMaxAdvance) {
            String tip = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u5141\u8bb8\u8865\u63d0{0}\u4e2a\u8003\u52e4\u671f\u95f4\u5185\u7684\u7533\u8bf7\uff0c\u540c\u65f6\u6700\u591a\u53ea\u80fd\u63d0\u4ea4{1}\u4e2a\u8003\u52e4\u671f\u95f4\u7684\u7533\u8bf7\u3002", (String)"BillAttFileService_15", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            return MessageFormat.format(tip, afterNum, maxAdvanceNum);
        }
        if (passAfter && !passAdvance && !passMaxAdvance) {
            String tip = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u81f3\u5c11\u9700\u8981\u63d0\u524d{0}\u4e2a\u8003\u52e4\u671f\u95f4\u63d0\u4ea4\u7533\u8bf7\uff0c\u540c\u65f6\u6700\u591a\u53ea\u80fd\u63d0\u4ea4{1}\u4e2a\u8003\u52e4\u671f\u95f4\u7684\u7533\u8bf7\u3002", (String)"BillAttFileService_16", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            return MessageFormat.format(tip, advanceNum, maxAdvanceNum);
        }
        if (!passAfter && passAdvance && passMaxAdvance) {
            String tip = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u5141\u8bb8\u8865\u63d0{0}\u4e2a\u8003\u52e4\u671f\u95f4\u5185\u7684\u7533\u8bf7\u3002", (String)"BillAttFileService_17", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            return MessageFormat.format(tip, afterNum);
        }
        if (passAfter && !passAdvance && passMaxAdvance) {
            String tip = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u81f3\u5c11\u9700\u8981\u63d0\u524d{0}\u4e2a\u8003\u52e4\u671f\u95f4\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"BillAttFileService_18", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            return MessageFormat.format(tip, advanceNum);
        }
        if (passAfter && passAdvance && !passMaxAdvance) {
            String tip = ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u63d0\u5355\u65e5\u671f\u8303\u56f4\u9650\u5236\uff0c\u6700\u591a\u53ea\u80fd\u63d0\u4ea4{0}\u4e2a\u8003\u52e4\u671f\u95f4\u7684\u7533\u8bf7\u3002", (String)"BillAttFileService_19", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            return MessageFormat.format(tip, maxAdvanceNum);
        }
        return ResManager.loadKDString((String)"\u7533\u8bf7\u4e0d\u7b26\u5408\u8003\u52e4\u671f\u95f4\u7684\u8303\u56f4\u3002", (String)"BillAttFileService_20", (String)"wtc-wtbs-business", (Object[])new Object[0]);
    }

    private List<Tuples.Tuple2<LocalDate, LocalDate>> optimizationTimeLine(List<Tuples.Tuple2<LocalDate, LocalDate>> dates, boolean isLinkNextDate) {
        if (WTCCollections.isEmpty(dates)) {
            return Collections.emptyList();
        }
        dates.sort(new Comparator<Tuples.Tuple2<LocalDate, LocalDate>>(){

            @Override
            public int compare(Tuples.Tuple2<LocalDate, LocalDate> o1, Tuples.Tuple2<LocalDate, LocalDate> o2) {
                LocalDate item1 = o1 == null || o1.item1 == null ? WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMaxEndDate()) : (LocalDate)o1.item1;
                LocalDate item2 = o2 == null || o2.item1 == null ? WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMaxEndDate()) : (LocalDate)o2.item2;
                return item1.compareTo(item2);
            }
        });
        ArrayList<Tuples.Tuple2<LocalDate, LocalDate>> optimizationResult = new ArrayList<Tuples.Tuple2<LocalDate, LocalDate>>(10);
        Tuples.Tuple2<LocalDate, LocalDate> lastTmp = dates.get(0);
        if (dates.size() == 1) {
            optimizationResult.add(lastTmp);
            return optimizationResult;
        }
        LocalDate tmpStart = (LocalDate)lastTmp.item1;
        LocalDate tmpEnd = (LocalDate)lastTmp.item2;
        for (int index = 1; index < dates.size(); ++index) {
            Tuples.Tuple2<LocalDate, LocalDate> next = dates.get(index);
            LocalDate nextStart = (LocalDate)next.item1;
            LocalDate nextEnd = (LocalDate)next.item2;
            boolean link = true;
            if (!isLinkNextDate) {
                link = nextStart.isAfter(tmpEnd);
            } else {
                LocalDate nextDate = tmpEnd.plusDays(1L);
                boolean bl = link = !nextStart.isEqual(nextDate);
            }
            if (link) {
                optimizationResult.add((Tuples.Tuple2<LocalDate, LocalDate>)new Tuples.Tuple2((Object)tmpStart, (Object)tmpEnd));
                tmpStart = nextStart;
                tmpEnd = nextEnd;
                continue;
            }
            tmpEnd = tmpEnd.isAfter(nextEnd) ? tmpEnd : nextEnd;
        }
        optimizationResult.add((Tuples.Tuple2<LocalDate, LocalDate>)new Tuples.Tuple2((Object)tmpStart, (Object)tmpEnd));
        return optimizationResult;
    }

    private String getMissErrorInfo(List<Tuples.Tuple2<LocalDate, LocalDate>> missPeriods) {
        ArrayList<String> dateInfo = new ArrayList<String>(10);
        ZoneId zoneId = WTCInteDateUtil.getSysTimeZone().getTimeZone().toZoneId();
        for (Tuples.Tuple2<LocalDate, LocalDate> missPeriod : missPeriods) {
            if (missPeriod.item1 == null || missPeriod.item2 == null || ((LocalDate)missPeriod.item1).atStartOfDay(zoneId) == null || ((LocalDate)missPeriod.item2).atStartOfDay(zoneId) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u5bf9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillAttFileService_21", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            if (((LocalDate)missPeriod.item1).isEqual((ChronoLocalDate)missPeriod.item2)) {
                dateInfo.add(WTCDateUtils.format((LocalDate)((LocalDate)missPeriod.item1)));
                continue;
            }
            String getTo = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"BillAttFileService_7", (String)"wtc-wtbs-business", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)Date.from(((LocalDate)missPeriod.item1).atStartOfDay(zoneId).toInstant())), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)Date.from(((LocalDate)missPeriod.item2).atStartOfDay(zoneId).toInstant())));
            dateInfo.add(getTo);
        }
        String fixInfo = String.join((CharSequence)WTCSymbolMultiLanguageUtil.getCaesuraSymbol(), dateInfo);
        String errorInfo = ResManager.loadKDString((String)"{0}\u6ca1\u6709\u8003\u52e4\u671f\u95f4\uff0c\u8bf7\u8c03\u6574\u65f6\u95f4\u6216\u8bbe\u7f6e\u8003\u52e4\u671f\u95f4\u3002", (String)"BillAttFileService_8", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        return MessageFormat.format(errorInfo, fixInfo);
    }

    private void setAfter(BillPeriodInfoResp resp, Integer afterVerify, Set<LocalDate> needVerifyDate, List<PeriodEntryBaseModel> periodEntryBaseModelsAfter) {
        LocalDate now = LocalDate.now();
        List afterDate = needVerifyDate.stream().filter(nv -> nv.isBefore(now)).collect(Collectors.toList());
        if (WTCCollections.isEmpty(afterDate)) {
            resp.setAfterPeriodCheck(true);
            return;
        }
        boolean checkResult = true;
        for (LocalDate localDate : afterDate) {
            int offSet = this.getOffSet(localDate, periodEntryBaseModelsAfter);
            checkResult = -afterVerify.intValue() <= offSet;
            if (checkResult) continue;
            break;
        }
        resp.setAfterPeriodCheck(checkResult);
    }

    private void setAdvance(BillPeriodInfoResp resp, Integer afterVerify, Set<LocalDate> needVerifyDate, List<PeriodEntryBaseModel> periodEntryBaseModelsAfter) {
        LocalDate now = LocalDate.now();
        List advDate = needVerifyDate.stream().filter(nv -> !nv.isBefore(now)).collect(Collectors.toList());
        if (WTCCollections.isEmpty(advDate)) {
            resp.setAdvancePeriodCheck(true);
            return;
        }
        boolean checkResult = true;
        for (LocalDate localDate : advDate) {
            int offSet = this.getOffSet(localDate, periodEntryBaseModelsAfter);
            checkResult = afterVerify <= offSet;
            if (checkResult) continue;
            break;
        }
        resp.setAdvancePeriodCheck(checkResult);
    }

    private void setMaxAdvance(BillPeriodInfoResp resp, Integer afterVerify, Set<LocalDate> needVerifyDate, List<PeriodEntryBaseModel> periodEntryBaseModelsAfter) {
        LocalDate now = LocalDate.now();
        List maxAdvDate = needVerifyDate.stream().filter(nv -> !nv.isBefore(now)).collect(Collectors.toList());
        if (WTCCollections.isEmpty(maxAdvDate)) {
            resp.setMaxAdvancePeriodCheck(true);
            return;
        }
        boolean checkResult = true;
        for (LocalDate localDate : maxAdvDate) {
            int offSet = this.getOffSet(localDate, periodEntryBaseModelsAfter);
            checkResult = afterVerify >= offSet;
            if (checkResult) continue;
            break;
        }
        resp.setMaxAdvancePeriodCheck(checkResult);
    }

    private int getOffSet(LocalDate verifyDate, List<PeriodEntryBaseModel> periodEntryBaseModels) {
        LocalDate now = LocalDate.now();
        int verifyIndex = -1;
        int nowDateIndex = -1;
        for (int index = 0; index < periodEntryBaseModels.size(); ++index) {
            PeriodEntryBaseModel periodEntryBaseModel = periodEntryBaseModels.get(index);
            LocalDate startDate = periodEntryBaseModel.getStartDate();
            LocalDate endDate = periodEntryBaseModel.getEndDate();
            if (startDate == null || endDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4\u7684startDate\u3001endDate \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillAttFileService_12", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            if (WTCDateUtils.betweenTimeEquals((Date)WTCDateUtils.toDate((LocalDate)verifyDate), (Date)WTCDateUtils.toDate((LocalDate)startDate), (Date)WTCDateUtils.toDate((LocalDate)endDate))) {
                verifyIndex = index;
            }
            if (!WTCDateUtils.betweenTimeEquals((Date)WTCDateUtils.toDate((LocalDate)now), (Date)WTCDateUtils.toDate((LocalDate)startDate), (Date)WTCDateUtils.toDate((LocalDate)endDate))) continue;
            nowDateIndex = index;
        }
        return verifyIndex - nowDateIndex;
    }

    private Tuples.Tuple3<List<PeriodEntryBaseModel>, List<PeriodEntryBaseModel>, List<Tuples.Tuple2<LocalDate, LocalDate>>> getAfterAndAdvMissPeriod(List<LocalDate> needVerifyDate, Map<LocalDate, Tuple<Long, Long>> dateAndPeriodInfo, Map<Long, List<PeriodEntryBaseModel>> periodEntryBaseModelList) {
        LocalDate localDateStart = needVerifyDate.get(0);
        LocalDate localDateEnd = needVerifyDate.get(needVerifyDate.size() - 1);
        ArrayList<Object> missPeriod = new ArrayList<Object>(10);
        List<PeriodEntryBaseModel> periodEntryBaseModelsAfter = Collections.emptyList();
        LocalDate now = LocalDate.now();
        if (localDateStart.isBefore(now)) {
            if (!dateAndPeriodInfo.containsKey(localDateStart)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0cdateAndPeriodInfo\u6570\u636e\u6ca1\u6709\u67e5\u8be2\u5230\u65e5\u671f\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillAttFileService_10", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            Tuple<Long, Long> after = dateAndPeriodInfo.get(localDateStart);
            if (after == null) {
                missPeriod.add(new Tuples.Tuple2((Object)localDateStart, (Object)now));
            } else {
                periodEntryBaseModelsAfter = periodEntryBaseModelList.get(after.getValue());
                missPeriod.addAll(this.getMissingPeriod(localDateStart, now, periodEntryBaseModelsAfter));
            }
        }
        List<PeriodEntryBaseModel> periodEntryBaseModelsAdv = Collections.emptyList();
        if (!localDateEnd.isBefore(now)) {
            if (!dateAndPeriodInfo.containsKey(localDateEnd)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0cdateAndPeriodInfo\u6570\u636e\u6ca1\u6709\u67e5\u8be2\u5230\u65e5\u671f\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillAttFileService_10", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            Tuple<Long, Long> advance = dateAndPeriodInfo.get(localDateEnd);
            if (advance == null) {
                missPeriod.add(new Tuples.Tuple2((Object)now, (Object)localDateEnd));
            } else {
                periodEntryBaseModelsAdv = periodEntryBaseModelList.get(advance.getValue());
                missPeriod.addAll(this.getMissingPeriod(now, localDateEnd, periodEntryBaseModelsAdv));
            }
        }
        return new Tuples.Tuple3(periodEntryBaseModelsAfter, periodEntryBaseModelsAdv, missPeriod);
    }

    private List<Tuples.Tuple2<LocalDate, LocalDate>> getMissingPeriod(LocalDate startDate, LocalDate endDate, List<PeriodEntryBaseModel> periodEntryBaseModels) {
        ArrayList<Tuples.Tuple2<LocalDate, LocalDate>> result = new ArrayList<Tuples.Tuple2<LocalDate, LocalDate>>(10);
        periodEntryBaseModels = periodEntryBaseModels == null ? Collections.emptyList() : periodEntryBaseModels;
        ArrayList<PeriodEntryBaseModel> afterFilter = new ArrayList<PeriodEntryBaseModel>(16);
        Date startDateToDate = WTCDateUtils.toDate((LocalDate)startDate);
        Date endDateToDate = WTCDateUtils.toDate((LocalDate)endDate);
        for (PeriodEntryBaseModel periodEntryBaseModel : periodEntryBaseModels) {
            Date end;
            LocalDate startDateFirst = periodEntryBaseModel.getStartDate();
            LocalDate endDateFirst = periodEntryBaseModel.getEndDate();
            if (startDateFirst == null || endDateFirst == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4\u7684startDate\u3001endDate \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillAttFileService_12", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            Date start = WTCDateUtils.toDate((LocalDate)startDateFirst);
            if (!WTCDateUtils.betweenTimeEquals((Date)startDateToDate, (Date)start, (Date)(end = WTCDateUtils.toDate((LocalDate)endDateFirst))) && !WTCDateUtils.betweenTimeEquals((Date)endDateToDate, (Date)start, (Date)end) && !WTCDateUtils.betweenTimeEquals((Date)start, (Date)startDateToDate, (Date)endDateToDate) && !WTCDateUtils.betweenTimeEquals((Date)end, (Date)startDateToDate, (Date)endDateToDate)) continue;
            afterFilter.add(periodEntryBaseModel);
        }
        if (WTCCollections.isEmpty(afterFilter)) {
            result.add(new Tuples.Tuple2((Object)startDate, (Object)endDate));
            return result;
        }
        PeriodEntryBaseModel periodEntryBaseModelFirst = (PeriodEntryBaseModel)afterFilter.get(0);
        LocalDate localDate = periodEntryBaseModelFirst.getStartDate();
        LocalDate endDateFirst = periodEntryBaseModelFirst.getEndDate();
        if (localDate == null || endDateFirst == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4\u7684startDate\u3001endDate \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillAttFileService_12", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        if (startDate.isBefore(localDate)) {
            result.add((Tuples.Tuple2<LocalDate, LocalDate>)new Tuples.Tuple2((Object)startDate, (Object)localDate.plusDays(-1L)));
        }
        LocalDate endTmp = endDateFirst;
        if (afterFilter.size() > 1) {
            for (int index = 1; index < afterFilter.size(); ++index) {
                PeriodEntryBaseModel periodEntryBaseModel = (PeriodEntryBaseModel)afterFilter.get(index);
                LocalDate startDatePeriod = periodEntryBaseModel.getStartDate();
                LocalDate endDatePeriod = periodEntryBaseModel.getEndDate();
                if (startDatePeriod == null || endDatePeriod == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8003\u52e4\u671f\u95f4\u7684startDate\u3001endDate \u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillAttFileService_12", (String)"wtc-wtbs-business", (Object[])new Object[0]));
                }
                if (!endTmp.plusDays(1L).isEqual(startDatePeriod)) {
                    LocalDate sub = startDatePeriod.plusDays(-1L);
                    LocalDate lastEndDesc = sub.isAfter(endDate) ? endDate : sub;
                    result.add((Tuples.Tuple2<LocalDate, LocalDate>)new Tuples.Tuple2((Object)endTmp, (Object)lastEndDesc));
                }
                endTmp = endDatePeriod;
            }
        }
        if (endTmp.isBefore(endDate)) {
            result.add((Tuples.Tuple2<LocalDate, LocalDate>)new Tuples.Tuple2((Object)endTmp.plusDays(1L), (Object)endDate));
        }
        return result;
    }

    private List<LocalDate> sortAsc(Set<LocalDate> dates) {
        return dates.stream().sorted((o1, o2) -> {
            o1 = o1 == null ? WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinEndDate()) : o1;
            o2 = o2 == null ? WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinEndDate()) : o2;
            return o1.compareTo((ChronoLocalDate)o2);
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public static void getQueryLog(Map<Long, List<LocalDate>> dateListMap, Log log) {
        try {
            log.info("getQueryLog dateListMap = {} ", (Object)JSON.toJSONString(dateListMap));
        }
        catch (Exception ex) {
            log.warn("make getBillPeriodKeyInfoLog info error");
        }
    }

    public static void getBillPeriodKeyInfoLog(PeriodBillCheckResult checkResult, Log log) {
        try {
            if (log == null) {
                return;
            }
            if (checkResult == null) {
                log.info("PeriodBillCheckResult is null");
                return;
            }
            if (LOG.isDebugEnabled()) {
                log.debug("debug info >>>>>> getPersonToDateToPeriodEntryTupleMap = {} ", (Object)JSON.toJSONString((Object)checkResult.getPersonToDateToPeriodEntryTupleMap()));
                log.debug("debug info >>>>>> PeriodBillCheckResult_keySet = {} ", (Object)JSON.toJSONString((Object)checkResult));
            }
            Map periodEntryBaseModelList = checkResult.getPeriodEntryBaseModelList();
            Set keySet = periodEntryBaseModelList.keySet();
            log.info("periodEntryBaseModelList_keySet = {}", keySet);
            Map personData = checkResult.getPersonToDateToPeriodEntryTupleMap();
            if (personData == null) {
                log.info("personData is null");
            } else {
                for (Map.Entry longMapEntry : personData.entrySet()) {
                    Map value = (Map)longMapEntry.getValue();
                    for (Map.Entry localDateTupleEntry : value.entrySet()) {
                        if (localDateTupleEntry.getValue() != null) continue;
                        log.info("Map<LocalDate, Tuple<Long, Long>>> is null,personId = {},LocalDate = {}", longMapEntry.getKey(), localDateTupleEntry.getKey());
                    }
                }
            }
        }
        catch (Exception ex) {
            log.warn("make getBillPeriodKeyInfoLog info error");
        }
    }
}

