/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.billservice.baseset;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.applybill.matchcore.afterrulecal.UnifyARCAdvanceAndAfterService;
import kd.wtc.wtbs.business.web.attperiod.PerAttPeriodQueryServiceImpl;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.model.billservice.BillServiceBaseSetInfo;
import kd.wtc.wtbs.common.model.billservice.BillServiceMaxAdvLimitResp;
import kd.wtc.wtbs.common.model.evaluation.RosterRepairAndAdvance;
import kd.wtc.wtbs.common.model.result.BillPeriodCheck;
import kd.wtc.wtbs.common.util.WTCDateUtils;

@Deprecated
public class BillBaseSetService {
    private static final Log LOG = LogFactory.getLog(UnifyARCAdvanceAndAfterService.class);
    private List<BillServiceBaseSetInfo> billServiceBaseSetInfos;
    private Map<BillServiceBaseSetInfo, Integer> billWeekDayMap = new HashMap<BillServiceBaseSetInfo, Integer>(16);
    private Map<BillServiceBaseSetInfo, BillPeriodCheck> billPeriodCheckMap = new HashMap<BillServiceBaseSetInfo, BillPeriodCheck>(16);

    private BillBaseSetService() {
    }

    public BillBaseSetService(List<BillServiceBaseSetInfo> billServiceBaseSetInfos) {
        this.billServiceBaseSetInfos = billServiceBaseSetInfos;
    }

    public List<BillServiceMaxAdvLimitResp> passMaxAdvance() {
        if (CollectionUtils.isEmpty(this.billServiceBaseSetInfos)) {
            return Collections.emptyList();
        }
        this.getInvokeRegionMethodInfo();
        this.getWeekDayInfo();
        this.getPeriodCheckInfo();
        ArrayList<BillServiceMaxAdvLimitResp> result = new ArrayList<BillServiceMaxAdvLimitResp>(10);
        for (BillServiceBaseSetInfo billServiceBaseSetInfo : this.billServiceBaseSetInfos) {
            BillServiceMaxAdvLimitResp advLimitResp = new BillServiceMaxAdvLimitResp();
            advLimitResp.setBaseSetInfo(billServiceBaseSetInfo);
            DynamicObject baseSetDy = billServiceBaseSetInfo.getBaseSetDy();
            if (baseSetDy == null || !baseSetDy.getBoolean(billServiceBaseSetInfo.getIsMaxAdvanceCrl())) {
                advLimitResp.setPassCheck(true);
                result.add(advLimitResp);
                continue;
            }
            String unit = baseSetDy.getString(billServiceBaseSetInfo.getMaxAdvanceUnit());
            int baseOffset = baseSetDy.getInt(billServiceBaseSetInfo.getMaxAdvanceNum());
            advLimitResp.setMaxLimitNum(Integer.valueOf(baseOffset));
            advLimitResp.setMaxLimitUnit(unit);
            boolean pass = false;
            if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.DAY.getCode())) {
                pass = this.passDay(billServiceBaseSetInfo.getCheckDate(), baseOffset);
            } else if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.PERIOD.getCode())) {
                BillPeriodCheck billPeriodCheck = this.billPeriodCheckMap.get(billServiceBaseSetInfo);
                advLimitResp.setBillPeriodCheck(billPeriodCheck);
                pass = this.passPeriodCheck(billPeriodCheck, baseOffset);
            } else if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.WEEKDAY.getCode())) {
                Integer weekDayOffset = this.billWeekDayMap.get(billServiceBaseSetInfo);
                pass = weekDayOffset <= baseOffset;
            }
            advLimitResp.setPassCheck(pass);
            result.add(advLimitResp);
        }
        return result;
    }

    private boolean passDay(Date checkDate, int baseOffset) {
        Date today = WTCDateUtils.getDayStartTime((Date)new Date());
        Date dutyDate = WTCDateUtils.getDayStartTime((Date)checkDate);
        int days = new BigDecimal(dutyDate.getTime() + "").subtract(new BigDecimal(today.getTime() + "")).divide(new BigDecimal(86400000), 4, RoundingMode.HALF_UP).intValue();
        return baseOffset - days >= 0;
    }

    private boolean passPeriodCheck(BillPeriodCheck billPeriodCheck, int baseOffset) {
        boolean verifyResult = true;
        if (billPeriodCheck != null) {
            verifyResult = billPeriodCheck.getPass() == false ? false : baseOffset >= billPeriodCheck.getSize();
        }
        return verifyResult;
    }

    private void getWeekDayInfo() {
        HashMap<RosterRepairAndAdvance, BillServiceBaseSetInfo> rosterAndBaseInfo = new HashMap<RosterRepairAndAdvance, BillServiceBaseSetInfo>(16);
        HashSet<RosterRepairAndAdvance> query = new HashSet<RosterRepairAndAdvance>(16);
        Date now = WTCDateUtils.getDayStartTime((Date)new Date());
        for (Map.Entry<BillServiceBaseSetInfo, Integer> entry : this.billWeekDayMap.entrySet()) {
            RosterRepairAndAdvance repairParam = new RosterRepairAndAdvance();
            BillServiceBaseSetInfo baseSetInfo = entry.getKey();
            repairParam.setAttFileBoId(Long.valueOf(baseSetInfo.getAttFileBoId()));
            repairParam.setBaselineDate(now);
            repairParam.setCompareDate(WTCDateUtils.getDayStartTime((Date)baseSetInfo.getCheckDate()));
            query.add(repairParam);
            rosterAndBaseInfo.put(repairParam, baseSetInfo);
        }
        Map<RosterRepairAndAdvance, Integer> rosterInfo = EvaluationServiceHelper.getWorkDaysBetween2Date(query);
        if (rosterInfo == null) {
            return;
        }
        LOG.info("BillBaseSetService.getWeekDayInfo rosterAndOffset = {}", (Object)JSON.toJSONString(rosterInfo));
        for (Map.Entry<RosterRepairAndAdvance, Integer> entry : rosterInfo.entrySet()) {
            RosterRepairAndAdvance repair = entry.getKey();
            Integer offSet = entry.getValue();
            BillServiceBaseSetInfo baseSetInfo = (BillServiceBaseSetInfo)rosterAndBaseInfo.get(repair);
            this.billWeekDayMap.put(baseSetInfo, offSet);
        }
    }

    private void getPeriodCheckInfo() {
        PerAttPeriodQueryServiceImpl instance = PerAttPeriodQueryServiceImpl.getInstance();
        for (Map.Entry<BillServiceBaseSetInfo, BillPeriodCheck> entry : this.billPeriodCheckMap.entrySet()) {
            long attFileBoId = entry.getKey().getAttFileBoId();
            Date checkDate = entry.getKey().getCheckDate();
            BillPeriodCheck billPeriodCheck = instance.billPerAttPeriodCheck(checkDate, attFileBoId, false);
            this.billPeriodCheckMap.put(entry.getKey(), billPeriodCheck);
        }
    }

    private void getInvokeRegionMethodInfo() {
        for (BillServiceBaseSetInfo baseSetInfo : this.billServiceBaseSetInfos) {
            DynamicObject baseSetDy = baseSetInfo.getBaseSetDy();
            if (baseSetDy == null || !baseSetDy.getBoolean(baseSetInfo.getIsMaxAdvanceCrl())) continue;
            String maxUni = baseSetDy.getString(baseSetInfo.getMaxAdvanceUnit());
            if (BaseSetUnitTypeEnum.PERIOD.getCode().equals(maxUni)) {
                this.billPeriodCheckMap.put(baseSetInfo, null);
                continue;
            }
            if (!BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(maxUni)) continue;
            this.billWeekDayMap.put(baseSetInfo, null);
        }
    }
}

