/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.billservice.baseset;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.evaluation.EvaluationServiceHelper;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterFieldEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoQuery;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceAdvAfterResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceBaseNewSetInfo;
import kd.wtc.wtbs.common.model.evaluation.RosterRepairAndAdvance;
import kd.wtc.wtbs.common.model.period.PeriodBillCheckResult;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class BillBaseStateLessService {
    private static final Log LOG = LogFactory.getLog(BillBaseStateLessService.class);
    private static final BillBaseStateLessService INS = (BillBaseStateLessService)WTCAppContextHelper.getBean(BillBaseStateLessService.class);

    public static BillBaseStateLessService getInstance() {
        return INS;
    }

    public Map<BillAdvanceAfterEnum, List<BillServiceAdvAfterResp>> checkAdvanceAfter(List<BillServiceBaseNewSetInfo> billServiceBaseNewSetInfos, Map<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>> advanceAndAfterInfo) {
        if (CollectionUtils.isEmpty(billServiceBaseNewSetInfos)) {
            return Collections.emptyMap();
        }
        if (advanceAndAfterInfo == null) {
            LOG.warn("\u8bf7\u5148\u521d\u59cb\u5316\u9884\u63d0\u8865\u63d0\u679a\u4e3e\u4fe1\u606f=null");
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u521d\u59cb\u5316\u9884\u63d0\u8865\u63d0\u679a\u4e3e\u4fe1\u606f\u3002", (String)"BillBaseStateLessService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        Map<String, Object> invokeRegionMethodInfoCommon = this.getInvokeRegionMethodInfoCommon(billServiceBaseNewSetInfos, advanceAndAfterInfo);
        Object billWeekDayObj = invokeRegionMethodInfoCommon.get("billWeekDayMap");
        Object needQueryPeriodObj = invokeRegionMethodInfoCommon.get("needQueryPeriod");
        HashMap<BillServiceBaseNewSetInfo, Map<LocalDate, Integer>> billWeekDayMap = billWeekDayObj == null ? new HashMap(16) : (Map)billWeekDayObj;
        List needQueryPeriod = (List)needQueryPeriodObj;
        this.getWeekDayInfo(billWeekDayMap);
        PeriodBillCheckResult periodCheckInfo = this.getPeriodCheckInfo(needQueryPeriod);
        HashMap<BillAdvanceAfterEnum, List<BillServiceAdvAfterResp>> result = new HashMap<BillAdvanceAfterEnum, List<BillServiceAdvAfterResp>>(16);
        for (Map.Entry<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>> advanceAfterEnum : advanceAndAfterInfo.entrySet()) {
            Map<BillAdvanceAfterFieldEnum, String> fieldInfo = advanceAfterEnum.getValue();
            BillAdvanceAfterEnum type = advanceAfterEnum.getKey();
            ArrayList respList = Lists.newArrayListWithExpectedSize((int)billServiceBaseNewSetInfos.size());
            for (BillServiceBaseNewSetInfo billServiceBaseNewSetInfo : billServiceBaseNewSetInfos) {
                String ctrlField = fieldInfo.get(BillAdvanceAfterFieldEnum.CTRL);
                String unitField = fieldInfo.get(BillAdvanceAfterFieldEnum.UNIT);
                String offSetField = fieldInfo.get(BillAdvanceAfterFieldEnum.OFFSET);
                respList.add(this.fillMaxAdvanceInfo(billServiceBaseNewSetInfo, ctrlField, unitField, offSetField, periodCheckInfo, billWeekDayMap, type));
            }
            result.put(type, respList);
        }
        List advance = (List)result.get(BillAdvanceAfterEnum.ADVANCE);
        List maxAdvance = (List)result.get(BillAdvanceAfterEnum.MAX_ADVANCE);
        if (advance != null && maxAdvance != null) {
            for (int index = 0; index < advance.size(); ++index) {
                boolean needChange;
                BillServiceAdvAfterResp billServiceAdvAfterResp = (BillServiceAdvAfterResp)advance.get(index);
                boolean bl = needChange = billServiceAdvAfterResp != null && billServiceAdvAfterResp.getBillPeriodInfoResp() != null && !billServiceAdvAfterResp.getBillPeriodInfoResp().isPassPeriodExistCheck() && maxAdvance.size() >= index + 1 && maxAdvance.get(index) != null && ((BillServiceAdvAfterResp)maxAdvance.get(index)).getBillPeriodInfoResp() != null && !((BillServiceAdvAfterResp)maxAdvance.get(index)).getBillPeriodInfoResp().isPassPeriodExistCheck();
                if (!needChange) continue;
                ((BillServiceAdvAfterResp)maxAdvance.get(index)).getBillPeriodInfoResp().setTipInfo("");
            }
        }
        return result;
    }

    private BillServiceAdvAfterResp fillMaxAdvanceInfo(BillServiceBaseNewSetInfo billServiceBaseNewSetInfo, String ctrlField, String unitField, String offSetField, PeriodBillCheckResult periodCheckInfo, Map<BillServiceBaseNewSetInfo, Map<LocalDate, Integer>> billWeekDayMap, BillAdvanceAfterEnum checkType) {
        BillAttFileService attFileService = new BillAttFileService();
        DynamicObject baseSetDy = billServiceBaseNewSetInfo.getBaseSetDy();
        BillServiceAdvAfterResp resp = new BillServiceAdvAfterResp();
        resp.setBaseSetInfo(billServiceBaseNewSetInfo);
        if (baseSetDy == null) {
            resp.setPassCheck(true);
            return resp;
        }
        String unit = baseSetDy.getString(unitField);
        int baseOffset = baseSetDy.getInt(offSetField);
        resp.setLimitNum(Integer.valueOf(baseOffset));
        resp.setLimitUnit(unit);
        if (!baseSetDy.getBoolean(ctrlField)) {
            resp.setPassCheck(true);
            return resp;
        }
        LinkedHashSet checkDates = billServiceBaseNewSetInfo.getCheckDates();
        LinkedHashSet<LocalDate> afterCheckDates = new LinkedHashSet<LocalDate>(16);
        LinkedHashSet<LocalDate> advanceCheckDates = new LinkedHashSet<LocalDate>(16);
        LinkedHashSet<LocalDate> finalCheckDates = new LinkedHashSet<LocalDate>(16);
        LocalDate now = LocalDate.now();
        for (LocalDate checkDate : checkDates) {
            if (checkDate.isBefore(now)) {
                afterCheckDates.add(checkDate);
                continue;
            }
            advanceCheckDates.add(checkDate);
        }
        if (checkType == BillAdvanceAfterEnum.AFTER && WTCCollections.isEmpty(afterCheckDates)) {
            resp.setPassCheck(true);
            return resp;
        }
        if ((checkType == BillAdvanceAfterEnum.ADVANCE || checkType == BillAdvanceAfterEnum.MAX_ADVANCE) && WTCCollections.isEmpty(advanceCheckDates)) {
            resp.setPassCheck(true);
            return resp;
        }
        if (checkType == BillAdvanceAfterEnum.AFTER) {
            finalCheckDates = afterCheckDates;
        }
        if (checkType == BillAdvanceAfterEnum.ADVANCE || checkType == BillAdvanceAfterEnum.MAX_ADVANCE) {
            finalCheckDates = advanceCheckDates;
        }
        boolean allPass = true;
        if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.DAY.getCode())) {
            allPass = BillBaseStateLessService.passDay(finalCheckDates, baseOffset, checkType);
        } else if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.PERIOD.getCode())) {
            BillPeriodInfoQuery billPeriodInfoQuery = new BillPeriodInfoQuery();
            if (checkType == BillAdvanceAfterEnum.AFTER) {
                billPeriodInfoQuery.setAfter(Integer.valueOf(baseOffset));
            } else if (checkType == BillAdvanceAfterEnum.ADVANCE) {
                billPeriodInfoQuery.setAdvance(Integer.valueOf(baseOffset));
            } else if (checkType == BillAdvanceAfterEnum.MAX_ADVANCE) {
                billPeriodInfoQuery.setMaxAdvance(Integer.valueOf(baseOffset));
            }
            billPeriodInfoQuery.setPersonId(billServiceBaseNewSetInfo.getPersonId());
            billPeriodInfoQuery.setPeriodBillCheckResult(periodCheckInfo);
            billPeriodInfoQuery.setVerifyDate(new HashSet<LocalDate>(finalCheckDates));
            BillPeriodInfoResp billPeriodInfoResp = attFileService.checkBillPeriod(billPeriodInfoQuery);
            resp.setBillPeriodInfoResp(billPeriodInfoResp);
            allPass = billPeriodInfoResp.isAdvancePeriodCheck() && billPeriodInfoResp.isAfterPeriodCheck() && billPeriodInfoResp.isMaxAdvancePeriodCheck();
        } else if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.WEEKDAY.getCode())) {
            allPass = BillBaseStateLessService.passWorkDay(billWeekDayMap.get(billServiceBaseNewSetInfo), baseOffset, checkType);
        }
        resp.setBillDy(billServiceBaseNewSetInfo.getBillDy());
        resp.setPassCheck(allPass);
        return resp;
    }

    private Map<String, Object> getInvokeRegionMethodInfoCommon(List<BillServiceBaseNewSetInfo> billServiceBaseNewSetInfos, Map<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>> advanceAndAfterInfo) {
        HashMap<BillServiceBaseNewSetInfo, Object> billWeekDayMap = new HashMap<BillServiceBaseNewSetInfo, Object>(16);
        ArrayList<BillServiceBaseNewSetInfo> needQueryPeriod = new ArrayList<BillServiceBaseNewSetInfo>(10);
        for (BillServiceBaseNewSetInfo baseSetInfo : billServiceBaseNewSetInfos) {
            DynamicObject baseSetDy = baseSetInfo.getBaseSetDy();
            if (baseSetDy == null || advanceAndAfterInfo == null || advanceAndAfterInfo.size() == 0) continue;
            for (Map.Entry<BillAdvanceAfterEnum, Map<BillAdvanceAfterFieldEnum, String>> info : advanceAndAfterInfo.entrySet()) {
                Map<BillAdvanceAfterFieldEnum, String> value = info.getValue();
                String ctrlField = value.get(BillAdvanceAfterFieldEnum.CTRL);
                String unitField = value.get(BillAdvanceAfterFieldEnum.UNIT);
                if (!baseSetDy.getBoolean(ctrlField)) continue;
                String maxUni = baseSetDy.getString(unitField);
                if (BaseSetUnitTypeEnum.PERIOD.getCode().equals(maxUni)) {
                    needQueryPeriod.add(baseSetInfo);
                    continue;
                }
                if (!BaseSetUnitTypeEnum.WEEKDAY.getCode().equals(maxUni)) continue;
                billWeekDayMap.put(baseSetInfo, null);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("billWeekDayMap", billWeekDayMap);
        result.put("needQueryPeriod", needQueryPeriod);
        return result;
    }

    public static boolean passWorkDay(Map<LocalDate, Integer> checkDateAndOffSet, int baseOffset, BillAdvanceAfterEnum checkType) {
        boolean result = true;
        LocalDate now = LocalDate.now();
        for (Map.Entry<LocalDate, Integer> dateAndOffSet : checkDateAndOffSet.entrySet()) {
            Integer weekDayOffset = dateAndOffSet.getValue();
            LocalDate checkDate = dateAndOffSet.getKey();
            if (BillAdvanceAfterEnum.MAX_ADVANCE == checkType && !checkDate.isBefore(now)) {
                result = weekDayOffset <= baseOffset;
            } else if (BillAdvanceAfterEnum.ADVANCE == checkType && !checkDate.isBefore(now)) {
                result = baseOffset <= weekDayOffset;
            } else if (BillAdvanceAfterEnum.AFTER == checkType && checkDate.isBefore(now)) {
                boolean bl = result = -baseOffset <= weekDayOffset;
            }
            if (result) continue;
            return false;
        }
        return true;
    }

    public static boolean passDay(LinkedHashSet<LocalDate> checkDates, int baseOffset, BillAdvanceAfterEnum checkType) {
        if (WTCCollections.isEmpty(checkDates)) {
            return true;
        }
        LocalDate localNow = LocalDate.now();
        Date today = WTCDateUtils.toDate((LocalDate)localNow);
        boolean passCheck = true;
        for (LocalDate checkDate : checkDates) {
            int days;
            Date dutyDate = WTCDateUtils.toDate((LocalDate)checkDate);
            if (BillAdvanceAfterEnum.MAX_ADVANCE == checkType && !checkDate.isBefore(localNow)) {
                days = new BigDecimal(dutyDate.getTime() + "").subtract(new BigDecimal(today.getTime() + "")).divide(new BigDecimal(86400000), 4, RoundingMode.HALF_UP).intValue();
                passCheck = baseOffset - days >= 0;
            } else if (BillAdvanceAfterEnum.ADVANCE == checkType && !checkDate.isBefore(localNow)) {
                days = (int)((dutyDate.getTime() - today.getTime()) / 86400000L);
                passCheck = days >= baseOffset;
            } else if (BillAdvanceAfterEnum.AFTER == checkType && checkDate.isBefore(localNow)) {
                days = (int)((today.getTime() - dutyDate.getTime()) / 86400000L);
                boolean bl = passCheck = days <= baseOffset;
            }
            if (passCheck) continue;
            return false;
        }
        return true;
    }

    public void getWeekDayInfo(Map<BillServiceBaseNewSetInfo, Map<LocalDate, Integer>> billWeekDayMap) {
        HashMap rosterAndBaseInfo = new HashMap(16);
        HashSet<RosterRepairAndAdvance> query = new HashSet<RosterRepairAndAdvance>(16);
        Date now = WTCDateUtils.getDayStartTime((Date)new Date());
        for (Map.Entry<BillServiceBaseNewSetInfo, Map<LocalDate, Integer>> entry : billWeekDayMap.entrySet()) {
            BillServiceBaseNewSetInfo baseSetInfo = entry.getKey();
            HashMap<LocalDate, RosterRepairAndAdvance> dateAndRoster = new HashMap<LocalDate, RosterRepairAndAdvance>(16);
            for (LocalDate localDate : baseSetInfo.getCheckDates()) {
                RosterRepairAndAdvance repairParam = new RosterRepairAndAdvance();
                repairParam.setAttFileBoId(Long.valueOf(baseSetInfo.getAttFileBoId()));
                repairParam.setBaselineDate(now);
                repairParam.setCompareDate(WTCDateUtils.toDate((LocalDate)localDate));
                dateAndRoster.put(localDate, repairParam);
                query.add(repairParam);
            }
            rosterAndBaseInfo.put(baseSetInfo, dateAndRoster);
        }
        Map<RosterRepairAndAdvance, Integer> rosterInfo = EvaluationServiceHelper.getWorkDaysBetween2Date(query);
        if (rosterInfo == null) {
            return;
        }
        LOG.info("BillBaseStateLessService.getWeekDayInfo rosterAndOffset = {}", (Object)JSON.toJSONString(rosterInfo));
        for (Map.Entry respInfo : rosterAndBaseInfo.entrySet()) {
            Map dateAndOffSet = billWeekDayMap.computeIfAbsent((BillServiceBaseNewSetInfo)respInfo.getKey(), (Function<BillServiceBaseNewSetInfo, Map<LocalDate, Integer>>)((Function<BillServiceBaseNewSetInfo, Map>)k -> new HashMap(16)));
            for (Map.Entry entry : ((Map)respInfo.getValue()).entrySet()) {
                LocalDate date = (LocalDate)entry.getKey();
                RosterRepairAndAdvance value = (RosterRepairAndAdvance)entry.getValue();
                Integer offSet = rosterInfo.get(value);
                dateAndOffSet.put(date, offSet);
            }
        }
    }

    private PeriodBillCheckResult getPeriodCheckInfo(List<BillServiceBaseNewSetInfo> needQueryPeriod) {
        if (WTCCollections.isEmpty(needQueryPeriod)) {
            return null;
        }
        HashMap<Long, List<LocalDate>> dateListMap = new HashMap<Long, List<LocalDate>>(16);
        for (BillServiceBaseNewSetInfo billServiceBaseNewSetInfo : needQueryPeriod) {
            long personId = billServiceBaseNewSetInfo.getPersonId();
            List localDates = dateListMap.computeIfAbsent(personId, val -> new ArrayList(10));
            LinkedHashSet checkDates = billServiceBaseNewSetInfo.getCheckDates();
            if (WTCCollections.isEmpty((Collection)checkDates)) continue;
            for (LocalDate checkDate : checkDates) {
                if (localDates.contains(checkDate)) continue;
                localDates.add(checkDate);
            }
        }
        Optional<PeriodBillCheckResult> periodBillCheckResultOptional = BillAttFileService.getInstance().getPerAttPeriods(dateListMap);
        PeriodBillCheckResult periodBillCheckResult = periodBillCheckResultOptional.orElse(null);
        BillAttFileService.getQueryLog(dateListMap, LOG);
        BillAttFileService.getBillPeriodKeyInfoLog(periodBillCheckResult, LOG);
        return periodBillCheckResult;
    }
}

