/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.billservice.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.billservice.BillSetSpiltRangeQuery;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class BillSetCommonService {
    private static final Log Log = LogFactory.getLog(BillSetCommonService.class);
    private static final BillSetCommonService INS = (BillSetCommonService)WTCAppContextHelper.getBean(BillSetCommonService.class);

    public static BillSetCommonService getInstance() {
        return INS;
    }

    public Tuples.Tuple2<LocalDate, LocalDate> splitHisBaseSet(BillSetSpiltRangeQuery query) {
        AccessDto accessDto;
        if (query == null) {
            Log.warn("BillSetSpiltRangeQuery query cant not be null");
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillSetCommonService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        DynamicObject attFileVersionDy = query.getAttFileVersionDy();
        DynamicObject sideTableDy = query.getSideTableDy();
        DynamicObject planVersionDy = query.getPlanVersionDy();
        String engineCondition = query.getEngineCondition();
        DynamicObject ruleVersionDy = query.getRuleVersionDy();
        String limitCondition = query.getLimitCondition();
        DynamicObject baseSetVersionDy = query.getCalSetVersionDy();
        LocalDate baseDate = query.getBaseDate();
        if (baseDate == null) {
            Log.warn("BillSetCommonService_getDyEffectDate baseDate cant not be null");
            throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u51c6\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillSetCommonService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)limitCondition) && (accessDto = (AccessDto)SerializationUtils.fromJsonString((String)limitCondition, AccessDto.class)) != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
            return new Tuples.Tuple2((Object)baseDate, (Object)baseDate);
        }
        Tuples.Tuple2<LocalDate, LocalDate> ruleRange = this.splitHisRuleRange(attFileVersionDy, sideTableDy, planVersionDy, engineCondition, ruleVersionDy, baseDate);
        ArrayList<LocalDate> splitPoint = new ArrayList<LocalDate>(10);
        splitPoint.add((LocalDate)ruleRange.item1);
        splitPoint.add((LocalDate)ruleRange.item2);
        Tuples.Tuple2<Date, Date> dyEffectDate = this.getDyEffectDate(baseSetVersionDy, "bsed", "bsled");
        splitPoint.add(WTCDateUtils.toLocalDate((Date)((Date)dyEffectDate.item1)));
        splitPoint.add(WTCDateUtils.toLocalDate((Date)((Date)dyEffectDate.item2)));
        return this.getBetweenBaseDate(splitPoint, baseDate);
    }

    public Tuples.Tuple2<LocalDate, LocalDate> splitHisRuleRange(DynamicObject attFileVersionDy, DynamicObject sideTableDy, DynamicObject planVersionDy, String engineCondition, DynamicObject ruleVersionDy, LocalDate baseDate) {
        if (HRStringUtils.isNotEmpty((String)engineCondition)) {
            return new Tuples.Tuple2((Object)baseDate, (Object)baseDate);
        }
        Tuples.Tuple2<LocalDate, LocalDate> planRange = this.splitHisPlanRange(attFileVersionDy, sideTableDy, planVersionDy, baseDate);
        if (ruleVersionDy == null) {
            Log.warn("BillSetCommonService_getDyEffectDate  ruleVersionDy can not be null");
            return new Tuples.Tuple2((Object)baseDate, (Object)baseDate);
        }
        Tuples.Tuple2<Date, Date> dyEffectDate = this.getDyEffectDate(ruleVersionDy, "bsed", "bsled");
        ArrayList<LocalDate> splitPoint = new ArrayList<LocalDate>(10);
        splitPoint.add(WTCDateUtils.toLocalDate((Date)((Date)dyEffectDate.item1)));
        splitPoint.add(WTCDateUtils.toLocalDate((Date)((Date)dyEffectDate.item2)));
        splitPoint.add((LocalDate)planRange.item1);
        splitPoint.add((LocalDate)planRange.item2);
        return this.getBetweenBaseDate(splitPoint, baseDate);
    }

    public Tuples.Tuple2<LocalDate, LocalDate> splitHisPlanRange(DynamicObject attFileVersionDy, DynamicObject sideTableDy, DynamicObject planVersionDy, LocalDate baseDate) {
        if (attFileVersionDy == null) {
            Log.warn("BillSetCommonService_getDyEffectDate  attFileVersionDy can not be null");
            return new Tuples.Tuple2((Object)baseDate, (Object)baseDate);
        }
        if (sideTableDy == null) {
            Log.warn("BillSetCommonService_getDyEffectDate  sideTableDy can not be null");
            return new Tuples.Tuple2((Object)baseDate, (Object)baseDate);
        }
        if (planVersionDy == null) {
            Log.warn("BillSetCommonService_getDyEffectDate  planVersionDy can not be null");
            return new Tuples.Tuple2((Object)baseDate, (Object)baseDate);
        }
        ArrayList<Object> splitPoint = new ArrayList<Object>(10);
        Tuples.Tuple2<Date, Date> dyEffectDate = this.getDyEffectDate(attFileVersionDy, "bsed", "bsled");
        splitPoint.add(dyEffectDate.item1);
        splitPoint.add(dyEffectDate.item2);
        Tuples.Tuple2<Date, Date> dyEffectDateSideTable = this.getDyEffectDate(sideTableDy, "startdate", "enddate");
        splitPoint.add(dyEffectDateSideTable.item1);
        splitPoint.add(dyEffectDateSideTable.item2);
        Tuples.Tuple2<Date, Date> dyEffectDatePlan = this.getDyEffectDate(planVersionDy, "bsed", "bsled");
        splitPoint.add(dyEffectDatePlan.item1);
        splitPoint.add(dyEffectDatePlan.item2);
        if (Log.isDebugEnabled()) {
            Log.debug("BillSetCommonService_splitHisPlanInOne datePoint = {}", (Object)WTCSerializationUtils.toJsonString(splitPoint));
        }
        List<LocalDate> collect = splitPoint.stream().map(WTCDateUtils::toLocalDate).collect(Collectors.toList());
        return this.getBetweenBaseDate(collect, baseDate);
    }

    private Tuples.Tuple2<LocalDate, LocalDate> getBetweenBaseDate(List<LocalDate> localDates, LocalDate baseLineDate) {
        List afterSort = Lists.newArrayList(localDates).stream().sorted().collect(Collectors.toList());
        if (WTCCollections.isEmpty(localDates)) {
            return new Tuples.Tuple2((Object)WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMaxEndDate()), (Object)WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMaxEndDate()));
        }
        if (afterSort.size() % 2 != 0) {
            Log.warn("BillSetCommonService_getBetweenBaseDate localDates  has to be double");
            throw new KDBizException(ResManager.loadKDString((String)"localDates \u5fc5\u987b\u4e3a\u5076\u6570\u5bf9\u3002", (String)"BillSetCommonService_2", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        int halfIndex = new BigDecimal(afterSort.size() + "").divide(new BigDecimal("2"), 0, RoundingMode.HALF_UP).intValue();
        LocalDate startDate = (LocalDate)afterSort.get(halfIndex - 1);
        LocalDate endDate = (LocalDate)afterSort.get(halfIndex);
        boolean betweenTimeEquals = WTCDateUtils.betweenTimeEquals((Date)WTCDateUtils.toDate((LocalDate)baseLineDate), (Date)WTCDateUtils.toDate((LocalDate)startDate), (Date)WTCDateUtils.toDate((LocalDate)endDate));
        if (!betweenTimeEquals) {
            Log.warn("BillSetCommonService_getBetweenBaseDate baseDate verify error.param is not query by baseline.fieldStart = {},fieldEnd = {}", (Object)startDate, (Object)endDate);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8c61startDate \u3001endDate \u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillSetCommonService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        return new Tuples.Tuple2((Object)startDate, (Object)endDate);
    }

    private Tuples.Tuple2<Date, Date> getDyEffectDate(DynamicObject dynamicObject, String fieldStart, String fieldEnd) {
        boolean containsKey;
        if (dynamicObject == null) {
            Log.warn("BillSetCommonService_getDyEffectDate   dynamicObject can not be null");
            throw new KDBizException(ResManager.loadKDString((String)"\u52a8\u6001\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillSetCommonService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        boolean bl = containsKey = dynamicObject.getDataEntityType().getProperties().containsKey((Object)fieldStart) && dynamicObject.getDataEntityType().getProperties().containsKey((Object)fieldEnd);
        if (!containsKey) {
            Log.warn("BillSetCommonService_getDyEffectDate dyn not contain properties,ieldStart = {}\uff0cfieldEnd={}", (Object)fieldStart, (Object)fieldEnd);
            throw new KDBizException(ResManager.loadKDString((String)"\u52a8\u6001\u5bf9\u8c61\u4e0d\u5305\u542b\u8be5\u5c5e\u6027\u3002", (String)"BillSetCommonService_5", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        Date startDate = dynamicObject.getDate(fieldStart);
        Date endDate = dynamicObject.getDate(fieldEnd);
        if (startDate == null || endDate == null) {
            Log.warn("BillSetCommonService_getDyEffectDate startDate \u3001endDate can not be null,fieldStart = {},fieldEnd = {}", (Object)fieldStart, (Object)fieldEnd);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8c61startDate \u3001endDate \u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillSetCommonService_6", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        return new Tuples.Tuple2((Object)startDate, (Object)endDate);
    }
}

