/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.billservice.dutyDate;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.business.bill.dutydate.BillDutyDateExtPlugin;
import kd.sdk.wtc.wtbs.business.bill.dutydate.OnMatchBillDutyDateEvent;
import kd.sdk.wtc.wtbs.common.enums.DutyDateErrorEnum;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.model.takecardrule.ShiftDateVo;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.common.enums.bill.ApplyBillDutyDateErrorEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.billservice.BillDutyDateRealTimeParam;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateReq;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateResp;
import kd.wtc.wtbs.common.model.billservice.BillShiftParam;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BillOptionalDutyDateService {
    private static final Log LOG = LogFactory.getLog(BillOptionalDutyDateService.class);
    public static final BigDecimal DAY_MILLIS = new BigDecimal("86400000");
    private static final long ONE_DAY_MILLIS = 86400000L;
    public static final String CROSS_SHIFT_OVER24_KEY = "allowCrossShiftAnd24h";
    public static final String CROSS_SHIFT_OVER24_VAL = "true";
    private static final BillOptionalDutyDateService INS = (BillOptionalDutyDateService)WTCAppContextHelper.getBean(BillOptionalDutyDateService.class);

    public static BillOptionalDutyDateService getInstance() {
        return INS;
    }

    public List<BillShiftParam> convertShiftParam(List<BillDutyDateRealTimeParam> dutyDateParam) {
        ArrayList shiftParams = Lists.newArrayListWithExpectedSize((int)dutyDateParam.size());
        Date min = WTCDateUtils.getMaxEndDate();
        Date max = WTCDateUtils.getMinEndDate();
        for (BillDutyDateRealTimeParam dateInfoForDy : dutyDateParam) {
            List needQueryRealTime = dateInfoForDy.getNeedQueryRealTime();
            if (WTCCollections.isEmpty((Collection)needQueryRealTime)) {
                BillShiftParam billShiftParam = new BillShiftParam(dateInfoForDy.getAttFileBoId(), null, null);
                shiftParams.add(billShiftParam);
                continue;
            }
            for (Tuples.Tuple2 startEnd : needQueryRealTime) {
                if (startEnd.item1 != null && ((Date)startEnd.item1).before(min)) {
                    min = (Date)startEnd.item1;
                }
                if (startEnd.item2 == null || !((Date)startEnd.item2).after(max)) continue;
                max = (Date)startEnd.item2;
            }
            Date start = HRDateTimeUtils.addDay((Date)WTCDateUtils.getDayStart((Date)min), (long)-3L);
            Date end = HRDateTimeUtils.addDay((Date)WTCDateUtils.getDayStart((Date)max), (long)3L);
            shiftParams.add(new BillShiftParam(dateInfoForDy.getAttFileBoId(), start, end));
        }
        return shiftParams;
    }

    public void handleRealTimeForDutyDate(List<BillDutyDateRealTimeParam> dateInfoForDyList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("BillOptionalDutyDateService_handleRealTimeForDutyDate, before = {}", (Object)JSON.toJSONString(dateInfoForDyList));
        }
        if (WTCCollections.isEmpty(dateInfoForDyList)) {
            return;
        }
        BillOptionalDutyDateService dutyDateService = new BillOptionalDutyDateService();
        ArrayList<BillOptionDutyDateReq> billOptionDutyDateReqs = new ArrayList<BillOptionDutyDateReq>(10);
        HashMap dateInfoAndDutyDateReqIndex = Maps.newHashMapWithExpectedSize((int)dateInfoForDyList.size());
        for (BillDutyDateRealTimeParam dateInfoForDy : dateInfoForDyList) {
            BillShiftParam shiftParam = dateInfoForDy.getShiftParam();
            int startIndex = billOptionDutyDateReqs.size();
            for (Tuples.Tuple2 needRealTime : dateInfoForDy.getNeedQueryRealTime()) {
                BillOptionDutyDateReq dutyDateReq = new BillOptionDutyDateReq();
                if (shiftParam != null) {
                    dutyDateReq.setShiftInfo(this.transTuple(shiftParam.getDutyShiftAndShift()));
                } else {
                    dutyDateReq.setShiftInfo(Collections.emptyList());
                }
                if (needRealTime.item1 == null || needRealTime.item2 == null) {
                    dateInfoAndDutyDateReqIndex.put(dateInfoForDy, new Tuple((Object)-1, (Object)-1));
                    continue;
                }
                dutyDateReq.setAttFileBoId(Long.valueOf(dateInfoForDy.getAttFileBoId()));
                dutyDateReq.setStartTime((Date)needRealTime.item1);
                dutyDateReq.setEndTime((Date)needRealTime.item2);
                billOptionDutyDateReqs.add(dutyDateReq);
            }
            int endIndex = billOptionDutyDateReqs.size();
            if (startIndex == endIndex) {
                dateInfoAndDutyDateReqIndex.put(dateInfoForDy, new Tuple((Object)-1, (Object)-1));
                continue;
            }
            dateInfoAndDutyDateReqIndex.put(dateInfoForDy, new Tuple((Object)startIndex, (Object)(endIndex - 1)));
        }
        List<BillOptionDutyDateResp> dutyDateRespList = dutyDateService.getDutyDate(billOptionDutyDateReqs);
        for (BillDutyDateRealTimeParam dateInfoForDy : dateInfoForDyList) {
            Tuple startEndIndex = (Tuple)dateInfoAndDutyDateReqIndex.get(dateInfoForDy);
            if (dateInfoForDy == null || (Integer)startEndIndex.item1 == -1 && (Integer)startEndIndex.item2 == -1) continue;
            Set confirmDutyDate = dateInfoForDy.getConfirmDutyDate();
            for (int start = ((Integer)startEndIndex.item1).intValue(); start <= (Integer)startEndIndex.item2; ++start) {
                BillOptionDutyDateResp billOptionDutyDateResp;
                if (start < 0 || (billOptionDutyDateResp = dutyDateRespList.get(start)).getDutyDate() == null) continue;
                confirmDutyDate.add(billOptionDutyDateResp.getDutyDate());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("BillOptionalDutyDateService_handleRealTimeForDutyDate, after = {}", (Object)JSON.toJSONString(dateInfoForDyList));
        }
    }

    private List<Tuple<DutyShift, Shift>> transTuple(List<Tuples.Tuple2<DutyShift, Shift>> tuple2Data) {
        if (CollectionUtils.isEmpty(tuple2Data)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)tuple2Data.size());
        for (Tuples.Tuple2<DutyShift, Shift> tuple2Datum : tuple2Data) {
            result.add(new Tuple(tuple2Datum.item1, tuple2Datum.item2));
        }
        return result;
    }

    public List<BillOptionDutyDateResp> getDutyDate(List<BillOptionDutyDateReq> optionDutyDateReqList) {
        if (WTCCollections.isEmpty(optionDutyDateReqList)) {
            return Collections.emptyList();
        }
        ArrayList<Tuple<DutyShift, Shift>> shiftInfoAll = new ArrayList<Tuple<DutyShift, Shift>>(10);
        HashSet<Long> dutyShiftId = new HashSet<Long>(16);
        for (BillOptionDutyDateReq billOptionDutyDateReq : optionDutyDateReqList) {
            List shiftInfo = billOptionDutyDateReq.getShiftInfo();
            if (shiftInfo == null) continue;
            for (Tuple dutyShiftShiftTuple : shiftInfo) {
                if (dutyShiftShiftTuple.item1 == null || dutyShiftId.contains(((DutyShift)dutyShiftShiftTuple.item1).getId())) continue;
                shiftInfoAll.add((Tuple<DutyShift, Shift>)dutyShiftShiftTuple);
                dutyShiftId.add(((DutyShift)dutyShiftShiftTuple.item1).getId());
            }
        }
        Map<Long, Map<Date, ShiftDateVo>> shiftDateVoMap = CollectionUtils.isEmpty(shiftInfoAll) ? Collections.emptyMap() : ApplyUtil.getTackCardRangeMapGroupByAttFileBoId(shiftInfoAll);
        ArrayList respList = Lists.newArrayListWithExpectedSize((int)optionDutyDateReqList.size());
        for (BillOptionDutyDateReq billOptionDutyDateReq : optionDutyDateReqList) {
            respList.add(this.getDutyDate(billOptionDutyDateReq, shiftDateVoMap));
        }
        return respList;
    }

    private BillOptionDutyDateResp getDutyDate(BillOptionDutyDateReq optionDutyDateReq, Map<Long, Map<Date, ShiftDateVo>> shiftDateVoMap) {
        Date startTime = optionDutyDateReq.getStartTime();
        Date endTime = optionDutyDateReq.getEndTime();
        if (startTime == null || endTime == null) {
            BillOptionDutyDateResp resp = new BillOptionDutyDateResp();
            resp.setCorrectMatch(false);
            resp.setErrorEnum(ApplyBillDutyDateErrorEnum.EMPTYSTARTDATE);
            return resp;
        }
        if (startTime.after(endTime)) {
            BillOptionDutyDateResp resp = new BillOptionDutyDateResp();
            resp.setCorrectMatch(false);
            resp.setErrorEnum(ApplyBillDutyDateErrorEnum.START_END_ERROR);
            return resp;
        }
        List dutyShiftRange = optionDutyDateReq.getShiftInfo();
        if (WTCCollections.isEmpty(shiftDateVoMap)) {
            shiftDateVoMap = CollectionUtils.isEmpty((Collection)dutyShiftRange) ? Collections.emptyMap() : ApplyUtil.getTackCardRangeMapGroupByAttFileBoId(dutyShiftRange);
        }
        Map<Object, Object> shiftDateVoMapAfterFilter = new HashMap(16);
        long attFileBoId = optionDutyDateReq.getAttFileBoId();
        LOG.info("BillOptionalDutyDateService_getDutyDate attFileBoId = {},shiftDateVoMap.size = {},shiftDateVoMap = {}", new Object[]{attFileBoId, shiftDateVoMap.size(), JSON.toJSONString(shiftDateVoMap)});
        if (WTCCollections.isNotEmpty(shiftDateVoMap)) {
            shiftDateVoMapAfterFilter = shiftDateVoMap.get(attFileBoId);
            Map<Object, Object> map = shiftDateVoMapAfterFilter = shiftDateVoMapAfterFilter == null ? Collections.emptyMap() : shiftDateVoMapAfterFilter;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("BillOptionalDutyDateService_getDutyDate attFileBoId = {},shiftDateVoMap.size = {},shiftDateVoMap = {}", new Object[]{attFileBoId, shiftDateVoMap.size(), JSON.toJSONString(shiftDateVoMap)});
        }
        Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> dutyDate = null;
        String dutyDateKey = this.getAppCustomParameter(CROSS_SHIFT_OVER24_KEY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("BillOptionalDutyDateService_getDutyDate,dutyDateKey = {}", (Object)dutyDateKey);
        }
        if (HRStringUtils.equals((String)CROSS_SHIFT_OVER24_VAL, (String)dutyDateKey) && this.over24OrCrossShift(startTime, endTime, dutyShiftRange)) {
            LOG.info("BillOptionalDutyDateService_getDutyDate crossShiftAndOver24");
            dutyDate = this.handleCrossShiftOr24(startTime, endTime, shiftDateVoMapAfterFilter);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("BillOptionalDutyDateService_getDutyDate inShiftAndIn24");
            }
            dutyDate = this.getDutyDate(optionDutyDateReq.getStartTime(), optionDutyDateReq.getEndTime(), shiftDateVoMapAfterFilter);
        }
        WTCPluginProxy<BillDutyDateExtPlugin> plugin = WTCPluginProxyFactory.create(BillDutyDateExtPlugin.class, "kd.sdk.wtc.wtbs.business.bill.dutydate.BillDutyDateExtPlugin");
        if (CollectionUtils.isNotEmpty((Collection)plugin.getPlugins())) {
            return BillOptionalDutyDateService.getCrossShiftOr24Dutydate(startTime, endTime, dutyDate, plugin);
        }
        BillOptionDutyDateResp resp = new BillOptionDutyDateResp();
        resp.setCorrectMatch(((Boolean)dutyDate.item1).booleanValue());
        resp.setDutyDate((Date)dutyDate.item3);
        resp.setErrorEnum((ApplyBillDutyDateErrorEnum)dutyDate.item2);
        return resp;
    }

    public BillOptionDutyDateResp getDutyDate(BillOptionDutyDateReq optionDutyDateReq) {
        return this.getDutyDate(optionDutyDateReq, null);
    }

    @NotNull
    private static BillOptionDutyDateResp getCrossShiftOr24Dutydate(Date startTime, Date endTime, Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> dutyDate, WTCPluginProxy<BillDutyDateExtPlugin> plugin) {
        Date customizedDutyDate;
        if (LOG.isDebugEnabled()) {
            LOG.debug("UnifyEntryDutyDateOtService_getCrossShiftOr24Dutydate \u5b58\u5728\u4e8c\u5f00\u57cb\u70b9\uff0c\u8fdb\u884c\u91cd\u65b0\u8d4b\u503c\u5f52\u5c5e\u65e5\u671f");
        }
        Date standardDate = null;
        DutyDateErrorEnum dutyDateErrorEnum = null;
        standardDate = (Date)dutyDate.item3;
        if (!((Boolean)dutyDate.item1).booleanValue()) {
            dutyDateErrorEnum = DutyDateErrorEnum.getEnumByKey((String)((ApplyBillDutyDateErrorEnum)dutyDate.item2).getKey());
        }
        Date finalStandardTime = null;
        if (standardDate != null) {
            finalStandardTime = new Date(standardDate.getTime());
        }
        OnMatchBillDutyDateEvent onMatchBillDutyDateEvent = new OnMatchBillDutyDateEvent(new Date(startTime.getTime()), new Date(endTime.getTime()), finalStandardTime, dutyDateErrorEnum);
        if (CollectionUtils.isNotEmpty((Collection)plugin.getPlugins())) {
            plugin.invokeReplace(service -> service.onMatchBillDutyDate(onMatchBillDutyDateEvent));
        }
        if ((customizedDutyDate = onMatchBillDutyDateEvent.getStandardDate()) != null) {
            customizedDutyDate = WTCDateUtils.getDayStart((Date)customizedDutyDate);
        }
        BillOptionDutyDateResp resp = new BillOptionDutyDateResp();
        resp.setDutyDate(customizedDutyDate);
        DutyDateErrorEnum customizedDutyDateErrorEnum = onMatchBillDutyDateEvent.getDutyDateErrorEnum();
        resp.setCorrectMatch(customizedDutyDateErrorEnum == null);
        if (customizedDutyDateErrorEnum != null) {
            resp.setErrorEnum(ApplyBillDutyDateErrorEnum.getEnumByKey((String)customizedDutyDateErrorEnum.getKey()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("BillOptionalDutyDateService_getCrossShiftOr24Dutydate resp = {}", (Object)SerializationUtils.toJsonString((Object)resp));
        }
        return resp;
    }

    private Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> handleCrossShiftOr24(Date startTime, Date endTime, Map<Date, ShiftDateVo> shiftDateVoMap) {
        boolean checkStartOrEnd = this.sysIsBeginDate();
        Date verifyTime = checkStartOrEnd ? startTime : endTime;
        return this.getDutyDate(verifyTime, verifyTime, shiftDateVoMap);
    }

    private boolean sysIsBeginDate() {
        long orgId = SystemParamQueryUtil.getWTCRootOrg();
        String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        String billcheckrule = (String)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"billcheckrule");
        return StringUtils.equals((CharSequence)"0", (CharSequence)billcheckrule);
    }

    public String getAppCustomParameter(String key) {
        AppCustomParam param = new AppCustomParam();
        param.setAppId(AppMetadataCache.getAppInfo((String)"wtp").getId());
        param.setSearchKeySet((Set)Sets.newHashSet((Object[])new String[]{key}));
        Map paramMap = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)param);
        if (paramMap == null || paramMap.get(key) == null) {
            return "";
        }
        return (String)paramMap.get(key);
    }

    public boolean over24OrCrossShift(Date startTime, Date endTime, List<Tuple<DutyShift, Shift>> dutyShiftRange) {
        long all = endTime.getTime() - startTime.getTime();
        if (all > 86400000L) {
            return true;
        }
        if (WTCCollections.isEmpty(dutyShiftRange)) {
            return false;
        }
        int crossShiftSize = 0;
        for (Tuple<DutyShift, Shift> dutyShiftShiftTuple : dutyShiftRange) {
            List<Tuples.Tuple3<String, Date, Date>> shiftDetailAbsoluteTime = ApplyUtil.getShiftDetailAbsoluteTime((DutyShift)dutyShiftShiftTuple.item1, (Shift)dutyShiftShiftTuple.item2);
            if (WTCCollections.isNotEmpty(shiftDetailAbsoluteTime)) {
                for (Tuples.Tuple3<String, Date, Date> shiftInfo : shiftDetailAbsoluteTime) {
                    if (!WTCDateUtils.hasIntersectionLCRO((Date)startTime, (Date)endTime, (Date)((Date)shiftInfo.item2), (Date)((Date)shiftInfo.item3))) continue;
                    ++crossShiftSize;
                    break;
                }
            }
            if (crossShiftSize <= true) continue;
            return true;
        }
        return false;
    }

    private Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> getDutyDate(Date startDate, Date endDate, Map<Date, ShiftDateVo> tackCardRangeMap) {
        BigDecimal all;
        if (startDate != null && endDate != null && (all = new BigDecimal(endDate.getTime() + "").subtract(new BigDecimal(startDate.getTime() + ""))).compareTo(DAY_MILLIS) > 0) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.OVER_24, null);
        }
        if (startDate == null) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.OVER_24, null);
        }
        Date startZeroDate = WTCDateUtils.getZeroDate((Date)startDate);
        Date preDay = HRDateTimeUtils.addDay((Date)startZeroDate, (long)-1L);
        ShiftDateVo preDayRange = tackCardRangeMap.get(preDay);
        ShiftDateVo startDayRange = tackCardRangeMap.get(startZeroDate);
        Date nextDate = HRDateTimeUtils.addDay((Date)startZeroDate, (long)1L);
        ShiftDateVo endDayRange = tackCardRangeMap.get(nextDate);
        if (startDayRange == null) {
            if (endDayRange != null) {
                if (WTCDateUtils.betweenTimeEquals((Date)endDate, (Date)endDayRange.getStartScopeDate(), (Date)endDayRange.getEndScopeDate())) {
                    return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)endDayRange.getBelongDate());
                }
            } else if (preDayRange != null && WTCDateUtils.betweenTimeEquals((Date)startDate, (Date)preDayRange.getStartScopeDate(), (Date)preDayRange.getEndScopeDate())) {
                return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)preDayRange.getBelongDate());
            }
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.NOSHIFT, null);
        }
        if (preDayRange == null && endDayRange == null) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.NOSHIFT, null);
        }
        Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> tuple3 = BillOptionalDutyDateService.getTupleInShiftRange(startDate, endDate, preDayRange, startDayRange, endDayRange);
        if (tuple3 == null) {
            tuple3 = this.getTupleTwoNullShift(startDate, preDayRange, startDayRange, endDayRange);
            if (tuple3 == null) {
                tuple3 = this.getTupleOneNullShift(startDate, endDate, preDayRange, startDayRange, endDayRange);
            }
            if (tuple3 == null) {
                tuple3 = this.getTupleShift(startDate, preDayRange, startDayRange, endDayRange);
            }
        }
        return tuple3;
    }

    private static Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> getTupleInShiftRange(Date startDate, Date endDate, ShiftDateVo preDayRange, ShiftDateVo startDayRange, ShiftDateVo endDayRange) {
        boolean curNex;
        boolean timeInPreShiftRange = false;
        boolean timeInCurShiftRange = false;
        boolean timeInNextShiftRange = false;
        if (startDate != null && endDate != null) {
            if (preDayRange != null) {
                timeInPreShiftRange = ApplyUtil.timeInShiftRange(startDate, endDate, preDayRange);
            }
            if (startDayRange != null) {
                timeInCurShiftRange = ApplyUtil.timeInShiftRange(startDate, endDate, startDayRange);
            }
            if (endDayRange != null) {
                timeInNextShiftRange = ApplyUtil.timeInShiftRange(startDate, endDate, endDayRange);
            }
        }
        boolean preCur = timeInPreShiftRange && timeInCurShiftRange;
        boolean bl = curNex = timeInCurShiftRange && timeInNextShiftRange;
        if (preCur || curNex) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.CROSSSHIFT, null);
        }
        if (timeInPreShiftRange) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)preDayRange.getBelongDate());
        }
        if (timeInCurShiftRange) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
        }
        if (timeInNextShiftRange) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)endDayRange.getBelongDate());
        }
        return null;
    }

    private Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> getTupleShift(Date startDate, ShiftDateVo preDayRange, ShiftDateVo startDayRange, ShiftDateVo endDayRange) {
        if (startDayRange == null) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.NOSHIFT, null);
        }
        if (!HRStringUtils.equals((String)startDayRange.getOffNonPlan(), (String)CROSS_SHIFT_OVER24_VAL) && startDayRange.getWorkEndDate() != null && startDate.compareTo(startDayRange.getWorkEndDate()) > 0) {
            return this.getTuple(startDate, startDayRange, endDayRange);
        }
        if (ApplyUtil.timeInRange(startDate, preDayRange.getStartScopeDate(), preDayRange.getEndScopeDate())) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)preDayRange.getBelongDate());
        }
        if (startDayRange.getStartScopeDate() == null || startDate.compareTo(startDayRange.getStartScopeDate()) < 0) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)preDayRange.getBelongDate());
        }
        if (ApplyUtil.timeInRange(startDate, startDayRange.getStartScopeDate(), startDayRange.getEndScopeDate())) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
        }
        if (endDayRange == null) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
        }
        if (endDayRange.getStartScopeDate() == null || startDate.compareTo(endDayRange.getStartScopeDate()) < 0) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
        }
        if (!ApplyUtil.timeInRange(startDate, endDayRange.getStartScopeDate(), endDayRange.getEndScopeDate())) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
        }
        return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)endDayRange.getBelongDate());
    }

    private Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> getTupleOneNullShift(Date startDate, Date endDate, ShiftDateVo preDayRange, ShiftDateVo startDayRange, ShiftDateVo endDayRange) {
        if (preDayRange == null) {
            if (ApplyUtil.timeInRange(startDate, startDayRange.getStartScopeDate(), startDayRange.getEndScopeDate())) {
                return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
            }
            if (startDayRange.getEndScopeDate() != null && startDate.compareTo(startDayRange.getEndScopeDate()) >= 0) {
                if (ApplyUtil.timeInRange(startDate, endDayRange.getStartScopeDate(), endDayRange.getEndScopeDate())) {
                    return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)endDayRange.getBelongDate());
                }
                return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
            }
            if (WTCDateUtils.betweenTimeEquals((Date)endDate, (Date)startDayRange.getStartScopeDate(), (Date)startDayRange.getEndScopeDate())) {
                return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
            }
            if (HRStringUtils.equals((String)startDayRange.getOffNonPlan(), (String)CROSS_SHIFT_OVER24_VAL)) {
                return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
            }
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.NOSHIFT, null);
        }
        if (startDayRange == null) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.NOSHIFT, null);
        }
        return null;
    }

    private Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> getTupleTwoNullShift(Date startDate, ShiftDateVo preDayRange, ShiftDateVo startDayRange, ShiftDateVo endDayRange) {
        if (preDayRange == null && startDayRange == null) {
            if (ApplyUtil.timeInRange(startDate, endDayRange.getStartScopeDate(), endDayRange.getEndScopeDate())) {
                return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)endDayRange.getBelongDate());
            }
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.NOSHIFT, null);
        }
        if (preDayRange == null && endDayRange == null) {
            if (ApplyUtil.timeInRange(startDate, startDayRange.getStartScopeDate(), startDayRange.getEndScopeDate())) {
                return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
            }
            if (startDayRange.getEndScopeDate() != null && startDate.compareTo(startDayRange.getEndScopeDate()) >= 0) {
                return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
            }
            return new Tuples.Tuple3((Object)Boolean.FALSE, (Object)ApplyBillDutyDateErrorEnum.NOSHIFT, null);
        }
        if (startDayRange == null && endDayRange == null) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)preDayRange.getBelongDate());
        }
        return null;
    }

    private Tuples.Tuple3<Boolean, ApplyBillDutyDateErrorEnum, Date> getTuple(Date startDate, ShiftDateVo startDayRange, ShiftDateVo endDayRange) {
        if (endDayRange == null || ApplyUtil.timeInRange(startDate, startDayRange.getStartScopeDate(), startDayRange.getEndScopeDate())) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
        }
        if (ApplyUtil.timeInRange(startDate, endDayRange.getStartScopeDate(), endDayRange.getEndScopeDate())) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)endDayRange.getBelongDate());
        }
        return new Tuples.Tuple3((Object)Boolean.TRUE, null, (Object)startDayRange.getBelongDate());
    }
}

