/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.billservice.plan;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineHelper;
import kd.wtc.wtbs.business.web.applybill.ruleengine.PlanRuleEngineService;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.constants.engine.EngineRuleSetEnum;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineInParam;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.model.billservice.BillDutyDatePlanInfo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BillPlanService {
    private static final Log Log = LogFactory.getLog(BillPlanService.class);
    private static final BillPlanService INS = (BillPlanService)WTCAppContextHelper.getBean(BillPlanService.class);

    public static BillPlanService getInstance() {
        return INS;
    }

    public void fillPlanByAttFileAndDate(List<BillDutyDatePlanInfo> dutyDatePlanInfos, AttFileScheduleEnum scheduleEnum, String planEntityName) {
        if (kd.bos.util.CollectionUtils.isEmpty(dutyDatePlanInfos) || HRStringUtils.isEmpty((String)planEntityName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"BillPlanService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        Set<Long> attFileBoIds = dutyDatePlanInfos.stream().map(BillDutyDatePlanInfo::getAttFileBoId).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> attFileBoIdAndSideTablePlanDy = this.getAttFileBoIdAndSideTablePlanDy(attFileBoIds, scheduleEnum);
        Map<Long, List<DynamicObject>> attFileVidAndPlanVersion = BillPlanService.getPlanDyByAttFilePlan(attFileBoIdAndSideTablePlanDy, scheduleEnum, planEntityName);
        for (BillDutyDatePlanInfo dutyDatePlanInfo : dutyDatePlanInfos) {
            long attFileBoId = dutyDatePlanInfo.getAttFileBoId();
            Date queryDate = dutyDatePlanInfo.getQueryDate();
            List<Object> hisPlanDys = attFileVidAndPlanVersion.get(attFileBoId);
            List<Object> sideTablePlanDys = attFileBoIdAndSideTablePlanDy.get(attFileBoId);
            sideTablePlanDys = sideTablePlanDys == null ? Collections.emptyList() : sideTablePlanDys;
            hisPlanDys = hisPlanDys == null ? Collections.emptyList() : hisPlanDys;
            long planBoId = 0L;
            for (DynamicObject dynamicObject : sideTablePlanDys) {
                if (!WTCDateUtils.betweenDay((Date)queryDate, (Date)dynamicObject.getDate("startdate"), (Date)dynamicObject.getDate("enddate"))) continue;
                dutyDatePlanInfo.setSidePlanDy(dynamicObject);
                planBoId = dynamicObject.getLong(WTCStringUtils.joinStr((String[])new String[]{scheduleEnum.getKey(), ".", "id"}));
            }
            DynamicObject planDy = UnifyBillCommonHelper.getSeqHisDyByDate(planBoId, queryDate, hisPlanDys);
            dutyDatePlanInfo.setPlanDy(planDy);
        }
    }

    private Map<Long, List<DynamicObject>> getAttFileBoIdAndSideTablePlanDy(Set<Long> attFileBoIds, AttFileScheduleEnum scheduleEnum) {
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setFileBoIdSet(attFileBoIds);
        queryParam.setBusyStatus((Set)Sets.newHashSet((Object[])new String[]{"1"}));
        String planId = WTCStringUtils.joinStr((String[])new String[]{scheduleEnum.getKey(), ".", "id"});
        queryParam.setProperties(WTCStringUtils.joinOnComma((String[])new String[]{planId, "attfileid.id", "startdate", "enddate"}));
        AttFileScheduleServiceImpl attFileImpl = new AttFileScheduleServiceImpl();
        Map<Long, List<DynamicObject>> longListMap = attFileImpl.queryAttFileSchedule(scheduleEnum, queryParam);
        if (longListMap == null) {
            return Collections.emptyMap();
        }
        return longListMap;
    }

    private static Map<Long, List<DynamicObject>> getPlanDyByAttFilePlan(Map<Long, List<DynamicObject>> attFileBoIdAndSideTablePlanDy, AttFileScheduleEnum scheduleEnum, String planEntityName) {
        HashMap attFileIdAndPlanBoIds = Maps.newHashMapWithExpectedSize((int)attFileBoIdAndSideTablePlanDy.size());
        HashSet planBoIds = Sets.newHashSetWithExpectedSize((int)attFileBoIdAndSideTablePlanDy.size());
        attFileBoIdAndSideTablePlanDy.forEach((key, attFilePlanDyLists) -> {
            ArrayList planBoIdsInOneAttFile = Lists.newArrayListWithExpectedSize((int)attFilePlanDyLists.size());
            for (DynamicObject attFilePlanDy : attFilePlanDyLists) {
                long boId = attFilePlanDy.getLong(WTCStringUtils.joinStr((String[])new String[]{scheduleEnum.getKey(), ".", "id"}));
                planBoIdsInOneAttFile.add(boId);
                planBoIds.add(boId);
            }
            attFileIdAndPlanBoIds.put(key, planBoIdsInOneAttFile);
        });
        DynamicObject[] allSeqHisDys = UnifyBillCommonHelper.getAllSeqHisDys(planEntityName, WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), planBoIds);
        HashMap attFileIdAndPlanDy = Maps.newHashMapWithExpectedSize((int)allSeqHisDys.length);
        for (Map.Entry attFileAndPlanBoIds : attFileIdAndPlanBoIds.entrySet()) {
            ArrayList planDys = Lists.newArrayListWithExpectedSize((int)planBoIds.size());
            Long attFileBoId = (Long)attFileAndPlanBoIds.getKey();
            List planBoIdsInAttFile = (List)attFileAndPlanBoIds.getValue();
            for (DynamicObject planHisDy : allSeqHisDys) {
                if (!planBoIdsInAttFile.contains(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)planHisDy, (String)"boid"))) continue;
                planDys.add(planHisDy);
            }
            attFileIdAndPlanDy.put(attFileBoId, planDys);
        }
        return attFileIdAndPlanDy;
    }

    @Deprecated
    public List<PlanRuleEngineOutParam> getRuleDyInEngine(Map<Long, List<DynamicObject>> attFileBoIdAndPlanDyMap, Map<Long, DynamicObject> attFileBoIdAndDy, PlanSceneEnum planSceneEnum) {
        HashMap<Long, List<DynamicObject>> convert = new HashMap<Long, List<DynamicObject>>(16);
        HashMap<Long, List<LocalDate>> queryDates = new HashMap<Long, List<LocalDate>>(16);
        if (WTCCollections.isNotEmpty(attFileBoIdAndDy)) {
            for (Map.Entry<Long, DynamicObject> idAndDy : attFileBoIdAndDy.entrySet()) {
                convert.put(idAndDy.getKey(), Lists.newArrayList((Object[])new DynamicObject[]{idAndDy.getValue()}));
                queryDates.put(idAndDy.getKey(), Lists.newArrayList((Object[])new LocalDate[]{LocalDate.now()}));
            }
        }
        return this.getRuleDyInEngine(attFileBoIdAndPlanDyMap, convert, queryDates, planSceneEnum);
    }

    public List<PlanRuleEngineOutParam> getRuleDyInEngine(Map<Long, List<DynamicObject>> attFileBoIdAndPlanDyMap, Map<Long, List<DynamicObject>> attFileBoIdAndVersionDy, Map<Long, List<LocalDate>> queryDates, PlanSceneEnum planSceneEnum) {
        if (attFileBoIdAndPlanDyMap == null || attFileBoIdAndPlanDyMap.size() == 0) {
            return Collections.emptyList();
        }
        HashSet<Long> planIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<DynamicObject>> attFileBoIdAndPlan : attFileBoIdAndPlanDyMap.entrySet()) {
            Set collect = attFileBoIdAndPlan.getValue().stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            planIds.addAll(collect);
        }
        if (Log.isInfoEnabled()) {
            Log.info("BillPlanService_getRuleDyInEngine planIds.size = {}", (Object)planIds.size());
        }
        List<DynamicObject> ruleAssociationDyList = PlanRuleEngineHelper.getPolicyByPlanIds(planIds);
        HashSet needQueryEngine = Sets.newHashSetWithExpectedSize((int)ruleAssociationDyList.size());
        for (DynamicObject ruleAssociationDy : ruleAssociationDyList) {
            String ruleSet = ruleAssociationDy.getString("ruleset");
            if (!HRStringUtils.equals((String)ruleSet, (String)EngineRuleSetEnum.ENGINE.getVal())) continue;
            needQueryEngine.add(ruleAssociationDy.getLong("planid"));
        }
        List<PlanRuleEngineInParam> planIdAndRuleEnginePolicyOri = this.getPlanIdAndRuleEnginePolicy(attFileBoIdAndPlanDyMap, attFileBoIdAndVersionDy, needQueryEngine, queryDates);
        ArrayList<PlanRuleEngineInParam> planIdAndRuleEnginePolicy = new ArrayList<PlanRuleEngineInParam>(planIdAndRuleEnginePolicyOri.size());
        planIdAndRuleEnginePolicy.addAll(planIdAndRuleEnginePolicyOri);
        Log.info("BillPlanService.getRuleDyInEngine planSceneEnum = {},planIdAndRuleEnginePolicy.size = {}", (Object)planSceneEnum, (Object)planIdAndRuleEnginePolicy.size());
        Iterator iterator = planIdAndRuleEnginePolicy.iterator();
        while (iterator.hasNext()) {
            PlanRuleEngineInParam planRuleEngineInParam = (PlanRuleEngineInParam)iterator.next();
            DynamicObject attFile = planRuleEngineInParam.getAttFile();
            Date date = planRuleEngineInParam.getDate();
            DynamicObject plan = planRuleEngineInParam.getPlan();
            boolean paramCheck = true;
            if (attFile == null) {
                Log.info("BillPlanService.getRuleDyInEngine attFile is null");
                paramCheck = false;
            }
            if (date == null) {
                Log.info("BillPlanService.getRuleDyInEngine date is null");
                paramCheck = false;
            }
            if (plan == null) {
                Log.info("BillPlanService.getRuleDyInEngine plan is null");
                paramCheck = false;
            }
            if (paramCheck) continue;
            iterator.remove();
        }
        Log.info("BillPlanService.getRuleDyInEngine after filter planSceneEnum = {},planIdAndRuleEnginePolicy.size = {}", (Object)planSceneEnum, (Object)planIdAndRuleEnginePolicy.size());
        List<Object> planRuleEngineOutParams = PlanRuleEngineService.getInstance().batchCallRuleEngine(planSceneEnum, planIdAndRuleEnginePolicy);
        planRuleEngineOutParams = planRuleEngineOutParams == null ? Collections.emptyList() : planRuleEngineOutParams;
        Log.info("BillPlanService.getRuleDyInEngine planRuleEngineOutParams.size = {}", (Object)planRuleEngineOutParams.size());
        for (PlanRuleEngineOutParam planRuleEngineOutParam : planRuleEngineOutParams) {
            if (!kd.bos.util.CollectionUtils.isEmpty((Collection)planRuleEngineOutParam.getRules())) continue;
            planRuleEngineOutParam.setRules(Collections.emptyList());
            Log.info("BillPlanService.getRuleDyInEngine rules is empty = {}", (Object)kd.bos.util.CollectionUtils.isEmpty((Collection)planRuleEngineOutParam.getRules()));
        }
        ArrayList<PlanRuleEngineOutParam> planRuleEngineOutParamsResult = new ArrayList<PlanRuleEngineOutParam>(10);
        for (PlanRuleEngineInParam planRuleEngineInParam : planIdAndRuleEnginePolicyOri) {
            Object requestPkValue = planRuleEngineInParam.getPlan().getPkValue();
            boolean match = false;
            for (PlanRuleEngineOutParam planRuleEngineOutParam : planRuleEngineOutParams) {
                Object pkValue = planRuleEngineOutParam.getPlan().getPkValue();
                if (!requestPkValue.equals(pkValue)) continue;
                match = true;
                break;
            }
            if (match) continue;
            Log.info("BillPlanService.getRuleDyInEngine do new planRuleEngineOutParam self planPkId = {}", requestPkValue);
            PlanRuleEngineOutParam outParam = new PlanRuleEngineOutParam();
            outParam.setRule(null);
            outParam.setDate(planRuleEngineInParam.getDate());
            outParam.setRules(Collections.emptyList());
            outParam.setPlan(planRuleEngineInParam.getPlan());
            outParam.setAttFileDy(planRuleEngineInParam.getAttFile());
            planRuleEngineOutParamsResult.add(outParam);
        }
        Log.info("BillPlanService.getRuleDyInEngine planRuleEngineOutParamsSelf.size={}", (Object)planRuleEngineOutParamsResult.size());
        planRuleEngineOutParamsResult.addAll(planRuleEngineOutParams);
        return planRuleEngineOutParamsResult;
    }

    private List<PlanRuleEngineInParam> getPlanIdAndRuleEnginePolicy(Map<Long, List<DynamicObject>> attFileBoIdAndPlanDyMap, Map<Long, List<DynamicObject>> attFileBoIdAndVersionDy, Set<Long> needQueryEngine, Map<Long, List<LocalDate>> queryDates) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        BillAttFileService attFileService = BillAttFileService.getInstance();
        HashSet<String> signSet = new HashSet<String>(16);
        for (Map.Entry<Long, List<DynamicObject>> attFileBoIdAndPlanDy : attFileBoIdAndPlanDyMap.entrySet()) {
            Long attFileBoId = attFileBoIdAndPlanDy.getKey();
            List<DynamicObject> planDyList = attFileBoIdAndPlanDy.getValue();
            for (DynamicObject planDy : planDyList) {
                if (!needQueryEngine.contains(planDy.getLong("id"))) continue;
                List<LocalDate> localDates = queryDates.get(attFileBoId);
                for (LocalDate localDate : localDates) {
                    DynamicObject attFileVersionByDate;
                    String sign = this.getEngineSign(planDy, localDate, attFileVersionByDate = attFileService.getAttFileVersionByDate(attFileBoIdAndVersionDy.get(attFileBoId), WTCDateUtils.toDate((LocalDate)localDate)));
                    if (!signSet.add(sign)) continue;
                    PlanRuleEngineInParam planRuleEngineInParam = new PlanRuleEngineInParam();
                    planRuleEngineInParam.setAttFile(attFileVersionByDate);
                    planRuleEngineInParam.setPlan(planDy);
                    planRuleEngineInParam.setDate(WTCDateUtils.toDate((LocalDate)localDate));
                    result.add(planRuleEngineInParam);
                }
            }
        }
        return result;
    }

    public String getEngineSign(DynamicObject planDy, LocalDate date, DynamicObject attFileVersionDy) {
        long planId = planDy == null ? 0L : planDy.getLong("id");
        LocalDate queryDate = date == null ? WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinEndDate()) : date;
        long attFileVersionId = attFileVersionDy == null ? 0L : attFileVersionDy.getLong("id");
        return planId + "_" + queryDate.toString() + "_" + attFileVersionId;
    }

    public Tuple<Boolean, List<Long>> matchEngineRuleBoId(DynamicObject needMatchPlan, LocalDate queryDate, DynamicObject matchEngineAttFileDy, List<PlanRuleEngineOutParam> planRuleEngineOutParamList) {
        if (!CollectionUtils.isEmpty(planRuleEngineOutParamList) && needMatchPlan != null) {
            BillPlanService planService = BillPlanService.getInstance();
            String engineSign = planService.getEngineSign(needMatchPlan, queryDate, matchEngineAttFileDy);
            for (PlanRuleEngineOutParam ruleEngineOutParam : planRuleEngineOutParamList) {
                String engineSignResult = planService.getEngineSign(ruleEngineOutParam.getPlan(), WTCDateUtils.toLocalDate((Date)ruleEngineOutParam.getDate()), ruleEngineOutParam.getAttFileDy());
                if (!HRStringUtils.equals((String)engineSign, (String)engineSignResult)) continue;
                List rules = ruleEngineOutParam.getRules();
                if (CollectionUtils.isEmpty((Collection)rules)) {
                    return new Tuple((Object)Boolean.TRUE, Collections.emptyList());
                }
                return new Tuple((Object)Boolean.TRUE, rules.stream().map(dy -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"boid")).collect(Collectors.toList()));
            }
        }
        return new Tuple((Object)Boolean.FALSE, Collections.emptyList());
    }

    public Optional<DynamicObject> getSideDy(List<BillDutyDatePlanInfo> allData, long queryAttFileBoId, Date queryDate) {
        if (queryDate == null || WTCCollections.isEmpty(allData)) {
            return Optional.empty();
        }
        for (BillDutyDatePlanInfo allDatum : allData) {
            boolean dateEquals;
            if (allDatum == null) continue;
            boolean attFileBoIdEquals = queryAttFileBoId == allDatum.getAttFileBoId();
            boolean bl = dateEquals = allDatum.getQueryDate() != null && WTCDateUtils.getDayStart((Date)allDatum.getQueryDate()).equals(WTCDateUtils.getDayStart((Date)queryDate));
            if (!attFileBoIdEquals || !dateEquals) continue;
            if (allDatum.getSidePlanDy() == null) {
                return Optional.empty();
            }
            return Optional.of(allDatum.getSidePlanDy());
        }
        return Optional.empty();
    }

    public Map<Long, Boolean> usePlanEngine(List<DynamicObject> planVersionDys) {
        if (WTCCollections.isEmpty(planVersionDys)) {
            return Collections.emptyMap();
        }
        HashSet<Long> planIds = new HashSet<Long>(16);
        for (DynamicObject planDy : planVersionDys) {
            if (planDy == null) continue;
            long planVersionId = planDy.getLong("id");
            planIds.add(planVersionId);
        }
        List<DynamicObject> policyByPlanIds = PlanRuleEngineHelper.getPolicyByPlanIds(planIds);
        Set engineIdSet = policyByPlanIds.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(16);
        for (DynamicObject planVersionDy : planVersionDys) {
            if (planVersionDy == null) continue;
            long aLong = planVersionDy.getLong("id");
            result.put(aLong, engineIdSet.contains(aLong));
        }
        return result;
    }
}

