/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.billservice.rule;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.AttfileLimitScopeServiceImpl;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.business.rulecontrol.ConditionValidateService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.bill.PlanRuleEngineOutParam;
import kd.wtc.wtbs.common.model.bill.unifybill.MatchRuleCal;
import kd.wtc.wtbs.common.model.billservice.BillDutyDateRuleInfo;
import kd.wtc.wtbs.common.model.billservice.BillRuleField;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class BillRuleService {
    private static final Log LOG = LogFactory.getLog(BillRuleService.class);
    private static final BillRuleService INS = (BillRuleService)WTCAppContextHelper.getBean(BillRuleService.class);

    public static BillRuleService getInstance() {
        return INS;
    }

    @Deprecated
    public void fillRuleCalByAttFileAndDate(List<BillDutyDateRuleInfo> billDutyDateRuleInfos, PlanSceneEnum planSceneEnum, BillRuleField fieldKey, boolean needReFillQueryAttFile) {
        if (WTCCollections.isEmpty(billDutyDateRuleInfos)) {
            return;
        }
        if (fieldKey == null) {
            throw new KDBizException(ResManager.loadKDString((String)"BillRuleField\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillRuleService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        String ruleInPlan = fieldKey.getRuleInPlan();
        String ruleEntityName = fieldKey.getRuleEntityName();
        String ruleCalEntryKeyName = fieldKey.getRuleCalEntryKeyName();
        String limitJsonKeyName = fieldKey.getLimitJsonKeyName();
        String typeKeyName = fieldKey.getTypeKeyName();
        if (needReFillQueryAttFile) {
            this.fillAttFile(billDutyDateRuleInfos);
        }
        this.fillRuleDy(billDutyDateRuleInfos, planSceneEnum, ruleInPlan, ruleEntityName, false);
        this.fillRuleCalList(billDutyDateRuleInfos, ruleCalEntryKeyName, limitJsonKeyName, typeKeyName);
    }

    public void fillRuleCalByRetrieval(List<BillDutyDateRuleInfo> billDutyDateRuleInfos, PlanSceneEnum planSceneEnum, BillRuleField fieldKey, boolean needReFillQueryAttFile) {
        if (WTCCollections.isEmpty(billDutyDateRuleInfos)) {
            return;
        }
        if (fieldKey == null) {
            throw new KDBizException(ResManager.loadKDString((String)"BillRuleField\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BillRuleService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        String ruleInPlan = fieldKey.getRuleInPlan();
        String ruleEntityName = fieldKey.getRuleEntityName();
        if (needReFillQueryAttFile) {
            this.fillAttFile(billDutyDateRuleInfos);
        }
        this.fillRuleDy(billDutyDateRuleInfos, planSceneEnum, ruleInPlan, ruleEntityName, false);
        this.fillRuleCalListByRe(billDutyDateRuleInfos, fieldKey);
    }

    private void fillAttFile(List<BillDutyDateRuleInfo> billDutyDateRuleInfos) {
        if (WTCCollections.isEmpty(billDutyDateRuleInfos)) {
            return;
        }
        Set<Long> attFileBoIds = billDutyDateRuleInfos.stream().map(BillDutyDateRuleInfo::getAttFileBoId).collect(Collectors.toSet());
        BillAttFileService attFileService = new BillAttFileService();
        Map<Long, List<DynamicObject>> attFileBoIdAndAttFileDys = attFileService.getAllAttFileVersion(attFileBoIds);
        HashMap attFileBoIdAndAttFileVersionDys = Maps.newHashMapWithExpectedSize((int)attFileBoIdAndAttFileDys.size());
        HashMap attFileBoIdAndAttFileBoDys = Maps.newHashMapWithExpectedSize((int)attFileBoIdAndAttFileDys.size());
        for (Map.Entry<Long, List<DynamicObject>> attFileAndDy : attFileBoIdAndAttFileDys.entrySet()) {
            Long attFileBoId = attFileAndDy.getKey();
            List hisVersionList = attFileBoIdAndAttFileVersionDys.computeIfAbsent(attFileBoId, k -> new ArrayList());
            if (WTCCollections.isEmpty((Collection)attFileAndDy.getValue())) continue;
            for (DynamicObject dynamicObject : attFileAndDy.getValue()) {
                if (dynamicObject.getBoolean("iscurrentversion")) {
                    attFileBoIdAndAttFileBoDys.put(attFileBoId, dynamicObject);
                    continue;
                }
                hisVersionList.add(dynamicObject);
            }
        }
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            Date queryDate = billDutyDateRuleInfo.getQueryDate();
            long attFileBoId = billDutyDateRuleInfo.getAttFileBoId();
            List attFileVersions = (List)attFileBoIdAndAttFileVersionDys.get(attFileBoId);
            if (WTCCollections.isEmpty((Collection)attFileVersions)) continue;
            BillAttFileService billAttFileService = new BillAttFileService();
            billDutyDateRuleInfo.setAttFileVersionDy(billAttFileService.getAttFileVersionByDate(attFileVersions, queryDate));
            billDutyDateRuleInfo.setCurrentAttFileBoDy((DynamicObject)attFileBoIdAndAttFileBoDys.get(attFileBoId));
        }
    }

    private void fillRuleCalList(List<BillDutyDateRuleInfo> billDutyDateRuleInfos, String ruleCalEntryKeyName, String limitJsonKeyName, String typeKeName) {
        ArrayList<MatchRuleCal> matchRuleCalLists = new ArrayList<MatchRuleCal>(10);
        HashMap<BillDutyDateRuleInfo, List<MatchRuleCal>> ruleCalIdAndMatchRuleCalMap = new HashMap<BillDutyDateRuleInfo, List<MatchRuleCal>>(16);
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            List<MatchRuleCal> matchRuleCal = this.getMatchRuleCal(billDutyDateRuleInfo, ruleCalEntryKeyName, limitJsonKeyName, typeKeName);
            matchRuleCalLists.addAll(matchRuleCal);
            ruleCalIdAndMatchRuleCalMap.put(billDutyDateRuleInfo, matchRuleCal);
        }
        AttfileLimitScopeServiceImpl service = new AttfileLimitScopeServiceImpl();
        Map<MatchRuleCal, Boolean> matchRuleCalBooleanMap = service.matchRuleCal(matchRuleCalLists);
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            List matchRuleCals = (List)ruleCalIdAndMatchRuleCalMap.get(billDutyDateRuleInfo);
            if (CollectionUtils.isEmpty((Collection)matchRuleCals)) {
                billDutyDateRuleInfo.setRuleCalList(Collections.emptyList());
                continue;
            }
            List matchResult = (List)ruleCalIdAndMatchRuleCalMap.get(billDutyDateRuleInfo);
            ArrayList<DynamicObject> passRuleCalResult = new ArrayList<DynamicObject>(10);
            for (MatchRuleCal matchRuleCal : matchResult) {
                if (!matchRuleCalBooleanMap.get(matchRuleCal).booleanValue()) continue;
                passRuleCalResult.add(matchRuleCal.getMatchRuleCalDy());
            }
            billDutyDateRuleInfo.setRuleCalList(passRuleCalResult);
        }
    }

    private void fillRuleCalListByRe(List<BillDutyDateRuleInfo> billDutyDateRuleInfos, BillRuleField ruleField) {
        LinkedHashMap<BillDutyDateRuleInfo, List<MatchRuleCal>> ruleCalIdAndMatchRuleCalMap = new LinkedHashMap<BillDutyDateRuleInfo, List<MatchRuleCal>>(16);
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            List<MatchRuleCal> matchRuleCal = this.getMatchRuleCal(billDutyDateRuleInfo, ruleField.getRuleCalEntryKeyName(), ruleField.getLimitJsonKeyName(), ruleField.getTypeKeyName());
            ruleCalIdAndMatchRuleCalMap.put(billDutyDateRuleInfo, matchRuleCal);
        }
        HashSet<Long> attPersonIds = new HashSet<Long>(16);
        ArrayList<RuleConditionRetrieval> retrievalList = new ArrayList<RuleConditionRetrieval>(10);
        HashMap<MatchRuleCal, RuleConditionRetrieval> matchResultMap = new HashMap<MatchRuleCal, RuleConditionRetrieval>(16);
        for (Map.Entry billDutyDateRuleInfoListEntry : ruleCalIdAndMatchRuleCalMap.entrySet()) {
            List matchRuleCals = (List)billDutyDateRuleInfoListEntry.getValue();
            BillDutyDateRuleInfo billDutyDateRuleInfo = (BillDutyDateRuleInfo)billDutyDateRuleInfoListEntry.getKey();
            if (matchRuleCals == null || matchRuleCals.isEmpty()) continue;
            for (MatchRuleCal matchRuleCal : matchRuleCals) {
                boolean typeEquals;
                RuleConditionRetrieval billRetrieval = new RuleConditionRetrieval();
                AccessDto accessDto = (AccessDto)matchRuleCal.getAccessDto();
                if (accessDto != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
                    billRetrieval.setAccessDto(accessDto);
                } else {
                    billRetrieval.setNeedExecuteMatch(false);
                }
                billRetrieval.setDimensionKey(matchRuleCal.getDimensionKey());
                boolean bl = typeEquals = matchRuleCal.getNeedMatchTypeId() == null || matchRuleCal.getNeedMatchTypeId() == 0L || HRObjectUtils.equals((Object)matchRuleCal.getRuleCalTypeId(), (Object)matchRuleCal.getNeedMatchTypeId());
                if (!typeEquals) {
                    billRetrieval.setMatchResult(false);
                    billRetrieval.setNeedExecuteMatch(false);
                }
                if (billRetrieval.isNeedExecuteMatch()) {
                    billRetrieval.setBillDy(billDutyDateRuleInfo.getBillDy());
                    billRetrieval.setEntryKey(billDutyDateRuleInfo.getEntryKey());
                    billRetrieval.setIndex(billDutyDateRuleInfo.getEntryIndex());
                    DynamicObject attFileVersionDy = matchRuleCal.getAttFileVersionDy();
                    if (attFileVersionDy != null) {
                        this.setAttFilePersonInfo(attFileVersionDy, billRetrieval);
                    } else {
                        billRetrieval.setNeedExecuteMatch(false);
                        billRetrieval.setMatchResult(false);
                    }
                    this.collectQueryAgePersonIds(attPersonIds, billRetrieval);
                    Date dutyDate = billDutyDateRuleInfo.getQueryDate();
                    billRetrieval.setOwnDate(dutyDate);
                    billRetrieval.setBillBusType(ruleField.getBillType());
                }
                matchResultMap.put(matchRuleCal, billRetrieval);
                retrievalList.add(billRetrieval);
            }
        }
        boolean needMatch = retrievalList.stream().anyMatch(RuleConditionRetrieval::isNeedExecuteMatch);
        if (needMatch) {
            this.matchRetrieval(billDutyDateRuleInfos, attPersonIds, retrievalList);
        }
        HashMap matchRuleCalBooleanMap = Maps.newHashMapWithExpectedSize((int)matchResultMap.size());
        for (Map.Entry entry : matchResultMap.entrySet()) {
            matchRuleCalBooleanMap.put(entry.getKey(), ((RuleConditionRetrieval)entry.getValue()).isMatchResult());
        }
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            List matchRuleCals = (List)ruleCalIdAndMatchRuleCalMap.get(billDutyDateRuleInfo);
            if (CollectionUtils.isEmpty((Collection)matchRuleCals)) {
                billDutyDateRuleInfo.setRuleCalList(new ArrayList(0));
                continue;
            }
            ArrayList<DynamicObject> passRuleCalResult = new ArrayList<DynamicObject>(10);
            for (MatchRuleCal matchRuleCal : matchRuleCals) {
                Boolean isMatch = (Boolean)matchRuleCalBooleanMap.get(matchRuleCal);
                if (!Boolean.TRUE.equals(isMatch)) continue;
                passRuleCalResult.add(matchRuleCal.getMatchRuleCalDy());
            }
            billDutyDateRuleInfo.setRuleCalList(passRuleCalResult);
        }
    }

    private void matchRetrieval(List<BillDutyDateRuleInfo> billDutyDateRuleInfos, Set<Long> attPersonIds, List<RuleConditionRetrieval> retrievalList) {
        Set<Long> fileVidSet = billDutyDateRuleInfos.stream().map(BillDutyDateRuleInfo::getAttFileVersionDy).filter(Objects::nonNull).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> attFileDyMap = RuleConditionBillMatchService.getAttFileByIds(fileVidSet);
        for (RuleConditionRetrieval billRetrieval : retrievalList) {
            if (billRetrieval.getAttFileV() == null) continue;
            long fileVid = billRetrieval.getAttFileV().getLong("id");
            DynamicObject fileVDy = attFileDyMap.get(fileVid);
            if (fileVDy == null) {
                billRetrieval.setNeedExecuteMatch(false);
                billRetrieval.setMatchResult(false);
                continue;
            }
            billRetrieval.setAttFileV(fileVDy);
        }
        List<RuleConditionRetrieval> matchList = retrievalList.stream().filter(RuleConditionRetrieval::isNeedExecuteMatch).collect(Collectors.toList());
        if (!matchList.isEmpty()) {
            RuleConditionBillMatchService.fillStandardRetrieval(matchList, attPersonIds);
            RuleConditionBillMatchService.beginRetrievalMatch(matchList);
        }
    }

    private void setAttFilePersonInfo(DynamicObject attFile, RuleConditionRetrieval retrieval) {
        if (attFile != null && retrieval != null) {
            long attPersonId = WTCDynamicObjectUtils.getBaseDataId(attFile, "attperson");
            retrieval.setAttFileVId(attFile.getLong("id"));
            retrieval.setAttPersonId(attPersonId);
            retrieval.setAttFileBoId(attFile.getLong("boid"));
            retrieval.setPersonId(attFile.getLong("person.id"));
            retrieval.setEmployeeId(attFile.getLong("employee.id"));
            retrieval.setDempempId(attFile.getLong("depemp.id"));
            retrieval.setAttFileV(attFile);
        }
    }

    private void collectQueryAgePersonIds(Set<Long> attPersonIds, RuleConditionRetrieval billRetrieval) {
        boolean needExecuteMatch = billRetrieval.isNeedExecuteMatch();
        AccessDto accessDto = billRetrieval.getAccessDto();
        if (needExecuteMatch && accessDto != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
            for (ConditionDto conditionDto : accessDto.getConditionList()) {
                String param = conditionDto.getParam();
                if (!HRStringUtils.isNotEmpty((String)param) || !param.contains("age") && !param.contains("entrydate") && !param.contains("regulardate") && !param.contains("joblevel") && !param.contains("jobgrade")) continue;
                attPersonIds.add(billRetrieval.getPersonId());
            }
        }
    }

    private List<MatchRuleCal> getMatchRuleCal(BillDutyDateRuleInfo billDutyDateRuleInfo, String ruleCalEntryKeyName, String limitJsonKeyName, String typeKeyName) {
        ArrayList<MatchRuleCal> result = new ArrayList<MatchRuleCal>(10);
        DynamicObject attFileVersion = billDutyDateRuleInfo.getAttFileVersionDy();
        if (attFileVersion == null) {
            return Collections.emptyList();
        }
        DynamicObject matchRuleDy = billDutyDateRuleInfo.getRuleDy();
        if (matchRuleDy == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection entries = matchRuleDy.getDynamicObjectCollection(ruleCalEntryKeyName);
        for (DynamicObject entry : entries) {
            DynamicObject typeDy;
            MatchRuleCal matchRuleCal = new MatchRuleCal();
            matchRuleCal.setAttFileVersionDy(attFileVersion);
            String calCulDes = entry.getString(limitJsonKeyName);
            matchRuleCal.setCalCulDes(calCulDes);
            matchRuleCal.setAccessDto((Object)ConditionValidateService.getRuleConditionInfo(calCulDes));
            matchRuleCal.setMatchRuleCalDy(entry);
            matchRuleCal.setNeedMatchTypeId(billDutyDateRuleInfo.getTypeId());
            if (HRStringUtils.isNotEmpty((String)typeKeyName) && (typeDy = entry.getDynamicObject(typeKeyName)) != null) {
                matchRuleCal.setRuleCalTypeId(typeDy.getLong("id"));
            }
            result.add(matchRuleCal);
        }
        return result;
    }

    public void fillRuleDy(List<BillDutyDateRuleInfo> billDutyDateRuleInfos, PlanSceneEnum planSceneEnum, String ruleInPlan, String ruleEntityName, boolean needReFillQueryAttFile) {
        if (needReFillQueryAttFile) {
            this.fillAttFile(billDutyDateRuleInfos);
        }
        HashMap<Long, List<DynamicObject>> attFileBoIdAndVersionDy = new HashMap<Long, List<DynamicObject>>(16);
        HashMap<Long, List<DynamicObject>> attFileBoIdAndPlan = new HashMap<Long, List<DynamicObject>>(16);
        HashMap<Long, List<LocalDate>> attFileBoIdAndQueryDates = new HashMap<Long, List<LocalDate>>(16);
        HashSet<String> planIds = new HashSet<String>(16);
        HashSet<String> attFileVersionIds = new HashSet<String>(16);
        HashSet<String> date = new HashSet<String>(16);
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            boolean addSuccess;
            DynamicObject planDy;
            boolean addSuccess2;
            DynamicObject attFileBoDy = billDutyDateRuleInfo.getCurrentAttFileBoDy();
            if (attFileBoDy == null) continue;
            long attFileBoId = attFileBoDy.getLong("id");
            List plans = attFileBoIdAndPlan.computeIfAbsent(attFileBoId, af -> new ArrayList(10));
            List attFileVersionDys = attFileBoIdAndVersionDy.computeIfAbsent(attFileBoId, af -> new ArrayList(10));
            List queryDates = attFileBoIdAndQueryDates.computeIfAbsent(attFileBoId, af -> new ArrayList(10));
            DynamicObject attFileVersionDy = billDutyDateRuleInfo.getAttFileVersionDy();
            if (attFileVersionDy != null && (addSuccess2 = attFileVersionIds.add(attFileBoId + "_" + attFileVersionDy.getLong("id")))) {
                attFileVersionDys.add(attFileVersionDy);
            }
            if ((planDy = billDutyDateRuleInfo.getPlanDy()) != null && (addSuccess = planIds.add(attFileBoId + "_" + planDy.getLong("id")))) {
                plans.add(planDy);
            }
            if (billDutyDateRuleInfo.getQueryDate() == null || !(addSuccess = date.add(attFileBoId + "_" + billDutyDateRuleInfo.getQueryDate().getTime()))) continue;
            queryDates.add(WTCDateUtils.toLocalDate((Date)billDutyDateRuleInfo.getQueryDate()));
        }
        List<PlanRuleEngineOutParam> ruleEngine = this.getRuleEngine(attFileBoIdAndPlan, attFileBoIdAndVersionDy, attFileBoIdAndQueryDates, planSceneEnum);
        ArrayList<Long> planRuleBoIds = new ArrayList<Long>(10);
        HashMap<BillDutyDateRuleInfo, Long> paramAndRuleBoIdMap = new HashMap<BillDutyDateRuleInfo, Long>(16);
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            Long ruleBoId;
            DynamicObject planDy = billDutyDateRuleInfo.getPlanDy();
            if (planDy == null || (ruleBoId = BillRuleService.getRuleBoIdByPlanDy(billDutyDateRuleInfo.getPlanDy(), WTCDateUtils.toLocalDate((Date)billDutyDateRuleInfo.getQueryDate()), billDutyDateRuleInfo.getAttFileVersionDy(), ruleInPlan, ruleEngine)) == null || ruleBoId == 0L) continue;
            planRuleBoIds.add(ruleBoId);
            paramAndRuleBoIdMap.put(billDutyDateRuleInfo, ruleBoId);
        }
        Tuples.Tuple2<Date, Date> minAndMax = this.minAndMax(billDutyDateRuleInfos);
        DynamicObject[] rules = UnifyBillCommonHelper.getAllSeqHisDys(ruleEntityName, (Date)minAndMax.item1, (Date)minAndMax.item2, Sets.newHashSet(planRuleBoIds));
        Map<Long, List<DynamicObject>> ruleIdAndDy = Arrays.stream(rules).collect(Collectors.groupingBy(r -> r.getLong("boid")));
        for (Map.Entry infoAndRuleBoId : paramAndRuleBoIdMap.entrySet()) {
            Long ruleBoId = (Long)infoAndRuleBoId.getValue();
            BillDutyDateRuleInfo ruleInfo = (BillDutyDateRuleInfo)infoAndRuleBoId.getKey();
            List<Object> ruleDys = ruleIdAndDy.get(ruleBoId);
            ruleDys = ruleDys == null ? Collections.emptyList() : ruleDys;
            DynamicObject ruleSeqHisDyByDate = UnifyBillCommonHelper.getSeqHisDyByDate(ruleBoId, ruleInfo.getQueryDate(), ruleDys);
            ruleInfo.setRuleDy(ruleSeqHisDyByDate);
        }
    }

    private Tuples.Tuple2<Date, Date> minAndMax(List<BillDutyDateRuleInfo> billDutyDateRuleInfos) {
        Date min = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMaxEndDate());
        Date max = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMinEndDate());
        for (BillDutyDateRuleInfo ruleInfo : billDutyDateRuleInfos) {
            Date queryDate = ruleInfo.getQueryDate();
            if (queryDate == null) continue;
            if (queryDate.before(min)) {
                min = queryDate;
            }
            if (!queryDate.after(max)) continue;
            max = queryDate;
        }
        return new Tuples.Tuple2((Object)min, (Object)max);
    }

    private static Long getRuleBoIdByPlanDy(DynamicObject plan, LocalDate queryDate, DynamicObject matchEngineAttFileDy, String ruleEntityName, List<PlanRuleEngineOutParam> planRuleEngineOutParams) {
        if (plan == null) {
            return 0L;
        }
        Tuple<Boolean, List<Long>> resultAndRuleBoIdSet = BillPlanService.getInstance().matchEngineRuleBoId(plan, queryDate, matchEngineAttFileDy, planRuleEngineOutParams);
        if (((Boolean)resultAndRuleBoIdSet.item1).booleanValue()) {
            List ruleBoIds = (List)resultAndRuleBoIdSet.item2;
            if (CollectionUtils.isEmpty((Collection)ruleBoIds)) {
                return 0L;
            }
            if (ruleBoIds.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u7684\u89c4\u5219\u5f15\u64ce\u4ec5\u53ef\u914d\u7f6e\u4e00\u6761\u89c4\u5219\u3002", (String)"UnifyBillCommonHelper_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            return (Long)ruleBoIds.get(0);
        }
        return plan.getLong(ruleEntityName + "." + "id");
    }

    private List<PlanRuleEngineOutParam> getRuleEngine(Map<Long, List<DynamicObject>> attFileBoIdAndPlanDyMap, Map<Long, List<DynamicObject>> attFileBoIdAndVersionDy, Map<Long, List<LocalDate>> queryDates, PlanSceneEnum planSceneEnum) {
        BillPlanService service = new BillPlanService();
        return service.getRuleDyInEngine(attFileBoIdAndPlanDyMap, attFileBoIdAndVersionDy, queryDates, planSceneEnum);
    }
}

