/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.billservice.shift;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.common.model.billservice.BillShiftParam;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class BillShiftService {
    private static final Log LOG = LogFactory.getLog(BillShiftService.class);

    public void fillShiftInfo(List<BillShiftParam> shiftParams) {
        this.validateParam(shiftParams);
        List<Long> appFileBoIds = shiftParams.stream().map(BillShiftParam::getAttFileBoId).collect(Collectors.toList());
        Tuples.Tuple2<Date, Date> minAndMax = this.minAndMax(shiftParams);
        DutyShiftResponse shiftResponse = ApplyUtil.getShift(appFileBoIds, (Date)minAndMax.item1, (Date)minAndMax.item2);
        if (shiftResponse == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("BillShiftService_getShiftInfo shiftResponse is null");
            }
            return;
        }
        Map dutyShiftMap = shiftResponse.getDutyShiftOfFileMap();
        if (WTCCollections.isEmpty((Map)dutyShiftMap)) {
            LOG.info("UnifyEntryShiftRangeService.matchProcess>>> DutyShiftResponse result empty");
            return;
        }
        for (BillShiftParam shiftParam : shiftParams) {
            if (shiftParam.getQueryStartDate() == null || shiftParam.getQueryEndDate() == null) {
                shiftParam.setDutyShiftAndShift(Collections.emptyList());
                continue;
            }
            List dateRange = WTCDateUtils.getDateRange((Date)shiftParam.getQueryStartDate(), (Date)shiftParam.getQueryEndDate());
            List dutyShiftList = dateRange.stream().map(date -> shiftResponse.getDutyShift(Long.valueOf(shiftParam.getAttFileBoId()), date)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            ArrayList matchShiftInfo = Lists.newArrayListWithExpectedSize((int)dateRange.size());
            for (DutyShift dutyShift : dutyShiftList) {
                Optional shiftOptional = shiftResponse.getShiftHisData(dutyShift.getShiftVid());
                if (!shiftOptional.isPresent()) continue;
                Shift shift = (Shift)shiftOptional.get();
                matchShiftInfo.add(new Tuples.Tuple2((Object)dutyShift, (Object)shift));
            }
            shiftParam.setDutyShiftAndShift((List)matchShiftInfo);
        }
    }

    private void validateParam(List<BillShiftParam> shiftReq) {
        for (BillShiftParam billShiftParam : shiftReq) {
            if (billShiftParam == null || billShiftParam.getQueryStartDate() == null || billShiftParam.getQueryEndDate() == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillShiftService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            if (!billShiftParam.getQueryStartDate().after(billShiftParam.getQueryEndDate())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"BillShiftService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
    }

    private Tuples.Tuple2<Date, Date> minAndMax(List<BillShiftParam> shiftReq) {
        Date min = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMaxEndDate());
        Date max = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMinEndDate());
        for (BillShiftParam billShiftParam : shiftReq) {
            Date queryStartDate = billShiftParam.getQueryStartDate();
            Date queryEndDate = billShiftParam.getQueryEndDate();
            if (queryStartDate.before(min)) {
                min = queryStartDate;
            }
            if (!queryEndDate.after(max)) continue;
            max = queryEndDate;
        }
        return new Tuples.Tuple2((Object)min, (Object)max);
    }
}

