/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.datetype;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class DateTypeService {
    private static final Log LOG = LogFactory.getLog(DateTypeService.class);
    private static final HRBaseServiceHelper DATE_TYPE_HELPER = new HRBaseServiceHelper("wtbd_datetype");
    private static final DateTypeService INS = new DateTypeService();

    public static DateTypeService getInstance() {
        return INS;
    }

    private DateTypeService() {
    }

    public Map<Long, DateType> getDateTypeMapByIds(Collection<Long> dateTypeIds) {
        DynamicObject[] dateTypeDys = DATE_TYPE_HELPER.query("id,number,name,dateproperty", new QFilter("id", "in", dateTypeIds).toArray());
        HashMap dateTypeMap = Maps.newHashMapWithExpectedSize((int)dateTypeIds.size());
        for (DynamicObject dateTypeDy : dateTypeDys) {
            DateType dateType = new DateType(Long.valueOf(dateTypeDy.getLong("id")), dateTypeDy.getString("number"), dateTypeDy.getString("name"), DateAttribute.fromById((Long)dateTypeDy.getLong("dateproperty.id")));
            dateTypeMap.put(dateType.getId(), dateType);
        }
        return dateTypeMap;
    }
}

