/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.file;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sdk.wtc.wtp.business.attfile.AttFileVersion;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class AttFileBusiness {
    public static void showAttFileDetailForm(IFormView view, IFormPlugin plugin, String actionId, Object attFileId) {
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setqFilter(new QFilter("id", "=", attFileId));
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        queryParam.setProperties("id,name,boid,sourcevid,empposorgrel,iscurrentversion,empposorgrel.id,attperson,attperson.id,attperson.name,type");
        DynamicObject attFileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFiles(queryParam);
        if (attFileDy != null) {
            String pageId;
            String appNumber;
            String errMsg;
            String fileType = attFileDy.getString("type");
            long attFileBoId = attFileDy.getLong("boid");
            boolean isCurrVersion = attFileDy.getBoolean("iscurrentversion");
            if (FileTypeEnum.VCFILE.getFileType().equals(fileType)) {
                errMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5047\u671f\u6863\u6848\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttFileBusiness_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                appNumber = "wtabm";
                pageId = "wtp_vafilebase";
            } else {
                errMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u8003\u52e4\u6863\u6848\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttFileBusiness_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                appNumber = "wtam";
                pageId = "wtp_attfilebase";
            }
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appNumber, (String)pageId, (String)"47150e89000000ac");
            if (!hasPerm) {
                view.showErrorNotification(errMsg);
                return;
            }
            if (!AttFileBusiness.checkAttFilePerm(attFileBoId, isCurrVersion, attFileDy, attFileId)) {
                view.showErrorNotification(errMsg);
                return;
            }
            ShowType showType = view.getFormShowParameter().getOpenStyle().getShowType();
            Map<String, Object> attFileDetailParamMap = AttFileBusiness.getAttFileDetailParamMap(attFileDy, attFileId);
            FormShowParameter formShowParameter = AttFileBusiness.getFileDetailForm(view, attFileDetailParamMap, plugin, actionId, fileType);
            if (ShowType.Modal == showType) {
                view.showForm(formShowParameter);
            } else {
                WtbsBusinessUtils.openTargetFormView(view, formShowParameter, appNumber);
            }
        }
    }

    public static boolean checkAttFileAuth(Object attFileId) {
        DynamicObject attFileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("id,boid,sourcevid,empposorgrel,iscurrentversion,empposorgrel.id,attperson,attperson.id,attperson.name,type", attFileId);
        if (attFileDy != null) {
            long attFileBoId = attFileDy.getLong("boid");
            boolean isCurrVersion = attFileDy.getBoolean("iscurrentversion");
            return AttFileBusiness.checkAttFilePerm(attFileBoId, isCurrVersion, attFileDy, attFileId);
        }
        return false;
    }

    private static boolean checkAttFilePerm(long attFileBoId, boolean isCurrVersion, DynamicObject attFileDy, Object attFileId) {
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setProperties("id");
        queryParam.setBoId(attFileBoId);
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        queryParam.setHisStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "1", "2", "-2", "-1"}));
        queryParam.setAuthCheck(Boolean.TRUE);
        queryParam.setAttStatus(null);
        List<DynamicObject> attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        if (CollectionUtils.isEmpty(attFiles)) {
            return false;
        }
        Set vidSet = attFiles.stream().map(info -> info.getLong("id")).collect(Collectors.toSet());
        if (isCurrVersion) {
            Long sourceVid = attFileDy.getLong("sourcevid");
            return vidSet.contains(sourceVid);
        }
        long fid = Long.parseLong(attFileId.toString());
        return vidSet.contains(fid);
    }

    private static Map<String, Object> getAttFileDetailParamMap(DynamicObject dynamicObject, Object pkId) {
        HashMap customVariablesMap = Maps.newHashMapWithExpectedSize((int)16);
        customVariablesMap.put("empposorgrel", dynamicObject.getLong("empposorgrel.id"));
        customVariablesMap.put("attfileid", pkId);
        customVariablesMap.put("attperson.id", dynamicObject.getLong("attperson.id"));
        customVariablesMap.put("attperson.name", dynamicObject.getString("attperson.name"));
        customVariablesMap.put("name", dynamicObject.getString("name"));
        customVariablesMap.put("boid", dynamicObject.getLong("boid"));
        return customVariablesMap;
    }

    private static FormShowParameter getFileDetailForm(IFormView view, Map<String, Object> customVariablesMap, IFormPlugin plugin, String actionId, String fileType) {
        FormShowParameter formShowParameter = new FormShowParameter();
        Object attFileIdObj = customVariablesMap.get("attfileid");
        if (attFileIdObj != null) {
            StringBuilder pageId = new StringBuilder(RequestContext.getOrCreate().getGlobalSessionId());
            pageId.append(attFileIdObj);
            IFormView parentView = view.getParentView();
            if (parentView != null) {
                pageId.append(parentView.getPageId());
            }
            formShowParameter.setPageId(pageId.toString());
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("wtp_attfiledetail");
        formShowParameter.setCustomParam("attfileid", customVariablesMap.get("attfileid"));
        formShowParameter.setCustomParam("currentObjectPKId", (Object)String.valueOf(customVariablesMap.get("attfileid")));
        if (FileTypeEnum.VCFILE.getFileType().equals(fileType)) {
            formShowParameter.setCustomParam("wtbs_entitytype_id", (Object)"1570286861933346816");
            formShowParameter.setCustomParam("filetype", (Object)FileTypeEnum.VCFILE.getFileType());
            formShowParameter.setCustomParam("appName", (Object)"wtabm");
        } else {
            formShowParameter.setCustomParam("wtbs_entitytype_id", (Object)"1381998876562612224");
            formShowParameter.setCustomParam("filetype", (Object)FileTypeEnum.ALLFILE.getFileType());
            formShowParameter.setCustomParam("appName", (Object)"wtam");
        }
        formShowParameter.setCustomParam("dateScope", customVariablesMap.get("dateScope"));
        formShowParameter.setCustomParam("customvariables", customVariablesMap);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        String attFileName = (String)customVariablesMap.get("name");
        String caption = AttFileBusiness.getCaption(attFileName, fileType);
        formShowParameter.setCaption(caption);
        formShowParameter.setHasRight(true);
        return formShowParameter;
    }

    private static String getCaption(String attPersonName, String fileType) {
        if (FileTypeEnum.VCFILE.getFileType().equals(fileType)) {
            return WtbsBusinessUtils.getFormCaption("wtp_vafilebase", () -> attPersonName);
        }
        return WtbsBusinessUtils.getFormCaption("wtp_attfilebase", () -> attPersonName);
    }

    public static AttFileVersion genAttFileVersion(DynamicObject attFileDy) {
        if (attFileDy == null) {
            return null;
        }
        AttFileVersion attFileVersion = new AttFileVersion();
        attFileVersion.setId(attFileDy.getLong("id"));
        attFileVersion.setAdminOrg(attFileDy.getLong("adminorg.id"));
        attFileVersion.setAffiliateAdminOrg(attFileDy.getLong("affiliateadminorg.id"));
        attFileVersion.setAgreedLocation(attFileDy.getLong("agreedlocation.id"));
        attFileVersion.setAttPerson(attFileDy.getLong("attperson.id"));
        attFileVersion.setAttTag(attFileDy.getLong("atttag.id"));
        attFileVersion.setBoId(attFileDy.getLong("boid"));
        attFileVersion.setBsed(attFileDy.getDate("bsed"));
        attFileVersion.setBsled(attFileDy.getDate("bsled"));
        attFileVersion.setAttTag(attFileDy.getLong("atttag.id"));
        attFileVersion.setCmpEmp(attFileDy.getLong("cmpemp.id"));
        attFileVersion.setDepEmp(attFileDy.getLong("depemp.id"));
        attFileVersion.setName(attFileDy.getString("name"));
        attFileVersion.setNumber(attFileDy.getString("number"));
        attFileVersion.setCompany(attFileDy.getLong("company.id"));
        attFileVersion.setDataStatus(attFileDy.getString("datastatus"));
        attFileVersion.setWorkplace(attFileDy.getLong("workplace.id"));
        attFileVersion.setJob(attFileDy.getLong("job.id"));
        attFileVersion.setPosition(attFileDy.getLong("position.id"));
        attFileVersion.setDependency(attFileDy.getLong("dependency.id"));
        attFileVersion.setDependencyType(attFileDy.getLong("dependencytype.id"));
        attFileVersion.setEmployee(attFileDy.getLong("employee.id"));
        attFileVersion.setEmpPosOrgRel(attFileDy.getLong("empposorgrel.id"));
        attFileVersion.setManagingScope(attFileDy.getLong("managingscope.id"));
        attFileVersion.setType(attFileDy.getString("type"));
        attFileVersion.setEmpGroup(attFileDy.getLong("empgroup.id"));
        attFileVersion.setStartDate(attFileDy.getDate("startdate"));
        attFileVersion.setEndDate(attFileDy.getDate("enddate"));
        attFileVersion.setOrg(attFileDy.getLong("org.id"));
        attFileVersion.setPersonId(attFileDy.getLong("person.id"));
        return attFileVersion;
    }
}

