/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCBatchHandleUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class AttFileQueryHelper {
    private static final Log LOGGER = LogFactory.getLog(AttFileQueryHelper.class);
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attfilebase");

    protected static List<DynamicObject> batchQueryAttFilesByPersonIds(Set<Long> attPersonIds, AttFileQueryParam attFileQueryParam) {
        int size = 16;
        if (!CollectionUtils.isEmpty(attPersonIds)) {
            size = attPersonIds.size();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)size);
        WTCBatchHandleUtils.batchHandleCollection((Collection)result, new ArrayList<Long>(attPersonIds), (int)5000, (Object)attFileQueryParam, AttFileQueryHelper::queryAttFilesByPersonIds);
        return result;
    }

    private static List<DynamicObject> queryAttFilesByPersonIds(List<Long> attPersonIds, AttFileQueryParam attFileQueryParam) {
        if (attPersonIds.size() == 1) {
            return AttFileQueryHelper.baseQueryParamAttFile(attFileQueryParam.getProperties(), attFileQueryParam, new QFilter("attperson.id", "=", (Object)attPersonIds.get(0)));
        }
        return AttFileQueryHelper.baseQueryParamAttFile(attFileQueryParam.getProperties(), attFileQueryParam, new QFilter("attperson.id", "in", attPersonIds));
    }

    protected static List<DynamicObject> batchQueryAttFilesByBoIds(Set<Long> boIds, AttFileQueryParam attFileQueryParam) {
        int size = 16;
        if (!CollectionUtils.isEmpty(boIds)) {
            size = boIds.size();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)size);
        WTCBatchHandleUtils.batchHandleCollection((Collection)result, new ArrayList<Long>(boIds), (int)5000, (Object)attFileQueryParam, AttFileQueryHelper::queryAttFilesByBoIds);
        return result;
    }

    private static List<DynamicObject> queryAttFilesByBoIds(List<Long> boIds, AttFileQueryParam attFileQueryParam) {
        QFilter qFilter = boIds.size() == 1 ? new QFilter("boid", "=", (Object)boIds.get(0)) : new QFilter("boid", "in", boIds);
        return AttFileQueryHelper.baseQueryParamAttFile(attFileQueryParam.getProperties(), attFileQueryParam, qFilter);
    }

    protected static List<DynamicObject> baseQueryParamAttFile(String properties, AttFileQueryParam attFileQueryParam, QFilter qFilter) {
        if (attFileQueryParam.getqFilter() == null) {
            AttFileQueryHelper.setQueryParamQFilter(attFileQueryParam);
        }
        QFilter[] qFilters = new QFilter[]{attFileQueryParam.getqFilter(), qFilter};
        return AttFileQueryHelper.baseQueryAttFile(properties, qFilters, attFileQueryParam.getOrderBy());
    }

    protected static List<DynamicObject> baseQueryAttFile(String properties, QFilter[] qFilters, String orderBy) {
        if (qFilters == null) {
            return Collections.emptyList();
        }
        if (HRStringUtils.isNotEmpty((String)properties)) {
            DynamicObject[] objects = helper.queryOriginalArray(properties, qFilters, orderBy);
            return Arrays.stream(objects).collect(Collectors.toList());
        }
        DynamicObject[] mainFile = helper.loadDynamicObjectArray(qFilters);
        return Arrays.stream(mainFile).collect(Collectors.toList());
    }

    public static QFilter getDateFileQFilter(Date date) {
        QFilter qFilter = new QFilter("id", "!=", (Object)0);
        if (date == null) {
            return qFilter;
        }
        date = WTCDateUtils.getZeroDate((Date)date);
        QFilter dateQFilter = WTCHisServiceHelper.getDateQFilter(date);
        dateQFilter.and(new QFilter("startdate", "<=", (Object)date));
        dateQFilter.and(new QFilter("enddate", ">=", (Object)date));
        return dateQFilter;
    }

    public static QFilter getQueryParamQFilterAll(AttFileQueryParam attFileQueryParam) {
        Set boIds;
        AttFileQueryHelper.setQueryParamQFilter(attFileQueryParam);
        QFilter getQFilter = attFileQueryParam.getqFilter();
        Set attPersonSetIds = attFileQueryParam.getAttPersonSetIds();
        if (!CollectionUtils.isEmpty((Collection)attPersonSetIds)) {
            getQFilter.and(new QFilter("attperson.id", "in", (Object)attPersonSetIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(boIds = attFileQueryParam.getSetBoIds()))) {
            getQFilter.and(new QFilter("boid", "in", (Object)boIds));
        }
        return getQFilter;
    }

    public static void setQueryParamQFilter(AttFileQueryParam attFileQueryParam) {
        Set depPersonSetIds;
        Set empPersonSetIds;
        Set cmpPersonSetIds;
        Set personSetIds;
        Set setFileNumber;
        Set delSetIds;
        Set boDelSetIds;
        Set attPersonDelSetIds;
        Boolean managed;
        AttStatusEnum attStatus;
        long attPersonId;
        long boId;
        long empGroupId;
        Set empGroupSetIds;
        long orgId;
        Set orgSetIds;
        long affiliateAdminOrgId;
        Set hisStatus;
        QFilter baseQFilter = AttFileQueryHelper.getDateFileQFilter(attFileQueryParam.getQueryDate());
        QFilter qFilter = attFileQueryParam.getqFilter();
        if (qFilter != null) {
            baseQFilter.and(qFilter);
        }
        if (attFileQueryParam.getBeCurrent() != null) {
            baseQFilter.and(new QFilter("iscurrentversion", "=", (Object)attFileQueryParam.getBeCurrent()));
        }
        if (Boolean.TRUE.equals(attFileQueryParam.getAuthCheck())) {
            baseQFilter.and(AttFileQueryHelper.getAttFileAuthQFilter());
        }
        if (!CollectionUtils.isEmpty((Collection)(hisStatus = attFileQueryParam.getHisStatus()))) {
            baseQFilter.and(new QFilter("datastatus", "in", (Object)hisStatus));
        } else {
            baseQFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
        }
        Set usableStatus = attFileQueryParam.getUsableStatus();
        if (!CollectionUtils.isEmpty((Collection)usableStatus)) {
            baseQFilter.and(new QFilter("usablestatus", "in", (Object)usableStatus));
        } else {
            baseQFilter.and(new QFilter("usablestatus", "=", (Object)"0"));
        }
        Set affiliateAdminOrgSetIds = attFileQueryParam.getAffiliateAdminOrgSetIds();
        if (!CollectionUtils.isEmpty((Collection)affiliateAdminOrgSetIds)) {
            baseQFilter.and(new QFilter("affiliateadminorg.id", "in", (Object)affiliateAdminOrgSetIds));
        }
        if ((affiliateAdminOrgId = attFileQueryParam.getAffiliateAdminOrgId()) != 0L) {
            baseQFilter.and(new QFilter("affiliateadminorg.id", "=", (Object)affiliateAdminOrgId));
        }
        if (!CollectionUtils.isEmpty((Collection)(orgSetIds = attFileQueryParam.getOrgSetIds()))) {
            baseQFilter.and(new QFilter("org.id", "in", (Object)orgSetIds));
        }
        if ((orgId = attFileQueryParam.getOrgId()) != 0L) {
            baseQFilter.and(new QFilter("org.id", "=", (Object)orgId));
        }
        if (!CollectionUtils.isEmpty((Collection)(empGroupSetIds = attFileQueryParam.getEmpGroupSetIds()))) {
            baseQFilter.and(new QFilter("empgroup.id", "in", (Object)empGroupSetIds));
        }
        if ((empGroupId = attFileQueryParam.getEmpGroupId()) != 0L) {
            baseQFilter.and(new QFilter("empgroup.id", "=", (Object)empGroupId));
        }
        if ((boId = attFileQueryParam.getBoId()) != 0L) {
            baseQFilter.and(new QFilter("boid", "=", (Object)boId));
        }
        if ((attPersonId = attFileQueryParam.getAttPersonId()) != 0L) {
            baseQFilter.and(new QFilter("attperson.id", "=", (Object)attPersonId));
        }
        if (null != (attStatus = attFileQueryParam.getAttStatus())) {
            baseQFilter.and(new QFilter("atttag.attendstatus", "=", (Object)attStatus.getCode()));
        }
        if (null != (managed = attFileQueryParam.getManaged())) {
            baseQFilter.and(new QFilter("ismanaged", "=", (Object)attFileQueryParam.getManaged()));
        }
        if (!CollectionUtils.isEmpty((Collection)(attPersonDelSetIds = attFileQueryParam.getAttPersonDelSetIds()))) {
            baseQFilter.and(new QFilter("attperson.id", "not in", (Object)attPersonDelSetIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(boDelSetIds = attFileQueryParam.getBoDelSetIds()))) {
            baseQFilter.and(new QFilter("boid", "not in", (Object)boDelSetIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(delSetIds = attFileQueryParam.getDelSetIds()))) {
            baseQFilter.and(new QFilter("id", "not in", (Object)delSetIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(setFileNumber = attFileQueryParam.getSetFileNumber()))) {
            baseQFilter.and(new QFilter("number", "in", (Object)setFileNumber));
        }
        if (!CollectionUtils.isEmpty((Collection)(personSetIds = attFileQueryParam.getPersonSetIds()))) {
            baseQFilter.and(new QFilter("person.id", "in", (Object)personSetIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(cmpPersonSetIds = attFileQueryParam.getCmpPersonSetIds()))) {
            baseQFilter.and(new QFilter("cmpemp.id", "in", (Object)cmpPersonSetIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(empPersonSetIds = attFileQueryParam.getEmpPersonSetIds()))) {
            baseQFilter.and(new QFilter("employee.id", "in", (Object)empPersonSetIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(depPersonSetIds = attFileQueryParam.getDepPersonSetIds()))) {
            baseQFilter.and(new QFilter("depemp.id", "in", (Object)depPersonSetIds));
        }
        if (HRStringUtils.isNotEmpty((String)attFileQueryParam.getFuzzyQueryValue()) && attFileQueryParam.getFuzzyQueryProperties() != null) {
            QFilter ftLikeQFilter = QFilter.ftlike((String)attFileQueryParam.getFuzzyQueryValue(), (String[])attFileQueryParam.getFuzzyQueryProperties());
            baseQFilter.and(ftLikeQFilter);
        }
        Date startDate = attFileQueryParam.getStartDate();
        Date endDate = attFileQueryParam.getEndDate();
        baseQFilter.and(WTCHisServiceHelper.getAttFileDateQFilter(startDate, endDate));
        attFileQueryParam.setqFilter(baseQFilter);
    }

    public static QFilter getAttFileAuthQFilter() {
        QFilter qFilter = new QFilter("id", "!=", (Object)0);
        if (WtbsBusinessUtils.isSuperUser()) {
            LOGGER.info("getAttFileAuthQFilter isSuperUser");
            return qFilter;
        }
        QFilter authQFilter = HRAuthService.getInstance().getDataRule(RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)"wtam").getId(), "wtp_attfilebase", "47150e89000000ac", new HashMap<String, Object>(1));
        LOGGER.info("attFile getDataRule QFilter{}", (Object)(authQFilter == null ? "null" : authQFilter.toString()));
        qFilter.and(authQFilter);
        return qFilter;
    }

    public static String getQueryField(AttFileScheduleEnum attFileScheduleEnum) {
        String attFileScheduleKey = attFileScheduleEnum.getKey();
        String bussinessField = "card".equals(attFileScheduleEnum.getKey()) || "mode".equals(attFileScheduleEnum.getKey()) ? attFileScheduleKey : WTCStringUtils.joinStr((String[])new String[]{attFileScheduleKey, ".", "id"});
        boolean timeHis = attFileScheduleEnum.isTimeHis();
        bussinessField = timeHis ? WTCStringUtils.joinStr((String[])new String[]{bussinessField, ",", "id, attfileid,attfileid.id,attfilevid, bsed, bsled"}) : WTCStringUtils.joinStr((String[])new String[]{bussinessField, ",", "id, attfileid,attfileid.id,attfilevid, startdate, enddate,busistatus"});
        return bussinessField;
    }

    public static QFilter getDateQFilter(Date startDate, Date endDate, boolean isTimeHis) {
        if (isTimeHis) {
            return WTCHisServiceHelper.getDateQFilter(startDate, endDate);
        }
        return WTCHisServiceHelper.getDateQFilter(startDate, endDate, "startdate", "enddate");
    }

    public static List<DynamicObject> queryAttFileByIds(String properties, List<Object> fileIds) {
        int size = 16;
        if (!CollectionUtils.isEmpty(fileIds)) {
            size = fileIds.size();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)size);
        WTCBatchHandleUtils.batchHandleCollection((Collection)result, fileIds, (int)5000, (Object)properties, AttFileQueryHelper::queryAttFilesByIds);
        return result;
    }

    public static List<DynamicObject> queryAttFileByIds(String properties, List<Object> fileIds, String orderBy) {
        int size = 16;
        if (!CollectionUtils.isEmpty(fileIds)) {
            size = fileIds.size();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)size);
        int index = fileIds.size() % 5000 > 0 ? fileIds.size() / 5000 + 1 : fileIds.size() / 5000;
        for (int i = 1; i <= index; ++i) {
            int minIndex = 5000 * (i - 1);
            int maxIndex = Math.min(5000 * i, fileIds.size());
            List<Object> list = fileIds.subList(minIndex, maxIndex);
            result.addAll(AttFileQueryHelper.queryAttFilesByIdsAndOrder(list, properties, orderBy));
        }
        return result;
    }

    private static List<DynamicObject> queryAttFilesByIds(List<Object> ids, String properties) {
        if (HRStringUtils.isEmpty((String)properties)) {
            return Arrays.stream(helper.loadDynamicObjectArray(ids.toArray())).collect(Collectors.toList());
        }
        return Arrays.stream(helper.queryOriginalArray(properties, new QFilter[]{new QFilter("id", "in", ids)})).collect(Collectors.toList());
    }

    private static List<DynamicObject> queryAttFilesByIdsAndOrder(List<Object> ids, String properties, String orderBy) {
        if (HRStringUtils.isEmpty((String)properties)) {
            return Arrays.stream(helper.loadDynamicObjectArray(ids.toArray())).collect(Collectors.toList());
        }
        return Arrays.stream(helper.queryOriginalArray(properties, new QFilter[]{new QFilter("id", "in", ids)}, orderBy)).collect(Collectors.toList());
    }

    public static QFilter getFileF7QFilter(AttFileQueryParam queryParam, int pageSize, int pageNumber) {
        QFilter queryParamQFilterAll = AttFileQueryHelper.getFileF7QFilter(queryParam);
        DataSet rows = AttFileQueryHelper.queryAttFileDataSet(Collections.singletonList(queryParamQFilterAll));
        DataSet limit = rows.limit(pageNumber, pageSize);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)pageSize);
        for (Row row : limit) {
            ids.add(row.getLong("id"));
        }
        return new QFilter("id", "in", (Object)ids);
    }

    public static QFilter getFileF7QFilter(AttFileQueryParam queryParam) {
        if (queryParam == null) {
            queryParam = new AttFileQueryParam(true);
            queryParam.setAttStatus(null);
        }
        return AttFileQueryHelper.getQueryParamQFilterAll(queryParam);
    }

    public static QFilter[] getScheduleCommonQFilter(boolean isTimeHis, List<Long> attFileIds) {
        QFilter attFileIdFilter = new QFilter("attfileid.id", "in", attFileIds);
        QFilter dataStatusFilter = WTCHisServiceHelper.dataStatusValidQFilter();
        QFilter timeHisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter notTimeHisFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter validFilter = new QFilter("busistatus", "=", (Object)"1");
        if (isTimeHis) {
            return new QFilter[]{attFileIdFilter, dataStatusFilter, timeHisFilter};
        }
        return new QFilter[]{attFileIdFilter, dataStatusFilter, notTimeHisFilter, validFilter};
    }

    public static QFilter getAttFileScheduleQueryQFilter(AttFileScheduleEnum scheduleEnum, AttFileScheduleQueryParam queryParam) {
        Set fileHisStatus;
        Set fileBoIdSet;
        long boId;
        QFilter qFilter = queryParam.getqFilter();
        if (qFilter == null) {
            qFilter = new QFilter("id", "!=", (Object)0L);
        }
        if ((boId = queryParam.getBoId()) != 0L) {
            qFilter.and(new QFilter("attfileid.id", "=", (Object)boId));
        }
        if (!CollectionUtils.isEmpty((Collection)(fileBoIdSet = queryParam.getFileBoIdSet()))) {
            qFilter.and(new QFilter("attfileid.id", "in", (Object)fileBoIdSet));
        }
        if (!CollectionUtils.isEmpty((Collection)(fileHisStatus = queryParam.getFileHisStatus()))) {
            qFilter.and(new QFilter("attfilevid.datastatus", "in", (Object)fileHisStatus));
        }
        Date startDate = queryParam.getStartDate();
        Date endDate = queryParam.getEndDate();
        QFilter dateQFilter = AttFileQueryHelper.getDateQFilter(startDate, endDate, scheduleEnum.isTimeHis());
        qFilter.and(dateQFilter);
        if (scheduleEnum.isTimeHis()) {
            Set histSet;
            if (!queryParam.isIgnoreIsCurrentVersion()) {
                qFilter.and(WTCHisServiceHelper.isCurrentVersion(false));
            }
            if (!CollectionUtils.isEmpty((Collection)(histSet = queryParam.getHisStatus()))) {
                qFilter.and(new QFilter("datastatus", "in", (Object)histSet));
            } else {
                qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
            }
        } else {
            Set histSet;
            if (!queryParam.isIgnoreIsCurrentVersion()) {
                qFilter.and(WTCHisServiceHelper.isCurrentVersion(true));
            }
            if (!CollectionUtils.isEmpty((Collection)(histSet = queryParam.getHisStatus()))) {
                qFilter.and(new QFilter("datastatus", "in", (Object)histSet));
            } else {
                qFilter.and(WTCHisServiceHelper.dataStatusValidQFilter());
            }
            Set busySet = queryParam.getBusyStatus();
            if (!CollectionUtils.isEmpty((Collection)busySet)) {
                qFilter.and(new QFilter("busistatus", "in", (Object)busySet));
            } else {
                QFilter validFilter = new QFilter("busistatus", "=", (Object)"1");
                qFilter.and(validFilter);
            }
        }
        return qFilter;
    }

    public static DataSet queryAttFileDataSet(List<QFilter> qFilters) {
        QFilter[] qFilterArray = qFilters.toArray(new QFilter[0]);
        return QueryServiceHelper.queryDataSet((String)AttFileQueryHelper.class.getName(), (String)"wtp_attfilebase", (String)"boid, bsed, id", (QFilter[])qFilterArray, null).groupBy(new String[]{"boid"}, new boolean[]{true}).maxP("bsed", "id").finish();
    }

    public static DataSet queryAttFileDataSet(List<QFilter> qFilters, int top) {
        QFilter[] qFilterArray = qFilters.toArray(new QFilter[0]);
        return QueryServiceHelper.queryDataSet((String)AttFileQueryHelper.class.getName(), (String)"wtp_attfilebase", (String)"boid, bsed, id", (QFilter[])qFilterArray, null, (int)top).groupBy(new String[]{"boid"}, new boolean[]{true}).maxP("bsed", "id").finish();
    }
}

