/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.groupby.OrderBasedGroupByDataSet;
import kd.bos.algo.dataset.order.OrderDataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.business.web.file.IAttFileQueryService;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttFileQueryServiceImpl
implements IAttFileQueryService {
    private static final Log LOG = LogFactory.getLog(AttFileQueryServiceImpl.class);
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attfilebase");
    private static final HRBaseServiceHelper helperF7 = new HRBaseServiceHelper("wtp_attfilebasef7");

    private AttFileQueryServiceImpl() {
    }

    public static AttFileQueryServiceImpl getInstance() {
        return AttFileQueryInstance.singleton;
    }

    @Override
    public List<DynamicObject> queryAttFiles(AttFileQueryParam attFileQueryParam) {
        return AttFileQueryServiceImpl.getFileDyList(attFileQueryParam);
    }

    @Override
    public List<DynamicObject> queryAttFiles(List<AttFileQueryParam> attFileQueryParamList) {
        if (CollectionUtils.isEmpty(attFileQueryParamList)) {
            return Collections.emptyList();
        }
        QFilter qFilter = null;
        String properties = "";
        String orderBy = null;
        for (int i = 0; i < attFileQueryParamList.size(); ++i) {
            AttFileQueryParam attFileQueryParam = attFileQueryParamList.get(i);
            QFilter getQFilter = AttFileQueryHelper.getQueryParamQFilterAll(attFileQueryParam);
            if (i == 0) {
                qFilter = getQFilter;
                if (HRStringUtils.isNotEmpty((String)attFileQueryParam.getProperties())) {
                    properties = attFileQueryParam.getProperties();
                }
                if (!HRStringUtils.isNotEmpty((String)attFileQueryParam.getOrderBy())) continue;
                orderBy = attFileQueryParam.getOrderBy();
                continue;
            }
            if (qFilter == null) continue;
            qFilter.or(getQFilter);
        }
        if (qFilter == null) {
            return Collections.emptyList();
        }
        return AttFileQueryHelper.baseQueryAttFile(properties, new QFilter[]{qFilter}, orderBy);
    }

    private QFilter addPersonAndBoIdQFilter(AttFileQueryParam attFileQueryParam) {
        Set boIds;
        QFilter getQFilter = attFileQueryParam.getqFilter();
        Set attPersonSetIds = attFileQueryParam.getAttPersonSetIds();
        if (!CollectionUtils.isEmpty((Collection)attPersonSetIds)) {
            getQFilter.and(new QFilter("attperson.id", "in", (Object)attPersonSetIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(boIds = attFileQueryParam.getSetBoIds()))) {
            getQFilter.and(new QFilter("boid", "in", (Object)boIds));
        }
        return getQFilter;
    }

    private static List<DynamicObject> getFileDyList(AttFileQueryParam attFileQueryParam) {
        AttFileQueryHelper.setQueryParamQFilter(attFileQueryParam);
        Set attPersonSetIds = attFileQueryParam.getAttPersonSetIds();
        if (!CollectionUtils.isEmpty((Collection)attPersonSetIds)) {
            return AttFileQueryHelper.batchQueryAttFilesByPersonIds(attPersonSetIds, attFileQueryParam);
        }
        Set setBoIds = attFileQueryParam.getSetBoIds();
        if (!CollectionUtils.isEmpty((Collection)setBoIds)) {
            return AttFileQueryHelper.batchQueryAttFilesByBoIds(setBoIds, attFileQueryParam);
        }
        return AttFileQueryHelper.baseQueryParamAttFile(attFileQueryParam.getProperties(), attFileQueryParam, null);
    }

    @Override
    public DynamicObject queryOneAttFiles(AttFileQueryParam attFileQueryParam) {
        AttFileQueryHelper.setQueryParamQFilter(attFileQueryParam);
        String orderBy = "bsed asc";
        if (HRStringUtils.isNotEmpty((String)attFileQueryParam.getOrderBy())) {
            orderBy = attFileQueryParam.getOrderBy();
        }
        if (HRStringUtils.isNotEmpty((String)attFileQueryParam.getProperties())) {
            return helper.queryOriginalOne(attFileQueryParam.getProperties(), new QFilter[]{attFileQueryParam.getqFilter()}, orderBy);
        }
        return helper.loadDynamicObject(new QFilter[]{attFileQueryParam.getqFilter()});
    }

    @Override
    public DynamicObject queryOneAttFile(String properties, Object pk) {
        if (HRStringUtils.isNotEmpty((String)properties)) {
            return helper.queryOriginalOne(properties, pk);
        }
        return helper.loadSingle(pk);
    }

    @Override
    public List<DynamicObject> queryAttFileByIds(String properties, List<Object> fileIds) {
        if (fileIds == null || fileIds.isEmpty()) {
            return Collections.emptyList();
        }
        if (fileIds.size() == 1) {
            DynamicObject dynamicObject = AttFileQueryServiceImpl.getInstance().queryOneAttFile(properties, fileIds.get(0));
            if (dynamicObject == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(dynamicObject);
        }
        return AttFileQueryHelper.queryAttFileByIds(properties, fileIds);
    }

    @Override
    @Deprecated
    public Page<DynamicObject> queryAttFileF7(AttFileQueryParam attFileQueryParam, int pageStart, int pageSize) {
        this.addFileF7OrgFilter(FileTypeEnum.ATTFILE, attFileQueryParam);
        return this.getFileF7DyPage(attFileQueryParam, pageStart, pageSize);
    }

    @Override
    public Page<DynamicObject> queryAttFileF7WithPerm(AttFileF7QueryParam attFileF7QueryParam, int pageStart, int pageSize) {
        this.addFileF7PermOrg(attFileF7QueryParam);
        this.addCustomOrgFilter(attFileF7QueryParam);
        FileTypeEnum fileType = attFileF7QueryParam.getFileType();
        if (fileType != null) {
            QFilter fileTypeQFilter = new QFilter("filetype", "=", (Object)fileType);
            this.addQFilter((AttFileQueryParam)attFileF7QueryParam, fileTypeQFilter);
        }
        return this.getFileF7DyPage((AttFileQueryParam)attFileF7QueryParam, pageStart, pageSize);
    }

    private void addCustomOrgFilter(AttFileF7QueryParam attFileF7QueryParam) {
        if (!attFileF7QueryParam.isOrgAuthCheck()) {
            return;
        }
        String formId = attFileF7QueryParam.getFormId();
        String appId = attFileF7QueryParam.getAppId();
        if (HRStringUtils.isEmpty((String)formId) || HRStringUtils.isEmpty((String)appId)) {
            return;
        }
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)formId, (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().isEmpty()) {
            QFilter orgQFilter = new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            this.addQFilter((AttFileQueryParam)attFileF7QueryParam, orgQFilter);
        }
    }

    private void addFileF7OrgFilter(FileTypeEnum fileTypeEnum, AttFileQueryParam attFileQueryParam) {
        String pageId = FileTypeEnum.VCFILE == fileTypeEnum ? FileTypeEnum.VCFILE.getPageId() : FileTypeEnum.ATTFILE.getPageId();
        String fileAppId = "wtp_vafilebase".equals(pageId) ? "wtabm" : "wtam";
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)fileAppId, (String)pageId, (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().isEmpty()) {
            QFilter orgQFilter = new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            this.addQFilter(attFileQueryParam, orgQFilter);
        }
    }

    private void addFileF7PermOrg(AttFileF7QueryParam attFileF7QueryParam) {
        String formId = attFileF7QueryParam.getFormId();
        String permField = attFileF7QueryParam.getPermField();
        String appId = attFileF7QueryParam.getAppId();
        if (HRStringUtils.isNotEmpty((String)formId) && HRStringUtils.isNotEmpty((String)permField) && HRStringUtils.isNotEmpty((String)appId)) {
            long userId = attFileF7QueryParam.getUserId() == 0L ? UserServiceHelper.getCurrentUserId() : attFileF7QueryParam.getUserId();
            QFilter permQFilter = HRAuthService.getInstance().getDataRuleForBdProp(userId, appId, formId, permField, "47150e89000000ac", new HashMap<String, Object>());
            this.addQFilter((AttFileQueryParam)attFileF7QueryParam, permQFilter);
        }
    }

    private Page<DynamicObject> getFileF7DyPage(AttFileQueryParam attFileQueryParam, int pageStart, int pageSize) {
        int size;
        this.setF7BaseFilter(attFileQueryParam);
        QFilter queryParamQFilterAll = AttFileQueryHelper.getFileF7QFilter(attFileQueryParam);
        DataSet rows = AttFileQueryHelper.queryAttFileDataSet(Collections.singletonList(queryParamQFilterAll));
        if (HRStringUtils.isNotEmpty((String)attFileQueryParam.getOrderBy())) {
            rows = rows.orderBy(new String[]{"boid"});
            size = ((OrderDataSet)rows).getCopyStore().size();
        } else {
            size = ((OrderBasedGroupByDataSet)rows).getCopyStore().size();
        }
        int countStart = pageStart * pageSize;
        DataSet limit = rows.limit(countStart, pageSize);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)Math.min(size, pageSize));
        for (Row row : limit) {
            ids.add(row.get("id"));
        }
        List<DynamicObject> dynamicObjects = HRStringUtils.isNotEmpty((String)attFileQueryParam.getOrderBy()) ? AttFileQueryHelper.queryAttFileByIds(attFileQueryParam.getProperties(), ids, attFileQueryParam.getOrderBy()) : this.queryAttFileByIds(attFileQueryParam.getProperties(), ids);
        Page page = new Page(pageSize, pageStart, dynamicObjects);
        if (size > 0 && pageSize > 0) {
            int totalPage = (size + pageSize - 1) / pageSize;
            page.setTotalRecord(size);
            page.setTotalPage(totalPage);
        }
        return page;
    }

    private void setF7BaseFilter(AttFileQueryParam attFileQueryParam) {
        attFileQueryParam.setBeCurrent(Boolean.FALSE);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        this.addQFilter(attFileQueryParam, dataStatusQFilter);
    }

    private void addQFilter(AttFileQueryParam attFileQueryParam, QFilter addQFilter) {
        QFilter qFilter = attFileQueryParam.getqFilter();
        if (qFilter == null) {
            attFileQueryParam.setqFilter(addQFilter);
        } else {
            qFilter.and(addQFilter);
        }
    }

    public Page<DynamicObject> queryAttFile(AttFileQueryParam attFileQueryParam, int pageStart, int pageSize) {
        QFilter[] qFilters;
        DynamicObject[] load;
        if (attFileQueryParam == null) {
            return new Page();
        }
        String properties = AttFileQueryParam.baseProperties;
        if (HRStringUtils.isNotEmpty((String)attFileQueryParam.getProperties())) {
            properties = attFileQueryParam.getProperties();
        }
        String orderBy = "bsed";
        if (HRStringUtils.isNotEmpty((String)attFileQueryParam.getOrderBy())) {
            orderBy = attFileQueryParam.getOrderBy();
        }
        if ((load = BusinessDataServiceHelper.load((String)"wtp_attfilebase", (String)properties, (QFilter[])(qFilters = new QFilter[]{AttFileQueryHelper.getQueryParamQFilterAll(attFileQueryParam)}), (String)orderBy, (int)pageStart, (int)pageSize)) == null || load.length == 0) {
            return new Page();
        }
        int count = helper.count("wtp_attfilebase", qFilters);
        Page page = new Page(pageSize, pageStart, Arrays.asList(load));
        if (count > 0 && pageSize > 0) {
            int totalPage = (count + pageSize - 1) / pageSize;
            page.setTotalRecord(count);
            page.setTotalPage(totalPage);
        }
        return page;
    }

    @Override
    public List<DynamicObject> filterAttFileByDateRange(List<DynamicObject> attFileList, Date startDate, Date endDate) {
        if (attFileList != null && !attFileList.isEmpty()) {
            if (startDate == null && endDate != null) {
                attFileList = attFileList.stream().filter(item -> item.getDate("startdate").compareTo(endDate) <= 0 && item.getDate("bsed").compareTo(endDate) <= 0).collect(Collectors.toList());
            } else if (startDate != null && endDate == null) {
                attFileList = attFileList.stream().filter(item -> item.getDate("enddate").compareTo(startDate) >= 0 && item.getDate("bsled").compareTo(startDate) >= 0).collect(Collectors.toList());
            } else if (startDate != null) {
                attFileList = attFileList.stream().filter(item -> item.getDate("startdate").compareTo(endDate) <= 0 && item.getDate("bsed").compareTo(endDate) <= 0 && item.getDate("enddate").compareTo(startDate) >= 0 && item.getDate("bsled").compareTo(startDate) >= 0).collect(Collectors.toList());
            }
        }
        return attFileList;
    }

    @Override
    public List<DynamicObject> filterAttFileByHisDateRange(List<DynamicObject> attFileList, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(attFileList)) {
            return Collections.emptyList();
        }
        if (startDate == null || endDate == null) {
            throw new KDBizException("params startDate and endDate can not be null");
        }
        return attFileList.stream().filter(file -> file != null && file.getDate("bsed").compareTo(endDate) <= 0 && file.getDate("bsled").compareTo(startDate) >= 0).collect(Collectors.toList());
    }

    @Override
    public Page<DynamicObject> queryFileF7ByFileVid(Set<Long> fileVidSet, AttFileF7QueryParam f7QueryParam, int pageStart, int pageSize) {
        if (fileVidSet == null || fileVidSet.isEmpty()) {
            return null;
        }
        List<DynamicObject> fileBoidDys = this.queryAttFileByIds("boid", new ArrayList<Object>(fileVidSet));
        Set fileBoidSet = fileBoidDys.stream().map(fileBoidDy -> fileBoidDy.getLong("boid")).collect(Collectors.toSet());
        f7QueryParam.setSetBoIds(fileBoidSet);
        return this.queryAttFileF7WithPerm(f7QueryParam, pageStart, pageSize);
    }

    @Override
    public List<DynamicObject> queryAttFilesByCustomAuth(AttFileF7QueryParam attFileF7QueryParam) {
        attFileF7QueryParam.setAuthCheck(Boolean.valueOf(false));
        this.addFileF7PermOrg(attFileF7QueryParam);
        this.addCustomOrgFilter(attFileF7QueryParam);
        return this.queryAttFiles((AttFileQueryParam)attFileF7QueryParam);
    }

    @Override
    public void setFileF7OrgPerm(FormShowParameter formShowParameter, String formId, String appId) {
        formShowParameter.setCustomParam("fileF7FormId", (Object)formId);
        formShowParameter.setCustomParam("fileF7AppId", (Object)appId);
    }

    public Map<Long, String> queryPersonImgMap(List<Long> personIds) {
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        List<DynamicObject> hrPersonDys = HRPIMServiceImpl.getInstance().listFieldsFilterInfoBatch("id", personIds, "headsculpture", null, "hrpi_person");
        for (DynamicObject hrPersonDy : hrPersonDys) {
            retMap.put(hrPersonDy.getLong("id"), hrPersonDy.getString("headsculpture"));
        }
        return retMap;
    }

    private static class AttFileQueryInstance {
        private static final AttFileQueryServiceImpl singleton = new AttFileQueryServiceImpl();

        private AttFileQueryInstance() {
        }
    }
}

