/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.file.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.web.WTCAttFileService;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.business.web.file.schedule.IAttFileScheduleSrevice;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttFileScheduleServiceImpl
implements IAttFileScheduleSrevice {
    public static AttFileScheduleServiceImpl getInstance() {
        return SingletonInstance.singleton;
    }

    @Override
    public Map<String, Map<Long, List<DynamicObject>>> queryAttFileSchedule(List<String> planList, List<Long> attFileIds) {
        LinkedHashMap scheduleMap = Maps.newLinkedHashMapWithExpectedSize((int)planList.size());
        for (String planKey : planList) {
            Map<Long, List<DynamicObject>> attFileScheduleMap = WTCAttFileService.queryAttFileScheduleByFileId(attFileIds, planKey);
            scheduleMap.put(planKey, attFileScheduleMap);
        }
        return scheduleMap;
    }

    @Override
    @Deprecated
    public Map<Long, List<DynamicObject>> queryFileScheduleByFileBoidAndDate(List<Long> attFileBoIds, AttFileScheduleEnum scheduleEnum, Date startDate, Date endDate) {
        Set fileBoIdSet = attFileBoIds.stream().collect(Collectors.toSet());
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setFileBoIdSet(fileBoIdSet);
        queryParam.setqFilter(WTCHisServiceHelper.dataStatusValidQFilter());
        queryParam.setLoad(Boolean.TRUE);
        queryParam.setEndDate(endDate);
        queryParam.setStartDate(startDate);
        return this.queryAttFileSchedule(scheduleEnum, queryParam);
    }

    @Override
    public Map<Long, List<DynamicObject>> queryAttFileSchedule(Collection<Long> fileBoIds, AttFileScheduleEnum scheduleSign, boolean isLoad) {
        ArrayList<Long> longs = new ArrayList<Long>(fileBoIds);
        QFilter[] qFilters = scheduleSign.isTimeHis() ? AttFileQueryHelper.getScheduleCommonQFilter(true, longs) : AttFileQueryHelper.getScheduleCommonQFilter(false, longs);
        HRBaseServiceHelper scheduleHelper = new HRBaseServiceHelper(scheduleSign.getPageId());
        if (isLoad) {
            return Arrays.stream(scheduleHelper.loadDynamicObjectArray(qFilters)).collect(Collectors.groupingBy(dy -> dy.getLong("attfileid.id")));
        }
        String queryField = AttFileQueryHelper.getQueryField(scheduleSign);
        return Arrays.stream(scheduleHelper.queryOriginalArray(queryField, qFilters)).collect(Collectors.groupingBy(dy -> dy.getLong("attfileid")));
    }

    @Override
    public Map<Long, List<DynamicObject>> queryAttFileSchedule(AttFileScheduleEnum scheduleEnum, AttFileScheduleQueryParam queryParam) {
        return this.queryAttFileScheduleByList(scheduleEnum, queryParam).stream().collect(Collectors.groupingBy(dy -> dy.getLong("attfileid.id")));
    }

    @Override
    public List<DynamicObject> queryAttFileScheduleByList(AttFileScheduleEnum scheduleEnum, AttFileScheduleQueryParam queryParam) {
        if (scheduleEnum == null || queryParam == null) {
            return Collections.emptyList();
        }
        QFilter attFileScheduleQueryQFilter = AttFileQueryHelper.getAttFileScheduleQueryQFilter(scheduleEnum, queryParam);
        HRBaseServiceHelper scheduleHelper = new HRBaseServiceHelper(scheduleEnum.getPageId());
        if (queryParam.getLoad() != null && queryParam.getLoad().booleanValue()) {
            return Arrays.asList(scheduleHelper.loadDynamicObjectArray(new QFilter[]{attFileScheduleQueryQFilter}));
        }
        String queryField = null;
        queryField = HRStringUtils.isNotEmpty((String)queryParam.getProperties()) ? ((queryField = queryParam.getProperties()).contains("attfileid.id") ? queryField : queryField + ",attfileid.id") : AttFileQueryHelper.getQueryField(scheduleEnum);
        return Arrays.asList(scheduleHelper.queryOriginalArray(queryField, new QFilter[]{attFileScheduleQueryQFilter}));
    }

    @Override
    public Map<Long, List<DynamicObject>> queryAttFileScheduleGroupByFileVersion(AttFileScheduleEnum scheduleEnum, List<DynamicObject> fileVersionDyList, List<DynamicObject> schList) {
        if (CollectionUtils.isEmpty(fileVersionDyList) || CollectionUtils.isEmpty(schList) || scheduleEnum == null) {
            return Collections.emptyMap();
        }
        Map<Long, List<DynamicObject>> scheduleListMap = schList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("attfileid.id")));
        boolean timeHis = scheduleEnum.isTimeHis();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileVersionDyList.size());
        Map<Long, List<DynamicObject>> fileMap = fileVersionDyList.stream().collect(Collectors.groupingBy(d -> d.getLong("boid")));
        for (Map.Entry<Long, List<DynamicObject>> entries : fileMap.entrySet()) {
            Long fileBoId = entries.getKey();
            List<DynamicObject> schDyList = scheduleListMap.get(fileBoId);
            if (CollectionUtils.isEmpty(schDyList)) continue;
            for (DynamicObject fileVersion : entries.getValue()) {
                Date dateStart = fileVersion.getDate("bsed");
                Date dateEnd = fileVersion.getDate("bsled");
                Date end = fileVersion.getDate("enddate");
                long fileVersionId = fileVersion.getLong("id");
                if (dateEnd.compareTo(end) > 0) {
                    dateEnd = end;
                }
                for (DynamicObject schDy : schDyList) {
                    Date schStartDate = this.getSchDate(schDy, timeHis, true);
                    Date schEndDate = this.getSchDate(schDy, timeHis, false);
                    if (schStartDate.compareTo(dateEnd) > 0 || schEndDate.compareTo(dateStart) < 0) continue;
                    List schResultList = (List)resultMap.get(fileVersionId);
                    if (schResultList == null) {
                        schResultList = Lists.newArrayListWithExpectedSize((int)schDyList.size());
                        schResultList.add(schDy);
                        resultMap.put(fileVersionId, schResultList);
                        continue;
                    }
                    schResultList.add(schDy);
                }
            }
        }
        return resultMap;
    }

    private Date getSchDate(DynamicObject schDy, boolean timeHis, boolean startDate) {
        if (schDy == null) {
            throw new IllegalArgumentException("param can not be null");
        }
        return schDy.getDate(this.getDateStr(timeHis, startDate));
    }

    private String getDateStr(boolean timeHis, boolean startDate) {
        if (timeHis) {
            if (startDate) {
                return "bsed";
            }
            return "bsled";
        }
        if (startDate) {
            return "startdate";
        }
        return "enddate";
    }

    private static class SingletonInstance {
        private static final AttFileScheduleServiceImpl singleton = new AttFileScheduleServiceImpl();

        private SingletonInstance() {
        }
    }
}

