/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.mservice.IHAOSMService;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCBatchHandleUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class HAOSMServiceImpl
implements IHAOSMService {
    private static final Log LOGGER = LogFactory.getLog(HAOSMServiceImpl.class);

    public static HAOSMServiceImpl getInstance() {
        return (HAOSMServiceImpl)WTCAppContextHelper.getBean(HAOSMServiceImpl.class);
    }

    @Override
    public Map<Long, List<Map<String, Object>>> batchGetOrgInfo(Date startDate, Date endDate, List<Long> boIdList) {
        LOGGER.info("HAOSMServiceImpl.batchGetOrgInfo param startDate{},endDate{},boIdList {}", new Object[]{startDate, endDate, boIdList == null ? "null" : JSON.toJSONString(boIdList)});
        if (CollectionUtils.isEmpty(boIdList) || startDate == null || endDate == null) {
            return Collections.emptyMap();
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
        ParamGetOrgInfo paramGetOrgInfo = new ParamGetOrgInfo(startDate, endDate);
        WTCBatchHandleUtils.batchHandleMap((Map)returnMap, boIdList, (int)1800, (Object)paramGetOrgInfo, this::batchGetOrgInfoInBatches);
        return returnMap;
    }

    @Override
    public List<Map<String, Object>> batchGetAllSubOrg(List<Long> orgIdList, Date date) {
        return (List)WTCServiceHelper.invokeHRMPService("haos", "IHAOSBatchAdminOrgInfoQueryService", "batchGetAllSubOrg", orgIdList, date);
    }

    private Map<Long, List<Map<String, Object>>> batchGetOrgInfoInBatches(List<Long> boIdList, ParamGetOrgInfo paramGetOrgInfo) {
        return (Map)WTCServiceHelper.invokeHRMPService("haos", "IHAOSBatchAdminOrgInfoQueryService", "batchGetOrgInfo", paramGetOrgInfo.startDate, paramGetOrgInfo.endDate, boIdList);
    }

    @Override
    public List<Map<String, Object>> batchQuerySubOrgWithLevel(List<Long> orgIdList, Date date, int level) {
        if (CollectionUtils.isEmpty(orgIdList) || date == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>(16);
        Tuple param = new Tuple((Object)date, (Object)level);
        WTCBatchHandleUtils.batchHandleCollection(returnList, orgIdList, (int)1800, (Object)param, this::batchQuerySubOrg);
        return returnList;
    }

    @Override
    public Map<String, Map<String, Object>> adminOrgStructQuery(List<Long> orgIdList, Date date, boolean needLongInfo) {
        LOGGER.info("adminOrgStructQuery.query.param", new Object[]{orgIdList.size(), date, needLongInfo});
        return (Map)WTCServiceHelper.invokeHRMPService("haos", "IHAOSBatchAdminOrgStructQueryService", "adminOrgStructQuery", orgIdList, date, needLongInfo);
    }

    private List<Map<String, Object>> batchQuerySubOrg(List<Long> orgIdList, Tuple<Date, Integer> param) {
        return (List)WTCServiceHelper.invokeHRMPService("haos", "IHAOSBatchAdminOrgInfoQueryService", "batchQuerySubOrg", orgIdList, param.getKey(), param.getValue());
    }

    protected static class ParamGetOrgInfo {
        Date startDate;
        Date endDate;

        public ParamGetOrgInfo(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }
}

