/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.mservice.HAOSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.IHBJMMService;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCBatchHandleUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class HBJMMServiceImpl
implements IHBJMMService {
    private static final Log LOGGER = LogFactory.getLog(HBJMMServiceImpl.class);

    public static HBJMMServiceImpl getInstance() {
        return (HBJMMServiceImpl)WTCAppContextHelper.getBean(HBJMMServiceImpl.class);
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getJobVersionChangeInfoByEventId(Date startDate, Date endDate, List<Long> boIdList) {
        LOGGER.info("HBJMMServiceImpl.getJobVersionChangeInfoByEventId param startDate{},endDate{},boIdList{}", new Object[]{startDate, endDate, boIdList == null ? "NULL" : JSON.toJSONString(boIdList)});
        if (CollectionUtils.isEmpty(boIdList)) {
            return Collections.emptyMap();
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
        HAOSMServiceImpl.ParamGetOrgInfo paramGetOrgInfo = new HAOSMServiceImpl.ParamGetOrgInfo(startDate, endDate);
        WTCBatchHandleUtils.batchHandleMap((Map)returnMap, boIdList, (int)1800, (Object)paramGetOrgInfo, this::getJobVersionChangeInfoByEventIdInBatches);
        return returnMap;
    }

    private Map<Long, List<Map<String, Object>>> getJobVersionChangeInfoByEventIdInBatches(List<Long> boIdList, HAOSMServiceImpl.ParamGetOrgInfo paramGetOrgInfo) {
        HashMap returnResult = Maps.newHashMapWithExpectedSize((int)boIdList.size());
        Map result = (Map)WTCServiceHelper.invokeHRMPService("hbjm", "IHBJMVersionInfoService", "getJobVersionChangeInfoByEventId", paramGetOrgInfo.startDate, paramGetOrgInfo.endDate, boIdList);
        if (result != null && result.get("code") != null && (Integer)result.get("code") == 200) {
            DynamicObjectCollection data = (DynamicObjectCollection)result.get("data");
            if (data != null && !data.isEmpty()) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)data.size());
                for (DynamicObject datum : data) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                    map.put("boid", datum.getLong("boid"));
                    map.put("id", datum.getLong("id"));
                    map.put("number", datum.getString("number"));
                    map.put("name", "name");
                    map.put("bsed", datum.getDate("bsed"));
                    map.put("bsled", datum.getDate("bsled"));
                    list.add(map);
                }
                Map<Long, List<Map>> collect = list.stream().collect(Collectors.groupingBy(d -> (Long)d.get("boid")));
                returnResult.putAll(collect);
            }
        } else {
            LOGGER.info("getJobVersionChangeInfoByEventIdInBatches code\uff01=200 ,startDate{},endDate{},boIdList{}", new Object[]{paramGetOrgInfo.startDate, paramGetOrgInfo.endDate, JSON.toJSONString(boIdList)});
        }
        return returnResult;
    }
}

