/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.web.mservice.IHRPIMService;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCBatchHandleUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class HRPIMServiceImpl
implements IHRPIMService {
    private static final Log LOGGER = LogFactory.getLog(HRPIMServiceImpl.class);

    public static HRPIMServiceImpl getInstance() {
        return (HRPIMServiceImpl)WTCAppContextHelper.getBean(HRPIMServiceImpl.class);
    }

    @Override
    public Map<String, Object> getPersonBaseInfo(Long personId) {
        LOGGER.info("HRPIMServiceImpl.getPersonBaseInfo param personId{}", (Object)personId);
        if (personId == null || personId == 0L) {
            return Collections.emptyMap();
        }
        return (Map)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonService", "getPersonBaseInfo", personId);
    }

    @Override
    public Map<String, Object> getPersonModelId() {
        return (Map)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonService", "getPersonModelId", new Object[0]);
    }

    @Override
    public Map<String, Object> queryPersonInfoByUserIds(List<Long> userIds) {
        return (Map)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonService", "queryPersonInfoByUserIds", userIds);
    }

    public Map<String, Object> queryUserInfoByPersonId(Long personId) {
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(16);
        idMaps.put("person", Collections.singletonList(personId));
        return (Map)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonService", "getUserIdByPersonInfo", idMaps);
    }

    @Override
    public List<Map<String, Object>> listBatchPersonAttachs(List<Long> personIds, QFilter qFilter, String attachEntityName) {
        LOGGER.info("HRPIMServiceImpl.listBatchPersonAttachs param personIds{},qFilter{},attachEntityName{}", new Object[]{personIds == null ? "NULL" : JSON.toJSONString(personIds), qFilter == null ? "NULL" : qFilter.toString(), attachEntityName});
        if (HRStringUtils.isEmpty((String)attachEntityName) || CollectionUtils.isEmpty(personIds)) {
            return Collections.emptyList();
        }
        ParamQueryAttach paramQueryAttach = new ParamQueryAttach(qFilter, attachEntityName);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        WTCBatchHandleUtils.batchHandleCollection((Collection)result, personIds, (int)1000, (Object)paramQueryAttach, this::listPersonAttachInBatches);
        return result;
    }

    private List<Map<String, Object>> listPersonAttachInBatches(List<Long> personIds, ParamQueryAttach paramQueryAttach) {
        return (List)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonService", "listBatchPersonAttachs", personIds, paramQueryAttach.qFilter, paramQueryAttach.attachEntityName);
    }

    @Override
    public List<Map<String, Object>> empPosOrgRelList(String postType, List<Long> personIds) {
        LOGGER.info("HRPIMServiceImpl.empPosOrgRelList param postType{},personIds{}", (Object)postType, (Object)(personIds == null ? "NULL" : JSON.toJSONString(personIds)));
        if (CollectionUtils.isEmpty(personIds)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        WTCBatchHandleUtils.batchHandleCollection((Collection)result, personIds, (int)1000, (Object)postType, this::empPosOrgRelListInBatches);
        return result;
    }

    @Override
    public List<Map<String, Object>> empPosOrgRelList(Long personId) {
        return (List)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonService", "listEmpposorgrels", personId);
    }

    private List<Map<String, Object>> empPosOrgRelListInBatches(List<Long> personIds, String postType) {
        return (List)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonService", "listEmpposorgrels", postType, personIds);
    }

    @Override
    public List<DynamicObject> listIntersectDataInfo(String entityName, String selectProperties, Date gteDate, Date lteDate, List<Long> personIdList, List<Long> employeeIdList, Map<String, Object> paramMap) {
        return this.listIntersectInfo("listIntersectDataInfo", entityName, selectProperties, gteDate, lteDate, personIdList, employeeIdList, paramMap);
    }

    private List<DynamicObject> listIntersectInfo(String functionName, String entityName, String selectProperties, Date gteDate, Date lteDate, List<Long> personIdList, List<Long> employeeIdList, Map<String, Object> paramMap) {
        LOGGER.info("HRPIMServiceImpl.listIntersectDataInfo param entityName{},selectProperties{},gteDate{},lteDate{},personIdList{}", new Object[]{entityName, selectProperties, gteDate, lteDate, personIdList == null ? "NULL" : JSON.toJSONString(personIdList)});
        if (HRStringUtils.isEmpty((String)entityName) || gteDate == null || lteDate == null || CollectionUtils.isEmpty(personIdList) && CollectionUtils.isEmpty(employeeIdList)) {
            return Collections.emptyList();
        }
        ParamIntersectDataInfo paramIntersectDataInfo = new ParamIntersectDataInfo(functionName, entityName, selectProperties, gteDate, lteDate, employeeIdList, paramMap);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        WTCBatchHandleUtils.batchHandleCollection((Collection)result, personIdList, (int)1000, (Object)paramIntersectDataInfo, this::listIntersectDataInfoInBatches);
        return result;
    }

    @Override
    public List<DynamicObject> listIntersectBusinessInfo(String entityName, String selectProperties, Date gteDate, Date lteDate, List<Long> personIdList, List<Long> employeeIdList, Map<String, Object> paramMap) {
        return this.listIntersectInfo("listIntersectBusinessInfo", entityName, selectProperties, gteDate, lteDate, personIdList, employeeIdList, paramMap);
    }

    private List<DynamicObject> listIntersectDataInfoInBatches(List<Long> personIds, ParamIntersectDataInfo paramIntersectDataInfo) {
        DynamicObject[] dynamicObjects = (DynamicObject[])WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonSyncService", paramIntersectDataInfo.functionName, paramIntersectDataInfo.entityName, paramIntersectDataInfo.selectProperties, paramIntersectDataInfo.gteDate, paramIntersectDataInfo.lteDate, personIds, paramIntersectDataInfo.employeeIdList, paramIntersectDataInfo.paramMap);
        return Arrays.stream(dynamicObjects).collect(Collectors.toList());
    }

    @Override
    public List<Map<String, Object>> listIntersectDataSocialworkageAndServicelengthInfo(Date gteDate, Date lteDate, List<Long> personIdList) {
        LOGGER.info("HRPIMServiceImpl.listIntersectDataSocialworkageAndServicelengthInfo param gteDate{},lteDate{},personIdList{}", new Object[]{gteDate, lteDate, personIdList == null ? "NULL" : JSON.toJSONString(personIdList)});
        if (gteDate == null || lteDate == null || CollectionUtils.isEmpty(personIdList)) {
            return Collections.emptyList();
        }
        return (List)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonSyncService", "listIntersectDataSocialworkageAndServicelengthInfo", gteDate, lteDate, personIdList);
    }

    @Override
    public DynamicObject[] listFieldsFilterInfo(String selectFields, QFilter custFilter, String entityName) {
        LOGGER.info("HRPIMServiceImpl.listFieldsFilterInfo param selectFields{},custFilter{},entityNam,entityName{}", new Object[]{selectFields, custFilter == null ? "" : custFilter.toString(), entityName});
        if (HRStringUtils.isEmpty((String)entityName) || HRStringUtils.isEmpty((String)selectFields)) {
            return new DynamicObject[0];
        }
        return (DynamicObject[])WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonSyncService", "listFieldsFilterInfo", selectFields, custFilter, entityName);
    }

    @Override
    public List<DynamicObject> listInfoById(List<Long> ids, String entityName) {
        LOGGER.info("HRPIMServiceImpl.listInfoById param ids{},entityName{}", (Object)(ids == null ? "NULL" : JSON.toJSONString(ids)), (Object)entityName);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        WTCBatchHandleUtils.batchHandleCollection((Collection)result, ids, (int)1000, (Object)entityName, this::listInfoByIdInBatches);
        return result;
    }

    private List<DynamicObject> listInfoByIdInBatches(List<Long> ids, String entityName) {
        DynamicObject[] dynamicObjects = (DynamicObject[])WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonSyncService", "listInfoById", ids, entityName);
        if (dynamicObjects == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toList());
    }

    @Override
    public List<DynamicObject> listFieldsFilterInfoBatch(String qcpProperty, List<Long> propertyIdList, String selectFields, QFilter custFilter, String entityName) {
        LOGGER.info("HRPIMServiceImpl.listFieldsFilterInfoBatch param qcpProperty {},propertyIdList{},selectFields{},custFilter{},entityName{}", new Object[]{qcpProperty, propertyIdList == null ? "NULL" : JSON.toJSONString(propertyIdList), selectFields, custFilter == null ? "" : custFilter.toString(), entityName});
        if (CollectionUtils.isEmpty(propertyIdList) || HRStringUtils.isEmpty((String)qcpProperty) || HRStringUtils.isEmpty((String)selectFields) || HRStringUtils.isEmpty((String)entityName)) {
            return Collections.emptyList();
        }
        ParamFieldsFilterInfo paramFieldsFilterInfo = new ParamFieldsFilterInfo(selectFields, custFilter, entityName, qcpProperty);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        WTCBatchHandleUtils.batchHandleCollection((Collection)result, propertyIdList, (int)1000, (Object)paramFieldsFilterInfo, this::listFieldsFilterInfoInBatches);
        return result;
    }

    private List<DynamicObject> listFieldsFilterInfoInBatches(List<Long> ids, ParamFieldsFilterInfo paramFieldsFilterInfo) {
        QFilter qFilter = new QFilter(paramFieldsFilterInfo.qcpProperty, "in", ids);
        if (paramFieldsFilterInfo.custFilter != null) {
            qFilter.and(paramFieldsFilterInfo.custFilter);
        }
        DynamicObject[] dynamicObjects = (DynamicObject[])WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIPersonSyncService", "listFieldsFilterInfo", paramFieldsFilterInfo.selectFields, qFilter, paramFieldsFilterInfo.entityName);
        return Arrays.stream(dynamicObjects).collect(Collectors.toList());
    }

    @Override
    public Map<Long, List<Map<String, Object>>> getDirectSuperiorByDepempId(List<Long> depId) {
        return (Map)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIWorkRoleService", "getDirectSuperiorByDepempId", depId);
    }

    @Override
    public List<Map<String, Object>> getMainChargeByOrg(List<Long> adminOrgId) {
        return (List)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIWorkRoleService", "getMainChargeByOrg", adminOrgId);
    }

    @Override
    public Map<String, Object> getEmpentrel(Long employeeId) {
        return (Map)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIEmployeeService", "getEmpentrel", employeeId);
    }

    @Override
    public Map<String, List<DynamicObject>> listDepEmpInfo(List<Map<String, Object>> queryList) {
        Map resMap = (Map)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIDepempService", "listDepEmpInfo", queryList);
        return (Map)resMap.get("data");
    }

    @Override
    public List<Map<String, Object>> listEmpOrgrels(List<Long> depEmpIdList) {
        return (List)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIDepempService", "listEmpOrgrels", depEmpIdList);
    }

    @Override
    public List<Map<String, Object>> listBatchEmployeeAttachs(List<Long> employeeIds, QFilter qFilter, String attachEntityName) {
        return (List)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIEmployeeService", "listBatchEmployeeAttachs", employeeIds, qFilter, attachEntityName);
    }

    @Override
    public Map<Long, List<Map<String, Object>>> queryChargeByPersonId(List<Long> personIds, Date queryDate) {
        return (Map)WTCServiceHelper.invokeHRMPService("hrpi", "IHRPIChargeService", "queryChargeByPersonId", personIds, queryDate);
    }

    private static class ParamFieldsFilterInfo {
        String selectFields;
        QFilter custFilter;
        String entityName;
        String qcpProperty;

        public ParamFieldsFilterInfo(String selectFields, QFilter custFilter, String entityName, String qcpProperty) {
            this.selectFields = selectFields;
            this.custFilter = custFilter;
            this.entityName = entityName;
            this.qcpProperty = qcpProperty;
        }
    }

    private static class ParamIntersectDataInfo {
        String functionName;
        String entityName;
        String selectProperties;
        Date gteDate;
        Date lteDate;
        List<Long> employeeIdList;
        Map<String, Object> paramMap;

        public ParamIntersectDataInfo(String functionName, String entityName, String selectProperties, Date gteDate, Date lteDate, List<Long> employeeIdList, Map<String, Object> paramMap) {
            this.functionName = functionName;
            this.entityName = entityName;
            this.selectProperties = selectProperties;
            this.gteDate = gteDate;
            this.lteDate = lteDate;
            this.employeeIdList = employeeIdList;
            this.paramMap = paramMap;
        }
    }

    private static class ParamQueryAttach {
        QFilter qFilter;
        String attachEntityName;

        public ParamQueryAttach(QFilter qFilter, String attachEntityName) {
            this.qFilter = qFilter;
            this.attachEntityName = attachEntityName;
        }
    }
}

