/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.web.takecardrule;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.takecardrule.ShiftDateVo;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class TakeCardRuleService {
    private static final Log LOGGER = LogFactory.getLog(TakeCardRuleService.class);

    public static void setTakeCardScope(List<ShiftDateVo> shiftDateVo) {
        Optional<Date> maxOptional;
        TakeCardRuleService.verifyShiftDateVos(shiftDateVo);
        Set<Long> ruleBidSet = shiftDateVo.stream().map(ShiftDateVo::getRuleBid).collect(Collectors.toSet());
        Date minSplitDate = null;
        Date maxSplitDate = null;
        Optional<Date> minOptional = shiftDateVo.stream().filter(object -> object.getSplitDate() != null).map(ShiftDateVo::getSplitDate).distinct().min(Date::compareTo);
        if (minOptional.isPresent()) {
            minSplitDate = minOptional.get();
        }
        if ((maxOptional = shiftDateVo.stream().filter(object -> object.getSplitDate() != null).map(ShiftDateVo::getSplitDate).distinct().max(Date::compareTo)).isPresent()) {
            maxSplitDate = maxOptional.get();
        }
        DynamicObject[] dynbamicObject = TakeCardRuleService.getRuleScope(ruleBidSet, minSplitDate, maxSplitDate);
        LOGGER.info("TakeCardRuleService.setTakeCardScope ruleBidSet={}, minSplitDate={},maxSplitDate={},dynbamicObject.length={}", new Object[]{ruleBidSet, minSplitDate, maxSplitDate, dynbamicObject.length});
        String tip = ResManager.loadKDString((String)"\u73ed\u6b21\u6570\u636e\u65e0\u6cd5\u5339\u914d\u53d6\u5361\u89c4\u5219\u3002\u8bf7\u68c0\u67e5\u53d6\u5361\u89c4\u5219\u7684\u751f\u6548\u65f6\u95f4\u5e94\u65e9\u4e8e\u73ed\u6b21\u7684\u751f\u6548\u65f6\u95f4\u3002", (String)"TakeCardRuleService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        for (ShiftDateVo shiftDate : shiftDateVo) {
            Long ruleBid = shiftDate.getRuleBid();
            ArrayList ruleList = Lists.newArrayListWithExpectedSize((int)dynbamicObject.length);
            for (DynamicObject dy : dynbamicObject) {
                long ruleBoId = dy.getLong("boid");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("TakeCardRuleService.setTakeCardScope ruleBoIdStr = {},ruleBid = {},match= {}", new Object[]{ruleBoId, ruleBid, String.valueOf(ruleBid)});
                }
                if (ruleBid == null || ruleBoId != ruleBid) continue;
                ruleList.add(dy);
            }
            if (CollectionUtils.isEmpty((Collection)ruleList)) {
                LOGGER.warn("TakeCardRuleService.setTakeCardScope ruleList is empty");
                throw new KDBizException(tip);
            }
            List<DynamicObject> filterRuleList = TakeCardRuleService.getSeqHisDyByDate(shiftDate.getRuleBid(), shiftDate.getSplitDate(), ruleList);
            if (CollectionUtils.isEmpty(filterRuleList)) {
                LOGGER.info("TakeCardRuleService.setTakeCardScope filterRuleList is empty");
                throw new KDBizException(tip);
            }
            if (HRStringUtils.equals((String)"true", (String)shiftDate.getOffNonPlan()) && !filterRuleList.get(0).getBoolean("isoff") || !HRStringUtils.equals((String)"true", (String)shiftDate.getOffNonPlan()) && filterRuleList.get(0).getBoolean("isoff")) {
                String errorShiftInfo = ResManager.loadKDString((String)"\u6392\u73ed\u6216\u73ed\u6b21\u6570\u636e\u9519\u8bef", (String)"TakeCardRuleService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
                LOGGER.error("TakeCardRuleService.verifyShiftDateVos error={}", (Object)"shift and rule do not match");
                throw new KDBizException(errorShiftInfo);
            }
            if (HRStringUtils.equals((String)"true", (String)shiftDate.getOffNonPlan())) {
                Date belongDate = shiftDate.getBelongDate();
                shiftDate.setStartScopeDate(HRDateTimeUtils.addSecond((Date)belongDate, (long)filterRuleList.get(0).getInt("takecardstarttime")));
                shiftDate.setEndScopeDate(HRDateTimeUtils.addSecond((Date)belongDate, (long)filterRuleList.get(0).getInt("takecardendtime")));
                continue;
            }
            int sBeforeScope = filterRuleList.get(0).getInt("wtbd_tcardruleentry.sbeforescope");
            int eAfterScope = filterRuleList.get(filterRuleList.size() - 1).getInt("wtbd_tcardruleentry.eafterscope");
            Date workStartDate = shiftDate.getWorkStartDate();
            Date workEndDate = shiftDate.getWorkEndDate();
            if (workStartDate == null || workEndDate == null) {
                LOGGER.warn("TakeCardRuleService.setTakeCardScope workStartDate or workEndDate is null");
                throw new KDBizException(ResManager.loadKDString((String)"\u6392\u73ed\u6570\u636e\u73ed\u6b21\u5b9a\u4e49\u6570\u636e\u95ee\u9898\u3002", (String)"TakeCardRuleService_2", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            shiftDate.setStartScopeDate(HRDateTimeUtils.addMinute((Date)workStartDate, (long)(-sBeforeScope)));
            shiftDate.setEndScopeDate(HRDateTimeUtils.addMinute((Date)workEndDate, (long)eAfterScope));
        }
    }

    private static void verifyShiftDateVos(List<ShiftDateVo> shiftDateVos) throws KDBizException {
        String errorShiftInfo = ResManager.loadKDString((String)"\u6392\u73ed\u6216\u73ed\u6b21\u6570\u636e\u9519\u8bef", (String)"TakeCardRuleService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(shiftDateVos)) {
            LOGGER.error("TakeCardRuleService.verifyShiftDateVos shiftDateVos is empty");
            throw new KDBizException(errorShiftInfo);
        }
        for (ShiftDateVo dutyDateInfo : shiftDateVos) {
            if (dutyDateInfo.getRuleBid() != null && dutyDateInfo.getRuleBid() != 0L && !HRStringUtils.isEmpty((String)dutyDateInfo.getOffNonPlan()) && dutyDateInfo.getBelongDate() != null && dutyDateInfo.getSplitDate() != null) continue;
            LOGGER.info("dutyDateInfo={}", JSON.toJSON((Object)dutyDateInfo));
            LOGGER.error("TakeCardRuleService.verifyShiftDateVos error={}", (Object)"illegal params to invoke verifyDutyDateInfos");
            throw new KDBizException(errorShiftInfo);
        }
    }

    private static DynamicObject[] getRuleScope(Collection<Long> ruleBidList, Date startDate, Date endDate) {
        QFilter[] qFilters = TakeCardRuleService.getQFilters(ruleBidList, startDate, endDate);
        HRBaseServiceHelper ruleServiceHelper = new HRBaseServiceHelper("wtbd_takecardrule");
        return ruleServiceHelper.queryOriginalArray("id,isoff,takecardstarttime,takecardendtime,boid,bsed,bsled,wtbd_tcardruleentry.sbeforescope,wtbd_tcardruleentry.eafterscope,wtbd_tcardruleentry.timeseq", qFilters);
    }

    private static QFilter[] getQFilters(Collection<Long> ruleBidList, Date startDate, Date endDate) {
        QFilter qFilter = WTCHisServiceHelper.validQFilterByBoNoStatus(ruleBidList);
        QFilter dateQFilter = WTCHisServiceHelper.getDateQFilter(startDate, endDate, "bsed", "bsled");
        return new QFilter[]{qFilter, dateQFilter};
    }

    private static List<DynamicObject> getSeqHisDyByDate(Object boId, Date time, List<DynamicObject> allDys) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        for (DynamicObject dy : allDys) {
            Object boIdFromDy = dy.get("boid");
            Date startTime = dy.getDate("bsed");
            Date endTime = dy.getDate("bsled");
            if (!boIdFromDy.equals(boId) || !WTCDateUtils.betweenDay((Date)time, (Date)startTime, (Date)endTime)) continue;
            dynamicObjectList.add(dy);
        }
        return dynamicObjectList.stream().sorted(Comparator.comparing(entry -> entry.getInt("wtbd_tcardruleentry.timeseq"))).collect(Collectors.toList());
    }
}

