/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.workschedule.datetypeadj;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.datetype.DateTypeService;
import kd.wtc.wtbs.business.workschedule.specialdate.SpecialDateService;
import kd.wtc.wtbs.common.enums.workschedule.DateTypeEnum;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.model.workschdule.datetypeadj.DateTypeAdj;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class DateTypeAdjService {
    private static final Log LOG = LogFactory.getLog(DateTypeAdjService.class);
    private static final DateTypeAdjService INS = new DateTypeAdjService();
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtbd_datetypeadj");
    private static final String DATETYPE_ADJ_SELECT_PROPS = "id,specialdate,entryentity.fromdatetype,entryentity.todatetype,entryentity.dayofweek,entryentity.todatetype.dateproperty,entryentity.shiftofftype";

    private DateTypeAdjService() {
    }

    public static DateTypeAdjService getInstance() {
        return INS;
    }

    public Long getSpecialDateId(Long id) {
        DynamicObject adjObj = HELPER.queryOne((Object)id);
        return adjObj != null ? adjObj.getLong("specialdate.id") : 0L;
    }

    public Map<Long, DateTypeAdj> getDateTypeAdjMap(Collection<Long> adjIdList, boolean isNeedLoadDateType) {
        Map<Long, DateTypeAdj> dateTypeAdjMap = this.getDateTypeAdjMap(adjIdList);
        if (isNeedLoadDateType) {
            Set<Long> dateTypeIds = dateTypeAdjMap.values().stream().map(DateTypeAdj::getAllOutPutDateTypeIds).flatMap(Collection::stream).collect(Collectors.toSet());
            Map<Long, DateType> dateTypeMap = DateTypeService.getInstance().getDateTypeMapByIds(dateTypeIds);
            for (DateTypeAdj dateTypeAdj : dateTypeAdjMap.values()) {
                if (dateTypeAdj == null) continue;
                dateTypeAdj.setDateTypeMap(dateTypeMap);
            }
        }
        return dateTypeAdjMap;
    }

    public Map<Long, DateTypeAdj> getDateTypeAdjMap(Collection<Long> adjIdList) {
        LOG.info("DateTypeAdjService.getDateTypeAdjMap:{}", adjIdList);
        DynamicObjectCollection dateTypeAdjEntry = HELPER.queryOriginalCollection(DATETYPE_ADJ_SELECT_PROPS, new QFilter[]{new QFilter("id", "in", adjIdList)}, "id");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)adjIdList.size());
        if (dateTypeAdjEntry.isEmpty()) {
            return resultMap;
        }
        HashMap specialIdMap = Maps.newHashMapWithExpectedSize((int)adjIdList.size());
        HashMap adjMap = Maps.newHashMapWithExpectedSize((int)adjIdList.size());
        for (DynamicObject adjEntry : dateTypeAdjEntry) {
            long l = adjEntry.getLong("id");
            long toDateTypeId = adjEntry.getLong("entryentity.todatetype");
            if (DateTypeEnum.REST_SPECIAL.getId().equals(toDateTypeId)) {
                specialIdMap.put(l, adjEntry.getLong("specialdate"));
            }
            List adjColls = adjMap.computeIfAbsent(l, key -> Lists.newLinkedList());
            adjColls.add(adjEntry);
        }
        Map<Long, List<Tuple<Tuple<Date, Date>, Tuple<Long, Long>>>> specialDateMap = null;
        if (!specialIdMap.isEmpty()) {
            specialDateMap = SpecialDateService.getInstance().getSpecialDateMap(specialIdMap);
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : adjMap.entrySet()) {
            List<Tuple<Tuple<Date, Date>, Tuple<Long, Long>>> specialDateEntryMap;
            boolean isNeedShiftOffType = ((List)entry.getValue()).size() > 0 && HRStringUtils.isNotEmpty((String)((DynamicObject)((List)entry.getValue()).get(0)).getString("entryentity.shiftofftype"));
            HashSet dateTypeIdSet = Sets.newHashSetWithExpectedSize((int)(((List)entry.getValue()).size() * 2));
            Map<String, Tuple<Long, Long>> dateTypeEntryMap = this.getDateTypeAdjEntryMap(entry);
            for (DynamicObject entry2 : entry.getValue()) {
                dateTypeIdSet.add(entry2.getLong("entryentity.fromdatetype"));
                dateTypeIdSet.add(entry2.getLong("entryentity.todatetype"));
            }
            List<Tuple<Tuple<Date, Date>, Tuple<Long, Long>>> list = specialDateEntryMap = specialDateMap == null ? null : specialDateMap.get(entry.getKey());
            if (specialDateEntryMap != null) {
                dateTypeIdSet.addAll(specialDateEntryMap.stream().map(tp -> (Long)((Tuple)tp.item2).item1).collect(Collectors.toSet()));
            }
            DateTypeAdj dateTypeAdj = new DateTypeAdj(dateTypeEntryMap, specialDateEntryMap, isNeedShiftOffType);
            dateTypeAdj.setDateTypeIdSet((Set)dateTypeIdSet);
            resultMap.put(entry.getKey(), dateTypeAdj);
        }
        return resultMap;
    }

    private Map<String, Tuple<Long, Long>> getDateTypeAdjEntryMap(Map.Entry<Long, List<DynamicObject>> listEntry) {
        HashMap dateTypeEntryMap = Maps.newHashMapWithExpectedSize((int)listEntry.getValue().size());
        for (DynamicObject entry : listEntry.getValue()) {
            String dayOfWeek = entry.getString("entryentity.dayofweek");
            String shiftOffType = entry.getString("entryentity.shiftofftype");
            long fromDateTypeId = entry.getLong("entryentity.fromdatetype");
            long toDateTypeId = entry.getLong("entryentity.todatetype");
            if (toDateTypeId == 0L) continue;
            Long toDatePropId = entry.getLong("entryentity.todatetype.dateproperty");
            dateTypeEntryMap.put(DateTypeAdj.genKeyOfEntryMap((String)dayOfWeek, (long)fromDateTypeId, (String)shiftOffType), Tuple.create((Object)toDateTypeId, (Object)toDatePropId));
        }
        return dateTypeEntryMap;
    }

    public DateTypeAdj getDateTypeAdj(long adjId) {
        LOG.info("DateTypeAdjService.getDateTypeAdj:{}", (Object)adjId);
        Map<Long, DateTypeAdj> dateTypeAdjMap = this.getDateTypeAdjMap(Sets.newHashSet((Object[])new Long[]{adjId}));
        return dateTypeAdjMap.get(adjId);
    }

    public Tuple<Long, Long> adjustDateType(Date workDate, int weekDay, long datePropId, long fromDateTypeId, DateTypeAdj dateTypeAdj) {
        return dateTypeAdj.adjustDateType(workDate, weekDay, datePropId, fromDateTypeId);
    }

    public DateType adjust2DateType(Date workDate, int weekDay, long datePropId, long fromDateTypeId, DateTypeAdj dateTypeAdj) {
        Tuple adjResult = dateTypeAdj.adjustDateType(workDate, weekDay, datePropId, fromDateTypeId);
        if (adjResult == null) {
            return null;
        }
        return dateTypeAdj.getDateTypeById((Long)adjResult.item1);
    }
}

