/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.workschedule.specialdate;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class SpecialDateService {
    private static final Log LOG = LogFactory.getLog(SpecialDateService.class);
    private static final SpecialDateService INS = new SpecialDateService();
    private static final HRBaseServiceHelper SPECIAL_DATE_HELPER = new HRBaseServiceHelper("wtbd_specialdate");
    private static final String SPEICIAL_DATE_PROPS = "id,entryentity.startdate,entryentity.enddate,entryentity.todatetype,entryentity.todatetype.dateproperty";

    private SpecialDateService() {
    }

    public static SpecialDateService getInstance() {
        return INS;
    }

    public boolean validateTimeCross(DynamicObjectCollection entryEntity) {
        return this.validateTimeCross(entryEntity, "startdate", "enddate");
    }

    public boolean validateTimeCross(DynamicObjectCollection entryEntity, String keyStart, String keyEnd) {
        TreeMap treeMap = Maps.newTreeMap();
        int size = 0;
        for (DynamicObject entry : entryEntity) {
            Date startDate = entry.getDate(keyStart);
            Date endDate = entry.getDate(keyEnd);
            if (startDate == null || endDate == null) continue;
            treeMap.put(startDate.getTime(), endDate.getTime());
            ++size;
        }
        return !this.validateTimeCross(treeMap, size);
    }

    public boolean validateTimeCross(TreeMap<Long, Long> timePairs, int size) {
        if (size != timePairs.size()) {
            return false;
        }
        long lastEndTime = 0L;
        for (Map.Entry<Long, Long> pair : timePairs.entrySet()) {
            if (pair.getKey() <= lastEndTime) {
                return false;
            }
            lastEndTime = pair.getValue();
        }
        return true;
    }

    public Map<Long, List<Tuple<Tuple<Date, Date>, Tuple<Long, Long>>>> getSpecialDateMap(Map<Long, Long> specialDateIdMap) {
        LOG.info("getSpecialDateMap.params:{}", specialDateIdMap);
        DynamicObjectCollection entryEntity = SPECIAL_DATE_HELPER.queryOriginalCollection(SPEICIAL_DATE_PROPS, new QFilter[]{new QFilter("id", "in", specialDateIdMap.values())});
        HashMap specialDateMap = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
        for (DynamicObject entry2 : entryEntity) {
            long id = entry2.getLong("id");
            List tuples = specialDateMap.computeIfAbsent(id, key -> Lists.newLinkedList());
            Date startDate = entry2.getDate("entryentity.startdate");
            Date endDate = entry2.getDate("entryentity.enddate");
            long toDateTypeId = entry2.getLong("entryentity.todatetype");
            long toDatePropId = entry2.getLong("entryentity.todatetype.dateproperty");
            tuples.add(Tuple.create((Object)Tuple.create((Object)startDate, (Object)endDate), (Object)Tuple.create((Object)toDateTypeId, (Object)toDatePropId)));
        }
        return specialDateIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (List)specialDateMap.get(entry.getValue())));
    }
}

