/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.wtctask;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class WTCRecordCountStatTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.recordCountStat();
    }

    private void recordCountStat() {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.set(WTCDateUtils.getNowYear(), WTCDateUtils.getNowMonth() - 2, 1);
        Date lastMonth = gc.getTime();
        Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((Date)lastMonth);
        Date endDayOfMonth = WTCDateUtils.getEndDayOfMonth((Date)lastMonth);
        Set<Long> attFileBoIdSet = this.queryAttFileBoIds(beginDayOfMonth);
        if (attFileBoIdSet.isEmpty()) {
            return;
        }
        Set<Long> midSet = this.queryRecordMIds(attFileBoIdSet, beginDayOfMonth, endDayOfMonth);
        int recordCountAvgMonth = this.queryRecordCountAvg(midSet, attFileBoIdSet.size(), beginDayOfMonth, endDayOfMonth);
        if (recordCountAvgMonth > 0) {
            this.saveAvgCount(recordCountAvgMonth);
        }
    }

    private void saveAvgCount(int recordCountAvgMonth) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_sysstat");
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("key", (Object)"recordCountAvgMonth");
        LocalDateTime now = LocalDateTime.now();
        Date newDate = WTCDateUtils.toDate((LocalDateTime)now);
        dynamicObject.set("name", (Object)("recordCountAvgMonth" + simpleDateFormat.format(newDate)));
        dynamicObject.set("createtime", (Object)newDate);
        dynamicObject.set("modifytime", (Object)newDate);
        dynamicObject.set("content", (Object)recordCountAvgMonth);
        serviceHelper.saveOne(dynamicObject);
    }

    private int queryRecordCountAvg(Set<Long> midSet, int size, Date beginDayOfMonth, Date endDayOfMonth) {
        HRBaseServiceHelper detailServiceHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        QFilter[] qFilters = new QFilter[]{new QFilter("attmain", "in", midSet), new QFilter("owndate", ">=", (Object)beginDayOfMonth), new QFilter("owndate", "<=", (Object)endDayOfMonth)};
        int count = detailServiceHelper.queryDataSet("queryRecordCountAvg", "id", qFilters).count("id", true);
        return count / size;
    }

    private Set<Long> queryAttFileBoIds(Date beginDayOfMonth) {
        HRBaseServiceHelper recordServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        QFilter[] qFilters = new QFilter[]{new QFilter("owndate", "=", (Object)beginDayOfMonth)};
        DataSet dataSet = recordServiceHelper.queryDataSet("WTCRecordCountStatTask.queryAttFileBoIds", "attfileid", qFilters);
        DataSet top = dataSet.top(100);
        HashSet personSet = Sets.newHashSetWithExpectedSize((int)100);
        while (top.hasNext()) {
            Row next = top.next();
            Long personid = next.getLong("attfileid");
            personSet.add(personid);
        }
        return personSet;
    }

    private Set<Long> queryRecordMIds(Set<Long> personIdSet, Date beginDayOfMonth, Date endDayOfMonth) {
        HRBaseServiceHelper recordServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        QFilter[] qFilters = new QFilter[]{new QFilter("owndate", ">=", (Object)beginDayOfMonth), new QFilter("owndate", "<=", (Object)endDayOfMonth), new QFilter("attfileid", "in", personIdSet)};
        DataSet dataSet = recordServiceHelper.queryDataSet("WTCRecordCountStatTask.queryRecordMIds", "id", qFilters);
        HashSet midSet = Sets.newHashSetWithExpectedSize((int)3100);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            Long mid = next.getLong("id");
            midSet.add(mid);
        }
        return midSet;
    }
}

