/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.mservice.attfile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sdk.wtc.wtbs.common.enums.UserModelType;
import kd.sdk.wtc.wtp.business.attfile.AttFileVersion;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.mservice.attfile.IAttFileQueryService;

public class AttFileQueryService
implements IAttFileQueryService {
    public AttFileVersion attFileQuery(Date date, Long personId, UserModelType userModelType) {
        if (date != null && personId != null && userModelType != null) {
            Set<Long> singleton = Collections.singleton(personId);
            AttFileQueryParam attFileQueryParam = this.getAttFileQueryParam(date, date, userModelType, singleton);
            DynamicObject attFileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFiles(attFileQueryParam);
            if (attFileDy != null) {
                return AttFileBusiness.genAttFileVersion((DynamicObject)attFileDy);
            }
        }
        return null;
    }

    public List<AttFileVersion> attFileQuery(Date startDate, Date endDate, Set<Long> userIdList, UserModelType userModelType, boolean checkAuth) {
        if (startDate == null || endDate == null || WTCCollections.isEmpty(userIdList) || userModelType == null) {
            return Collections.emptyList();
        }
        ArrayList<AttFileVersion> resultList = new ArrayList<AttFileVersion>(userIdList.size());
        AttFileQueryParam attFileQueryParam = this.getAttFileQueryParam(startDate, endDate, userModelType, userIdList);
        attFileQueryParam.setAuthCheck(Boolean.valueOf(checkAuth));
        List files = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        for (DynamicObject file : files) {
            AttFileVersion attFileVersion = AttFileBusiness.genAttFileVersion((DynamicObject)file);
            if (attFileVersion == null) continue;
            resultList.add(attFileVersion);
        }
        return resultList;
    }

    private AttFileQueryParam getAttFileQueryParam(Date startDate, Date endDate, UserModelType userModelType, Set<Long> userIdList) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setStartDate(startDate);
        attFileQueryParam.setEndDate(endDate);
        attFileQueryParam.setBeCurrent(Boolean.valueOf(false));
        switch (userModelType) {
            case PERSON: {
                attFileQueryParam.setPersonSetIds(userIdList);
                break;
            }
            case CMP_PERSON: {
                attFileQueryParam.setCmpPersonSetIds(userIdList);
                break;
            }
            case EMP_PERSON: {
                attFileQueryParam.setEmpPersonSetIds(userIdList);
                break;
            }
            case DEP_PERSON: {
                attFileQueryParam.setDepPersonSetIds(userIdList);
            }
        }
        return attFileQueryParam;
    }
}

