/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.mservice.mobilescheme;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.mobile.MobileSchemeServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.mservice.mobilescheme.IMobileSchemeQueryService;

public class MobileSchemeQueryService
implements IMobileSchemeQueryService {
    private static final Log LOG = LogFactory.getLog(MobileSchemeQueryService.class);
    private static final int batch_execute_size = 1000;

    public Map<Long, Long> batchMatchMobileScheme(List<DynamicObject> attFiles, String workSpace) {
        return MobileSchemeServiceHelper.batchMatchMobileScheme(attFiles, (String)workSpace);
    }

    public Map<Long, Long> batchMatchMobileSchemeByFileBoId(Set<Long> attFileBoIds, String workSpace) {
        if (WTCCollections.isEmpty(attFileBoIds)) {
            return Collections.emptyMap();
        }
        if (attFileBoIds.size() > 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6863\u6848\u6570\u91cf\u8d85\u8fc7\u9650\u5236\uff0c\u5355\u6b21\u67e5\u8be2\u6863\u6848\u6570\u91cf\u4e0d\u8d85\u8fc7{0}\u3002", (String)"MobileSchemeQueryService_0", (String)"wtc-wtbs-mservice", (Object[])new Object[]{1000}));
        }
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setSetBoIds(attFileBoIds);
        queryParam.setBeCurrent(Boolean.TRUE);
        List attFiles = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        return MobileSchemeServiceHelper.batchMatchMobileScheme((List)attFiles, (String)workSpace);
    }

    public Map<Long, Map<String, Map<Long, BigDecimal>>> getPerSumAttItems(Map<Long, Long> attFileSchemeMap, Map<Long, List<Long>> attFileVidMap, List<String> perAttPeriodIds, boolean filterConfirm) {
        if (WTCMaps.isEmpty(attFileSchemeMap)) {
            return Collections.emptyMap();
        }
        if (attFileSchemeMap.size() > 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6863\u6848\u6570\u91cf\u8d85\u8fc7\u9650\u5236\uff0c\u5355\u6b21\u67e5\u8be2\u6863\u6848\u6570\u91cf\u4e0d\u8d85\u8fc7{0}\u3002", (String)"MobileSchemeQueryService_0", (String)"wtc-wtbs-mservice", (Object[])new Object[]{1000}));
        }
        Map<Long, DynamicObject> schemeRuleMap = this.batchQueryRuleBySchemeIds(attFileSchemeMap.values(), "A");
        Map<Long, DynamicObject> perSumConfigMapByRules = this.getConfigMapByRules(schemeRuleMap.values(), "persumconfig");
        ArrayList<Long> attFieVidList = new ArrayList<Long>(attFileVidMap.keySet());
        List<Long> attItemSet = this.getAttItemSet(perSumConfigMapByRules.values(), "persumsource", filterConfirm);
        LOG.info("MobileSchemeQueryService.getPerSumAttItems.attItemSet:{}", (Object)attItemSet.size());
        if (WTCCollections.isEmpty(attItemSet)) {
            return Collections.emptyMap();
        }
        Map<Long, Map<String, Map<Long, BigDecimal>>> periodAttItemValueMap = this.queryAttItemValueWithMultiAttFile(perAttPeriodIds, attItemSet, attFieVidList);
        LOG.debug("MobileSchemeQueryService.getPerSumAttItems.periodAttItemValueMap:{}", periodAttItemValueMap);
        HashMap<Long, Map<String, Map<Long, BigDecimal>>> resultMap = new HashMap<Long, Map<String, Map<Long, BigDecimal>>>(attFileSchemeMap.size());
        Set<Map.Entry<Long, Long>> entries = attFileSchemeMap.entrySet();
        for (String perAttPeriodId : perAttPeriodIds) {
            for (Map.Entry<Long, Long> entry : entries) {
                DynamicObject perSumConfigDy;
                Long boId = entry.getKey();
                Long schemeId = entry.getValue();
                DynamicObject ruleDy = schemeRuleMap.get(schemeId);
                if (ruleDy == null || (perSumConfigDy = perSumConfigMapByRules.get(ruleDy.getLong("id"))) == null) continue;
                Map<String, Map<Long, BigDecimal>> attPeriodAttItemValueMap = periodAttItemValueMap.get(boId);
                DynamicObjectCollection perSumConfigEntry = perSumConfigDy.getDynamicObjectCollection("entryentity");
                HashMap attPeriodAttItemValueResultMap = new HashMap(16);
                LinkedHashMap<Long, BigDecimal> perSumResultMap = new LinkedHashMap<Long, BigDecimal>(perSumConfigEntry.size());
                Map<Long, BigDecimal> periodAttItemResultMap = WTCMaps.isEmpty(attPeriodAttItemValueMap) ? Collections.emptyMap() : attPeriodAttItemValueMap.get(perAttPeriodId);
                for (DynamicObject perSumEntry : perSumConfigEntry) {
                    if (!perSumEntry.containsProperty("aconfirm") || !perSumEntry.getBoolean("aconfirm")) continue;
                    DynamicObject source = perSumEntry.getDynamicObject("persumsource");
                    perSumResultMap.put(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)source, (String)"id"), WTCMaps.isEmpty(periodAttItemResultMap) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : this.calculateAttItemStatistics(source, periodAttItemResultMap));
                }
                attPeriodAttItemValueResultMap.put(perAttPeriodId, perSumResultMap);
                if (resultMap.containsKey(boId) && WTCMaps.isNotEmpty((Map)((Map)resultMap.get(boId)))) {
                    attPeriodAttItemValueResultMap.putAll((Map)resultMap.get(boId));
                }
                resultMap.put(boId, attPeriodAttItemValueResultMap);
            }
        }
        LOG.info("MobileSchemeQueryService.getPerSumAttItems.resultMap:{}", resultMap);
        return resultMap;
    }

    public Map<Long, Map<String, Map<Long, BigDecimal>>> getDailyAttItemsDetail(Map<Long, Long> attFileSchemeMap, List<Date> queryDates, boolean filterConfirm) {
        if (WTCMaps.isEmpty(attFileSchemeMap) || WTCCollections.isEmpty(queryDates)) {
            return Collections.emptyMap();
        }
        if (attFileSchemeMap.size() > 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6863\u6848\u6570\u91cf\u8d85\u8fc7\u9650\u5236\uff0c\u5355\u6b21\u67e5\u8be2\u6863\u6848\u6570\u91cf\u4e0d\u8d85\u8fc7{0}\u3002", (String)"MobileSchemeQueryService_0", (String)"wtc-wtbs-mservice", (Object[])new Object[]{1000}));
        }
        Map<Long, DynamicObject> schemeRuleMap = this.batchQueryRuleBySchemeIds(attFileSchemeMap.values(), "A");
        Map<Long, DynamicObject> dailyDetConfigMapByRules = this.getConfigMapByRules(schemeRuleMap.values(), "dailydetconfig");
        List queryDateStrList = queryDates.stream().map(qd -> WTCDateUtils.date2Str((Date)qd, (String)"yyyy-MM-dd")).collect(Collectors.toList());
        HashMap<Long, List<String>> queryDailyDetMap = new HashMap<Long, List<String>>(attFileSchemeMap.size());
        for (Long boId : attFileSchemeMap.keySet()) {
            queryDailyDetMap.put(boId, queryDateStrList);
        }
        List<Long> attItemSet = this.getAttItemSet(dailyDetConfigMapByRules.values(), "dailydetsource", filterConfirm);
        LOG.info("MobileSchemeQueryService.getDailyAttItemsDetail.attItemSet:{}", (Object)attItemSet.size());
        if (WTCCollections.isEmpty(attItemSet)) {
            return Collections.emptyMap();
        }
        Map<Long, Map<String, Map<Long, String>>> multiAttFileQueryAttItemValueByDate = this.queryAttItemValueWithMultiAttFile(queryDailyDetMap, attItemSet);
        LOG.info("MobileSchemeQueryService.getDailyAttItemsDetail.multiAttFileQueryAttItemValueByDate:{}", (Object)multiAttFileQueryAttItemValueByDate.size());
        HashMap<Long, Map<String, Map<Long, BigDecimal>>> resultMap = new HashMap<Long, Map<String, Map<Long, BigDecimal>>>(attFileSchemeMap.size());
        for (String dateStr : queryDateStrList) {
            for (Map.Entry<Long, Long> attFileSchemeEntry : attFileSchemeMap.entrySet()) {
                DynamicObject dailyConfigDy;
                Long boId = attFileSchemeEntry.getKey();
                Long schemeId = attFileSchemeEntry.getValue();
                DynamicObject ruleDy = schemeRuleMap.get(schemeId);
                if (ruleDy == null || (dailyConfigDy = dailyDetConfigMapByRules.get(ruleDy.getLong("id"))) == null) continue;
                Map<String, Map<Long, String>> attItemDateMap = multiAttFileQueryAttItemValueByDate.get(boId);
                DynamicObjectCollection dailyConfigEntry = dailyConfigDy.getDynamicObjectCollection("entryentity");
                HashMap dailyResultMap = new HashMap(16);
                LinkedHashMap<Long, BigDecimal> dailyMap = new LinkedHashMap<Long, BigDecimal>(dailyConfigEntry.size());
                Map<Long, String> attItemMap = WTCMaps.isEmpty(attItemDateMap) ? Collections.emptyMap() : attItemDateMap.get(dateStr);
                for (DynamicObject dailyEntry : dailyConfigEntry) {
                    if (!dailyEntry.containsProperty("aconfirm") || !dailyEntry.getBoolean("aconfirm")) continue;
                    DynamicObject source = dailyEntry.getDynamicObject("dailydetsource");
                    dailyMap.put(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)source, (String)"id"), WTCMaps.isEmpty(attItemMap) ? BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP) : this.calculateAttItemStatisticsByDaily(source, attItemMap));
                }
                dailyResultMap.put(dateStr, dailyMap);
                if (resultMap.containsKey(boId) && WTCMaps.isNotEmpty((Map)((Map)resultMap.get(boId)))) {
                    dailyResultMap.putAll((Map)resultMap.get(boId));
                }
                resultMap.put(boId, dailyResultMap);
            }
        }
        LOG.info("MobileSchemeQueryService.getDailyAttItemsDetail.resultMap:{}", (Object)resultMap.size());
        LOG.debug("MobileSchemeQueryService.getDailyAttItemsDetail.resultMap:{}", resultMap);
        return resultMap;
    }

    private Map<Long, DynamicObject> batchQueryRuleBySchemeIds(Collection<Long> mobileSchemeIds, String workspace) {
        if (WTCCollections.isEmpty(mobileSchemeIds)) {
            return Collections.emptyMap();
        }
        int schemeIdSize = mobileSchemeIds.size();
        if (schemeIdSize < 1000) {
            return this.queryRuleBySchemeIdsExecute(mobileSchemeIds, workspace);
        }
        ArrayList<Long> mobileSchemeIdList = new ArrayList<Long>(mobileSchemeIds);
        int batchSize = schemeIdSize / 1000;
        if (schemeIdSize % 1000 > 0) {
            ++batchSize;
        }
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(schemeIdSize);
        for (int index = 0; index < batchSize; ++index) {
            List batchCell = WTCCollections.subList(mobileSchemeIdList, (int)(index * 1000), (int)((index + 1) * 1000));
            if (WTCCollections.isEmpty((Collection)batchCell)) continue;
            resultMap.putAll(this.queryRuleBySchemeIdsExecute(batchCell, workspace));
        }
        return resultMap;
    }

    private Map<Long, DynamicObject> queryRuleBySchemeIdsExecute(Collection<Long> mobileSchemeIds, String workspace) {
        if (WTCCollections.isEmpty(mobileSchemeIds)) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> mobileRuleMap = this.batchFindRuleById(mobileSchemeIds, workspace);
        if (WTCMaps.isEmpty(mobileRuleMap)) {
            return Collections.emptyMap();
        }
        Set ruleIds = mobileRuleMap.values().stream().map(rule -> rule.getLong("id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ruleIds);
        DynamicObject[] queryRule = new HRBaseServiceHelper("wtp_mobilerule").query("id,persumconfig,attcommproblem,selectedbill,showproblem,dailydetconfig,dailystaconfig,perstaconfig,quotaconfig", qFilter.toArray());
        if (queryRule == null || queryRule.length < 1) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> queryRuleMap = Arrays.stream(queryRule).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(mobileRuleMap.size());
        mobileRuleMap.forEach((schemeId, rule) -> {
            DynamicObject ruleDy = (DynamicObject)queryRuleMap.get(rule.getLong("id"));
            if (ruleDy != null) {
                resultMap.put((Long)schemeId, ruleDy);
            }
        });
        return resultMap;
    }

    private Map<Long, DynamicObject> batchFindRuleById(Collection<Long> mobileSchemeIds, String workspace) {
        if (WTCCollections.isEmpty(mobileSchemeIds)) {
            return Collections.emptyMap();
        }
        QFilter qFilter = new QFilter("id", "in", mobileSchemeIds);
        String ruleName = this.getRuleName(workspace);
        DynamicObject[] mobileScheme = new HRBaseServiceHelper("wtp_mobilescheme").query("id," + ruleName, qFilter.toArray());
        if (HRObjectUtils.isEmpty((Object)mobileScheme)) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> resultMap = Arrays.stream(mobileScheme).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDynamicObject(ruleName)));
        return resultMap;
    }

    private String getRuleName(String workspace) {
        return StringUtils.equals((CharSequence)"A", (CharSequence)workspace) ? "staffmobilerule" : "teammobilerule";
    }

    private BigDecimal calculateAttItemStatistics(DynamicObject perSumConfigDy, Map<Long, BigDecimal> attItemValueMap) {
        Set<Long> attItemSet = this.getAttItemSetConfigEntry(perSumConfigDy);
        LOG.info("query source idList:{}", (Object)SerializationUtils.toJsonString(attItemSet));
        if (WTCCollections.isEmpty(attItemSet)) {
            return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        }
        BigDecimal value = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        if (HRStringUtils.equals((String)perSumConfigDy.getString("treatmentmeth"), (String)"1")) {
            for (Long attItemId : attItemSet) {
                BigDecimal attItemValue = attItemValueMap.get(attItemId);
                if (attItemValue == null) continue;
                value = value.add(attItemValue.setScale(2, RoundingMode.HALF_UP));
            }
        } else if (HRStringUtils.equals((String)perSumConfigDy.getString("treatmentmeth"), (String)"2")) {
            BigDecimal attItemValueSum = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
            for (Long attItemId : attItemSet) {
                BigDecimal attItemValue = attItemValueMap.get(attItemId);
                if (attItemValue == null) continue;
                attItemValueSum = attItemValueSum.add(attItemValue.setScale(2, RoundingMode.HALF_UP));
            }
            value = attItemValueSum.divide(new BigDecimal(attItemValueMap.size()), 2, RoundingMode.HALF_UP);
        }
        return value;
    }

    private BigDecimal calculateAttItemStatisticsByDaily(DynamicObject DailyConfigDy, Map<Long, String> attItemValueMap) {
        BigDecimal value = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        Set<Long> attItemSet = this.getAttItemSetConfigEntry(DailyConfigDy);
        LOG.info("query source idList:{}", (Object)SerializationUtils.toJsonString(attItemSet));
        if (WTCCollections.isEmpty(attItemSet)) {
            return value;
        }
        for (Long attItemId : attItemSet) {
            Double attItemValue;
            String attItmValueStr = attItemValueMap.get(attItemId);
            if (!WTCStringUtils.isNotEmpty((String)attItmValueStr)) continue;
            try {
                attItemValue = Double.valueOf(attItmValueStr);
            }
            catch (Exception e) {
                LOG.warn("MobileSchemeQueryService.calculateAttItemStatisticsByDaily.fail:{}", (Object)e.getMessage());
                continue;
            }
            value = value.add(BigDecimal.valueOf(attItemValue).setScale(2, RoundingMode.HALF_UP));
        }
        return value;
    }

    private Map<Long, DynamicObject> getConfigMapByRules(Collection<DynamicObject> rules, String configFieldName) {
        if (WTCCollections.isEmpty(rules)) {
            return Collections.emptyMap();
        }
        String tableName = "";
        if ("persumconfig".equals(configFieldName)) {
            tableName = "wtp_persumconfig";
        } else if ("dailydetconfig".equals(configFieldName)) {
            tableName = "wtp_dailydetconfig";
        } else {
            return Collections.emptyMap();
        }
        Predicate<DynamicObject> tPredicate = rule -> rule.containsProperty(configFieldName) && rule.get(configFieldName) instanceof DynamicObject && rule.getDynamicObject(configFieldName) != null;
        Set schemeConfigIds = rules.stream().filter(tPredicate).map(rule -> rule.getDynamicObject(configFieldName).getLong("id")).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("id", "in", schemeConfigIds);
        DynamicObject[] queryConfigs = HRBaseServiceHelper.create((String)tableName).loadDynamicObjectArray(idFilter.toArray());
        if (queryConfigs == null || queryConfigs.length < 1) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> configMap = Arrays.stream(queryConfigs).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(rules.size());
        for (DynamicObject rule2 : rules) {
            long perSumConfigId;
            DynamicObject perSumConfig;
            if (!tPredicate.test(rule2) || (perSumConfig = configMap.get(perSumConfigId = rule2.getDynamicObject(configFieldName).getLong("id"))) == null) continue;
            resultMap.put(rule2.getLong("id"), perSumConfig);
        }
        return resultMap;
    }

    private List<Long> getAttItemSet(Collection<DynamicObject> configs, String queryField, boolean filterConfirm) {
        if (!Arrays.asList("persumsource", "dailydetsource").contains(queryField)) {
            return Collections.emptyList();
        }
        if (WTCCollections.isEmpty(configs)) {
            return Collections.emptyList();
        }
        ArrayList<Long> attItemIdSet = new ArrayList<Long>(16);
        configs.stream().filter(config -> config.containsProperty("entryentity") && WTCCollections.isNotEmpty((Collection)config.getDynamicObjectCollection("entryentity"))).forEach(config -> {
            DynamicObjectCollection sourceColl = config.getDynamicObjectCollection("entryentity");
            sourceColl.stream().filter(entry -> filterConfirm && entry.containsProperty("aconfirm") && entry.getBoolean("aconfirm")).forEach(entry -> {
                DynamicObject source = entry.getDynamicObject(queryField);
                DynamicObjectCollection entityCollection = source.getDynamicObjectCollection("entryentity");
                attItemIdSet.addAll(entityCollection.stream().filter(entity -> entity.containsProperty("attitem") && entity.get("attitem") instanceof DynamicObject).map(entity -> entity.getDynamicObject("attitem").getLong("id")).collect(Collectors.toSet()));
            });
        });
        return attItemIdSet;
    }

    private Set<Long> getAttItemSetConfigEntry(DynamicObject configEntry) {
        DynamicObjectCollection entityCollection = configEntry.getDynamicObjectCollection("entryentity");
        return entityCollection.stream().filter(entity -> entity.containsProperty("attitem") && entity.get("attitem") instanceof DynamicObject).map(entity -> entity.getDynamicObject("attitem").getLong("id")).collect(Collectors.toSet());
    }

    private Map<Long, Map<String, Map<Long, String>>> queryAttItemValueWithMultiAttFile(Map<Long, List<String>> attFileQueryMap, List<Long> attItemIds) {
        if (WTCMaps.isEmpty(attFileQueryMap) || WTCCollections.isEmpty(attItemIds)) {
            return Collections.emptyMap();
        }
        return (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtdtd", (String)"IAttRecordService", (String)"listDetailAttItems", (Object[])new Object[]{attFileQueryMap, attItemIds});
    }

    private Map<Long, Map<String, Map<Long, BigDecimal>>> queryAttItemValueWithMultiAttFile(List<String> perAttPeriodIdSet, List<Long> attItemSet, List<Long> attFileSet) {
        if (WTCCollections.isEmpty(perAttPeriodIdSet) || WTCCollections.isEmpty(attItemSet) || WTCCollections.isEmpty(attFileSet)) {
            return Collections.emptyMap();
        }
        return (Map)DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtte", (String)"IAttRecordService", (String)"getAttItemValueByPerAttPeriodIds", (Object[])new Object[]{perAttPeriodIdSet, attItemSet, attFileSet});
    }
}

