/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.mservice.roleperm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class ChangeBillRolePermUpgradeService
extends WTCUpgradeService {
    private static final Log LOG = LogFactory.getLog(ChangeBillRolePermUpgradeService.class);
    private static final String ADD_NEW_PERM_ID = "47156aff000000ac";
    private static final String CHANGE_PERM_ID = "4730fc9f000029ae";
    private static final Set<String> NOT_UPGRADE_ROLE = Sets.newHashSet((Object[])new String[]{"3+G10ZAK5DY9", "2R3J2G83GTAG", "2R3EEFVUDV99", "2R2US/WRZUF1", "2R3HKYSOUS2G"});
    private static final Set<String> NEED_UPGRADE_ENTITY = Sets.newHashSet((Object[])new String[]{"wtom_otbillchange", "wtom_otselfbillchange", "wtam_busibillchange", "wtam_busiselfbillchange", "wtabm_vaupdate", "wtabm_vaupdateself"});

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        List<RoleAndPermEntryInfo> needUpGradeInfo = this.getNeedUpGradeInfo(NEED_UPGRADE_ENTITY, dbKey);
        if (CollectionUtils.isEmpty(needUpGradeInfo)) {
            return;
        }
        String insertSql = "INSERT INTO T_PERM_ROLEPERMDETIAL(fentryid,fseq,fentitytypeid,fcontrolmode,finheritmode,fpermitemid,fbizappid,froleid,fid) VALUES(?,0,?,' ',' ',?,?,?,?);";
        ArrayList<Object[]> insertData = new ArrayList<Object[]>(10);
        String[] ids = ID.genStringIds((int)needUpGradeInfo.size());
        for (int index = 0; index < needUpGradeInfo.size(); ++index) {
            RoleAndPermEntryInfo info = needUpGradeInfo.get(index);
            Object[] param = new Object[]{ids[index], info.getfEntityTypeId(), CHANGE_PERM_ID, info.getfBizAppId(), info.getfRoleId(), info.getFid()};
            insertData.add(param);
        }
        HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)insertSql, insertData);
    }

    private List<RoleAndPermEntryInfo> getNeedUpGradeInfo(Set<String> changeEntity, String dbKey) {
        if (CollectionUtils.isEmpty(changeEntity)) {
            return Collections.emptyList();
        }
        ArrayList copyChangeEntity = Lists.newArrayListWithExpectedSize((int)changeEntity.size());
        for (String entity : changeEntity) {
            if (!HRStringUtils.isNotEmpty((String)entity)) continue;
            copyChangeEntity.add("'" + entity + "'");
        }
        if (CollectionUtils.isEmpty((Collection)copyChangeEntity)) {
            return Collections.emptyList();
        }
        String queryInfo = "SELECT fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid FROM t_perm_rolepermdetial where fentitytypeid in (" + String.join((CharSequence)",", copyChangeEntity) + ") and fpermitemid in ('" + ADD_NEW_PERM_ID + "','" + CHANGE_PERM_ID + "');";
        DataSet rows = HRDBUtil.queryDataSet((String)"ChangeBillRolePermUpgradeService_0", (DBRoute)DBRoute.of((String)dbKey), (String)queryInfo, (Object[])new Object[0]);
        ArrayList<RoleAndPermEntryInfo> roleAndPermEntryInfosAddNew = new ArrayList<RoleAndPermEntryInfo>(10);
        ArrayList<RoleAndPermEntryInfo> roleAndPermEntryInfosChange = new ArrayList<RoleAndPermEntryInfo>(10);
        ArrayList<RoleAndPermEntryInfo> needUpgrade = new ArrayList<RoleAndPermEntryInfo>(10);
        for (Row next : rows) {
            String fRoleId = next.getString("froleid");
            if (NOT_UPGRADE_ROLE.contains(fRoleId)) continue;
            String fPermitemId = next.getString("fpermitemid");
            RoleAndPermEntryInfo info = new RoleAndPermEntryInfo();
            info.setfRoleId(fRoleId);
            info.setfPermItemId(fPermitemId);
            info.setFid(next.getString("fid"));
            info.setfEntryId(next.getString("fentryid"));
            info.setSeq(next.getInteger("fseq"));
            info.setfControlModel(next.getString("fcontrolmode"));
            info.setfInheritMode(next.getString("finheritmode"));
            info.setfEntityTypeId(next.getString("fentitytypeid"));
            info.setfBizAppId(next.getString("fbizappid"));
            if (ADD_NEW_PERM_ID.equals(fPermitemId)) {
                roleAndPermEntryInfosAddNew.add(info);
                continue;
            }
            if (!CHANGE_PERM_ID.equals(fPermitemId)) continue;
            roleAndPermEntryInfosChange.add(info);
        }
        LOG.info("ChangeBillRolePermUpgradeService_getNeedUpGradeInfo before filter roleAndPermEntryInfosAddNew.size = {},roleAndPermEntryInfosChange.size = {}", (Object)roleAndPermEntryInfosAddNew.size(), (Object)roleAndPermEntryInfosChange.size());
        if (CollectionUtils.isEmpty(roleAndPermEntryInfosAddNew)) {
            return Collections.emptyList();
        }
        for (RoleAndPermEntryInfo newInfo : roleAndPermEntryInfosAddNew) {
            boolean needChange = true;
            for (RoleAndPermEntryInfo changeInfo : roleAndPermEntryInfosChange) {
                if (!HRStringUtils.equals((String)newInfo.getFid(), (String)changeInfo.getFid()) || !HRStringUtils.equals((String)newInfo.getfEntityTypeId(), (String)changeInfo.getfEntityTypeId()) || !HRStringUtils.equals((String)newInfo.getfBizAppId(), (String)changeInfo.getfBizAppId()) || !HRStringUtils.equals((String)newInfo.getfRoleId(), (String)changeInfo.getfRoleId())) continue;
                needChange = false;
                break;
            }
            LOG.info("ChangeBillRolePermUpgradeService_getNeedUpGradeInfo newPermInfo={},needChange = {}", (Object)newInfo, (Object)needChange);
            if (!needChange) continue;
            needUpgrade.add(newInfo);
        }
        LOG.info("ChangeBillRolePermUpgradeService_getNeedUpGradeInfo needUpgrade.size = {}", needUpgrade);
        return needUpgrade;
    }

    private static class RoleAndPermEntryInfo {
        private String fid;
        private String fEntryId;
        private Integer seq;
        private String fControlModel;
        private String fPermItemId;
        private String fInheritMode;
        private String fEntityTypeId;
        private String fBizAppId;
        private String fRoleId;

        private RoleAndPermEntryInfo() {
        }

        public String getFid() {
            return this.fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getfEntryId() {
            return this.fEntryId;
        }

        public void setfEntryId(String fEntryId) {
            this.fEntryId = fEntryId;
        }

        public Integer getSeq() {
            return this.seq;
        }

        public void setSeq(Integer seq) {
            this.seq = seq;
        }

        public String getfControlModel() {
            return this.fControlModel;
        }

        public void setfControlModel(String fControlModel) {
            this.fControlModel = fControlModel;
        }

        public String getfPermItemId() {
            return this.fPermItemId;
        }

        public void setfPermItemId(String fPermItemId) {
            this.fPermItemId = fPermItemId;
        }

        public String getfInheritMode() {
            return this.fInheritMode;
        }

        public void setfInheritMode(String fInheritMode) {
            this.fInheritMode = fInheritMode;
        }

        public String getfEntityTypeId() {
            return this.fEntityTypeId;
        }

        public void setfEntityTypeId(String fEntityTypeId) {
            this.fEntityTypeId = fEntityTypeId;
        }

        public String getfBizAppId() {
            return this.fBizAppId;
        }

        public void setfBizAppId(String fBizAppId) {
            this.fBizAppId = fBizAppId;
        }

        public String getfRoleId() {
            return this.fRoleId;
        }

        public void setfRoleId(String fRoleId) {
            this.fRoleId = fRoleId;
        }

        public String toString() {
            return "RoleAndPermEntryInfo{fid='" + this.fid + '\'' + ", fEntryId='" + this.fEntryId + '\'' + ", seq=" + this.seq + ", fControlModel='" + this.fControlModel + '\'' + ", fPermItemId='" + this.fPermItemId + '\'' + ", fInheritMode='" + this.fInheritMode + '\'' + ", fEntityTypeId='" + this.fEntityTypeId + '\'' + ", fBizAppId='" + this.fBizAppId + '\'' + ", fRoleId='" + this.fRoleId + '\'' + '}';
        }
    }
}

