/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.mservice.roleperm;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.proxy.Joiner;

public class SelfBillRolePermUpgradeService
extends WTCUpgradeService {
    private static final Log LOG = LogFactory.getLog(SelfBillRolePermUpgradeService.class);
    private static final String APPIDWTSS = "1Q=BI7RA+PXM";
    private static final String APPIDHSSC = "2ZK3NJ2OQYKX";
    private Map<String, List<String>> entityPermItemMap = new HashMap<String, List<String>>(16);
    private static final String SELECTROLEPERMDETIAL = "select taa.fid fid,taa.fbizappid fbizappid,taa.froleid froleid from t_perm_rolepermdetial taa   where taa.fentitytypeid in ('wtss_pcpersonhome','wtss_mobilehomepage') and taa.fbizappid in ('1Q=BI7RA+PXM','2ZK3NJ2OQYKX') and taa.fpermitemid = '47150e89000000ac';";
    private static final String SELECT_SYSTEM_SQL = "select fid from t_perm_role where fissystem  = '1';";
    private static final String INSERTPERMDETAILSQL = "INSERT INTO T_PERM_ROLEPERMDETIAL(fentryid,fseq,fentitytypeid,fcontrolmode,finheritmode,fpermitemid,fbizappid,froleid,fid) VALUES(?,0,?,' ',' ',?,?,?,?);";
    private static final String DELETEPERMDETAILSQL = "delete from t_perm_rolepermdetial where ";
    private static Set<String> SYSTEMSETIDS = new HashSet<String>();

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        sqlFileName = "kd_1.5.205_1_wtbs_perm_roleperm_selfbillupdate.sql";
        this.readEntityPermFile(sqlFileName);
        this.updateRole(dbKey);
    }

    private void readEntityPermFile(String sqlFileName) {
        BufferedReader bd = null;
        InputStreamReader reader = null;
        InputStream inputStream = null;
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/upgrade/" + sqlFileName);
            reader = new InputStreamReader(Objects.requireNonNull(inputStream));
            bd = new BufferedReader(reader);
            ArrayList<String> permDetailListWtss = new ArrayList<String>(16);
            ArrayList<String> permDetailListHssc = new ArrayList<String>(16);
            String line = "";
            while ((line = bd.readLine()) != null) {
                if (HRStringUtils.isEmpty((String)line)) continue;
                if (line.contains(APPIDWTSS)) {
                    permDetailListWtss.add(line);
                    continue;
                }
                if (!line.contains(APPIDHSSC)) continue;
                permDetailListHssc.add(line);
            }
            this.entityPermItemMap.put(APPIDWTSS, permDetailListWtss);
            this.entityPermItemMap.put(APPIDHSSC, permDetailListHssc);
            LOG.info("SelfBillRolePermUpgradeService.readEntityPermFile success");
            this.safeClose(bd);
            this.safeClose(reader);
            this.safeClose(inputStream);
        }
        catch (IOException io) {
            try {
                String msg = "SelfBillRolePermUpgradeService BufferedReader exception";
                throw new KDBizException((Throwable)io, new ErrorCode("SelfBillRolePermUpgradeService BufferedReader", msg), new Object[0]);
            }
            catch (Throwable throwable) {
                this.safeClose(bd);
                this.safeClose(reader);
                this.safeClose(inputStream);
                throw throwable;
            }
        }
    }

    private void updateRole(String dbKey) {
        try (TXHandle required = TX.requiresNew();){
            DBRoute dbRoute = DBRoute.of((String)dbKey);
            SYSTEMSETIDS = (Set)HRDBUtil.query((DBRoute)dbRoute, (String)SELECT_SYSTEM_SQL, (Object[])new Object[0], resultSet -> {
                HashSet<String> roleSetIds = new HashSet<String>(16);
                while (resultSet.next()) {
                    String froleid = resultSet.getString("fid");
                    roleSetIds.add(froleid);
                }
                return roleSetIds;
            });
            Map bizAppRoleMap = (Map)HRDBUtil.query((DBRoute)dbRoute, (String)SELECTROLEPERMDETIAL, (Object[])new Object[0], resultSet -> {
                HashMap<String, Map> map = new HashMap<String, Map>(16);
                while (resultSet.next()) {
                    String fbizappid = resultSet.getString("fbizappid");
                    Map roleMap = map.computeIfAbsent(fbizappid, key -> new HashMap(16));
                    String froleid = resultSet.getString("froleid");
                    String fid = resultSet.getString("fid");
                    if (SYSTEMSETIDS.contains(froleid)) continue;
                    roleMap.put(froleid, fid);
                }
                return map;
            });
            if (CollectionUtils.isEmpty((Map)bizAppRoleMap)) {
                return;
            }
            try {
                this.deleteRolePermDetail(dbRoute);
                List<Object[]> params = this.getInsertParams(bizAppRoleMap);
                if (!CollectionUtils.isEmpty(params)) {
                    HRDBUtil.executeBatch((DBRoute)dbRoute, (String)INSERTPERMDETAILSQL, params);
                    LOG.info("SelfBillRolePermUpgradeService.insert permdetail success");
                }
            }
            catch (Exception ex) {
                required.markRollback();
                String msg = "SelfBillRolePermUpgradeService TXHandle exception";
                throw new KDBizException((Throwable)ex, new ErrorCode("SelfBillRolePermUpgradeService TXHandle", msg), new Object[0]);
            }
        }
    }

    private void deleteRolePermDetail(DBRoute dbRoute) {
        ArrayList<Object> entityIdList = new ArrayList<Object>(16);
        ArrayList<Object> permIdList = new ArrayList<Object>(16);
        this.getDeleteParams(APPIDWTSS, entityIdList, permIdList);
        this.getDeleteParams(APPIDHSSC, entityIdList, permIdList);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(DELETEPERMDETAILSQL, new Object[0]);
        if (WTCCollections.isNotEmpty(SYSTEMSETIDS)) {
            HashSet sysRoleIds = Sets.newHashSetWithExpectedSize((int)SYSTEMSETIDS.size());
            for (String ids : SYSTEMSETIDS) {
                sysRoleIds.add("'" + ids + "'");
            }
            String join = Joiner.on((char)',').join((Iterable)sysRoleIds);
            sqlBuilder.append(MessageFormat.format(" froleid not in ({0}) and ", join), new Object[0]);
        }
        sqlBuilder.appendIn("fbizappid", new Object[]{APPIDWTSS, APPIDHSSC});
        sqlBuilder.appendIn(" and fentitytypeid", entityIdList);
        sqlBuilder.appendIn(" and fpermitemid", permIdList);
        DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
    }

    private void getDeleteParams(String bizAppId, List<Object> entityIdList, List<Object> permIdList) {
        List<String> entityPermList = this.entityPermItemMap.get(bizAppId);
        for (String entityPermStr : entityPermList) {
            String[] split = entityPermStr.split(",");
            entityIdList.add(split[0]);
            permIdList.add(split[1]);
        }
    }

    private List<Object[]> getInsertParams(Map<String, Map<String, String>> bizAppRoleMap) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        this.getInsertParams(paramsList, bizAppRoleMap, APPIDWTSS);
        this.getInsertParams(paramsList, bizAppRoleMap, APPIDHSSC);
        return paramsList;
    }

    private void getInsertParams(List<Object[]> paramsList, Map<String, Map<String, String>> bizAppRoleMap, String bizAppId) {
        List<String> entityPermList = this.entityPermItemMap.get(bizAppId);
        if (CollectionUtils.isEmpty(entityPermList)) {
            return;
        }
        String[] strIds = null;
        int index = 0;
        Map<String, String> roleMap = bizAppRoleMap.get(bizAppId);
        if (CollectionUtils.isEmpty(roleMap)) {
            return;
        }
        for (Map.Entry<String, String> roleEntry : roleMap.entrySet()) {
            String roleId = roleEntry.getKey();
            String fid = roleEntry.getValue();
            for (String entityPermStr : entityPermList) {
                if (strIds == null) {
                    int count = roleMap.size() * entityPermList.size();
                    strIds = ID.genStringIds((int)count);
                }
                String[] split = entityPermStr.split(",");
                paramsList.add(new Object[]{strIds[index], split[0], split[1], bizAppId, roleId, fid});
                ++index;
            }
        }
    }

    private void safeClose(Closeable cs) {
        try {
            if (cs != null) {
                cs.close();
            }
        }
        catch (IOException e) {
            LOG.info("SelfBillRolePermUpgradeService.saveClose exception");
        }
    }
}

