/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.bean;

import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.bean.WTCBeanDefinition;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCBeanDefinitionResolver {
    private static final Log LOG = LogFactory.getLog(WTCBeanDefinitionResolver.class);

    public static Map<String, WTCBeanDefinition> resolve(Map<String, String> beanDefinitionMap) {
        HashMap<String, WTCBeanDefinition> resolvedResult = new HashMap<String, WTCBeanDefinition>(100);
        WTCBeanDefinitionResolver.resolveBeanDefinitions(beanDefinitionMap, resolvedResult);
        return resolvedResult;
    }

    private static void resolveBeanDefinitions(Map<String, String> beanDefinitionStrs, Map<String, WTCBeanDefinition> resolvedResult) {
        if (MapUtils.isNotEmpty(beanDefinitionStrs)) {
            beanDefinitionStrs.forEach((beanName, beanClassName) -> {
                if (StringUtils.isBlank((CharSequence)beanName)) {
                    throw new WTCException("beanName could not be empty");
                }
                beanName = beanName.trim();
                if (StringUtils.isNotEmpty((CharSequence)(beanClassName = WTCStringUtils.trimNonNull(beanClassName)))) {
                    WTCBeanDefinition beanDefinition = new WTCBeanDefinition((String)beanName, (String)beanClassName);
                    WTCBeanDefinitionResolver.checkIn(beanDefinition, resolvedResult);
                }
            });
        }
    }

    private static void checkIn(WTCBeanDefinition beanDefinition, Map<String, WTCBeanDefinition> resolvedResult) throws WTCException {
        WTCBeanDefinition oldBeanDefinition = resolvedResult.put(beanDefinition.beanName, beanDefinition);
        if (oldBeanDefinition != null) {
            throw new WTCException("bean definition conflict, the bean name is: " + beanDefinition.beanName);
        }
    }
}

