/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.bean;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.entity.plugin.support.util.Assert;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.bean.WTCBeanDefinition;
import kd.wtc.wtbs.common.bean.WTCBeanDefinitionResolver;
import kd.wtc.wtbs.common.bean.WTCBeanFactory;
import kd.wtc.wtbs.common.bean.annotations.SingletonBean;
import kd.wtc.wtbs.common.config.WTCProjectConfig;
import kd.wtc.wtbs.common.config.WTCProjectConfigHelper;
import kd.wtc.wtbs.common.lang.TypeCloneable;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.timewatch.TimeWatchDynamicProxyFactory;

public class WTCBeanFactoryDefault
implements WTCBeanFactory {
    private static final Log LOG = LogFactory.getLog(WTCBeanFactoryDefault.class);
    private final Map<String, Object> singletonBeans = new ConcurrentHashMap<String, Object>(100);
    private final Map<String, TypeCloneable<?>> prototypeBeans = new ConcurrentHashMap(100);
    private final Map<String, WTCBeanDefinition> beanDefinitionMap;

    public WTCBeanFactoryDefault() {
        WTCProjectConfig appConfig = WTCProjectConfigHelper.getProjectConfig();
        LOG.info("init WTCBeanFactoryDefault begin.");
        this.beanDefinitionMap = WTCBeanDefinitionResolver.resolve(appConfig.getBeanMap());
    }

    @Override
    public <T> T getBean(Class<T> beanClass) {
        Assert.notNull(beanClass, (String)"beanClass can not be null.");
        boolean checkClassSuccess = WTCBeanFactoryDefault.checkBeanClass(beanClass);
        if (!checkClassSuccess) {
            return null;
        }
        WTCBeanDefinition wtcBeanDefinition = this.resloveBeanClass(beanClass);
        return this.doGetBeanInner(wtcBeanDefinition);
    }

    @Override
    public Object getBean(String beanClassFullName) {
        Class<?> targetClass;
        Assert.notNull((Object)beanClassFullName, (String)"beanClassFullName can not be null.");
        try {
            targetClass = Class.forName(beanClassFullName);
        }
        catch (Throwable error) {
            LOG.warn("getBean\u5f02\u5e38,beanFullClassName:{}, errorMsg:{}", (Object)beanClassFullName, (Object)error.getMessage());
            throw new WTCException(error, "Can't Create TieBeanFactory by Class:" + beanClassFullName);
        }
        return this.getBean(targetClass);
    }

    private static boolean checkBeanClass(Class<?> beanClass) {
        boolean isAnnotation = beanClass.isAnnotation();
        boolean isArray = beanClass.isArray();
        boolean isEnum = beanClass.isEnum();
        boolean isNative = Modifier.isNative(beanClass.getModifiers());
        boolean isAbstract = Modifier.isAbstract(beanClass.getModifiers());
        boolean isInterface = Modifier.isInterface(beanClass.getModifiers());
        boolean isStatic = Modifier.isStatic(beanClass.getModifiers());
        return !isAnnotation && !isArray && !isEnum && !isNative && !isAbstract && !isInterface && !isStatic;
    }

    private final WTCBeanDefinition resloveBeanClass(Class<?> beanClass) {
        WTCBeanDefinition wtcBeanDefinition = this.beanDefinitionMap.computeIfAbsent(beanClass.getName(), beanDefinition -> new WTCBeanDefinition(beanClass.getName(), beanClass.getName()));
        if (wtcBeanDefinition.getBeanClass() == null) {
            try {
                Class<?> targetClazz = Class.forName(wtcBeanDefinition.beanClassName);
                wtcBeanDefinition.setBeanClass(targetClazz);
            }
            catch (ClassNotFoundException e) {
                throw new WTCException(e, "Class not found:" + wtcBeanDefinition.beanClassName);
            }
        }
        return wtcBeanDefinition;
    }

    private <T> T doGetBeanInner(WTCBeanDefinition beanDefinition) {
        Object service;
        Class<?> targetClazz = beanDefinition.getBeanClass();
        boolean annotationPresent = targetClazz.isAnnotationPresent(SingletonBean.class);
        if (annotationPresent) {
            service = this.singletonBeans.computeIfAbsent(beanDefinition.beanName, bea -> WTCBeanFactoryDefault.newBeanInstance(beanDefinition.beanClassName));
        } else {
            TypeCloneable typeCloneable = this.prototypeBeans.computeIfAbsent(beanDefinition.beanName, bean -> {
                if (targetClazz.isAssignableFrom(TypeCloneable.class)) {
                    try {
                        return (TypeCloneable)targetClazz.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException exception) {
                        throw new WTCException(exception, "New instance exception:" + targetClazz.getName());
                    }
                }
                return new FakeCloneableBean(targetClazz);
            });
            service = typeCloneable.clone();
        }
        return (T)service;
    }

    private static <T> T newBeanInstance(String beanClassName) {
        try {
            Class<?> targetClazz = Class.forName(beanClassName);
            return (T)TimeWatchDynamicProxyFactory.getInstance().createProxy(targetClazz.getName(), targetClazz);
        }
        catch (Exception e) {
            throw new WTCException(e, "Class not found:" + beanClassName);
        }
    }

    private static class FakeCloneableBean
    implements TypeCloneable {
        Class<?> clazz;

        FakeCloneableBean(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Object clone() {
            try {
                return TimeWatchDynamicProxyFactory.getInstance().createProxy(this.clazz.getName(), this.clazz);
            }
            catch (Exception e) {
                throw new WTCException(e, "New instance exception:" + this.clazz);
            }
        }
    }
}

