/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.concurrent;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.wtc.wtbs.common.concurrent.WTCMutexLockInfo;

public class WTCMutexHelper {
    private static final Log LOG = LogFactory.getLog(WTCMutexHelper.class);

    public static boolean require(WTCMutexLockInfo lockInfo) {
        boolean requireSuccess;
        if (lockInfo == null || lockInfo.getInfo() == null) {
            return false;
        }
        try {
            requireSuccess = MutexHelper.require((IFormView)lockInfo.getView(), (MutexLockInfo)lockInfo.getInfo(), (StringBuilder)lockInfo.getErrMsg());
        }
        catch (KDBizException e) {
            LOG.warn("WTCMutexHelper.require.error:{}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOG.warn("WTCMutexHelper.require.error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f51\u7edc\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"WTCMutexHelper_0", (String)"wtc-wtbs-common", (Object[])new Object[0]));
        }
        if (requireSuccess) {
            AutoReleaseLock.create().register(lockInfo.getInfo().getDataObjId(), lockInfo.getInfo().getEntityNumber(), lockInfo.getInfo().getOperationKey());
        }
        return requireSuccess;
    }

    public static boolean release(String entityKey, String opKey, String objId) {
        return MutexHelper.release((String)entityKey, (String)opKey, (String)objId);
    }

    public static boolean release(WTCMutexLockInfo lockInfo) {
        if (lockInfo == null || lockInfo.getInfo() == null) {
            return false;
        }
        return MutexHelper.release((String)lockInfo.getInfo().getEntityNumber(), (String)lockInfo.getInfo().getOperationKey(), (String)lockInfo.getInfo().getDataObjId());
    }
}

