/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import kd.bos.logging.Log;
import kd.wtc.wtbs.common.config.WTCAppConfigData;
import kd.wtc.wtbs.common.config.WTCBaseAppConfigData;
import kd.wtc.wtbs.common.config.WTCProjectConfig;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

abstract class AbstractWTCProjectConfig
implements WTCProjectConfig {
    private static final String PARAM_KEY_PROFILE_ACTIVE = "wtc.profile.active";
    private static final String PARAM_KEY_PROFILE_DEFAULT = "wtc.profile.default";
    private static final String PARAM_KEY_CONFIG_BASE_APP_NAME = "wtc.config.base.app.name";
    private static final String DEFAULT_BASE_APP_NAME = "wtc-wtbs";
    private static final Log LOG = WTCLogFactory.getLog(AbstractWTCProjectConfig.class);
    private String baseAppName;
    @Nullable
    private String baseAppActiveProfile;
    private List<String> appNames = Collections.emptyList();
    private final Map<String, String> appActiveProfileMap = new HashMap<String, String>(16);
    @Nullable
    private String beanFactoryClassName;
    private final Map<String, String> beanMap = new HashMap<String, String>(128);
    private final Map<String, Object> params = new HashMap<String, Object>(32);
    private boolean resolved = false;

    AbstractWTCProjectConfig() {
    }

    @Override
    public final void resolve() {
        if (this.resolved) {
            return;
        }
        this.resolveBaseAppName();
        this.resolveBaseAppConfig();
        this.resolveAppConfigs();
        this.resolved = true;
    }

    private void resolveBaseAppName() {
        this.baseAppName = WTCStringUtils.toStr(System.getProperty(PARAM_KEY_CONFIG_BASE_APP_NAME), DEFAULT_BASE_APP_NAME);
    }

    private void resolveBaseAppConfig() {
        WTCBaseAppConfigData baseAppConfigData = this.loadBaseAppConfigData(this.baseAppName);
        if (baseAppConfigData == null) {
            return;
        }
        this.appNames = WTCCollections.isEmpty(baseAppConfigData.getAppNames()) ? Collections.emptyList() : baseAppConfigData.getAppNames().stream().filter(appName -> !this.baseAppName.equals(appName)).collect(Collectors.toList());
        this.baseAppActiveProfile = baseAppConfigData.getActiveProfile();
        this.appActiveProfileMap.put(this.baseAppName, this.baseAppActiveProfile);
        this.beanFactoryClassName = WTCStringUtils.trimNonNull(baseAppConfigData.getBeanFactoryName());
        this.resolveBeanAndParam(baseAppConfigData);
    }

    private void resolveBeanAndParam(WTCAppConfigData appConfigData) {
        if (WTCMaps.isNotEmpty(appConfigData.getBeans())) {
            this.beanMap.putAll(appConfigData.getBeans());
        }
        if (WTCMaps.isNotEmpty(appConfigData.getParams())) {
            this.params.putAll(appConfigData.getParams());
        }
    }

    private void resolveAppConfigs() {
        for (String appName : this.appNames) {
            if (!StringUtils.isNotBlank((CharSequence)appName)) continue;
            this.resolveAppConfig(appName);
        }
    }

    private void resolveAppConfig(String appName) {
        WTCAppConfigData appConfigData = this.loadAppConfigData(appName);
        if (appConfigData == null) {
            return;
        }
        this.appActiveProfileMap.put(appName, appConfigData.getActiveProfile());
        this.resolveBeanAndParam(appConfigData);
    }

    @Nullable
    protected WTCBaseAppConfigData loadBaseAppConfigData(String baseAppName) {
        WTCBaseAppConfigData defaultBaseAppConfigData = this.loadDefaultBaseAppConfigData(baseAppName);
        if (defaultBaseAppConfigData == null) {
            return null;
        }
        String activeProfile = this.getActiveProfile(defaultBaseAppConfigData.getActiveProfile());
        defaultBaseAppConfigData.setActiveProfile(activeProfile);
        if (StringUtils.isNotBlank((CharSequence)activeProfile)) {
            WTCBaseAppConfigData baseAppConfigData = this.loadBaseAppConfigData(baseAppName, activeProfile);
            defaultBaseAppConfigData.merge(baseAppConfigData);
        }
        return defaultBaseAppConfigData;
    }

    @Nullable
    protected abstract WTCBaseAppConfigData loadBaseAppConfigData(String var1, String var2);

    @Nullable
    protected abstract WTCBaseAppConfigData loadDefaultBaseAppConfigData(String var1);

    @Nullable
    protected WTCAppConfigData loadAppConfigData(String appName) {
        WTCAppConfigData defaultAppConfigData = this.loadDefaultAppConfigData(appName);
        if (defaultAppConfigData == null) {
            return null;
        }
        String activeProfile = this.getActiveProfile(defaultAppConfigData.getActiveProfile());
        defaultAppConfigData.setActiveProfile(activeProfile);
        if (StringUtils.isNotBlank((CharSequence)activeProfile)) {
            WTCAppConfigData appConfigData = this.loadAppConfigData(appName, activeProfile);
            defaultAppConfigData.merge(appConfigData);
        }
        return defaultAppConfigData;
    }

    @Nullable
    protected abstract WTCAppConfigData loadDefaultAppConfigData(String var1);

    @Nullable
    protected abstract WTCAppConfigData loadAppConfigData(String var1, String var2);

    protected String getActiveProfile(String profile) {
        String activeProfile = System.getProperty(PARAM_KEY_PROFILE_ACTIVE);
        if (StringUtils.isBlank((CharSequence)activeProfile)) {
            activeProfile = StringUtils.isBlank((CharSequence)profile) ? System.getProperty(PARAM_KEY_PROFILE_DEFAULT) : profile;
        }
        return WTCStringUtils.toStr(activeProfile, "");
    }

    public String getBaseAppName() {
        return this.baseAppName;
    }

    @Override
    @Nullable
    public String getBaseAppActiveProfile() {
        return this.baseAppActiveProfile;
    }

    @Override
    @Nullable
    public String getBeanFactoryClassName() {
        return this.beanFactoryClassName;
    }

    @Override
    public Map<String, Object> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public String getAppActiveProfile(String appName) {
        return this.appActiveProfileMap.get(appName);
    }

    @Override
    public Map<String, String> getBeanMap() {
        return this.beanMap;
    }

    public String toString() {
        return "AbstractWTCAppConfig{baseAppName='" + this.baseAppName + '\'' + ", baseAppActiveProfile='" + this.baseAppActiveProfile + '\'' + ", appNames=" + this.appNames + ", appActiveProfileMap=" + this.appActiveProfileMap + ", beanFactoryClassName='" + this.beanFactoryClassName + '\'' + ", beanMap=" + this.beanMap + ", params=" + this.params + '}';
    }
}

