/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.config;

import kd.bos.logging.Log;
import kd.wtc.wtbs.common.config.WTCProjectConfig;
import kd.wtc.wtbs.common.config.WTCProjectConfigResourceLocation;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public final class WTCProjectConfigHelper {
    public static final String SYS_APP_CONFIG_FACTORY_CLASS_NAME = "wtc.config.app.config.class.name";
    private static final Log LOG = WTCLogFactory.getLog(WTCProjectConfigHelper.class);
    private static final WTCProjectConfig PROJECT_CONFIG = WTCProjectConfigHelper.initProjectConfig();

    public static WTCProjectConfig getProjectConfig() {
        return PROJECT_CONFIG;
    }

    public static WTCProjectConfig initProjectConfig() {
        String appConfigFactoryClassName = System.getProperty(SYS_APP_CONFIG_FACTORY_CLASS_NAME);
        WTCProjectConfig appConfig = StringUtils.isBlank((CharSequence)appConfigFactoryClassName) ? new WTCProjectConfigResourceLocation() : WTCProjectConfigHelper.createByClassName(appConfigFactoryClassName);
        LOG.info("app config:{}", (Object)appConfig);
        appConfig.resolve();
        return appConfig;
    }

    private static WTCProjectConfig createByClassName(String className) {
        WTCProjectConfig factory;
        try {
            Class<?> clazz = Class.forName(className);
            factory = (WTCProjectConfig)clazz.newInstance();
        }
        catch (Exception e) {
            throw new WTCException(e, "Can't Create WTCProjectConfig by Class:" + className);
        }
        return factory;
    }
}

