/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.deduction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.wtc.wtbs.common.deduction.BillEntryDateSplit;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class BillApplyEntry
implements Serializable {
    private static final long serialVersionUID = -4514620843093366800L;
    private long entryId;
    private long deductionRuleId;
    private BigDecimal vaTimeDay;
    private BigDecimal vaTimeHour;
    private String entryUnit;
    private Date startDate;
    private Date endDate;
    private List<BillEntryDateSplit> splitList;
    private boolean disposable;
    private boolean nonQuota;
    private boolean split;
    private String vacationType;

    public List<BillEntryDateSplit> getSplitList() {
        if (this.splitList == null) {
            this.splitList = new ArrayList<BillEntryDateSplit>(10);
        }
        return this.splitList;
    }

    public BillEntryDateSplit getDateSplitByDate(Date date) {
        Date assignDate = WTCDateUtils.getZeroDate(date);
        for (BillEntryDateSplit tmp : this.getSplitList()) {
            Date oldAssignDate = WTCDateUtils.getZeroDate(tmp.getDate());
            if (!oldAssignDate.equals(assignDate)) continue;
            return tmp;
        }
        return null;
    }

    public void setSplitList(List<BillEntryDateSplit> splitList) {
        this.splitList = splitList;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public BillApplyEntry setEntryId(long entryId) {
        this.entryId = entryId;
        return this;
    }

    public long getDeductionRuleId() {
        return this.deductionRuleId;
    }

    public BillApplyEntry setDeductionRuleId(long deductionRuleId) {
        this.deductionRuleId = deductionRuleId;
        return this;
    }

    public BigDecimal getVaTimeDay() {
        if (this.vaTimeDay == null) {
            this.vaTimeDay = BigDecimal.ZERO;
        }
        return this.vaTimeDay;
    }

    public BillApplyEntry setVaTimeDay(BigDecimal vaTimeDay) {
        this.vaTimeDay = vaTimeDay;
        return this;
    }

    public BigDecimal getVaTimeHour() {
        if (this.vaTimeHour == null) {
            this.vaTimeHour = BigDecimal.ZERO;
        }
        return this.vaTimeHour;
    }

    public BillApplyEntry setVaTimeHour(BigDecimal vaTimeHour) {
        this.vaTimeHour = vaTimeHour;
        return this;
    }

    public String getVacationType() {
        return this.vacationType;
    }

    public BillApplyEntry setVacationType(String vacationType) {
        this.vacationType = vacationType;
        return this;
    }

    public String getEntryUnit() {
        return this.entryUnit;
    }

    public BillApplyEntry setEntryUnit(String entryUnit) {
        this.entryUnit = entryUnit;
        return this;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public BillApplyEntry setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public BillApplyEntry setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public boolean getDisposable() {
        return this.disposable;
    }

    public void setDisposable(boolean disposable) {
        this.disposable = disposable;
    }

    public boolean getNonQuota() {
        return this.nonQuota;
    }

    public void setNonQuota(boolean nonQuota) {
        this.nonQuota = nonQuota;
    }

    public boolean getSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public String toString() {
        return "BillApplyEntry{entryId=" + this.entryId + ", deductionRuleId=" + this.deductionRuleId + ", vaTimeDay=" + this.vaTimeDay + ", vaTimeHour=" + this.vaTimeHour + ", entryUnit='" + this.entryUnit + '\'' + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", splitList=" + this.splitList + ", disposable=" + this.disposable + "nonQuota=" + this.nonQuota + ", split=" + this.split + '}';
    }

    public void adjustSplitTime() {
        BigDecimal vaTimeDay = BigDecimal.ZERO;
        BigDecimal vaTimeHour = BigDecimal.ZERO;
        for (BillEntryDateSplit split : this.splitList) {
            vaTimeDay = vaTimeDay.add(split.getVaTimeDay());
            vaTimeHour = vaTimeHour.add(split.getVaTimeHour());
        }
        this.vaTimeDay = vaTimeDay;
        this.vaTimeHour = vaTimeHour;
    }
}

