/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.common.enums.bill;

import java.util.Objects;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.enums.BillTypeConstants;
import kd.wtc.wtbs.common.util.BillTypeNameCache;

public enum BillTypeEnum {
    VACATIONBILL(BillTypeConstants.VOCATION_ID, new MultiLangEnumBridge("\u4f11\u5047", "BillTypeEnum_0", "wtc-wtbs-common")),
    EVECTIONBILL(BillTypeConstants.TRAVEL_ID, new MultiLangEnumBridge("\u51fa\u5dee", "BillTypeEnum_1", "wtc-wtbs-common")),
    OVERTIMEBILL(BillTypeConstants.OVERTIME_ID, new MultiLangEnumBridge("\u52a0\u73ed", "BillTypeEnum_2", "wtc-wtbs-common")),
    SUPPLEMENTBILL(BillTypeConstants.SUPPLY_SIGN_ID, new MultiLangEnumBridge("\u8865\u7b7e", "BillTypeEnum_3", "wtc-wtbs-common")),
    ADJUSTMENTBILL(BillTypeConstants.ADJUSTMENT_ID, new MultiLangEnumBridge("\u8c03\u73ed", "BillTypeEnum_4", "wtc-wtbs-common")),
    VACATIONBILLBATCH(BillTypeConstants.VOCATION_ID, new MultiLangEnumBridge("\u6279\u91cf\u4f11\u5047", "BillTypeEnum_6", "wtc-wtbs-common")),
    ERRORBILL(0L, new MultiLangEnumBridge("\u9519\u8bef\u5355\u636e", "BillTypeEnum_5", "wtc-wtbs-common"));

    private final long frozenBillTypeId;
    private final MultiLangEnumBridge description;
    private BillTypeNameCache billNameCache;

    public String getDescription() {
        return this.description.loadKDString();
    }

    public long getFrozenBillTypeId() {
        return this.frozenBillTypeId;
    }

    private BillTypeEnum(long frozenBillTypeId, MultiLangEnumBridge description) {
        this.frozenBillTypeId = frozenBillTypeId;
        this.description = description;
        if (frozenBillTypeId == BillTypeConstants.TRAVEL_ID) {
            this.billNameCache = new BillTypeNameCache(frozenBillTypeId);
        }
    }

    public static BillTypeEnum getByCode(long frozenBillTypeId) {
        for (BillTypeEnum value : BillTypeEnum.values()) {
            if (value.getFrozenBillTypeId() != frozenBillTypeId) continue;
            return value;
        }
        return ERRORBILL;
    }

    public String getBillName() {
        String billName = "";
        billName = this == EVECTIONBILL && !Objects.isNull(this.billNameCache) && !BillTypeEnum.EVECTIONBILL.description.getDescription().equals(this.billNameCache.getCNBillName()) ? this.billNameCache.getBillName() : this.description.loadKDString();
        return billName;
    }

    public String getBillName(String preStr, String nextStr) {
        return preStr + this.getBillName() + nextStr;
    }
}

